/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.fetch;

import java.text.MessageFormat;
import org.netbeans.libs.git.GitBranch;
import org.netbeans.libs.git.GitRemoteConfig;
import org.netbeans.modules.git.ui.selectors.ItemSelector;
import org.netbeans.modules.git.utils.GitUtils;
import org.openide.util.NbBundle;

public class BranchMapping
extends ItemSelector.Item {
    private final String label;
    private final String tooltip;
    private final String remoteBranchName;
    private final GitRemoteConfig remote;
    private static final String BRANCH_MAPPING_LABEL = "{0} -> {1}/{0} [{2}]";
    private static final String BRANCH_MAPPING_LABEL_UPTODATE = "{0} -> {1}/{0}";

    public BranchMapping(String remoteBranchName, String remoteBranchId, GitBranch localBranch, GitRemoteConfig remote, boolean preselected) {
        super(preselected);
        this.remoteBranchName = remoteBranchName;
        this.remote = remote;
        if (localBranch == null) {
            this.label = MessageFormat.format(BRANCH_MAPPING_LABEL, remoteBranchName, remote.getRemoteName(), "<font color=\"#00b400\">A</font>");
            this.tooltip = NbBundle.getMessage(BranchMapping.class, (String)"LBL_FetchBranchesPanel.BranchMapping.description", (Object[])new Object[]{remote.getRemoteName() + "/" + remoteBranchName, NbBundle.getMessage(BranchMapping.class, (String)"LBL_FetchBranchesPanel.BranchMapping.Mode.added.description")});
        } else if (localBranch.getId().equals(remoteBranchId)) {
            this.label = MessageFormat.format(BRANCH_MAPPING_LABEL_UPTODATE, remoteBranchName, remote.getRemoteName());
            this.tooltip = NbBundle.getMessage(BranchMapping.class, (String)"LBL_FetchBranchesPanel.BranchMapping.Mode.uptodate.description", (Object)localBranch.getName());
        } else {
            this.label = MessageFormat.format(BRANCH_MAPPING_LABEL, remoteBranchName, remote.getRemoteName(), "<font color=\"#0000FF\">U</font>");
            this.tooltip = NbBundle.getMessage(BranchMapping.class, (String)"LBL_FetchBranchesPanel.BranchMapping.description", (Object[])new Object[]{localBranch.getName(), NbBundle.getMessage(BranchMapping.class, (String)"LBL_FetchBranchesPanel.BranchMapping.Mode.updated.description")});
        }
    }

    public String getRefSpec() {
        return GitUtils.getRefSpec(this.remoteBranchName, this.remote.getRemoteName());
    }

    @Override
    public String getText() {
        return this.label;
    }

    @Override
    public String getTooltipText() {
        return this.tooltip;
    }

    public String getRemoteBranchName() {
        return this.remoteBranchName;
    }

    public String getRemoteName() {
        return this.remote.getRemoteName();
    }

    @Override
    public int compareTo(ItemSelector.Item t) {
        if (t == null) {
            return 1;
        }
        if (t instanceof BranchMapping) {
            return this.remoteBranchName.compareTo(((BranchMapping)t).remoteBranchName);
        }
        return 0;
    }
}

