/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.diff;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import org.netbeans.libs.git.GitClient;
import org.netbeans.modules.git.FileInformation;
import org.netbeans.modules.git.GitModuleConfig;
import org.netbeans.modules.git.ui.actions.AddAction;
import org.netbeans.modules.git.ui.checkout.CheckoutPathsAction;
import org.netbeans.modules.git.ui.checkout.RevertChangesAction;
import org.netbeans.modules.git.ui.commit.CommitAction;
import org.netbeans.modules.git.ui.commit.ExcludeFromCommitAction;
import org.netbeans.modules.git.ui.commit.GitFileNode;
import org.netbeans.modules.git.ui.commit.IncludeInCommitAction;
import org.netbeans.modules.git.ui.conflicts.ResolveConflictsAction;
import org.netbeans.modules.git.ui.diff.DiffNode;
import org.netbeans.modules.git.ui.diff.ExportUncommittedChangesAction;
import org.netbeans.modules.git.ui.status.GitStatusNode;
import org.netbeans.modules.versioning.diff.DiffUtils;
import org.netbeans.modules.versioning.util.FilePathCellRenderer;
import org.netbeans.modules.versioning.util.OpenInEditorAction;
import org.netbeans.modules.versioning.util.SystemActionBridge;
import org.netbeans.modules.versioning.util.status.VCSStatusNode;
import org.netbeans.modules.versioning.util.status.VCSStatusTable;
import org.netbeans.modules.versioning.util.status.VCSStatusTableModel;
import org.openide.awt.Mnemonics;
import org.openide.cookies.EditorCookie;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;

class DiffFileTable
extends VCSStatusTable<DiffNode> {
    private Map<File, EditorCookie> editorCookies;
    private PropertyChangeListener changeListener;
    private GitClient.DiffMode diffMode;

    public DiffFileTable(VCSStatusTableModel<DiffNode> model) {
        super(model);
        this.setDefaultRenderer(new DiffTableCellRenderer());
    }

    protected void setModelProperties() {
        Node.Property[] properties = new Node.Property[]{new ColumnDescriptor<String>("name", String.class, VCSStatusNode.NameProperty.DISPLAY_NAME, VCSStatusNode.NameProperty.DESCRIPTION), new ColumnDescriptor<String>("gitstatus", String.class, GitStatusNode.GitStatusProperty.DISPLAY_NAME, GitStatusNode.GitStatusProperty.DESCRIPTION), new ColumnDescriptor<String>("path", String.class, VCSStatusNode.PathProperty.DISPLAY_NAME, VCSStatusNode.PathProperty.DESCRIPTION)};
        this.tableModel.setProperties(properties);
    }

    protected JPopupMenu getPopup() {
        JPopupMenu menu = new JPopupMenu();
        JMenuItem item = menu.add((Action)new OpenInEditorAction(this.getSelectedFiles()));
        Mnemonics.setLocalizedText((AbstractButton)item, (String)item.getText());
        menu.addSeparator();
        final GitStatusNode[] selectedNodes = (GitStatusNode[])this.getSelectedNodes();
        boolean displayAdd = false;
        for (GitStatusNode node : selectedNodes) {
            if (!((GitFileNode)node.getFileNode()).getInformation().containsStatus(EnumSet.of(FileInformation.Status.NEW_INDEX_WORKING_TREE, FileInformation.Status.IN_CONFLICT, FileInformation.Status.MODIFIED_INDEX_WORKING_TREE))) continue;
            displayAdd = true;
        }
        Lookup lkp = Lookups.fixed((Object[])((Object[])selectedNodes));
        if (displayAdd) {
            item = menu.add((Action)SystemActionBridge.createAction((Action)SystemAction.get(AddAction.class), (String)NbBundle.getMessage(AddAction.class, (String)"LBL_AddAction.popupName"), (Lookup)lkp));
            Mnemonics.setLocalizedText((AbstractButton)item, (String)item.getText());
        }
        item = menu.add((Action)SystemActionBridge.createAction((Action)SystemAction.get(CommitAction.class), (String)NbBundle.getMessage(CommitAction.class, (String)"LBL_CommitAction.popupName"), (Lookup)lkp));
        Mnemonics.setLocalizedText((AbstractButton)item, (String)item.getText());
        SystemActionBridge efca = SystemActionBridge.createAction((Action)SystemAction.get(ExcludeFromCommitAction.class), (String)NbBundle.getMessage(ExcludeFromCommitAction.class, (String)"LBL_ExcludeFromCommitAction_PopupName"), (Lookup)lkp);
        SystemActionBridge iica = SystemActionBridge.createAction((Action)SystemAction.get(IncludeInCommitAction.class), (String)NbBundle.getMessage(IncludeInCommitAction.class, (String)"LBL_IncludeInCommitAction_PopupName"), (Lookup)lkp);
        if (efca.isEnabled() || iica.isEnabled()) {
            if (efca.isEnabled()) {
                item = menu.add((Action)efca);
                Mnemonics.setLocalizedText((AbstractButton)item, (String)item.getText());
            } else if (iica.isEnabled()) {
                item = menu.add((Action)iica);
                Mnemonics.setLocalizedText((AbstractButton)item, (String)item.getText());
            }
        }
        item = menu.add((Action)SystemActionBridge.createAction((Action)SystemAction.get(RevertChangesAction.class), (String)NbBundle.getMessage(CheckoutPathsAction.class, (String)"LBL_RevertChangesAction_PopupName"), (Lookup)lkp));
        Mnemonics.setLocalizedText((AbstractButton)item, (String)item.getText());
        item = menu.add(new AbstractAction(NbBundle.getMessage(ExportUncommittedChangesAction.class, (String)"LBL_ExportUncommittedChangesAction_PopupName")){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((ExportUncommittedChangesAction)SystemAction.get(ExportUncommittedChangesAction.class)).exportDiff((Node[])selectedNodes, DiffFileTable.this.diffMode);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)item, (String)item.getText());
        item = menu.add((Action)SystemActionBridge.createAction((Action)SystemAction.get(CheckoutPathsAction.class), (String)NbBundle.getMessage(CheckoutPathsAction.class, (String)"LBL_CheckoutPathsAction_PopupName"), (Lookup)lkp));
        Mnemonics.setLocalizedText((AbstractButton)item, (String)item.getText());
        ResolveConflictsAction a = (ResolveConflictsAction)SystemAction.get(ResolveConflictsAction.class);
        if (a.isEnabled()) {
            menu.addSeparator();
            item = menu.add((Action)SystemActionBridge.createAction((Action)((Object)a), (String)NbBundle.getMessage(ResolveConflictsAction.class, (String)"LBL_ResolveConflictsAction_PopupName"), (Lookup)lkp));
            Mnemonics.setLocalizedText((AbstractButton)item, (String)item.getText());
        }
        return menu;
    }

    public void setNodes(DiffNode[] nodes) {
        throw new UnsupportedOperationException("Do not call this method.");
    }

    void setNodes(Map<File, EditorCookie> editorCookies, DiffNode[] nodes) {
        this.setEditorCookies(editorCookies);
        super.setNodes((VCSStatusNode[])nodes);
    }

    public void updateNodes(List<DiffNode> toRemove, List<DiffNode> toRefresh, List<DiffNode> toAdd) {
        throw new UnsupportedOperationException("Do not call this method.");
    }

    void updateNodes(Map<File, EditorCookie> editorCookies, List<DiffNode> toRemove, List<DiffNode> toRefresh, List<DiffNode> toAdd) {
        this.setEditorCookies(editorCookies);
        super.updateNodes(toRemove, toRefresh, toAdd);
        if (this.getTable().getRowCount() == 1) {
            this.getTable().getSelectionModel().addSelectionInterval(0, 0);
        }
    }

    private void setEditorCookies(Map<File, EditorCookie> editorCookies) {
        this.editorCookies = editorCookies;
        this.changeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                Object source = e.getSource();
                String propertyName = e.getPropertyName();
                if ("modified".equals(propertyName) && source instanceof EditorCookie.Observable) {
                    final EditorCookie.Observable cookie = (EditorCookie.Observable)source;
                    Mutex.EVENT.readAccess(new Runnable(){

                        @Override
                        public void run() {
                            for (int i = 0; i < DiffFileTable.this.tableModel.getRowCount(); ++i) {
                                if (DiffFileTable.this.editorCookies.get(((DiffNode)DiffFileTable.this.tableModel.getNode(i)).getFile()) != cookie) continue;
                                DiffFileTable.this.tableModel.fireTableCellUpdated(i, 0);
                                break;
                            }
                        }
                    });
                }
            }
        };
        for (Map.Entry<File, EditorCookie> e : editorCookies.entrySet()) {
            EditorCookie editorCookie = e.getValue();
            if (!(editorCookie instanceof EditorCookie.Observable)) continue;
            ((EditorCookie.Observable)editorCookie).addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this.changeListener, (Object)editorCookie));
        }
    }

    protected JTable getDiffTable() {
        return super.getTable();
    }

    void setSelectedMode(GitClient.DiffMode diffMode) {
        this.diffMode = diffMode;
    }

    private class DiffTableCellRenderer
    extends DefaultTableCellRenderer {
        private FilePathCellRenderer pathRenderer = new FilePathCellRenderer();

        private DiffTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component renderer;
            int modelColumnIndex = table.convertColumnIndexToModel(column);
            DiffNode node = null;
            if (modelColumnIndex == 0) {
                node = (DiffNode)DiffFileTable.this.tableModel.getNode(table.convertRowIndexToModel(row));
                String htmlDisplayName = DiffUtils.getHtmlDisplayName((Node)node, (boolean)this.isModified(node.getFile()), (boolean)isSelected);
                if (GitModuleConfig.getDefault().isExcludedFromCommit(node.getFile().getAbsolutePath())) {
                    htmlDisplayName = "<s>" + (htmlDisplayName == null ? ((GitFileNode)node.getFileNode()).getName() : htmlDisplayName) + "</s>";
                }
                if (htmlDisplayName != null) {
                    value = "<html>" + htmlDisplayName;
                }
            }
            if ((renderer = modelColumnIndex == 2 ? this.pathRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column) : super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column)) instanceof JComponent) {
                if (node == null) {
                    node = (DiffNode)DiffFileTable.this.tableModel.getNode(table.convertRowIndexToModel(row));
                }
                String path = node.getFile().getAbsolutePath();
                ((JComponent)renderer).setToolTipText(path);
            }
            return renderer;
        }

        private boolean isModified(File file) {
            EditorCookie editorCookie = (EditorCookie)DiffFileTable.this.editorCookies.get(file);
            return editorCookie != null ? editorCookie.isModified() : false;
        }
    }

    private static class ColumnDescriptor<T>
    extends PropertySupport.ReadOnly<T> {
        public ColumnDescriptor(String name, Class<T> type, String displayName, String shortDescription) {
            super(name, type, displayName, shortDescription);
        }

        public T getValue() throws IllegalAccessException, InvocationTargetException {
            return null;
        }
    }
}

