/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.commit;

import java.awt.EventQueue;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.prefs.Preferences;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitUser;
import org.netbeans.modules.git.FileInformation;
import org.netbeans.modules.git.FileStatusCache;
import org.netbeans.modules.git.Git;
import org.netbeans.modules.git.GitModuleConfig;
import org.netbeans.modules.git.client.GitClientExceptionHandler;
import org.netbeans.modules.git.client.GitProgressSupport;
import org.netbeans.modules.git.ui.commit.CommitAction;
import org.netbeans.modules.git.ui.commit.GitCommitParameters;
import org.netbeans.modules.git.ui.commit.GitCommitTable;
import org.netbeans.modules.git.ui.commit.GitFileNode;
import org.netbeans.modules.git.ui.diff.MultiDiffPanelController;
import org.netbeans.modules.git.utils.GitUtils;
import org.netbeans.modules.versioning.hooks.GitHook;
import org.netbeans.modules.versioning.hooks.GitHookContext;
import org.netbeans.modules.versioning.hooks.VCSHookContext;
import org.netbeans.modules.versioning.hooks.VCSHooks;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.netbeans.modules.versioning.util.Utils;
import org.netbeans.modules.versioning.util.common.VCSCommitDiffProvider;
import org.netbeans.modules.versioning.util.common.VCSCommitFilter;
import org.netbeans.modules.versioning.util.common.VCSCommitPanel;
import org.netbeans.modules.versioning.util.common.VCSCommitParameters;
import org.netbeans.modules.versioning.util.common.VCSCommitTable;
import org.netbeans.modules.versioning.util.common.VCSFileNode;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.SaveCookie;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class GitCommitPanel
extends VCSCommitPanel<GitFileNode> {
    static final GitCommitFilter FILTER_HEAD_VS_WORKING = new GitCommitFilter("HEAD_VS_WORKING", new ImageIcon(GitCommitPanel.class.getResource("/org/netbeans/modules/git/resources/icons/head_vs_working.png")), NbBundle.getMessage(GitCommitPanel.class, (String)"ParametersPanel.tgbHeadVsWorking.toolTipText"), true);
    static final GitCommitFilter FILTER_HEAD_VS_INDEX = new GitCommitFilter("HEAD_VS_INDEX", new ImageIcon(GitCommitPanel.class.getResource("/org/netbeans/modules/git/resources/icons/head_vs_index.png")), NbBundle.getMessage(GitCommitPanel.class, (String)"ParametersPanel.tgbHeadVsIndex.toolTipText"), false);
    private final Collection<GitHook> hooks;
    private final File[] roots;
    private final File repository;
    private final boolean fromGitView;
    private final DiffProvider diffProvider;
    GitProgressSupport support;

    private GitCommitPanel(GitCommitTable table, File[] roots, File repository, VCSCommitParameters.DefaultCommitParameters parameters, Preferences preferences, Collection<GitHook> hooks, VCSHookContext hooksContext, DiffProvider diffProvider, boolean fromGitView, List<VCSCommitFilter> filters) {
        super((VCSCommitTable)table, (VCSCommitParameters)parameters, preferences, hooks, hooksContext, filters, (VCSCommitDiffProvider)diffProvider);
        this.diffProvider = diffProvider;
        this.roots = roots;
        this.repository = repository;
        this.hooks = hooks;
        this.fromGitView = fromGitView;
    }

    public static GitCommitPanel create(File[] roots, File repository, GitUser user, boolean fromGitView) {
        Preferences preferences = GitModuleConfig.getDefault().getPreferences();
        String lastCanceledCommitMessage = GitModuleConfig.getDefault().getLastCanceledCommitMessage();
        GitCommitParameters parameters = new GitCommitParameters(preferences, lastCanceledCommitMessage, user);
        Collection hooks = VCSHooks.getInstance().getHooks(GitHook.class);
        GitHookContext hooksCtx = new GitHookContext(roots, null, new GitHookContext.LogEntry[0]);
        DiffProvider diffProvider = new DiffProvider();
        return new GitCommitPanel(new GitCommitTable(), roots, repository, parameters, preferences, hooks, (VCSHookContext)hooksCtx, diffProvider, fromGitView, GitCommitPanel.createFilters(fromGitView));
    }

    private static void disableFilters() {
        for (GitCommitFilter f : Arrays.asList(FILTER_HEAD_VS_INDEX, FILTER_HEAD_VS_WORKING)) {
            f.setSelected(false);
        }
    }

    private static List<VCSCommitFilter> createFilters(boolean gitViewStoredMode) {
        assert (EventQueue.isDispatchThread());
        GitCommitPanel.disableFilters();
        FileInformation.Mode mode = gitViewStoredMode ? GitModuleConfig.getDefault().getLastUsedModificationContext() : GitModuleConfig.getDefault().getLastUsedCommitViewMode();
        (FileInformation.Mode.HEAD_VS_INDEX.equals((Object)mode) ? FILTER_HEAD_VS_INDEX : FILTER_HEAD_VS_WORKING).setSelected(true);
        return Arrays.asList(new VCSCommitFilter[]{FILTER_HEAD_VS_INDEX, FILTER_HEAD_VS_WORKING});
    }

    public GitCommitParameters getParameters() {
        return (GitCommitParameters)super.getParameters();
    }

    public Collection<GitHook> getHooks() {
        return this.hooks;
    }

    protected void computeNodes() {
        this.computeNodesIntern();
    }

    public boolean open(VCSContext context, HelpCtx helpCtx) {
        assert (EventQueue.isDispatchThread());
        boolean ok = super.open(context, helpCtx);
        GitProgressSupport supp = this.support;
        if (supp != null) {
            supp.cancel();
        }
        if (ok && !this.fromGitView) {
            GitModuleConfig.getDefault().setLastUsedCommitViewMode(this.getSelectedFilter() == FILTER_HEAD_VS_INDEX ? FileInformation.Mode.HEAD_VS_INDEX : FileInformation.Mode.HEAD_VS_WORKING_TREE);
        }
        for (Map.Entry e : this.diffProvider.controllers.entrySet()) {
            ((MultiDiffPanelController)e.getValue()).componentClosed();
        }
        return ok;
    }

    RequestProcessor.Task computeNodesIntern() {
        final boolean[] refreshFinnished = new boolean[]{false};
        RequestProcessor rp = Git.getInstance().getRequestProcessor(this.repository);
        GitProgressSupport supp = this.support;
        if (supp != null) {
            supp.cancel();
        }
        this.support = this.getProgressSupport(refreshFinnished);
        String preparingMessage = NbBundle.getMessage(CommitAction.class, (String)"Progress_Preparing_Commit");
        this.setupProgress(preparingMessage, this.support.getProgressComponent());
        RequestProcessor.Task task = this.support.start(rp, this.repository, preparingMessage);
        Timer t = new Timer();
        t.schedule(new TimerTask(){

            @Override
            public void run() {
                if (!refreshFinnished[0]) {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            GitCommitPanel.this.showProgress();
                        }
                    });
                }
            }
        }, 1000L);
        return task;
    }

    protected GitProgressSupport getProgressSupport(final boolean[] refreshFinished) {
        return new GitProgressSupport(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void perform() {
                ArrayList<File> fileList;
                block9: {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            GitCommitPanel.this.getCommitTable().setNodes((VCSFileNode[])new GitFileNode[0]);
                        }
                    });
                    FileStatusCache cache = Git.getInstance().getFileStatusCache();
                    cache.refreshAllRoots(Collections.singletonMap(GitCommitPanel.this.repository, Arrays.asList(GitCommitPanel.this.roots)), this.getProgressMonitor());
                    refreshFinished[0] = true;
                    File[][] split = Utils.splitFlatOthers((File[])GitCommitPanel.this.roots);
                    fileList = new ArrayList<File>();
                    for (int c = 0; c < split.length; ++c) {
                        int i;
                        File[] files;
                        boolean recursive;
                        File[] splitRoots = split[c];
                        boolean bl = recursive = c == 1;
                        if (recursive) {
                            files = cache.listFiles(splitRoots, (EnumSet<FileInformation.Status>)GitCommitPanel.this.getAcceptedStatus());
                            for (i = 0; i < files.length; ++i) {
                                for (int r = 0; r < splitRoots.length; ++r) {
                                    if (!Utils.isAncestorOrEqual((File)splitRoots[r], (File)files[i]) || fileList.contains(files[i])) continue;
                                    fileList.add(files[i]);
                                }
                            }
                            continue;
                        }
                        files = GitUtils.flatten(splitRoots, GitCommitPanel.this.getAcceptedStatus());
                        for (i = 0; i < files.length; ++i) {
                            if (fileList.contains(files[i])) continue;
                            fileList.add(files[i]);
                        }
                    }
                    if (!fileList.isEmpty()) break block9;
                    refreshFinished[0] = true;
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            GitCommitPanel.this.stopProgress();
                        }
                    });
                    return;
                }
                try {
                    ArrayList<GitFileNode> nodesList = new ArrayList<GitFileNode>(fileList.size());
                    Git git = Git.getInstance();
                    for (File file : fileList) {
                        if (!GitCommitPanel.this.repository.equals(git.getRepositoryRoot(file))) continue;
                        GitFileNode node = new GitFileNode(GitCommitPanel.this.repository, file);
                        nodesList.add(node);
                    }
                    final GitFileNode[] nodes = nodesList.toArray(new GitFileNode[nodesList.size()]);
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            GitCommitPanel.this.getCommitTable().setNodes((VCSFileNode[])nodes);
                        }
                    });
                    refreshFinished[0] = true;
                }
                catch (Throwable throwable) {
                    refreshFinished[0] = true;
                    EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
                    throw throwable;
                }
                EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
        };
    }

    private EnumSet<FileInformation.Status> getAcceptedStatus() {
        VCSCommitFilter f = this.getSelectedFilter();
        if (f == FILTER_HEAD_VS_INDEX) {
            return FileInformation.STATUS_MODIFIED_HEAD_VS_INDEX;
        }
        if (f == FILTER_HEAD_VS_WORKING) {
            return FileInformation.STATUS_MODIFIED_HEAD_VS_WORKING;
        }
        throw new IllegalStateException("wrong filter " + (f != null ? f.getID() : "NULL"));
    }

    static class GitCommitPanelMerged
    extends GitCommitPanel {
        private final File repository;

        static GitCommitPanel create(File[] roots, File repository, GitUser user) {
            Preferences preferences = GitModuleConfig.getDefault().getPreferences();
            String lastCanceledCommitMessage = GitModuleConfig.getDefault().getLastCanceledCommitMessage();
            GitCommitParameters parameters = new GitCommitParameters(preferences, lastCanceledCommitMessage, user);
            Collection hooks = VCSHooks.getInstance().getHooks(GitHook.class);
            GitHookContext hooksCtx = new GitHookContext(roots, null, new GitHookContext.LogEntry[0]);
            DiffProvider diffProvider = new DiffProvider();
            return new GitCommitPanelMerged(new GitCommitTable(false), roots, repository, parameters, preferences, hooks, hooksCtx, diffProvider);
        }

        private GitCommitPanelMerged(GitCommitTable gitCommitTable, File[] roots, File repository, VCSCommitParameters.DefaultCommitParameters parameters, Preferences preferences, Collection<GitHook> hooks, GitHookContext hooksCtx, DiffProvider diffProvider) {
            super(gitCommitTable, roots, repository, parameters, preferences, hooks, (VCSHookContext)hooksCtx, diffProvider, true, GitCommitPanelMerged.createFilters());
            this.repository = repository;
        }

        private static List<VCSCommitFilter> createFilters() {
            GitCommitPanel.disableFilters();
            FILTER_HEAD_VS_INDEX.setSelected(true);
            return Collections.singletonList(FILTER_HEAD_VS_INDEX);
        }

        @Override
        protected GitProgressSupport getProgressSupport(boolean[] refreshFinnished) {
            return new MergedCommitDialogProgressSupport(refreshFinnished);
        }

        public void setErrorLabel(String htmlErrorLabel) {
            if (htmlErrorLabel == null || htmlErrorLabel.isEmpty()) {
                htmlErrorLabel = NbBundle.getMessage(GitCommitPanel.class, (String)"MSG_CommitPanel.afterMerge");
            }
            super.setErrorLabel(htmlErrorLabel);
        }

        private class MergedCommitDialogProgressSupport
        extends GitProgressSupport {
            private final boolean[] refreshFinished;

            MergedCommitDialogProgressSupport(boolean[] refreshFinished) {
                this.refreshFinished = refreshFinished;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void perform() {
                File[] files;
                block11: {
                    FileStatusCache cache;
                    block10: {
                        block9: {
                            EventQueue.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    GitCommitPanelMerged.this.getCommitTable().setNodes((VCSFileNode[])new GitFileNode[0]);
                                }
                            });
                            try {
                                files = this.getClient().listModifiedIndexEntries(new File[]{GitCommitPanelMerged.this.repository}, this.getProgressMonitor());
                            }
                            catch (GitException ex) {
                                GitClientExceptionHandler.notifyException((Exception)((Object)ex), true);
                                this.refreshFinished[0] = true;
                                EventQueue.invokeLater(new Runnable(){

                                    @Override
                                    public void run() {
                                        GitCommitPanelMerged.this.stopProgress();
                                    }
                                });
                                return;
                            }
                            cache = Git.getInstance().getFileStatusCache();
                            if (!this.isCanceled()) break block9;
                            this.refreshFinished[0] = true;
                            EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
                            return;
                        }
                        cache.refreshAllRoots(Collections.singletonMap(GitCommitPanelMerged.this.repository, Arrays.asList(files)), this.getProgressMonitor());
                        if (!this.isCanceled()) break block10;
                        this.refreshFinished[0] = true;
                        EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
                        return;
                    }
                    this.refreshFinished[0] = true;
                    files = cache.listFiles(new File[]{GitCommitPanelMerged.this.repository}, FileInformation.STATUS_MODIFIED_HEAD_VS_INDEX);
                    if (files.length != 0) break block11;
                    this.refreshFinished[0] = true;
                    EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
                    return;
                }
                try {
                    ArrayList<GitFileNode> nodesList = new ArrayList<GitFileNode>(files.length);
                    for (File file : files) {
                        GitFileNode node = new GitFileNode(GitCommitPanelMerged.this.repository, file);
                        nodesList.add(node);
                    }
                    final GitFileNode[] nodes = nodesList.toArray(new GitFileNode[files.length]);
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            GitCommitPanelMerged.this.getCommitTable().setNodes((VCSFileNode[])nodes);
                        }
                    });
                    this.refreshFinished[0] = true;
                }
                catch (Throwable throwable) {
                    this.refreshFinished[0] = true;
                    EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
                    throw throwable;
                }
                EventQueue.invokeLater(new /* invalid duplicate definition of identical inner class */);
            }
        }
    }

    private static class GitCommitFilter
    extends VCSCommitFilter {
        private final Icon icon;
        private final String tooltip;
        private final String id;

        GitCommitFilter(String id, Icon icon, String tooltip, boolean selected) {
            super(selected);
            this.icon = icon;
            this.tooltip = tooltip;
            this.id = id;
        }

        public Icon getIcon() {
            return this.icon;
        }

        public String getTooltip() {
            return this.tooltip;
        }

        public String getID() {
            return this.id;
        }

        public void setSelected(boolean selected) {
            super.setSelected(selected);
        }
    }

    private static class DiffProvider
    extends VCSCommitDiffProvider {
        private final Map<File, MultiDiffPanelController> controllers = new HashMap<File, MultiDiffPanelController>();

        private DiffProvider() {
        }

        public Set<File> getModifiedFiles() {
            return this.getSaveCookiesPerFile().keySet();
        }

        private Map<File, SaveCookie> getSaveCookiesPerFile() {
            HashMap<File, SaveCookie> modifiedFiles = new HashMap<File, SaveCookie>();
            for (Map.Entry<File, MultiDiffPanelController> e : this.controllers.entrySet()) {
                SaveCookie[] cookies = e.getValue().getSaveCookies(false);
                if (cookies.length <= 0) continue;
                modifiedFiles.put(e.getKey(), cookies[0]);
            }
            return modifiedFiles;
        }

        public JComponent createDiffComponent(File file) {
            MultiDiffPanelController controller = new MultiDiffPanelController(file);
            this.controllers.put(file, controller);
            return controller.getPanel();
        }

        protected SaveCookie[] getSaveCookies() {
            return this.getSaveCookiesPerFile().values().toArray(new SaveCookie[0]);
        }

        protected EditorCookie[] getEditorCookies() {
            LinkedList<EditorCookie> allCookies = new LinkedList<EditorCookie>();
            for (Map.Entry<File, MultiDiffPanelController> e : this.controllers.entrySet()) {
                EditorCookie[] cookies = e.getValue().getEditorCookies(true);
                if (cookies.length <= 0) continue;
                allCookies.add(cookies[0]);
            }
            return allCookies.toArray(new EditorCookie[allCookies.size()]);
        }
    }
}

