/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.commit;

import java.io.File;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.modules.git.GitModuleConfig;
import org.netbeans.modules.git.ui.actions.MultipleRepositoryAction;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.openide.nodes.Node;
import org.openide.util.RequestProcessor;

public class ExcludeFromCommitAction
extends MultipleRepositoryAction {
    @Override
    protected RequestProcessor.Task performAction(File repository, File[] roots, VCSContext context) {
        return this.exclude(repository, roots);
    }

    @Override
    protected boolean enable(Node[] activatedNodes) {
        boolean enabled = super.enable(activatedNodes);
        if (enabled) {
            enabled = false;
            GitModuleConfig config = GitModuleConfig.getDefault();
            for (File root : this.getCurrentContext(activatedNodes).getRootFiles()) {
                if (config.isExcludedFromCommit(root.getAbsolutePath())) continue;
                enabled = true;
                break;
            }
        }
        return enabled;
    }

    public RequestProcessor.Task exclude(File repository, File[] roots) {
        List<String> toExclude = ExcludeFromCommitAction.filterRoots(roots);
        GitModuleConfig config = GitModuleConfig.getDefault();
        config.addExclusionPaths(toExclude);
        return null;
    }

    private static List<String> filterRoots(File[] roots) {
        LinkedList<String> toExclude = new LinkedList<String>();
        GitModuleConfig config = GitModuleConfig.getDefault();
        for (File root : roots) {
            String path = root.getAbsolutePath();
            if (config.isExcludedFromCommit(path)) continue;
            toExclude.add(path);
        }
        return toExclude;
    }
}

