/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.commit;

import java.awt.EventQueue;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitRepositoryState;
import org.netbeans.libs.git.GitRevisionInfo;
import org.netbeans.libs.git.GitUser;
import org.netbeans.modules.git.FileInformation;
import org.netbeans.modules.git.Git;
import org.netbeans.modules.git.GitModuleConfig;
import org.netbeans.modules.git.client.GitClient;
import org.netbeans.modules.git.client.GitClientExceptionHandler;
import org.netbeans.modules.git.client.GitProgressSupport;
import org.netbeans.modules.git.ui.actions.SingleRepositoryAction;
import org.netbeans.modules.git.ui.commit.GitCommitPanel;
import org.netbeans.modules.git.ui.commit.GitCommitParameters;
import org.netbeans.modules.git.ui.commit.GitFileNode;
import org.netbeans.modules.git.ui.repository.RepositoryInfo;
import org.netbeans.modules.git.utils.GitUtils;
import org.netbeans.modules.versioning.hooks.GitHook;
import org.netbeans.modules.versioning.hooks.GitHookContext;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.netbeans.modules.versioning.util.common.VCSCommitFilter;
import org.netbeans.modules.versioning.util.common.VCSCommitOptions;
import org.netbeans.modules.versioning.util.common.VCSCommitTable;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileUtil;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class CommitAction
extends SingleRepositoryAction {
    private static final Logger LOG = Logger.getLogger(CommitAction.class.getName());

    protected String iconResource() {
        return "org/netbeans/modules/git/resources/icons/commit.png";
    }

    @Override
    protected void performAction(final File repository, final File[] roots, final VCSContext context) {
        if (!this.canCommit(repository)) {
            return;
        }
        RepositoryInfo info = RepositoryInfo.getInstance(repository);
        final GitRepositoryState state = info.getRepositoryState();
        EventQueue.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                GitUser user = null;
                GitClient client = null;
                try {
                    client = Git.getInstance().getClient(repository);
                    user = client.getUser();
                }
                catch (GitException ex) {
                    GitClientExceptionHandler.notifyException((Exception)((Object)ex), true);
                    return;
                }
                finally {
                    if (client != null) {
                        client.release();
                    }
                }
                GitCommitPanel panel = state == GitRepositoryState.MERGING_RESOLVED ? GitCommitPanel.GitCommitPanelMerged.create(roots, repository, user) : GitCommitPanel.create(roots, repository, user, CommitAction.this.isFromGitView(context));
                VCSCommitTable table = panel.getCommitTable();
                boolean ok = panel.open(context, new HelpCtx(CommitAction.class));
                if (ok) {
                    List commitFiles = table.getCommitFiles();
                    GitModuleConfig.getDefault().setLastCanceledCommitMessage("");
                    panel.getParameters().storeCommitMessage();
                    VCSCommitFilter selectedFilter = panel.getSelectedFilter();
                    RequestProcessor rp = Git.getInstance().getRequestProcessor(repository);
                    CommitProgressSupport support = new CommitProgressSupport(panel, commitFiles, selectedFilter, state);
                    support.start(rp, repository, NbBundle.getMessage(CommitAction.class, (String)"LBL_Commit_Progress"));
                } else if (!panel.getParameters().getCommitMessage().isEmpty()) {
                    GitModuleConfig.getDefault().setLastCanceledCommitMessage(panel.getParameters().getCommitMessage());
                }
            }
        });
    }

    private static void refreshFS(final Collection<File> filesToRefresh) {
        Git.getInstance().getRequestProcessor().post(new Runnable(){

            @Override
            public void run() {
                FileUtil.refreshFor((File[])filesToRefresh.toArray(new File[filesToRefresh.size()]));
            }
        }, 100);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean canCommit(File repository) {
        boolean commitPermitted = true;
        RepositoryInfo info = RepositoryInfo.getInstance(repository);
        GitRepositoryState state = info.getRepositoryState();
        if (!state.canCommit()) {
            commitPermitted = false;
            Map<Object, Object> conflicts = Collections.emptyMap();
            if (state.equals((Object)GitRepositoryState.MERGING)) {
                GitClient client = null;
                try {
                    client = Git.getInstance().getClient(repository);
                    conflicts = client.getConflicts(new File[]{repository}, GitUtils.NULL_PROGRESS_MONITOR);
                }
                catch (GitException ex) {
                    LOG.log(Level.INFO, null, ex);
                }
                finally {
                    if (client != null) {
                        client.release();
                    }
                }
            }
            NotifyDescriptor.Confirmation nd = conflicts.isEmpty() ? new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(CommitAction.class, (String)"LBL_CommitAction_CommitNotAllowed_State", (Object)state.toString()), NbBundle.getMessage(CommitAction.class, (String)"LBL_CommitAction_CannotCommit"), -1, 0) : new NotifyDescriptor.Confirmation((Object)NbBundle.getMessage(CommitAction.class, (String)"LBL_CommitAction_CommitNotAllowed_Conflicts"), NbBundle.getMessage(CommitAction.class, (String)"LBL_CommitAction_CannotCommit"), 0, 3);
            Object retval = DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
            if (retval == NotifyDescriptor.YES_OPTION) {
                GitUtils.openInVersioningView(conflicts.keySet(), repository, GitUtils.NULL_PROGRESS_MONITOR);
            }
        }
        return commitPermitted;
    }

    protected boolean isFromGitView(VCSContext context) {
        return GitUtils.isFromInternalView(context);
    }

    public static class GitViewCommitAction
    extends CommitAction {
        @Override
        protected boolean isFromGitView(VCSContext context) {
            return true;
        }
    }

    private static class CommitProgressSupport
    extends GitProgressSupport {
        private final GitCommitPanel panel;
        private final List<GitFileNode> commitFiles;
        private final VCSCommitFilter selectedFilter;
        private final GitRepositoryState state;

        private CommitProgressSupport(GitCommitPanel panel, List<GitFileNode> commitFiles, VCSCommitFilter selectedFilter, GitRepositoryState state) {
            this.panel = panel;
            this.commitFiles = commitFiles;
            this.selectedFilter = selectedFilter;
            this.state = state;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void perform() {
            try {
                LinkedList<File> addCandidates = new LinkedList<File>();
                LinkedList<File> deleteCandidates = new LinkedList<File>();
                LinkedList<File> commitCandidates = new LinkedList<File>();
                GitCommitParameters parameters = this.panel.getParameters();
                GitClient client = this.getClient();
                this.populateCandidates(addCandidates, deleteCandidates, commitCandidates);
                if (this.isCanceled()) {
                    return;
                }
                String message = parameters.getCommitMessage();
                GitUser author = parameters.getAuthor();
                GitUser commiter = parameters.getCommiter();
                Collection<GitHook> hooks = this.panel.getHooks();
                try {
                    this.outputInRed(NbBundle.getMessage(CommitAction.class, (String)"MSG_COMMIT_TITLE"));
                    this.outputInRed(NbBundle.getMessage(CommitAction.class, (String)"MSG_COMMIT_TITLE_SEP"));
                    if (addCandidates.size() > 0) {
                        client.add(addCandidates.toArray(new File[addCandidates.size()]), this.getProgressMonitor());
                    }
                    if (deleteCandidates.size() > 0) {
                        client.remove(deleteCandidates.toArray(new File[deleteCandidates.size()]), false, this.getProgressMonitor());
                    }
                    if (GitModuleConfig.getDefault().getSignOff() && commiter != null) {
                        message = message + "\nSigned-off-by:" + GitCommitParameters.getUserString(commiter);
                    }
                    String origMessage = message;
                    message = this.beforeCommitHook(commitCandidates, hooks, message);
                    GitRevisionInfo info = this.commit(commitCandidates, message, author, commiter);
                    GitModuleConfig.getDefault().putRecentCommitAuthors(GitCommitParameters.getUserString(author));
                    GitModuleConfig.getDefault().putRecentCommiter(GitCommitParameters.getUserString(commiter));
                    this.afterCommitHook(commitCandidates, hooks, info, origMessage);
                }
                catch (GitException ex) {
                    GitClientExceptionHandler.notifyException((Exception)((Object)ex), true);
                }
                finally {
                    CommitAction.refreshFS(commitCandidates);
                    Git.getInstance().getFileStatusCache().refreshAllRoots(commitCandidates);
                    this.outputInRed(NbBundle.getMessage(CommitAction.class, (String)"MSG_COMMIT_DONE"));
                    this.output("");
                    Git.getInstance().getHistoryProvider().fireHistoryChange(commitCandidates.toArray(new File[commitCandidates.size()]));
                }
            }
            catch (GitException ex) {
                LOG.log(Level.WARNING, null, ex);
            }
        }

        private void populateCandidates(List<File> addCandidates, List<File> deleteCandidates, List<File> commitCandidates) {
            ArrayList<String> excPaths = new ArrayList<String>();
            ArrayList<String> incPaths = new ArrayList<String>();
            Iterator<GitFileNode> it = this.commitFiles.iterator();
            while (it.hasNext()) {
                if (this.isCanceled()) {
                    return;
                }
                GitFileNode node = it.next();
                FileInformation info = node.getInformation();
                VCSCommitOptions option = node.getCommitOptions();
                File file = node.getFile();
                if (option != VCSCommitOptions.EXCLUDE) {
                    if (info.containsStatus(FileInformation.Status.NEW_INDEX_WORKING_TREE) || info.containsStatus(FileInformation.Status.MODIFIED_INDEX_WORKING_TREE) && this.selectedFilter == GitCommitPanel.FILTER_HEAD_VS_WORKING) {
                        addCandidates.add(file);
                    } else if (info.containsStatus(FileInformation.STATUS_REMOVED)) {
                        deleteCandidates.add(file);
                    }
                    commitCandidates.add(file);
                    incPaths.add(file.getAbsolutePath());
                    continue;
                }
                excPaths.add(file.getAbsolutePath());
            }
            if (!excPaths.isEmpty()) {
                GitModuleConfig.getDefault().addExclusionPaths(excPaths);
            }
            if (!incPaths.isEmpty()) {
                GitModuleConfig.getDefault().removeExclusionPaths(incPaths);
            }
        }

        private String beforeCommitHook(List<File> commitCandidates, Collection<GitHook> hooks, String message) {
            if (hooks.isEmpty()) {
                return message;
            }
            File[] hookFiles = commitCandidates.toArray(new File[commitCandidates.size()]);
            for (GitHook hook : hooks) {
                try {
                    GitHookContext context = new GitHookContext(hookFiles, message, new GitHookContext.LogEntry[0]);
                    if ((context = hook.beforeCommit(context)) == null || context.getMessage() == null || context.getMessage().isEmpty()) continue;
                    message = context.getMessage();
                }
                catch (IOException ex) {}
            }
            return message;
        }

        private void afterCommitHook(List<File> commitCandidates, Collection<GitHook> hooks, GitRevisionInfo info, String origMessage) {
            if (hooks.isEmpty()) {
                return;
            }
            File[] hookFiles = commitCandidates.toArray(new File[commitCandidates.size()]);
            GitHookContext.LogEntry logEntry = new GitHookContext.LogEntry(info.getFullMessage(), info.getAuthor().getName(), info.getRevision(), new Date(info.getCommitTime()));
            GitHookContext context = new GitHookContext(hookFiles, origMessage, new GitHookContext.LogEntry[]{logEntry});
            for (GitHook hook : hooks) {
                hook.afterCommit(context);
            }
        }

        private GitRevisionInfo commit(List<File> commitCandidates, String message, GitUser author, GitUser commiter) throws GitException {
            GitRevisionInfo info = this.getClient().commit(this.state == GitRepositoryState.MERGING_RESOLVED ? new File[]{} : commitCandidates.toArray(new File[commitCandidates.size()]), message, author, commiter, this.getProgressMonitor());
            this.printInfo(info);
            return info;
        }

        private void printInfo(GitRevisionInfo info) {
            StringBuilder sb = new StringBuilder(10);
            GitUtils.printInfo(sb, info);
            this.getLogger().output(sb.toString());
        }
    }
}

