/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.actions;

import java.io.File;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.GitRemoteConfig;
import org.netbeans.modules.git.Git;
import org.netbeans.modules.git.client.GitClient;
import org.netbeans.modules.git.ui.actions.GitAction;
import org.netbeans.modules.git.utils.GitUtils;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.nodes.Node;

public abstract class SingleRepositoryAction
extends GitAction {
    private static final Logger LOG = Logger.getLogger(SingleRepositoryAction.class.getName());
    private static final Set<File> loggedRepositories = new HashSet<File>();

    @Override
    protected final void performContextAction(final Node[] nodes) {
        Utils.postParallel((Runnable)new Runnable(){

            @Override
            public void run() {
                VCSContext context = SingleRepositoryAction.this.getCurrentContext(nodes);
                SingleRepositoryAction.this.performAction(context);
            }
        }, (int)0);
    }

    public final void performAction(VCSContext context) {
        Map.Entry<File, File[]> actionRoots = SingleRepositoryAction.getActionRoots(context);
        if (actionRoots != null) {
            this.logRemoteRepositoryAccess(actionRoots.getKey());
            this.performAction(actionRoots.getKey(), actionRoots.getValue(), context);
        }
    }

    protected abstract void performAction(File var1, File[] var2, VCSContext var3);

    protected static Map.Entry<File, File[]> getActionRoots(VCSContext context) {
        Set<File> repositories = GitUtils.getRepositoryRoots(context);
        if (repositories.isEmpty()) {
            LOG.log(Level.FINE, "No repository in the given context: {0}", context.getRootFiles());
            return null;
        }
        AbstractMap.SimpleImmutableEntry<File, File[]> actionRoots = GitUtils.getActionRoots(context);
        if (actionRoots != null) {
            File repository = actionRoots.getKey();
            if (repositories.size() > 1) {
                LOG.log(Level.FINE, "Multiple repositories in the given context: {0}, selected {1}", new Object[]{context.getRootFiles(), repository});
            }
        }
        return actionRoots;
    }

    private void logRemoteRepositoryAccess(final File repositoryRoot) {
        if (loggedRepositories.add(repositoryRoot)) {
            Git.getInstance().getRequestProcessor(repositoryRoot).post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    HashSet urls = new HashSet();
                    GitClient client = null;
                    try {
                        client = Git.getInstance().getClient(repositoryRoot);
                        Map<String, GitRemoteConfig> cfgs = client.getRemotes(GitUtils.NULL_PROGRESS_MONITOR);
                        for (Map.Entry<String, GitRemoteConfig> e : cfgs.entrySet()) {
                            GitRemoteConfig cfg = e.getValue();
                            for (List uris : Arrays.asList(cfg.getUris(), cfg.getPushUris())) {
                                if (uris.isEmpty()) continue;
                                urls.addAll(uris);
                            }
                        }
                    }
                    catch (GitException ex) {
                    }
                    finally {
                        if (client != null) {
                            client.release();
                        }
                    }
                    for (String url : urls) {
                        if (url.trim().isEmpty()) continue;
                        Utils.logVCSExternalRepository((String)"GIT", (String)url);
                    }
                }
            });
        }
    }
}

