/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.actions;

import java.io.File;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.progress.NotificationListener;
import org.netbeans.modules.git.FileInformation;
import org.netbeans.modules.git.Git;
import org.netbeans.modules.git.client.GitClient;
import org.netbeans.modules.git.client.GitClientExceptionHandler;
import org.netbeans.modules.git.client.GitProgressSupport;
import org.netbeans.modules.git.ui.actions.GitAction;
import org.netbeans.modules.git.ui.actions.SingleRepositoryAction;
import org.netbeans.modules.git.utils.GitUtils;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.openide.util.NbBundle;

public class AddAction
extends SingleRepositoryAction {
    @Override
    protected void performAction(File repository, final File[] roots, VCSContext context) {
        GitProgressSupport supp = new GitProgressSupport(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected void perform() {
                File[] actionRoots = GitUtils.listFiles(roots, FileInformation.STATUS_LOCAL_CHANGES);
                if (actionRoots.length == 0) {
                    return;
                }
                try {
                    GitClient client = this.getClient();
                    client.addNotificationListener((NotificationListener)new GitProgressSupport.DefaultFileListener(actionRoots));
                    client.add(actionRoots, this.getProgressMonitor());
                }
                catch (GitException ex) {
                    GitClientExceptionHandler.notifyException((Exception)((Object)ex), true);
                }
                finally {
                    this.setDisplayName(NbBundle.getMessage(GitAction.class, (String)"LBL_Progress.RefreshingStatuses"));
                    Git.getInstance().getFileStatusCache().refreshAllRoots(actionRoots);
                }
            }
        };
        supp.start(Git.getInstance().getRequestProcessor(repository), repository, NbBundle.getMessage(AddAction.class, (String)"LBL_AddProgress"));
    }
}

