/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import org.netbeans.libs.git.GitException;
import org.netbeans.libs.git.progress.ProgressMonitor;
import org.netbeans.modules.git.Git;
import org.netbeans.modules.git.client.GitClient;
import org.netbeans.modules.versioning.util.Utils;

public class VersionsCache {
    private static VersionsCache instance;

    private VersionsCache() {
    }

    public static synchronized VersionsCache getInstance() {
        if (instance == null) {
            instance = new VersionsCache();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getFileRevision(File base, String revision, ProgressMonitor pm) throws IOException {
        if ("-1".equals(revision)) {
            return null;
        }
        File repository = Git.getInstance().getRepositoryRoot(base);
        if ("CURRENT".equals(revision)) {
            return base;
        }
        File tempFile = new File(Utils.getTempFolder(), "nb-git-" + base.getName());
        tempFile.deleteOnExit();
        GitClient client = null;
        try {
            boolean result;
            client = Git.getInstance().getClient(repository);
            FileOutputStream fos = new FileOutputStream(tempFile);
            try {
                result = "INDEX".equals(revision) ? client.catIndexEntry(base, 0, fos, pm) : client.catFile(base, revision, fos, pm);
            }
            finally {
                fos.close();
            }
            if (!result) {
                tempFile.delete();
                tempFile = null;
            }
        }
        catch (FileNotFoundException ex) {
            tempFile.delete();
            tempFile = null;
        }
        catch (GitException.MissingObjectException ex) {
            tempFile.delete();
            tempFile = null;
        }
        catch (GitException ex) {
            throw new IOException(ex);
        }
        finally {
            if (client != null) {
                client.release();
            }
        }
        return tempFile;
    }
}

