/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.regex.Pattern;
import javax.swing.Action;
import org.netbeans.libs.git.GitBranch;
import org.netbeans.libs.git.GitRepositoryState;
import org.netbeans.libs.git.GitTag;
import org.netbeans.modules.git.FileInformation;
import org.netbeans.modules.git.FileStatusCache;
import org.netbeans.modules.git.Git;
import org.netbeans.modules.git.options.AnnotationColorProvider;
import org.netbeans.modules.git.ui.actions.AddAction;
import org.netbeans.modules.git.ui.blame.AnnotateAction;
import org.netbeans.modules.git.ui.commit.CommitAction;
import org.netbeans.modules.git.ui.commit.ExcludeFromCommitAction;
import org.netbeans.modules.git.ui.commit.IncludeInCommitAction;
import org.netbeans.modules.git.ui.conflicts.ResolveConflictsAction;
import org.netbeans.modules.git.ui.diff.DiffAction;
import org.netbeans.modules.git.ui.history.SearchHistoryAction;
import org.netbeans.modules.git.ui.ignore.IgnoreAction;
import org.netbeans.modules.git.ui.ignore.UnignoreAction;
import org.netbeans.modules.git.ui.menu.BranchMenu;
import org.netbeans.modules.git.ui.menu.CheckoutMenu;
import org.netbeans.modules.git.ui.menu.ExportMenu;
import org.netbeans.modules.git.ui.menu.RemoteMenu;
import org.netbeans.modules.git.ui.menu.RevertMenu;
import org.netbeans.modules.git.ui.menu.TagMenu;
import org.netbeans.modules.git.ui.merge.MergeRevisionAction;
import org.netbeans.modules.git.ui.output.OpenOutputAction;
import org.netbeans.modules.git.ui.repository.RepositoryBrowserAction;
import org.netbeans.modules.git.ui.repository.RepositoryInfo;
import org.netbeans.modules.git.ui.reset.ResetAction;
import org.netbeans.modules.git.ui.status.StatusAction;
import org.netbeans.modules.git.utils.GitUtils;
import org.netbeans.modules.versioning.spi.VCSAnnotator;
import org.netbeans.modules.versioning.spi.VCSContext;
import org.netbeans.modules.versioning.spi.VersioningSupport;
import org.netbeans.modules.versioning.util.SystemActionBridge;
import org.netbeans.modules.versioning.util.Utils;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.openide.util.ContextAwareAction;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;

public class Annotator
extends VCSAnnotator
implements PropertyChangeListener {
    private static final EnumSet<FileInformation.Status> STATUS_IS_IMPORTANT = EnumSet.noneOf(FileInformation.Status.class);
    private static final EnumSet<FileInformation.Status> STATUS_BADGEABLE = EnumSet.of(FileInformation.Status.UPTODATE, FileInformation.Status.NEW_INDEX_WORKING_TREE, FileInformation.Status.MODIFIED_HEAD_WORKING_TREE);
    private static final Pattern lessThan;
    private static final String badgeModified = "org/netbeans/modules/git/resources/icons/modified-badge.png";
    private static final String badgeConflicts = "org/netbeans/modules/git/resources/icons/conflicts-badge.png";
    private static final String toolTipModified;
    private static final String toolTipConflict;
    private final FileStatusCache cache;
    private MessageFormat format;
    private String emptyFormat;
    public static final String ACTIONS_PATH_PREFIX = "Actions/Git/";
    private final Map<RepositoryInfo, Set<File>> filesWithRepositoryAnnotations = new WeakHashMap<RepositoryInfo, Set<File>>(3);

    public Annotator() {
        this.cache = Git.getInstance().getFileStatusCache();
    }

    public Action[] getActions(VCSContext context, VCSAnnotator.ActionDestination destination) {
        Set<File> roots = GitUtils.getRepositoryRoots(context);
        boolean noneVersioned = roots == null || roots.isEmpty();
        LinkedList<Action> actions = new LinkedList<Action>();
        if (destination.equals((Object)VCSAnnotator.ActionDestination.MainMenu)) {
            if (noneVersioned) {
                this.addAction("org-netbeans-modules-git-ui-clone-CloneAction", context, actions, true);
                this.addAction("org-netbeans-modules-git-ui-init-InitAction", context, actions, true);
                actions.add(null);
                actions.add((Action)SystemAction.get(RepositoryBrowserAction.class));
            } else {
                actions.add((Action)SystemAction.get(StatusAction.class));
                actions.add((Action)SystemAction.get(AddAction.class));
                actions.add((Action)SystemAction.get(CommitAction.class));
                actions.add((Action)SystemAction.get(DiffAction.class));
                actions.add(new ExportMenu(VCSAnnotator.ActionDestination.MainMenu, null));
                actions.add(new RevertMenu(VCSAnnotator.ActionDestination.MainMenu, null));
                IgnoreAction ia = (IgnoreAction)SystemAction.get(IgnoreAction.class);
                UnignoreAction uia = (UnignoreAction)SystemAction.get(UnignoreAction.class);
                ExcludeFromCommitAction efca = (ExcludeFromCommitAction)SystemAction.get(ExcludeFromCommitAction.class);
                IncludeInCommitAction iica = (IncludeInCommitAction)SystemAction.get(IncludeInCommitAction.class);
                if (ia.isEnabled() || uia.isEnabled() || efca.isEnabled() || iica.isEnabled()) {
                    actions.add(null);
                    if (ia.isEnabled()) {
                        actions.add((Action)((Object)ia));
                    }
                    if (uia.isEnabled()) {
                        actions.add((Action)((Object)uia));
                    }
                    if (efca.isEnabled()) {
                        actions.add((Action)((Object)efca));
                    } else if (iica.isEnabled()) {
                        actions.add((Action)((Object)iica));
                    }
                }
                actions.add(null);
                actions.add((Action)SystemAction.get(RepositoryBrowserAction.class));
                actions.add((Action)SystemAction.get(OpenOutputAction.class));
                actions.add(null);
                actions.add(new BranchMenu(VCSAnnotator.ActionDestination.MainMenu, null));
                actions.add(new TagMenu(VCSAnnotator.ActionDestination.MainMenu, null));
                actions.add(new CheckoutMenu(VCSAnnotator.ActionDestination.MainMenu, null));
                actions.add((Action)SystemAction.get(MergeRevisionAction.class));
                ResolveConflictsAction a = (ResolveConflictsAction)SystemAction.get(ResolveConflictsAction.class);
                if (a.isEnabled()) {
                    actions.add(null);
                    actions.add((Action)((Object)a));
                }
                actions.add(null);
                actions.add((Action)SystemAction.get(ResetAction.class));
                actions.add(null);
                this.addAction("org-netbeans-modules-git-ui-clone-CloneAction", context, actions, true);
                actions.add(new RemoteMenu(VCSAnnotator.ActionDestination.MainMenu, null));
                actions.add((Action)SystemAction.get(SearchHistoryAction.class));
                actions.add((Action)SystemAction.get(AnnotateAction.class));
            }
            Utils.setAcceleratorBindings((String)ACTIONS_PATH_PREFIX, (Action[])actions.toArray(new Action[actions.size()]));
        } else {
            Lookup lkp = context.getElements();
            if (noneVersioned) {
                this.addAction("org-netbeans-modules-git-ui-init-InitAction", context, actions);
            } else {
                Node[] nodes = context.getElements().lookupAll(Node.class).toArray(new Node[0]);
                actions.add((Action)SystemActionBridge.createAction((Action)SystemAction.get(StatusAction.class), (String)NbBundle.getMessage(StatusAction.class, (String)"LBL_StatusAction.popupName"), (Lookup)lkp));
                actions.add((Action)SystemActionBridge.createAction((Action)SystemAction.get(AddAction.class), (String)NbBundle.getMessage(AddAction.class, (String)"LBL_AddAction.popupName"), (Lookup)lkp));
                actions.add((Action)SystemActionBridge.createAction((Action)SystemAction.get(CommitAction.class), (String)NbBundle.getMessage(CommitAction.class, (String)"LBL_CommitAction.popupName"), (Lookup)lkp));
                actions.add((Action)SystemActionBridge.createAction((Action)SystemAction.get(DiffAction.class), (String)NbBundle.getMessage(DiffAction.class, (String)"LBL_DiffAction_PopupName"), (Lookup)lkp));
                actions.add(new ExportMenu(VCSAnnotator.ActionDestination.PopupMenu, lkp));
                actions.add(new RevertMenu(VCSAnnotator.ActionDestination.PopupMenu, lkp));
                SystemActionBridge ia = SystemActionBridge.createAction((Action)SystemAction.get(IgnoreAction.class), (String)NbBundle.getMessage(IgnoreAction.class, (String)"LBL_IgnoreAction_PopupName"), (Lookup)lkp);
                SystemActionBridge uia = SystemActionBridge.createAction((Action)SystemAction.get(UnignoreAction.class), (String)NbBundle.getMessage(UnignoreAction.class, (String)"LBL_UnignoreAction_PopupName"), (Lookup)lkp);
                SystemActionBridge efca = SystemActionBridge.createAction((Action)SystemAction.get(ExcludeFromCommitAction.class), (String)NbBundle.getMessage(ExcludeFromCommitAction.class, (String)"LBL_ExcludeFromCommitAction_PopupName"), (Lookup)lkp);
                SystemActionBridge iica = SystemActionBridge.createAction((Action)SystemAction.get(IncludeInCommitAction.class), (String)NbBundle.getMessage(IncludeInCommitAction.class, (String)"LBL_IncludeInCommitAction_PopupName"), (Lookup)lkp);
                if (ia.isEnabled() || uia.isEnabled() || efca.isEnabled() || iica.isEnabled()) {
                    actions.add(null);
                    if (ia.isEnabled()) {
                        actions.add((Action)ia);
                    }
                    if (uia.isEnabled()) {
                        actions.add((Action)uia);
                    }
                    if (efca.isEnabled()) {
                        actions.add((Action)efca);
                    } else if (iica.isEnabled()) {
                        actions.add((Action)iica);
                    }
                }
                actions.add(null);
                actions.add(new BranchMenu(VCSAnnotator.ActionDestination.PopupMenu, lkp));
                actions.add(new TagMenu(VCSAnnotator.ActionDestination.PopupMenu, lkp));
                actions.add(new CheckoutMenu(VCSAnnotator.ActionDestination.PopupMenu, lkp));
                actions.add((Action)SystemActionBridge.createAction((Action)SystemAction.get(MergeRevisionAction.class), (String)NbBundle.getMessage(MergeRevisionAction.class, (String)"LBL_MergeRevisionAction_PopupName"), (Lookup)lkp));
                SystemActionBridge a = SystemActionBridge.createAction((Action)SystemAction.get(ResolveConflictsAction.class), (String)NbBundle.getMessage(ResolveConflictsAction.class, (String)"LBL_ResolveConflictsAction_PopupName"), (Lookup)lkp);
                if (a.isEnabled()) {
                    actions.add(null);
                    actions.add((Action)a);
                }
                actions.add(null);
                this.addAction("org-netbeans-modules-git-ui-clone-CloneAction", context, actions);
                actions.add(new RemoteMenu(VCSAnnotator.ActionDestination.PopupMenu, lkp));
                actions.add((Action)SystemActionBridge.createAction((Action)SystemAction.get(SearchHistoryAction.class), (String)NbBundle.getMessage(SearchHistoryAction.class, (String)"LBL_SearchHistoryAction_PopupName"), (Lookup)lkp));
                actions.add((Action)SystemActionBridge.createAction((Action)SystemAction.get(AnnotateAction.class), (String)(((AnnotateAction)SystemAction.get(AnnotateAction.class)).visible(nodes) ? NbBundle.getMessage(AnnotateAction.class, (String)"LBL_HideAnnotateAction_PopupName") : NbBundle.getMessage(AnnotateAction.class, (String)"LBL_ShowAnnotateAction_PopupName")), (Lookup)lkp));
            }
        }
        return actions.toArray(new Action[actions.size()]);
    }

    private void addAction(String name, VCSContext context, List<Action> actions) {
        this.addAction(name, context, actions, false);
    }

    private void addAction(String name, VCSContext context, List<Action> actions, boolean accelerate) {
        Action action = accelerate ? Utils.getAcceleratedAction((String)(ACTIONS_PATH_PREFIX + name + ".instance")) : (Action)FileUtil.getConfigObject((String)(ACTIONS_PATH_PREFIX + name + ".instance"), Action.class);
        if (action instanceof ContextAwareAction) {
            action = ((ContextAwareAction)action).createContextAwareInstance(Lookups.singleton((Object)context));
        }
        if (action != null) {
            actions.add(action);
        }
    }

    public Image annotateIcon(Image icon, VCSContext context) {
        boolean folderAnnotation = false;
        for (File file : context.getRootFiles()) {
            if (!file.isDirectory()) continue;
            folderAnnotation = true;
            Utils.addFolderToLog((File)file);
            break;
        }
        if (!folderAnnotation && context.getRootFiles().size() > 1) {
            boolean bl = folderAnnotation = !Utils.isFromMultiFileDataObject((VCSContext)context);
        }
        if (!folderAnnotation) {
            return this.annotateFileIcon(context, icon);
        }
        return this.annotateFolderIcon(context, icon);
    }

    public String annotateName(String name, VCSContext context) {
        FileInformation mostImportantInfo = null;
        File mostImportantFile = null;
        boolean folderAnnotation = false;
        for (File file : context.getRootFiles()) {
            FileInformation info = this.cache.getStatus(file);
            if (!info.containsStatus(STATUS_IS_IMPORTANT) || !Annotator.isMoreImportant(info, mostImportantInfo)) continue;
            mostImportantInfo = info;
            mostImportantFile = file;
            folderAnnotation = info.isDirectory();
        }
        if (!folderAnnotation && context.getRootFiles().size() > 1) {
            boolean bl = folderAnnotation = !Utils.isFromMultiFileDataObject((VCSContext)context);
        }
        if (mostImportantInfo == null) {
            return null;
        }
        return folderAnnotation ? this.annotateFolderNameHtml(name, context, mostImportantInfo, mostImportantFile) : this.annotateNameHtml(name, mostImportantInfo, mostImportantFile);
    }

    private static boolean isMoreImportant(FileInformation a, FileInformation b) {
        if (b == null) {
            return true;
        }
        if (a == null) {
            return false;
        }
        return a.getComparableStatus() < b.getComparableStatus();
    }

    private Image annotateFileIcon(VCSContext context, Image icon) throws IllegalArgumentException {
        FileInformation mostImportantInfo = null;
        for (File file : context.getRootFiles()) {
            FileInformation info = this.cache.getStatus(file);
            if (!info.containsStatus(STATUS_IS_IMPORTANT) || !Annotator.isMoreImportant(info, mostImportantInfo)) continue;
            mostImportantInfo = info;
        }
        if (mostImportantInfo == null) {
            return null;
        }
        String tooltip = null;
        String statusText = mostImportantInfo.getStatusText(FileInformation.Mode.HEAD_VS_WORKING_TREE);
        if (mostImportantInfo.containsStatus(FileInformation.Status.NOTVERSIONED_EXCLUDED)) {
            tooltip = this.getAnnotationProvider().EXCLUDED_FILE_TOOLTIP.getFormat().format(new Object[]{statusText});
        } else if (((Object)mostImportantInfo.getStatus()).equals(EnumSet.of(FileInformation.Status.NEW_HEAD_INDEX, FileInformation.Status.REMOVED_INDEX_WORKING_TREE))) {
            tooltip = this.getAnnotationProvider().UP_TO_DATE_FILE_TOOLTIP.getFormat().format(new Object[]{statusText});
        } else if (((Object)mostImportantInfo.getStatus()).equals(EnumSet.of(FileInformation.Status.MODIFIED_HEAD_INDEX, FileInformation.Status.MODIFIED_INDEX_WORKING_TREE))) {
            tooltip = this.getAnnotationProvider().UP_TO_DATE_FILE_TOOLTIP.getFormat().format(new Object[]{statusText});
        } else if (mostImportantInfo.containsStatus(FileInformation.Status.REMOVED_HEAD_WORKING_TREE)) {
            tooltip = this.getAnnotationProvider().REMOVED_FILE_TOOLTIP.getFormat().format(new Object[]{statusText});
        } else if (((Object)mostImportantInfo.getStatus()).equals(EnumSet.of(FileInformation.Status.NEW_INDEX_WORKING_TREE, FileInformation.Status.REMOVED_HEAD_INDEX))) {
            tooltip = this.getAnnotationProvider().UP_TO_DATE_FILE_TOOLTIP.getFormat().format(new Object[]{statusText});
        } else if (((Object)mostImportantInfo.getStatus()).equals(EnumSet.of(FileInformation.Status.NEW_INDEX_WORKING_TREE, FileInformation.Status.REMOVED_HEAD_INDEX, FileInformation.Status.MODIFIED_HEAD_WORKING_TREE))) {
            tooltip = this.getAnnotationProvider().MODIFIED_FILE_TOOLTIP.getFormat().format(new Object[]{statusText});
        } else if (mostImportantInfo.containsStatus(FileInformation.Status.NEW_INDEX_WORKING_TREE)) {
            tooltip = this.getAnnotationProvider().NEW_FILE_TOOLTIP.getFormat().format(new Object[]{statusText});
        } else if (mostImportantInfo.containsStatus(FileInformation.Status.NEW_HEAD_INDEX)) {
            tooltip = this.getAnnotationProvider().ADDED_FILE_TOOLTIP.getFormat().format(new Object[]{statusText});
        } else if (mostImportantInfo.containsStatus(FileInformation.Status.MODIFIED_HEAD_WORKING_TREE)) {
            tooltip = this.getAnnotationProvider().MODIFIED_FILE_TOOLTIP.getFormat().format(new Object[]{statusText});
        } else if (mostImportantInfo.containsStatus(FileInformation.Status.UPTODATE)) {
            tooltip = null;
        } else if (mostImportantInfo.containsStatus(FileInformation.Status.IN_CONFLICT)) {
            tooltip = this.getAnnotationProvider().CONFLICT_FILE_TOOLTIP.getFormat().format(new Object[]{statusText});
        } else if (mostImportantInfo.containsStatus(FileInformation.Status.NOTVERSIONED_NOTMANAGED)) {
            tooltip = null;
        } else if (mostImportantInfo.containsStatus(FileInformation.Status.UNKNOWN)) {
            tooltip = null;
        } else {
            throw new IllegalStateException("Unknown status: " + mostImportantInfo.getStatus());
        }
        return tooltip != null ? ImageUtilities.addToolTipToImage((Image)icon, (String)tooltip) : null;
    }

    private Image annotateFolderIcon(VCSContext context, Image icon) {
        boolean isVersioned = false;
        for (File file : context.getRootFiles()) {
            FileInformation info = this.cache.getStatus(file);
            if (!info.containsStatus(STATUS_BADGEABLE)) continue;
            isVersioned = true;
            break;
        }
        if (!isVersioned) {
            return null;
        }
        Image badge = null;
        if (this.cache.containsFiles(context, EnumSet.of(FileInformation.Status.IN_CONFLICT), false)) {
            badge = ImageUtilities.assignToolTipToImage((Image)ImageUtilities.loadImage((String)badgeConflicts, (boolean)true), (String)toolTipConflict);
        } else if (this.cache.containsFiles(context, FileInformation.STATUS_LOCAL_CHANGES, false)) {
            badge = ImageUtilities.assignToolTipToImage((Image)ImageUtilities.loadImage((String)badgeModified, (boolean)true), (String)toolTipModified);
        }
        if (badge != null) {
            return ImageUtilities.mergeImages((Image)icon, (Image)badge, (int)16, (int)9);
        }
        return icon;
    }

    private String annotateFolderNameHtml(String name, VCSContext context, FileInformation mostImportantInfo, File mostImportantFile) {
        boolean annotationsVisible = VersioningSupport.getPreferences().getBoolean("textAnnotationsVisible", false);
        String nameHtml = Annotator.htmlEncode(name);
        if (mostImportantInfo.containsStatus(FileInformation.Status.NOTVERSIONED_EXCLUDED)) {
            return this.getAnnotationProvider().EXCLUDED_FILE.getFormat().format(new Object[]{nameHtml, ""});
        }
        String folderAnnotation = "";
        Set roots = context.getRootFiles();
        File repository = Git.getInstance().getRepositoryRoot(mostImportantFile);
        if (annotationsVisible && (roots.size() > 1 || mostImportantFile.equals(repository))) {
            GitRepositoryState repositoryState;
            String branchLabel = "";
            RepositoryInfo info = RepositoryInfo.getInstance(repository);
            this.addFileWithRepositoryAnnotation(info, mostImportantFile);
            GitBranch branch = info.getActiveBranch();
            if (branch != null && (branchLabel = branch.getName()) == "(no branch)") {
                Map<String, GitTag> tags = info.getTags();
                StringBuilder tagLabel = new StringBuilder();
                for (GitTag tag : tags.values()) {
                    if (!tag.getTaggedObjectId().equals(branch.getId())) continue;
                    tagLabel.append(",").append(tag.getTagName());
                }
                if (tagLabel.length() <= 1) {
                    branchLabel = branch.getId();
                    if (branchLabel.length() > 7) {
                        branchLabel = branchLabel.substring(0, 7) + "...";
                    }
                } else {
                    tagLabel.delete(0, 1);
                    branchLabel = tagLabel.toString();
                }
            }
            folderAnnotation = (repositoryState = info.getRepositoryState()) != GitRepositoryState.SAFE ? repositoryState.toString() + " - " + branchLabel : branchLabel;
        }
        MessageFormat uptodateFormat = this.getAnnotationProvider().UP_TO_DATE_FILE.getFormat();
        return uptodateFormat.format(new Object[]{nameHtml, !folderAnnotation.isEmpty() ? " [" + folderAnnotation + "]" : ""});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addFileWithRepositoryAnnotation(RepositoryInfo info, File file) {
        info.removePropertyChangeListener(this);
        Map<RepositoryInfo, Set<File>> map = this.filesWithRepositoryAnnotations;
        synchronized (map) {
            Set<File> files = this.filesWithRepositoryAnnotations.get(info);
            if (files == null) {
                files = new HashSet<File>();
                this.filesWithRepositoryAnnotations.put(info, files);
            }
            files.add(file);
        }
        info.addPropertyChangeListener(this);
    }

    @Override
    public void propertyChange(final PropertyChangeEvent evt) {
        if (evt.getPropertyName() == "prop.activeBranch" || evt.getPropertyName() == "prop.state" || evt.getPropertyName() == "prop.head" && ((GitBranch)evt.getNewValue()).getName() == "(no branch)") {
            Utils.post((Runnable)new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Set filesToRefresh;
                    RepositoryInfo info = (RepositoryInfo)evt.getSource();
                    Map map = Annotator.this.filesWithRepositoryAnnotations;
                    synchronized (map) {
                        filesToRefresh = (Set)Annotator.this.filesWithRepositoryAnnotations.remove(info);
                    }
                    if (filesToRefresh != null && !filesToRefresh.isEmpty()) {
                        Git.getInstance().headChanged(filesToRefresh);
                    }
                }
            }, (int)400);
        }
    }

    public String annotateNameHtml(String name, FileInformation mostImportantInfo, File mostImportantFile) {
        String statusText;
        name = Annotator.htmlEncode(name);
        boolean annotationsVisible = VersioningSupport.getPreferences().getBoolean("textAnnotationsVisible", false);
        String textAnnotation = annotationsVisible && mostImportantFile != null && mostImportantInfo.containsStatus(STATUS_IS_IMPORTANT) ? (this.format != null ? this.formatAnnotation(mostImportantInfo, mostImportantFile) : (!(statusText = mostImportantInfo.getShortStatusText()).isEmpty() ? " [" + mostImportantInfo.getShortStatusText() + "]" : "")) : "";
        if (mostImportantInfo.containsStatus(FileInformation.Status.NOTVERSIONED_EXCLUDED)) {
            return this.getAnnotationProvider().EXCLUDED_FILE.getFormat().format(new Object[]{name, textAnnotation});
        }
        if (((Object)mostImportantInfo.getStatus()).equals(EnumSet.of(FileInformation.Status.NEW_HEAD_INDEX, FileInformation.Status.REMOVED_INDEX_WORKING_TREE))) {
            return this.getAnnotationProvider().UP_TO_DATE_FILE.getFormat().format(new Object[]{name, textAnnotation});
        }
        if (((Object)mostImportantInfo.getStatus()).equals(EnumSet.of(FileInformation.Status.MODIFIED_HEAD_INDEX, FileInformation.Status.MODIFIED_INDEX_WORKING_TREE))) {
            return this.getAnnotationProvider().UP_TO_DATE_FILE.getFormat().format(new Object[]{name, textAnnotation});
        }
        if (mostImportantInfo.containsStatus(FileInformation.Status.REMOVED_HEAD_WORKING_TREE)) {
            return this.getAnnotationProvider().REMOVED_FILE.getFormat().format(new Object[]{name, textAnnotation});
        }
        if (((Object)mostImportantInfo.getStatus()).equals(EnumSet.of(FileInformation.Status.NEW_INDEX_WORKING_TREE, FileInformation.Status.REMOVED_HEAD_INDEX))) {
            return this.getAnnotationProvider().UP_TO_DATE_FILE.getFormat().format(new Object[]{name, textAnnotation});
        }
        if (((Object)mostImportantInfo.getStatus()).equals(EnumSet.of(FileInformation.Status.NEW_INDEX_WORKING_TREE, FileInformation.Status.REMOVED_HEAD_INDEX, FileInformation.Status.MODIFIED_HEAD_WORKING_TREE))) {
            return this.getAnnotationProvider().MODIFIED_FILE.getFormat().format(new Object[]{name, textAnnotation});
        }
        if (mostImportantInfo.containsStatus(FileInformation.Status.NEW_INDEX_WORKING_TREE)) {
            return this.getAnnotationProvider().NEW_FILE.getFormat().format(new Object[]{name, textAnnotation});
        }
        if (mostImportantInfo.containsStatus(FileInformation.Status.NEW_HEAD_INDEX)) {
            return this.getAnnotationProvider().ADDED_FILE.getFormat().format(new Object[]{name, textAnnotation});
        }
        if (mostImportantInfo.containsStatus(FileInformation.Status.MODIFIED_HEAD_WORKING_TREE)) {
            return this.getAnnotationProvider().MODIFIED_FILE.getFormat().format(new Object[]{name, textAnnotation});
        }
        if (mostImportantInfo.containsStatus(FileInformation.Status.UPTODATE)) {
            return this.getAnnotationProvider().UP_TO_DATE_FILE.getFormat().format(new Object[]{name, textAnnotation});
        }
        if (mostImportantInfo.containsStatus(FileInformation.Status.IN_CONFLICT)) {
            return this.getAnnotationProvider().CONFLICT_FILE.getFormat().format(new Object[]{name, textAnnotation});
        }
        if (mostImportantInfo.containsStatus(FileInformation.Status.NOTVERSIONED_NOTMANAGED)) {
            return name;
        }
        if (mostImportantInfo.containsStatus(FileInformation.Status.UNKNOWN)) {
            return name;
        }
        throw new IllegalStateException("Unknown status: " + mostImportantInfo.getStatus());
    }

    private static String htmlEncode(String name) {
        if (name.indexOf(60) == -1) {
            return name;
        }
        return lessThan.matcher(name).replaceAll("&lt;");
    }

    private AnnotationColorProvider getAnnotationProvider() {
        return AnnotationColorProvider.getInstance();
    }

    private String formatAnnotation(FileInformation info, File file) {
        Object[] arguments;
        String annotation;
        String stickyString;
        String statusString = "";
        if (info.containsStatus(FileInformation.Status.UPTODATE)) {
            statusString = info.getShortStatusText();
        }
        if ((stickyString = null) == null) {
            stickyString = "";
        }
        if ((annotation = this.format.format(arguments = new Object[]{statusString, stickyString}, new StringBuffer(), (FieldPosition)null).toString().trim()).equals(this.emptyFormat)) {
            return "";
        }
        return " " + annotation;
    }

    static {
        STATUS_IS_IMPORTANT.addAll(FileInformation.STATUS_LOCAL_CHANGES);
        STATUS_IS_IMPORTANT.addAll(EnumSet.of(FileInformation.Status.UPTODATE, FileInformation.Status.NOTVERSIONED_EXCLUDED));
        lessThan = Pattern.compile("<");
        toolTipModified = "<img src=\"" + Annotator.class.getClassLoader().getResource(badgeModified) + "\">&nbsp;" + NbBundle.getMessage(Annotator.class, (String)"MSG_Contains_Modified");
        toolTipConflict = "<img src=\"" + Annotator.class.getClassLoader().getResource(badgeConflicts) + "\">&nbsp;" + NbBundle.getMessage(Annotator.class, (String)"MSG_Contains_Conflicts");
    }
}

