/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.nbimpl.actions;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.netbeans.api.project.Project;
import org.netbeans.modules.profiler.api.project.ProjectProfilingSupport;
import org.netbeans.modules.profiler.nbimpl.actions.ProfilerLauncher;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.ui.support.ProjectActionPerformer;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

public class ProjectSensitivePerformer
implements ProjectActionPerformer {
    private static final Logger LOG = Logger.getLogger(ProjectSensitivePerformer.class.getName());
    private final String command;

    public ProjectSensitivePerformer(String command) {
        this.command = command;
    }

    public boolean enable(Project project) {
        if (project == null) {
            return false;
        }
        ActionProvider ap = (ActionProvider)project.getLookup().lookup(ActionProvider.class);
        try {
            if (ap != null && ProjectSensitivePerformer.contains(ap.getSupportedActions(), this.command)) {
                ProjectProfilingSupport ppp = ProjectProfilingSupport.get((Lookup.Provider)project);
                if (ppp == null) {
                    return false;
                }
                return ppp.isProfilingSupported() && ap.isActionEnabled(this.command, project.getLookup());
            }
        }
        catch (IllegalArgumentException e) {
            LOG.log(Level.WARNING, null, e);
        }
        return false;
    }

    public void perform(Project project) {
        ActionProvider ap = (ActionProvider)project.getLookup().lookup(ActionProvider.class);
        if (ap != null) {
            ProxyLookup ctx = new ProxyLookup(new Lookup[]{project.getLookup(), Lookups.fixed((Object[])new Object[]{project})});
            SwingUtilities.invokeLater(new Runnable((Lookup)ctx){
                final /* synthetic */ Lookup val$ctx;
                {
                    this.val$ctx = lookup;
                }

                @Override
                public void run() {
                    ProfilerLauncher.Session s = ProfilerLauncher.newSession(ProjectSensitivePerformer.this.command, this.val$ctx);
                    if (s != null) {
                        s.run();
                    }
                }
            });
        }
    }

    private static boolean contains(String[] actions, String action) {
        for (String a : actions) {
            if (!a.equals(action)) continue;
            return true;
        }
        return false;
    }
}

