/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.nbimpl;

import java.io.File;
import java.util.Map;
import java.util.Properties;
import org.netbeans.lib.profiler.common.AttachSettings;
import org.netbeans.lib.profiler.common.ProfilingSettings;
import org.netbeans.modules.profiler.nbimpl.ProfilerControlPanel2Support;
import org.netbeans.modules.profiler.nbimpl.actions.ProfilerLauncher;
import org.netbeans.modules.profiler.spi.LoadGenPlugin;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Lookup;

public class NetBeansProfiler
extends org.netbeans.modules.profiler.NetBeansProfiler {
    private ProfilerControlPanel2Support actionSupport;

    public void storeProfilingProperties(Properties props) {
        this.getActionSupport().setProperties(props);
    }

    public String getLibsDir() {
        File dir = InstalledFileLocator.getDefault().locate("lib/jfluid-server.jar", "org.netbeans.lib.profiler", false);
        if (dir == null) {
            return null;
        }
        return dir.getParentFile().getPath();
    }

    public boolean rerunAvailable() {
        int state = this.getProfilingState();
        return state == 1 || state == 16 ? ProfilerLauncher.canRelaunch() : false;
    }

    public boolean modifyAvailable() {
        return this.getProfilingState() == 4;
    }

    public void rerunLastProfiling() {
        ProfilerLauncher.Session s = ProfilerLauncher.getLastSession();
        if (s != null) {
            s.run();
        }
    }

    public boolean attachToApp(ProfilingSettings profilingSettings, AttachSettings attachSettings) {
        this.getActionSupport().nullAll();
        return super.attachToApp(profilingSettings, attachSettings);
    }

    public void modifyCurrentProfiling(ProfilingSettings profilingSettings) {
        ProfilerLauncher.Session s;
        Properties properties = this.getActionSupport().getProperties();
        if (properties != null) {
            profilingSettings.store((Map)properties);
        }
        if ((s = ProfilerLauncher.getLastSession()) != null) {
            s.setProfilingSettings(profilingSettings);
        }
        super.modifyCurrentProfiling(profilingSettings);
    }

    Properties getCurrentProfilingProperties() {
        return this.getActionSupport().getProperties();
    }

    protected void cleanupAfterProfiling() {
        this.stopLoadGenerator();
        super.cleanupAfterProfiling();
    }

    private void stopLoadGenerator() {
        String scriptPath;
        LoadGenPlugin plugin;
        Properties profilingProperties = this.getCurrentProfilingProperties();
        if (profilingProperties != null && (plugin = (LoadGenPlugin)Lookup.getDefault().lookup(LoadGenPlugin.class)) != null && (scriptPath = profilingProperties.getProperty("profiler.loadgen.path")) != null) {
            plugin.stop(scriptPath);
        }
    }

    private synchronized ProfilerControlPanel2Support getActionSupport() {
        if (this.actionSupport == null) {
            this.actionSupport = new ProfilerControlPanel2Support();
        }
        return this.actionSupport;
    }
}

