/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.client.samples.wizard.ui;

import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.web.client.samples.wizard.ui.Bundle;
import org.netbeans.modules.web.client.samples.wizard.ui.SampleVisualPanel;
import org.netbeans.modules.web.clientproject.api.network.NetworkException;
import org.netbeans.modules.web.clientproject.api.network.NetworkSupport;
import org.netbeans.modules.web.clientproject.spi.SiteTemplateImplementation;
import org.netbeans.modules.web.clientproject.util.ValidationUtilities;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileChooserBuilder;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class OnlineSampleVisualPanel
extends JPanel {
    private final List<ChangeListener> listeners = new CopyOnWriteArrayList<ChangeListener>();
    private final WizardDescriptor descriptor;
    private JButton browseButton;
    private JLabel createdFolderLabel;
    private JTextField createdFolderTextField;
    private JLabel projectLocationLabel;
    private JTextField projectLocationTextField;
    private JLabel projectNameLabel;
    private JTextField projectNameTextField;
    private JLabel templateUrlLabel;
    private JTextField templateUrlTextField;

    public OnlineSampleVisualPanel(WizardDescriptor descriptor) {
        this.descriptor = descriptor;
        this.initComponents();
        this.initFields();
    }

    private void initFields() {
        String projectName = (String)this.descriptor.getProperty("sampleProjectName");
        String projectURL = (String)this.descriptor.getProperty("sampleProjectURL");
        this.templateUrlTextField.setText(projectURL);
        File projectLocation = ProjectChooser.getProjectsFolder();
        this.projectLocationTextField.setText(projectLocation.getAbsolutePath());
        this.projectNameTextField.setText(this.findName(projectLocation, projectName));
        this.projectNameTextField.selectAll();
        this.createdFolderTextField.setText(this.getProjectLocation() + File.separatorChar + this.getProjectName());
        DefaultDocumentListener documentListener = new DefaultDocumentListener();
        this.projectNameTextField.getDocument().addDocumentListener(documentListener);
        this.projectLocationTextField.getDocument().addDocumentListener(documentListener);
        this.setName(NbBundle.getMessage(OnlineSampleVisualPanel.class, (String)"LBL_NameAndLocation"));
    }

    private String findName(File projectLocation, String projectName) {
        String baseName = projectName;
        int index = 0;
        while (new File(projectLocation, projectName).exists()) {
            projectName = baseName + ++index;
        }
        return projectName;
    }

    public final void addChangeListener(ChangeListener listener) {
        this.listeners.add(listener);
    }

    public final void removeChangeListener(ChangeListener listener) {
        this.listeners.remove(listener);
    }

    public String getErrorMessage() {
        String error = this.validateProjectName();
        if (error != null) {
            return error;
        }
        error = this.validateProjectLocation();
        if (error != null) {
            return error;
        }
        return null;
    }

    private String validateProjectName() {
        String projectName = this.getProjectName();
        if (projectName.isEmpty()) {
            return Bundle.OnlineSampleVisualPanel_error_name_missing();
        }
        return null;
    }

    private String validateProjectLocation() {
        File projLoc;
        File projectLocation = FileUtil.normalizeFile((File)new File(this.getProjectLocation()).getAbsoluteFile());
        if (!projectLocation.isDirectory()) {
            return Bundle.OnlineSampleVisualPanel_error_location_invalid();
        }
        File destFolder = this.getProjectDirectory();
        if (!ValidationUtilities.isValidFilename((File)destFolder)) {
            return Bundle.OnlineSampleVisualPanel_error_location_invalid();
        }
        for (projLoc = destFolder; projLoc != null && !projLoc.exists(); projLoc = projLoc.getParentFile()) {
        }
        if (projLoc == null || !projLoc.canWrite()) {
            return Bundle.OnlineSampleVisualPanel_error_location_notWritable();
        }
        if (FileUtil.toFileObject((File)projLoc) == null) {
            return Bundle.OnlineSampleVisualPanel_error_location_invalid();
        }
        File[] kids = destFolder.listFiles();
        if (destFolder.exists() && kids != null && kids.length > 0) {
            return Bundle.OnlineSampleVisualPanel_error_location_notEmpty();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String prepareTemplate() {
        block12: {
            assert (!EventQueue.isDispatchThread());
            SiteTemplateImplementation siteTemplate = (SiteTemplateImplementation)this.descriptor.getProperty("sampleTemplate");
            String templateName = siteTemplate.getName();
            if (siteTemplate.isPrepared()) {
                return null;
            }
            ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)Bundle.SiteTemplateWizard_template_preparing(templateName));
            progressHandle.start();
            while (true) {
                try {
                    siteTemplate.prepare();
                    break block12;
                }
                catch (NetworkException ex) {
                    if (!NetworkSupport.showNetworkErrorDialog((List)ex.getFailedRequests())) {
                        String string = Bundle.SiteTemplateWizard_error_preparing(templateName);
                        progressHandle.finish();
                        return string;
                    }
                    try {
                    }
                    catch (IOException ex2) {
                        String string = Bundle.SiteTemplateWizard_error_preparing(templateName);
                        return string;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                progressHandle.finish();
            }
        }
        return null;
    }

    public String getProjectName() {
        return this.projectNameTextField.getText().trim();
    }

    public String getProjectLocation() {
        return this.projectLocationTextField.getText().trim();
    }

    public File getProjectDirectory() {
        return FileUtil.normalizeFile((File)new File(this.createdFolderTextField.getText()));
    }

    public String getProjectURL() {
        return this.templateUrlTextField.getText();
    }

    private void initComponents() {
        this.projectNameLabel = new JLabel();
        this.projectNameTextField = new JTextField();
        this.projectLocationLabel = new JLabel();
        this.createdFolderLabel = new JLabel();
        this.createdFolderTextField = new JTextField();
        this.projectLocationTextField = new JTextField();
        this.browseButton = new JButton();
        this.templateUrlLabel = new JLabel();
        this.templateUrlTextField = new JTextField();
        Mnemonics.setLocalizedText((JLabel)this.projectNameLabel, (String)NbBundle.getMessage(OnlineSampleVisualPanel.class, (String)"LBL_ProjectName"));
        Mnemonics.setLocalizedText((JLabel)this.projectLocationLabel, (String)NbBundle.getMessage(OnlineSampleVisualPanel.class, (String)"LBL_ProjectLocation"));
        this.projectLocationLabel.setMaximumSize(new Dimension(141, 15));
        this.projectLocationLabel.setMinimumSize(new Dimension(141, 15));
        this.projectLocationLabel.setPreferredSize(new Dimension(141, 15));
        Mnemonics.setLocalizedText((JLabel)this.createdFolderLabel, (String)NbBundle.getMessage(OnlineSampleVisualPanel.class, (String)"LBL_ProjectFolder"));
        this.createdFolderLabel.setMaximumSize(new Dimension(141, 15));
        this.createdFolderLabel.setMinimumSize(new Dimension(141, 15));
        this.createdFolderLabel.setPreferredSize(new Dimension(141, 15));
        this.createdFolderTextField.setEditable(false);
        Mnemonics.setLocalizedText((AbstractButton)this.browseButton, (String)NbBundle.getMessage(OnlineSampleVisualPanel.class, (String)"LBL_Browse"));
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                OnlineSampleVisualPanel.this.browseButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((JLabel)this.templateUrlLabel, (String)NbBundle.getMessage(OnlineSampleVisualPanel.class, (String)"OnlineSampleVisualPanel.templateUrlLabel.text"));
        this.templateUrlLabel.setMaximumSize(new Dimension(141, 15));
        this.templateUrlLabel.setMinimumSize(new Dimension(141, 15));
        this.templateUrlLabel.setPreferredSize(new Dimension(141, 15));
        this.templateUrlTextField.setEditable(false);
        this.templateUrlTextField.setText(NbBundle.getMessage(OnlineSampleVisualPanel.class, (String)"OnlineSampleVisualPanel.templateUrlTextField.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.projectNameLabel).addComponent(this.projectLocationLabel, -2, -1, -2).addComponent(this.createdFolderLabel, -2, -1, -2).addComponent(this.templateUrlLabel, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.projectLocationTextField, GroupLayout.Alignment.TRAILING).addComponent(this.createdFolderTextField, GroupLayout.Alignment.TRAILING).addComponent(this.projectNameTextField).addComponent(this.templateUrlTextField, -1, 382, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.browseButton)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.projectNameLabel).addComponent(this.projectNameTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.projectLocationLabel, -2, -1, -2).addComponent(this.projectLocationTextField, -2, -1, -2).addComponent(this.browseButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.createdFolderLabel, -2, -1, -2).addComponent(this.createdFolderTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.templateUrlLabel, -2, -1, -2).addComponent(this.templateUrlTextField, -2, -1, -2))));
        this.projectNameLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(OnlineSampleVisualPanel.class, (String)"OnlineSampleVisualPanel.projectNameLabel.AccessibleContext.accessibleName"));
        this.projectLocationLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(OnlineSampleVisualPanel.class, (String)"OnlineSampleVisualPanel.projectLocationLabel.AccessibleContext.accessibleName"));
        this.createdFolderLabel.getAccessibleContext().setAccessibleName(NbBundle.getMessage(OnlineSampleVisualPanel.class, (String)"OnlineSampleVisualPanel.createdFolderLabel.AccessibleContext.accessibleName"));
    }

    private void browseButtonActionPerformed(ActionEvent evt) {
        File projectDir;
        File projDir;
        File workDir = null;
        String projectLocation = this.getProjectLocation();
        if (projectLocation != null && !projectLocation.isEmpty() && (projDir = new File(projectLocation)).isDirectory()) {
            workDir = projDir;
        }
        if (workDir == null) {
            workDir = ProjectChooser.getProjectsFolder();
        }
        if ((projectDir = new FileChooserBuilder(SampleVisualPanel.class).setTitle(NbBundle.getMessage(SampleVisualPanel.class, (String)"TTL_DialogLocation")).setDirectoriesOnly(true).setDefaultWorkingDirectory(workDir).forceUseOfDefaultWorkingDirectory(true).showOpenDialog()) != null) {
            this.projectLocationTextField.setText(FileUtil.normalizeFile((File)projectDir).getAbsolutePath());
        }
    }

    private void updateProjectFolder() {
        this.createdFolderTextField.setText(this.getProjectLocation() + File.separatorChar + this.getProjectName());
    }

    private void fireChange() {
        for (ChangeListener listener : this.listeners) {
            listener.stateChanged(new ChangeEvent(this));
        }
    }

    private final class DefaultDocumentListener
    implements DocumentListener {
        private DefaultDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.processChange();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.processChange();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.processChange();
        }

        private void processChange() {
            OnlineSampleVisualPanel.this.updateProjectFolder();
            OnlineSampleVisualPanel.this.fireChange();
        }
    }
}

