/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.client.samples.wizard.iterator;

import java.awt.EventQueue;
import java.io.File;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Set;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.web.client.samples.wizard.iterator.AbstractWizardIterator;
import org.netbeans.modules.web.client.samples.wizard.iterator.Bundle;
import org.netbeans.modules.web.client.samples.wizard.ui.OnlineSamplePanel;
import org.netbeans.modules.web.clientproject.ClientSideProject;
import org.netbeans.modules.web.clientproject.sites.OnlineSites;
import org.netbeans.modules.web.clientproject.sites.SiteHelper;
import org.netbeans.modules.web.clientproject.spi.ClientProjectExtender;
import org.netbeans.modules.web.clientproject.spi.SiteTemplateImplementation;
import org.netbeans.modules.web.clientproject.util.ClientSideProjectUtilities;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.ProjectGenerator;
import org.netbeans.spi.project.ui.support.ProjectChooser;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class OnlineSampleWizardIterator
extends AbstractWizardIterator {
    private static final String LIBRARIES_PATH = "LIBRARIES_PATH";

    protected OnlineSampleWizardIterator() {
    }

    protected abstract SiteTemplateImplementation getSiteTemplate();

    protected abstract String getProjectName();

    protected abstract String getProjectZipURL();

    @Override
    protected WizardDescriptor.Panel[] createPanels(WizardDescriptor wizard) {
        wizard.putProperty("sampleProjectName", (Object)this.getProjectName());
        wizard.putProperty("sampleProjectURL", (Object)this.getProjectZipURL());
        wizard.putProperty("sampleTemplate", (Object)this.getSiteTemplate());
        return new WizardDescriptor.Panel[]{new OnlineSamplePanel(wizard)};
    }

    @Override
    public Set instantiate(ProgressHandle handle) throws IOException {
        File parent;
        handle.start();
        handle.progress(Bundle.OnlineSampleWizardIterator_creatingProject());
        LinkedHashSet<FileObject> files = new LinkedHashSet<FileObject>();
        File projectDir = FileUtil.normalizeFile((File)((File)this.descriptor.getProperty("sampleProjectDir")));
        String name = (String)this.descriptor.getProperty("sampleProjectName");
        if (!projectDir.isDirectory() && !projectDir.mkdirs()) {
            throw new IOException("Cannot create project directory");
        }
        FileObject projectDirFO = FileUtil.toFileObject((File)projectDir);
        AntProjectHelper projectHelper = ProjectGenerator.createProject((FileObject)projectDirFO, (String)"org.netbeans.modules.web.clientproject");
        this.setProjectName(projectHelper, name);
        files.add(projectDirFO);
        ClientSideProject project = (ClientSideProject)FileOwnerQuery.getOwner((FileObject)projectHelper.getProjectDirectory());
        EditableProperties properties = projectHelper.getProperties("nbproject/project.properties");
        properties.put("start.file", this.getStartFile());
        projectHelper.putProperties("nbproject/project.properties", properties);
        FileObject siteRoot = this.instantiate(handle, this.descriptor, project);
        FileObject startFile = siteRoot.getFileObject(this.getStartFile());
        if (startFile != null) {
            files.add(startFile);
        }
        if ((parent = projectDir.getParentFile()) != null && parent.exists()) {
            ProjectChooser.setProjectsFolder((File)parent);
        }
        handle.finish();
        return files;
    }

    protected String getStartFile() {
        return "index.html";
    }

    private void setProjectName(final AntProjectHelper projectHelper, final String name) {
        ProjectManager.mutex().writeAccess(new Runnable(){

            @Override
            public void run() {
                Element nameElement;
                Element data = projectHelper.getPrimaryConfigurationData(true);
                Document document = data.getOwnerDocument();
                NodeList nameList = data.getElementsByTagNameNS("http://www.netbeans.org/ns/clientside-project/1", "name");
                if (nameList.getLength() == 1) {
                    nameElement = (Element)nameList.item(0);
                    NodeList deadKids = nameElement.getChildNodes();
                    while (deadKids.getLength() > 0) {
                        nameElement.removeChild(deadKids.item(0));
                    }
                } else {
                    nameElement = document.createElementNS("http://www.netbeans.org/ns/clientside-project/1", "name");
                    data.insertBefore(nameElement, data.getChildNodes().item(0));
                }
                nameElement.appendChild(document.createTextNode(name));
                projectHelper.putPrimaryConfigurationData(data, true);
            }
        });
    }

    private FileObject instantiate(ProgressHandle handle, WizardDescriptor wizardDescriptor, ClientSideProject project) throws IOException {
        AntProjectHelper projectHelper = project.getProjectHelper();
        SiteTemplateImplementation siteTemplate = this.getSiteTemplate();
        SiteTemplateImplementation.ProjectProperties projectProperties = new SiteTemplateImplementation.ProjectProperties();
        projectProperties.setSiteRootFolder("public_html");
        projectProperties.setTestFolder("test");
        projectProperties.setConfigFolder("config");
        if (siteTemplate != null) {
            siteTemplate.configure(projectProperties);
            this.initProject(project, projectProperties);
            handle.progress(Bundle.OnlineSampleWizardIterator_applyingTemplate());
            this.applySiteTemplate(projectHelper.getProjectDirectory(), projectProperties, siteTemplate, handle);
        } else {
            this.initProject(project, projectProperties);
        }
        FileObject siteRootDir = project.getSiteRootFolder();
        assert (siteRootDir != null);
        for (ClientProjectExtender extender : Lookup.getDefault().lookupAll(ClientProjectExtender.class)) {
            extender.apply(project.getProjectDirectory(), siteRootDir, (String)wizardDescriptor.getProperty(LIBRARIES_PATH));
        }
        return siteRootDir;
    }

    private void initProject(ClientSideProject project, SiteTemplateImplementation.ProjectProperties properties) throws IOException {
        ClientSideProjectUtilities.initializeProject((ClientSideProject)project, (String)properties.getSiteRootFolder(), (String)properties.getTestFolder(), (String)properties.getConfigFolder());
    }

    private void applySiteTemplate(FileObject projectDir, SiteTemplateImplementation.ProjectProperties projectProperties, SiteTemplateImplementation siteTemplate, ProgressHandle handle) {
        assert (!EventQueue.isDispatchThread());
        String templateName = siteTemplate.getName();
        try {
            siteTemplate.apply(projectDir, projectProperties, handle);
        }
        catch (IOException ex) {
            this.errorOccured(Bundle.OnlineSampleWizardIterator_error_applyingSiteTemplate(templateName));
        }
    }

    private void errorOccured(String message) {
        DialogDisplayer.getDefault().notifyLater((NotifyDescriptor)new NotifyDescriptor.Message((Object)message, 0));
    }

    public static class OnlineSiteTemplate
    extends OnlineSites {
        public OnlineSiteTemplate(String id, String name, String url, String zipName) {
            this(id, name, "", url, zipName);
        }

        public OnlineSiteTemplate(String id, String name, String description, String url, String zipName) {
            super(id, name, description, url, new File(SiteHelper.getJsLibsDirectory(), zipName));
        }
    }
}

