/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.discovery.wizard.api.support;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmModel;
import org.netbeans.modules.cnd.api.model.CsmModelAccessor;
import org.netbeans.modules.cnd.api.model.CsmModelState;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.project.NativeFileItem;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.discovery.projectimport.ImportProject;
import org.netbeans.modules.cnd.discovery.wizard.api.DiscoveryDescriptor;
import org.netbeans.modules.cnd.discovery.wizard.api.support.ProjectBridge;
import org.netbeans.modules.cnd.discovery.wizard.support.impl.DiscoveryProjectGeneratorImpl;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptorProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.Folder;
import org.netbeans.modules.cnd.makeproject.api.configurations.Item;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.ModelImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.utils.MIMENames;
import org.openide.util.Utilities;

public final class DiscoveryProjectGenerator {
    private DiscoveryProjectGenerator() {
    }

    public static void generateProjects(DiscoveryDescriptor descriptor) throws IOException {
        DiscoveryProjectGeneratorImpl impl = new DiscoveryProjectGeneratorImpl(descriptor);
        impl.process();
    }

    public static boolean fixExcludedHeaderFiles(Project makeProject, Logger logger) {
        ProjectBridge bridge;
        CsmModel model;
        if (CsmModelAccessor.getModelState() != CsmModelState.ON && logger != null) {
            logger.log(Level.INFO, "#model is not ON: {0}", CsmModelAccessor.getModelState());
        }
        if (!((model = CsmModelAccessor.getModel()) instanceof ModelImpl) || makeProject == null) {
            if (logger != null) {
                logger.log(Level.INFO, "Failed fixing of excluded header files for project {0}", makeProject);
            }
            return false;
        }
        NativeProject np = (NativeProject)makeProject.getLookup().lookup(NativeProject.class);
        if (np == null) {
            if (logger != null) {
                logger.log(Level.INFO, "Not found make project for fixing of excluded header files for project {0}", makeProject);
            }
            return false;
        }
        CsmProject p = model.getProject((Object)np);
        if (p == null) {
            if (logger != null) {
                logger.log(Level.INFO, "Not found model project for fixing of excluded header files for project {0}", np);
            }
            return false;
        }
        if (logger != null) {
            logger.log(Level.INFO, "Start fixing of excluded header files for project {0}", p);
        }
        ConfigurationDescriptorProvider pdp = (ConfigurationDescriptorProvider)makeProject.getLookup().lookup(ConfigurationDescriptorProvider.class);
        ConfigurationDescriptorProvider.SnapShot delta = pdp.startModifications();
        boolean isChanged = false;
        HashSet<String> needCheck = new HashSet<String>();
        HashSet<String> needAdd = new HashSet<String>();
        HashMap<String, Item> normalizedItems = DiscoveryProjectGenerator.initNormalizedNames(makeProject);
        for (CsmFile file : p.getAllFiles()) {
            ProjectBase pb;
            Set parentFiles;
            if (!(file instanceof FileImpl)) continue;
            FileImpl impl = (FileImpl)file;
            NativeFileItem item = impl.getNativeFileItem();
            if (item == null) {
                String path = ((Object)impl.getAbsolutePath()).toString();
                item = (NativeFileItem)normalizedItems.get(path);
            }
            boolean isLineDirective = false;
            if (item != null && item.getLanguage() == NativeFileItem.Language.C_HEADER && p instanceof ProjectBase && (parentFiles = (pb = (ProjectBase)p).getParentFiles(file)).isEmpty()) {
                isLineDirective = true;
            }
            if (item != null && np.equals(item.getNativeProject()) && item.isExcluded()) {
                if (!(item instanceof Item)) continue;
                if (logger != null) {
                    logger.log(Level.FINE, "#fix excluded->included header for file {0}", impl.getAbsolutePath());
                }
                ProjectBridge.setExclude((Item)item, false);
                ProjectBridge.setHeaderTool((Item)item);
                isChanged = true;
                if (!file.isHeaderFile()) continue;
                needCheck.add(item.getAbsolutePath());
                continue;
            }
            if (isLineDirective && item != null && np.equals(item.getNativeProject()) && !item.isExcluded()) {
                if (!(item instanceof Item)) continue;
                if (logger != null) {
                    logger.log(Level.FINE, "#fix included->excluded for file {0}", impl.getAbsolutePath());
                }
                ProjectBridge.setExclude((Item)item, true);
                isChanged = true;
                continue;
            }
            if (item != null || !file.isHeaderFile()) continue;
            String path = ((Object)impl.getAbsolutePath()).toString();
            needAdd.add(path);
        }
        if ((needCheck.size() > 0 || needAdd.size() > 0) && (bridge = new ProjectBridge(makeProject)).isValid()) {
            if (needAdd.size() > 0) {
                Map<String, Folder> prefferedFolders = bridge.prefferedFolders();
                Iterator i$ = needAdd.iterator();
                while (i$.hasNext()) {
                    int i;
                    String path;
                    String name = path = (String)i$.next();
                    if (Utilities.isWindows()) {
                        path = path.replace('\\', '/');
                    }
                    if ((i = path.lastIndexOf(47)) < 0) continue;
                    String folderPath = path.substring(0, i);
                    Folder prefferedFolder = prefferedFolders.get(folderPath);
                    if (prefferedFolder == null) {
                        LinkedList<String> mkFolder = new LinkedList<String>();
                        while ((i = folderPath.lastIndexOf(47)) > 0) {
                            mkFolder.addLast(folderPath.substring(i + 1));
                            prefferedFolder = prefferedFolders.get(folderPath = folderPath.substring(0, i));
                            if (prefferedFolder == null) continue;
                        }
                        if (prefferedFolder != null) {
                            while (!mkFolder.isEmpty()) {
                                String segment = (String)mkFolder.pollLast();
                                prefferedFolder = prefferedFolder.addNewFolder(segment, segment, true, (Folder.Kind)null);
                                folderPath = folderPath + "/" + segment;
                                prefferedFolders.put(folderPath, prefferedFolder);
                            }
                        }
                    }
                    if (prefferedFolder == null) continue;
                    String relPath = bridge.getRelativepath(name);
                    Item item = bridge.getProjectItem(relPath);
                    if (item == null) {
                        item = bridge.createItem(name);
                        item = prefferedFolder.addItem(item);
                    }
                    if (item == null) continue;
                    ProjectBridge.setHeaderTool(item);
                    isChanged = true;
                    if (!MIMENames.isCppOrCOrFortran((String)item.getMIMEType())) {
                        needCheck.add(path);
                    }
                    ProjectBridge.excludeItemFromOtherConfigurations(item);
                }
            }
            if (needCheck.size() > 0) {
                isChanged |= bridge.checkForNewExtensions(needCheck);
            }
        }
        if (isChanged) {
            DiscoveryProjectGenerator.saveMakeConfigurationDescriptor(makeProject, delta);
        } else {
            pdp.endModifications(delta, false, null);
        }
        return isChanged;
    }

    public static void saveMakeConfigurationDescriptor(Project lastSelectedProject, ConfigurationDescriptorProvider.SnapShot delta) {
        ConfigurationDescriptorProvider pdp = (ConfigurationDescriptorProvider)lastSelectedProject.getLookup().lookup(ConfigurationDescriptorProvider.class);
        MakeConfigurationDescriptor makeConfigurationDescriptor = pdp.getConfigurationDescriptor();
        if (makeConfigurationDescriptor != null) {
            makeConfigurationDescriptor.setModified();
            makeConfigurationDescriptor.save();
            if (delta != null) {
                pdp.endModifications(delta, true, ImportProject.logger);
            } else {
                makeConfigurationDescriptor.checkForChangedItems(lastSelectedProject, null, null);
            }
        }
    }

    public static HashMap<String, Item> initNormalizedNames(Project makeProject) {
        MakeConfigurationDescriptor makeConfigurationDescriptor;
        HashMap<String, Item> normalizedItems = new HashMap<String, Item>();
        ConfigurationDescriptorProvider pdp = (ConfigurationDescriptorProvider)makeProject.getLookup().lookup(ConfigurationDescriptorProvider.class);
        if (pdp != null && (makeConfigurationDescriptor = pdp.getConfigurationDescriptor()) != null) {
            for (Item item : makeConfigurationDescriptor.getProjectItems()) {
                normalizedItems.put(item.getNormalizedPath(), item);
            }
        }
        return normalizedItems;
    }
}

