/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.discovery.wizard;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;
import org.netbeans.modules.cnd.utils.CndPathUtilitities;
import org.netbeans.modules.cnd.utils.FileFilterFactory;
import org.netbeans.modules.cnd.utils.ui.FileChooser;
import org.netbeans.modules.cnd.utils.ui.ListEditorPanel;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

public class AdditionalLibrariesListPanel
extends ListEditorPanel<String> {
    public static JPanel wrapPanel(ListEditorPanel<String> innerPanel) {
        JPanel outerPanel = new JPanel();
        outerPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(12, 12, 12, 12);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        outerPanel.add((Component)innerPanel, gridBagConstraints);
        outerPanel.setPreferredSize(new Dimension(500, 250));
        return outerPanel;
    }

    public AdditionalLibrariesListPanel(List<String> objects) {
        super(objects);
        this.getDefaultButton().setVisible(false);
        this.getUpButton().setVisible(false);
        this.getDownButton().setVisible(false);
        this.getCopyButton().setVisible(false);
    }

    public String addAction() {
        FileFilter[] filters = FileFilterFactory.getBinaryFilters();
        FileChooser fileChooser = new FileChooser(this.getString("LIBRARY_CHOOSER_TITLE_TXT"), this.getString("LIBRARY_CHOOSER_BUTTON_TXT"), 0, filters, "", false);
        fileChooser.setMultiSelectionEnabled(true);
        int ret = fileChooser.showOpenDialog((Component)((Object)this));
        if (ret == 1) {
            return null;
        }
        StringBuilder buf = new StringBuilder();
        for (File item : fileChooser.getSelectedFiles()) {
            String itemPath = item.getPath();
            itemPath = CndPathUtilitities.normalizeSlashes((String)itemPath);
            if (buf.length() > 0) {
                buf.append(';');
            }
            buf.append(itemPath);
        }
        if (buf.length() == 0) {
            return null;
        }
        return buf.toString();
    }

    public void addObjectAction(String newObject) {
        if (newObject != null) {
            ArrayList<String> list = new ArrayList<String>();
            StringTokenizer st = new StringTokenizer(newObject, ";");
            while (st.hasMoreTokens()) {
                list.add(st.nextToken());
            }
            this.addObjectsAction(list);
        }
    }

    public String getListLabelText() {
        return this.getString("LIBRARY_LIST_TXT");
    }

    public char getListLabelMnemonic() {
        return this.getString("LIBRARY_LIST_MN").charAt(0);
    }

    public String getAddButtonText() {
        return this.getString("ADD_BUTTON_TXT");
    }

    public char getAddButtonMnemonics() {
        return this.getString("ADD_BUTTON_MN").charAt(0);
    }

    public String getRenameButtonText() {
        return this.getString("EDIT_BUTTON_TXT");
    }

    public char getRenameButtonMnemonics() {
        return this.getString("EDIT_BUTTON_MN").charAt(0);
    }

    public String copyAction(String o) {
        return o;
    }

    public void editAction(String o, int i) {
        String s = o;
        NotifyDescriptor.InputLine notifyDescriptor = new NotifyDescriptor.InputLine(this.getString("EDIT_DIALOG_LABEL_TXT"), this.getString("EDIT_DIALOG_TITLE_TXT"));
        notifyDescriptor.setInputText(s);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)notifyDescriptor);
        if (notifyDescriptor.getValue() != NotifyDescriptor.OK_OPTION) {
            return;
        }
        String newS = notifyDescriptor.getInputText().trim();
        this.replaceElement(o, newS, i);
    }

    private String getString(String key) {
        return NbBundle.getMessage(AdditionalLibrariesListPanel.class, (String)key);
    }
}

