/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.discovery.services;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import org.netbeans.modules.cnd.api.project.NativeFileItem;
import org.netbeans.modules.cnd.api.project.NativeFileSearch;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.api.toolchain.AbstractCompiler;
import org.netbeans.modules.cnd.api.toolchain.PredefinedToolKind;
import org.netbeans.modules.cnd.api.toolchain.Tool;
import org.netbeans.modules.cnd.api.toolchain.ToolchainManager;
import org.netbeans.modules.cnd.discovery.api.QtInfoProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.spi.configurations.AllOptionsProvider;
import org.netbeans.modules.cnd.makeproject.spi.configurations.PkgConfigManager;
import org.netbeans.modules.cnd.makeproject.spi.configurations.UserOptionsProvider;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.nativeexecution.api.util.ProcessUtils;
import org.openide.util.CharSequences;

public class UserOptionsProviderImpl
implements UserOptionsProvider {
    private final Map<String, PkgConfigManager.PkgConfig> pkgConfigs = new HashMap<String, PkgConfigManager.PkgConfig>();
    private final Map<ExecutionEnvironment, Map<String, PkgConfigManager.PackageConfiguration>> commandCache = new WeakHashMap<ExecutionEnvironment, Map<String, PkgConfigManager.PackageConfiguration>>();

    public List<String> getItemUserIncludePaths(List<String> includes, AllOptionsProvider compilerOptions, AbstractCompiler compiler, MakeConfiguration makeConfiguration) {
        ArrayList<String> res = new ArrayList<String>(includes);
        if (makeConfiguration.getConfigurationType().getValue() != 0) {
            for (PkgConfigManager.PackageConfiguration pc : this.getPackages(compilerOptions.getAllOptions((Tool)compiler), makeConfiguration)) {
                for (String path : pc.getIncludePaths()) {
                    res.add(path);
                }
            }
        }
        if (makeConfiguration.isQmakeConfiguration()) {
            res.addAll(QtInfoProvider.getDefault().getQtIncludeDirectories(makeConfiguration));
        }
        return res;
    }

    private ExecutionEnvironment getExecutionEnvironment(MakeConfiguration makeConfiguration) {
        return makeConfiguration.getDevelopmentHost().getExecutionEnvironment();
    }

    public List<String> getItemUserMacros(List<String> macros, AllOptionsProvider compilerOptions, AbstractCompiler compiler, MakeConfiguration makeConfiguration) {
        ArrayList<String> res = new ArrayList<String>(macros);
        if (makeConfiguration.getConfigurationType().getValue() != 0) {
            String options = compilerOptions.getAllOptions((Tool)compiler);
            for (PkgConfigManager.PackageConfiguration pc : this.getPackages(options, makeConfiguration)) {
                res.addAll(pc.getMacros());
            }
            this.convertOptionsToMacros(compiler, options, res);
        }
        return res;
    }

    private void convertOptionsToMacros(AbstractCompiler compiler, String options, List<String> res) {
        String[] split;
        if (compiler == null || compiler.getDescriptor() == null) {
            return;
        }
        List predefinedMacros = compiler.getDescriptor().getPredefinedMacros();
        if (predefinedMacros == null || predefinedMacros.isEmpty()) {
            return;
        }
        for (String s : split = options.split(" ")) {
            if (!s.startsWith("-")) continue;
            for (ToolchainManager.PredefinedMacro macro : predefinedMacros) {
                if (macro.getFlags() == null || !macro.getFlags().equals(s) || macro.isHidden()) continue;
                res.add(macro.getMacro());
            }
        }
    }

    public List<String> getItemUserUndefinedMacros(List<String> macros, AllOptionsProvider compilerOptions, AbstractCompiler compiler, MakeConfiguration makeConfiguration) {
        ArrayList<String> res = new ArrayList<String>(macros);
        if (makeConfiguration.getConfigurationType().getValue() != 0) {
            String options = compilerOptions.getAllOptions((Tool)compiler);
            this.convertOptionsToUndefinedMacros(compiler, options, res);
        }
        return res;
    }

    private void convertOptionsToUndefinedMacros(AbstractCompiler compiler, String options, List<String> res) {
        String[] split;
        if (compiler == null || compiler.getDescriptor() == null) {
            return;
        }
        List predefinedMacros = compiler.getDescriptor().getPredefinedMacros();
        if (predefinedMacros == null || predefinedMacros.isEmpty()) {
            return;
        }
        for (String s : split = options.split(" ")) {
            if (!s.startsWith("-")) continue;
            for (ToolchainManager.PredefinedMacro macro : predefinedMacros) {
                if (macro.getFlags() == null || !macro.getFlags().equals(s) || !macro.isHidden()) continue;
                res.add(macro.getMacro());
            }
        }
    }

    public NativeFileItem.LanguageFlavor getLanguageFlavor(AllOptionsProvider compilerOptions, AbstractCompiler compiler, MakeConfiguration makeConfiguration) {
        if (makeConfiguration.getConfigurationType().getValue() != 0) {
            String options = compilerOptions.getAllOptions((Tool)compiler);
            if (compiler.getKind() == PredefinedToolKind.CCompiler) {
                if (options.indexOf("-xc99") >= 0) {
                    return NativeFileItem.LanguageFlavor.C99;
                }
                if (options.indexOf("-std=c89") >= 0) {
                    return NativeFileItem.LanguageFlavor.C89;
                }
                if (options.indexOf("-std=c99") >= 0) {
                    return NativeFileItem.LanguageFlavor.C99;
                }
            } else if (compiler.getKind() == PredefinedToolKind.CCCompiler) {
                if (options.indexOf("-std=c++0x") >= 0 || options.indexOf("-std=c++11") >= 0 || options.indexOf("-std=gnu++0x") >= 0 || options.indexOf("-std=gnu++11") >= 0) {
                    return NativeFileItem.LanguageFlavor.CPP11;
                }
            } else if (compiler.getKind() == PredefinedToolKind.FortranCompiler) {
                // empty if block
            }
        }
        return NativeFileItem.LanguageFlavor.UNKNOWN;
    }

    private List<PkgConfigManager.PackageConfiguration> getPackages(String s, MakeConfiguration conf) {
        String pkg;
        int j;
        int i;
        ArrayList<PkgConfigManager.PackageConfiguration> res = new ArrayList<PkgConfigManager.PackageConfiguration>();
        while ((i = s.indexOf(96)) >= 0 && (j = (pkg = s.substring(i + 1)).indexOf(96)) > 0) {
            PkgConfigManager.PackageConfiguration config;
            String executable = pkg.substring(0, j);
            s = s.substring(i + executable.length() + 2);
            if (executable.startsWith("pkg-config ")) {
                config = this.getPkgConfigOutput(conf, executable);
                if (config == null) continue;
                res.add(config);
                continue;
            }
            config = this.getCommandOutput(conf, executable);
            if (config == null) continue;
            res.add(config);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PkgConfigManager.PkgConfig getPkgConfig(ExecutionEnvironment env) {
        PkgConfigManager.PkgConfig pkg;
        String hostKey = ExecutionEnvironmentFactory.toUniqueID((ExecutionEnvironment)env);
        Map<String, PkgConfigManager.PkgConfig> map = this.pkgConfigs;
        synchronized (map) {
            pkg = this.pkgConfigs.get(hostKey);
            if (pkg == null) {
                pkg = PkgConfigManager.getDefault().getPkgConfig(env);
                this.pkgConfigs.put(hostKey, pkg);
            }
        }
        return pkg;
    }

    public NativeFileSearch getPackageFileSearch(ExecutionEnvironment env) {
        final PkgConfigManager.PkgConfig pkg = this.getPkgConfig(env);
        if (pkg != null) {
            return new NativeFileSearch(){

                public Collection<CharSequence> searchFile(NativeProject project, String fileName) {
                    Collection resolvedPath = pkg.getResolvedPath(fileName);
                    ArrayList<CharSequence> res = new ArrayList<CharSequence>(1);
                    if (resolvedPath != null) {
                        for (PkgConfigManager.ResolvedPath path : resolvedPath) {
                            res.add(CharSequences.create((CharSequence)(path.getIncludePath() + File.separator + fileName)));
                        }
                    }
                    return res;
                }
            };
        }
        return null;
    }

    private PkgConfigManager.PackageConfiguration getPkgConfigOutput(MakeConfiguration conf, String executable) {
        PkgConfigManager.PkgConfig configs;
        PkgConfigManager.PackageConfiguration config;
        String pkg = executable.substring(11).trim();
        StringTokenizer st = new StringTokenizer(pkg);
        boolean readFlags = false;
        String findPkg = null;
        while (st.hasMoreTokens()) {
            String aPkg = st.nextToken();
            if (aPkg.equals("--cflags")) {
                readFlags = true;
                continue;
            }
            if (aPkg.startsWith("-")) {
                readFlags = false;
                continue;
            }
            findPkg = aPkg;
        }
        if (readFlags && findPkg != null && (config = (configs = this.getPkgConfig(this.getExecutionEnvironment(conf))).getPkgConfig(findPkg)) != null) {
            return config;
        }
        return null;
    }

    private synchronized PkgConfigManager.PackageConfiguration getCommandOutput(MakeConfiguration conf, String command) {
        ExecutionEnvironment env = this.getExecutionEnvironment(conf);
        Map<String, PkgConfigManager.PackageConfiguration> map = this.commandCache.get(env);
        if (map == null) {
            map = new HashMap<String, PkgConfigManager.PackageConfiguration>();
            this.commandCache.put(env, map);
        }
        if (map.containsKey(command)) {
            return map.get(command);
        }
        ArrayList<String> args = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(command, " ");
        String executable = null;
        while (st.hasMoreTokens()) {
            if (executable == null) {
                executable = st.nextToken();
                continue;
            }
            args.add(st.nextToken());
        }
        ProcessUtils.ExitStatus status = ProcessUtils.executeInDir((String)conf.getMakefileConfiguration().getAbsBuildCommandWorkingDir(), (ExecutionEnvironment)env, (String)executable, (String[])args.toArray(new String[args.size()]));
        String flags = status.output;
        MyPackageConfiguration config = null;
        if (flags != null) {
            config = new MyPackageConfiguration(executable, flags);
        }
        map.put(command, config);
        return config;
    }

    private static final class MyPackageConfiguration
    implements PkgConfigManager.PackageConfiguration {
        private final String executable;
        private final List<String> macros = new ArrayList<String>();
        private final List<String> paths = new ArrayList<String>();

        private MyPackageConfiguration(String executable, String flags) {
            this.executable = executable;
            StringTokenizer st = new StringTokenizer(flags, " ");
            while (st.hasMoreElements()) {
                String t = st.nextToken();
                if (t.startsWith("-I")) {
                    this.paths.add(t.substring(2));
                    continue;
                }
                if (!t.startsWith("-D")) continue;
                this.macros.add(t.substring(2));
            }
        }

        public String getName() {
            return this.executable;
        }

        public Collection<String> getIncludePaths() {
            return this.paths;
        }

        public Collection<String> getMacros() {
            return this.macros;
        }

        public String getDisplayName() {
            return this.executable;
        }

        public String getLibs() {
            return "";
        }

        public String getVersion() {
            return "";
        }
    }
}

