/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.discovery.services;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.model.CsmListeners;
import org.netbeans.modules.cnd.api.model.CsmModelAccessor;
import org.netbeans.modules.cnd.api.model.CsmProgressAdapter;
import org.netbeans.modules.cnd.api.model.CsmProgressListener;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.project.NativeProject;
import org.netbeans.modules.cnd.discovery.api.DiscoveryExtensionInterface;
import org.netbeans.modules.cnd.discovery.projectimport.ImportProject;
import org.netbeans.modules.cnd.discovery.wizard.DiscoveryWizardAction;
import org.netbeans.modules.cnd.discovery.wizard.api.support.DiscoveryProjectGenerator;
import org.netbeans.modules.cnd.makeproject.api.wizards.IteratorExtension;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;

public final class DiscoveryManagerImpl {
    public static final String BUILD_LOG_KEY = "build-log";
    public static final String BUILD_EXEC_KEY = "exec-log";
    private static final RequestProcessor RP = new RequestProcessor("Discovery Manager Worker", 1);
    private static final Map<CsmProject, CsmProgressListener> listeners = new WeakHashMap<CsmProject, CsmProgressListener>();
    private static final Map<NativeProject, CsmProgressListener> listeners2 = new WeakHashMap<NativeProject, CsmProgressListener>();

    private DiscoveryManagerImpl() {
    }

    public static void projectBuilt(Project project, Map<String, Object> artifacts, boolean isIncremental) {
        RP.post((Runnable)new DiscoveryWorker(project, artifacts, isIncremental));
    }

    public static void discoverHeadersByModel(final Project project) {
        RP.post(new Runnable(){

            @Override
            public void run() {
                final NativeProject np = (NativeProject)project.getLookup().lookup(NativeProject.class);
                ImportProject.logger.log(Level.INFO, "Post fixing of excluded header files for project {0}", np);
                CsmProgressAdapter listener = new CsmProgressAdapter(){

                    public void projectParsingFinished(CsmProject aCsmProject) {
                        ImportProject.logger.log(Level.INFO, "Model parsing finished and ready to fixing of excluded header files for project {0}", aCsmProject);
                        CsmProject csmProject = CsmModelAccessor.getModel().getProject((Object)np);
                        if (csmProject != null && csmProject.equals(aCsmProject)) {
                            CsmListeners.getDefault().removeProgressListener((CsmProgressListener)this);
                            listeners2.remove(np);
                            DiscoveryProjectGenerator.fixExcludedHeaderFiles(project, ImportProject.logger);
                        }
                    }
                };
                listeners2.put(np, listener);
                CsmListeners.getDefault().addProgressListener((CsmProgressListener)listener);
            }
        });
    }

    private static final class DiscoveryWorker
    implements Runnable {
        private final Project project;
        private final Map<String, Object> artifacts;
        private final boolean isIncremental;

        DiscoveryWorker(Project project, Map<String, Object> artifacts, boolean isIncremental) {
            this.project = project;
            this.artifacts = artifacts;
            this.isIncremental = isIncremental;
        }

        @Override
        public void run() {
            DiscoveryExtensionInterface extension = (DiscoveryExtensionInterface)Lookup.getDefault().lookup(IteratorExtension.class);
            if (extension == null) {
                return;
            }
            String artifact = (String)this.artifacts.get(DiscoveryManagerImpl.BUILD_EXEC_KEY);
            if (artifact != null) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("DW:rootFolder", this.findRoot());
                map.put("DW:execLogFile", artifact);
                map.put("DW:consolidationLevel", "file");
                if (this.isIncremental) {
                    map.put("DW:incremental", Boolean.TRUE);
                }
                if (extension.canApply(map, this.project)) {
                    try {
                        this.postModelTask();
                        extension.apply(map, this.project);
                    }
                    catch (IOException ex) {
                        ex.printStackTrace(System.err);
                    }
                }
                return;
            }
            artifact = (String)this.artifacts.get(DiscoveryManagerImpl.BUILD_LOG_KEY);
            if (artifact != null) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("DW:rootFolder", this.findRoot());
                map.put("DW:logFile", artifact);
                map.put("DW:consolidationLevel", "file");
                if (this.isIncremental) {
                    map.put("DW:incremental", Boolean.TRUE);
                }
                if (extension.canApply(map, this.project)) {
                    try {
                        this.postModelTask();
                        extension.apply(map, this.project);
                    }
                    catch (IOException ex) {
                        ex.printStackTrace(System.err);
                    }
                }
            }
        }

        private String findRoot() {
            return DiscoveryWizardAction.findSourceRoot(this.project);
        }

        private void postModelTask() {
            NativeProject np = (NativeProject)this.project.getLookup().lookup(NativeProject.class);
            final CsmProject csmProject = CsmModelAccessor.getModel().getProject((Object)np);
            if (csmProject == null) {
                ImportProject.logger.log(Level.INFO, "Can not post fix excluded header files; no associated CsmProject for {0}", np);
                return;
            }
            ImportProject.logger.log(Level.INFO, "Post fixing of excluded header files for project {0}", csmProject);
            CsmProgressAdapter listener = new CsmProgressAdapter(){

                public void projectParsingFinished(CsmProject aCsmProject) {
                    ImportProject.logger.log(Level.INFO, "Model parsing finished and ready to fixing of excluded header files for model project {0}", aCsmProject);
                    if (csmProject.equals(aCsmProject)) {
                        CsmListeners.getDefault().removeProgressListener((CsmProgressListener)this);
                        listeners.remove(aCsmProject);
                        DiscoveryProjectGenerator.fixExcludedHeaderFiles(DiscoveryWorker.this.project, ImportProject.logger);
                    }
                }
            };
            listeners.put(csmProject, listener);
            CsmListeners.getDefault().addProgressListener((CsmProgressListener)listener);
        }
    }
}

