/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.discovery.projectimport;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.actions.CMakeAction;
import org.netbeans.modules.cnd.actions.MakeAction;
import org.netbeans.modules.cnd.actions.QMakeAction;
import org.netbeans.modules.cnd.actions.ShellRunAction;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.api.toolchain.PredefinedToolKind;
import org.netbeans.modules.cnd.api.toolchain.Tool;
import org.netbeans.modules.cnd.api.toolchain.ToolKind;
import org.netbeans.modules.cnd.builds.ImportUtils;
import org.netbeans.modules.cnd.discovery.buildsupport.BuildTraceSupport;
import org.netbeans.modules.cnd.discovery.projectimport.ImportProject;
import org.netbeans.modules.cnd.discovery.services.DiscoveryManagerImpl;
import org.netbeans.modules.cnd.execution.ExecutionSupport;
import org.netbeans.modules.cnd.execution.ShellExecSupport;
import org.netbeans.modules.cnd.makeproject.api.configurations.CompilerSet2Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptorProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.Item;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.remote.api.RfsListener;
import org.netbeans.modules.cnd.remote.api.RfsListenerSupport;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionListener;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.util.CommonTasksSupport;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakSet;
import org.openide.windows.InputOutput;

public class ReconfigureProject {
    private static boolean TRACE = Boolean.getBoolean("cnd.discovery.trace.projectimport");
    private static final Logger logger = Logger.getLogger("org.netbeans.modules.cnd.discovery.projectimport.ImportProject");
    private static final RequestProcessor RP = new RequestProcessor(ReconfigureProject.class.getName(), 1);
    private final Project makeProject;
    private final ConfigurationDescriptorProvider pdp;
    private final boolean isSunCompiler;
    private CompilerSet compilerSet;
    private final int platform;
    private DataObject configure;
    private DataObject cmake;
    private DataObject qmake;
    private DataObject make;
    private String cFlags;
    private String cxxFlags;
    private String linkerFlags;
    private AtomicBoolean canceled = new AtomicBoolean(false);
    private Future<Integer> lastTask;
    private Set<ExecutionListener> listeners = new WeakSet();
    private InputOutput tab;
    private boolean configureCodeAssistance = false;
    private File makeLog = null;
    private File execLog = null;
    private String remoteExecLog = null;
    private ExecutionEnvironment executionEnvironment;

    public ReconfigureProject(Project makeProject) {
        FileObject absBuildCommandFileObject;
        String mime;
        if (TRACE) {
            logger.setLevel(Level.ALL);
        }
        this.makeProject = makeProject;
        this.pdp = (ConfigurationDescriptorProvider)makeProject.getLookup().lookup(ConfigurationDescriptorProvider.class);
        assert (this.pdp != null && this.pdp.gotDescriptor());
        MakeConfiguration configuration = this.pdp.getConfigurationDescriptor().getActiveConfiguration();
        assert (configuration != null && configuration.getConfigurationType().getValue() == 0);
        CompilerSet2Configuration set = configuration.getCompilerSet();
        this.compilerSet = set.getCompilerSet();
        assert (this.compilerSet != null);
        this.isSunCompiler = this.compilerSet.getCompilerFlavor().isSunStudioCompiler();
        for (Item item : this.pdp.getConfigurationDescriptor().getExternalFileItemsAsArray()) {
            DataObject dao = item.getDataObject();
            if (dao == null) continue;
            mime = dao.getPrimaryFile().getMIMEType();
            if ("text/sh".equals(mime)) {
                if (!"configure".equals(dao.getPrimaryFile().getNameExt())) continue;
                this.configure = dao;
                continue;
            }
            if ("text/x-cmake".equals(mime)) {
                this.cmake = dao;
                continue;
            }
            if ("text/x-qtproject".equals(mime)) {
                this.qmake = dao;
                continue;
            }
            if (!"text/x-make".equals(mime)) continue;
            if (dao.getPrimaryFile().hasExt("mk")) {
                if (this.make != null) continue;
                this.make = dao;
                continue;
            }
            this.make = dao;
        }
        if (this.make == null && (absBuildCommandFileObject = configuration.getMakefileConfiguration().getAbsBuildCommandFileObject()) != null && absBuildCommandFileObject.isValid()) {
            for (FileObject children : absBuildCommandFileObject.getChildren()) {
                mime = children.getMIMEType();
                if (!"text/x-make".equals(mime)) continue;
                if (children.hasExt("mk")) {
                    if (this.make != null) continue;
                    try {
                        this.make = DataObject.find((FileObject)children);
                    }
                    catch (DataObjectNotFoundException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                    continue;
                }
                if (!children.getExt().isEmpty()) continue;
                try {
                    this.make = DataObject.find((FileObject)children);
                }
                catch (DataObjectNotFoundException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
        this.platform = configuration.getDevelopmentHost().getBuildPlatform();
    }

    public boolean isApplicable() {
        if (this.cmake != null && this.make != null) {
            return true;
        }
        if (this.qmake != null && this.make != null) {
            return true;
        }
        if (this.configure != null && this.make != null) {
            return true;
        }
        return this.make != null;
    }

    public void addExecutionListener(ExecutionListener listener) {
        this.listeners.add(listener);
    }

    public void removeExecutionListener(ExecutionListener listener) {
        this.listeners.remove(listener);
    }

    public void setConfigureCodeAssistance(boolean configureCodeAssistance) {
        this.configureCodeAssistance = configureCodeAssistance;
    }

    private String escapeFlags(String flags) {
        if (!(flags.indexOf(32) <= 0 && flags.indexOf(61) <= 0 || flags.startsWith("\""))) {
            flags = "\"" + flags + "\"";
        }
        return flags;
    }

    public void reconfigure(final String cFlags, final String cxxFlags, final String linkerFlags, final InputOutput io) {
        if (SwingUtilities.isEventDispatchThread()) {
            RP.post(new Runnable(){

                @Override
                public void run() {
                    ReconfigureProject.this.reconfigure(cFlags, cxxFlags, linkerFlags, ReconfigureProject.this.getRestOptions(), true, io);
                }
            });
        } else {
            this.reconfigure(cFlags, cxxFlags, linkerFlags, this.getRestOptions(), true, io);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reconfigure(String cFlags, String cxxFlags, String linkerFlags, String otherOptions, boolean waitFinished, InputOutput io) {
        block10: {
            try {
                this.tab = io;
                if (waitFinished) {
                    final AtomicInteger res = new AtomicInteger();
                    final AtomicBoolean finished = new AtomicBoolean(false);
                    ExecutionListener listener = new ExecutionListener(){

                        public void executionStarted(int pid) {
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void executionFinished(int rc) {
                            res.set(rc);
                            AtomicBoolean atomicBoolean = finished;
                            synchronized (atomicBoolean) {
                                finished.set(true);
                                finished.notifyAll();
                            }
                        }
                    };
                    this.addExecutionListener(listener);
                    this._reconfigure(cFlags, cxxFlags, linkerFlags, otherOptions);
                    AtomicBoolean atomicBoolean = finished;
                    synchronized (atomicBoolean) {
                        while (!finished.get()) {
                            try {
                                finished.wait();
                                if (!finished.get()) continue;
                                return;
                            }
                            catch (InterruptedException ex) {
                                Exceptions.printStackTrace((Throwable)ex);
                            }
                        }
                        break block10;
                    }
                }
                this._reconfigure(cFlags, cxxFlags, linkerFlags, otherOptions);
            }
            catch (Throwable ex) {
                for (ExecutionListener listener : this.listeners) {
                    listener.executionFinished(0);
                }
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }

    private void _reconfigure(String cFlags, String cxxFlags, String linkerFlags, String otherOptions) {
        block19: {
            block22: {
                ExecutionListener listener;
                block23: {
                    block20: {
                        ExecutionListener listener2;
                        block21: {
                            block17: {
                                ExecutionListener listener3;
                                block18: {
                                    cFlags = this.escapeFlags(cFlags);
                                    cxxFlags = this.escapeFlags(cxxFlags);
                                    linkerFlags = this.escapeFlags(linkerFlags);
                                    this.cFlags = cFlags;
                                    this.cxxFlags = cxxFlags;
                                    this.linkerFlags = linkerFlags;
                                    if (this.cmake == null || this.make == null) break block17;
                                    String arguments = this.getConfigureArguments(this.cmake.getPrimaryFile().getPath(), otherOptions, cFlags, cxxFlags, linkerFlags, this.isSunCompiler());
                                    ExecutionSupport ses = (ExecutionSupport)this.cmake.getNodeDelegate().getLookup().lookup(ExecutionSupport.class);
                                    if (ses != null) {
                                        try {
                                            List vars = ImportUtils.parseEnvironment((String)arguments);
                                            for (String s : ImportUtils.quoteList((List)vars)) {
                                                int i = arguments.indexOf(s);
                                                if (i < 0) continue;
                                                arguments = arguments.substring(0, i) + arguments.substring(i + s.length());
                                            }
                                            ses.setArguments(new String[]{arguments});
                                            ses.setEnvironmentVariables(vars.toArray(new String[vars.size()]));
                                        }
                                        catch (IOException ex) {
                                            Exceptions.printStackTrace((Throwable)ex);
                                        }
                                    }
                                    listener3 = new ExecutionListener(){

                                        public void executionStarted(int pid) {
                                            for (ExecutionListener listener : ReconfigureProject.this.listeners) {
                                                listener.executionStarted(pid);
                                            }
                                        }

                                        public void executionFinished(int rc) {
                                            if (rc == 0) {
                                                ReconfigureProject.this.postClean(false);
                                            } else {
                                                for (ExecutionListener listener : ReconfigureProject.this.listeners) {
                                                    listener.executionFinished(rc);
                                                }
                                            }
                                        }
                                    };
                                    if (TRACE) {
                                        logger.log(Level.INFO, "#{0} {1}", new Object[]{this.cmake.getPrimaryFile().getPath(), arguments});
                                    }
                                    if (!this.canceled.get()) break block18;
                                    listener3.executionFinished(-1);
                                    break block19;
                                }
                                this.lastTask = CMakeAction.performAction((Node)this.cmake.getNodeDelegate(), (ExecutionListener)listener3, null, (Project)this.makeProject, (InputOutput)this.tab);
                                if (this.lastTask != null) break block19;
                                listener3.executionFinished(0);
                                break block19;
                            }
                            if (this.qmake == null || this.make == null) break block20;
                            String arguments = this.getConfigureArguments(this.qmake.getPrimaryFile().getPath(), otherOptions, cFlags, cxxFlags, linkerFlags, this.isSunCompiler());
                            ExecutionSupport ses = (ExecutionSupport)this.qmake.getNodeDelegate().getLookup().lookup(ExecutionSupport.class);
                            if (ses != null) {
                                try {
                                    ses.setArguments(new String[]{arguments});
                                }
                                catch (IOException ex) {
                                    Exceptions.printStackTrace((Throwable)ex);
                                }
                            }
                            listener2 = new ExecutionListener(){

                                public void executionStarted(int pid) {
                                    for (ExecutionListener listener : ReconfigureProject.this.listeners) {
                                        listener.executionStarted(pid);
                                    }
                                }

                                public void executionFinished(int rc) {
                                    if (rc == 0) {
                                        ReconfigureProject.this.postClean(false);
                                    } else {
                                        for (ExecutionListener listener : ReconfigureProject.this.listeners) {
                                            listener.executionFinished(rc);
                                        }
                                    }
                                }
                            };
                            if (TRACE) {
                                logger.log(Level.INFO, "#{0} {1}", new Object[]{this.qmake.getPrimaryFile().getPath(), arguments});
                            }
                            if (!this.canceled.get()) break block21;
                            listener2.executionFinished(-1);
                            break block19;
                        }
                        this.lastTask = QMakeAction.performAction((Node)this.qmake.getNodeDelegate(), (ExecutionListener)listener2, null, (Project)this.makeProject, (InputOutput)this.tab);
                        if (this.lastTask != null) break block19;
                        listener2.executionFinished(0);
                        break block19;
                    }
                    if (this.configure == null || this.make == null) break block22;
                    String arguments = this.getConfigureArguments(this.configure.getPrimaryFile().getPath(), otherOptions, cFlags, cxxFlags, linkerFlags, this.isSunCompiler());
                    ShellExecSupport ses = (ShellExecSupport)this.configure.getNodeDelegate().getLookup().lookup(ShellExecSupport.class);
                    if (ses != null) {
                        try {
                            ses.setArguments(new String[]{arguments});
                            List vars = ImportUtils.parseEnvironment((String)arguments);
                            ses.setEnvironmentVariables(vars.toArray(new String[vars.size()]));
                        }
                        catch (IOException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                    listener = new ExecutionListener(){

                        public void executionStarted(int pid) {
                            for (ExecutionListener listener : ReconfigureProject.this.listeners) {
                                listener.executionStarted(pid);
                            }
                        }

                        public void executionFinished(int rc) {
                            if (rc == 0) {
                                ReconfigureProject.this.postClean(false);
                            } else {
                                for (ExecutionListener listener : ReconfigureProject.this.listeners) {
                                    listener.executionFinished(rc);
                                }
                            }
                        }
                    };
                    if (TRACE) {
                        logger.log(Level.INFO, "#{0} {1}", new Object[]{this.configure.getPrimaryFile().getPath(), arguments});
                    }
                    if (!this.canceled.get()) break block23;
                    listener.executionFinished(-1);
                    break block19;
                }
                this.lastTask = ShellRunAction.performAction((Node)this.configure.getNodeDelegate(), (ExecutionListener)listener, null, (Project)this.makeProject, (InputOutput)this.tab);
                if (this.lastTask != null) break block19;
                listener.executionFinished(0);
                break block19;
            }
            if (this.make != null) {
                this.postClean(true);
            } else {
                assert (false);
                for (ExecutionListener listener : this.listeners) {
                    listener.executionFinished(0);
                }
            }
        }
    }

    private void postClean(final boolean notifyStart) {
        ExecutionListener listener = new ExecutionListener(){

            public void executionStarted(int pid) {
                if (notifyStart) {
                    for (ExecutionListener listener : ReconfigureProject.this.listeners) {
                        listener.executionStarted(pid);
                    }
                }
            }

            public void executionFinished(int rc) {
                ReconfigureProject.this.postMake();
            }
        };
        if (TRACE) {
            logger.log(Level.INFO, "#make -f {0} clean", this.make.getPrimaryFile().getPath());
        }
        if (this.canceled.get()) {
            listener.executionFinished(-1);
        } else {
            this.lastTask = MakeAction.execute((Node)this.make.getNodeDelegate(), (String)"clean", (ExecutionListener)listener, null, (Project)this.makeProject, null, (InputOutput)this.tab);
            if (this.lastTask == null) {
                listener.executionFinished(0);
            }
        }
    }

    private void postMake() {
        String arguments = this.getConfigureArguments(this.make.getPrimaryFile().getPath(), null, this.cFlags, this.cxxFlags, this.linkerFlags, this.isSunCompiler());
        if (TRACE) {
            logger.log(Level.INFO, "#make -f {0}", this.make.getPrimaryFile().getPath());
        }
        if (this.configureCodeAssistance) {
            MakeConfigurationDescriptor descriptor;
            MakeConfiguration activeConfiguration = null;
            ConfigurationDescriptorProvider provider = (ConfigurationDescriptorProvider)this.makeProject.getLookup().lookup(ConfigurationDescriptorProvider.class);
            if (provider != null && provider.gotDescriptor() && (descriptor = provider.getConfigurationDescriptor()) != null && (activeConfiguration = descriptor.getActiveConfiguration()) != null) {
                this.executionEnvironment = activeConfiguration.getDevelopmentHost().getExecutionEnvironment();
            }
            if (this.executionEnvironment != null) {
                this.makeLog = ImportProject.createTempFile("make");
                if (BuildTraceSupport.useBuildTrace(activeConfiguration)) {
                    try {
                        HostInfo hostInfo = HostInfoUtils.getHostInfo((ExecutionEnvironment)this.executionEnvironment);
                        if (BuildTraceSupport.supportedPlatforms(this.executionEnvironment)) {
                            this.execLog = ImportProject.createTempFile("exec");
                            this.execLog.deleteOnExit();
                            if (this.executionEnvironment.isRemote()) {
                                this.remoteExecLog = hostInfo.getTempDir() + "/" + this.execLog.getName();
                            }
                        }
                    }
                    catch (IOException ex) {
                    }
                    catch (ConnectionManager.CancellationException ex) {}
                }
            } else {
                this.configureCodeAssistance = false;
            }
        }
        ExecutionListener listener = new ExecutionListener(){
            private ImportProject.RfsListenerImpl listener;

            public void executionStarted(int pid) {
                if (ReconfigureProject.this.makeLog != null && ReconfigureProject.this.executionEnvironment.isRemote()) {
                    this.listener = new ImportProject.RfsListenerImpl(ReconfigureProject.this.executionEnvironment);
                    RfsListenerSupport.addListener((ExecutionEnvironment)ReconfigureProject.this.executionEnvironment, (RfsListener)this.listener);
                }
            }

            public void executionFinished(int rc) {
                for (ExecutionListener aListener : ReconfigureProject.this.listeners) {
                    aListener.executionFinished(rc);
                }
                if (rc < 0) {
                    return;
                }
                if (this.listener != null) {
                    this.listener.download();
                    RfsListenerSupport.removeListener((ExecutionEnvironment)ReconfigureProject.this.executionEnvironment, (RfsListener)this.listener);
                }
                if (ReconfigureProject.this.executionEnvironment.isRemote() && ReconfigureProject.this.execLog != null) {
                    try {
                        if (HostInfoUtils.fileExists((ExecutionEnvironment)ReconfigureProject.this.executionEnvironment, (String)ReconfigureProject.this.remoteExecLog)) {
                            Future task = CommonTasksSupport.downloadFile((String)ReconfigureProject.this.remoteExecLog, (ExecutionEnvironment)ReconfigureProject.this.executionEnvironment, (String)ReconfigureProject.this.execLog.getAbsolutePath(), null);
                            if (TRACE) {
                                logger.log(Level.INFO, "#download file {0}", ReconfigureProject.this.makeLog.getAbsolutePath());
                            }
                            task.get();
                        }
                    }
                    catch (Throwable ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                        ReconfigureProject.this.execLog = null;
                    }
                }
                HashMap<String, Object> artifacts = new HashMap<String, Object>();
                if (ReconfigureProject.this.execLog != null) {
                    artifacts.put("exec-log", ReconfigureProject.this.execLog.getAbsolutePath());
                    DiscoveryManagerImpl.projectBuilt(ReconfigureProject.this.makeProject, artifacts, false);
                }
            }
        };
        Node node = this.make.getNodeDelegate();
        ExecutionSupport ses = (ExecutionSupport)node.getLookup().lookup(ExecutionSupport.class);
        List vars = ImportUtils.parseEnvironment((String)arguments);
        if (ses != null) {
            try {
                ses.setEnvironmentVariables(vars.toArray(new String[vars.size()]));
                if (this.execLog != null) {
                    MakeConfiguration activeConfiguration;
                    MakeConfigurationDescriptor descriptor;
                    ConfigurationDescriptorProvider provider = (ConfigurationDescriptorProvider)this.makeProject.getLookup().lookup(ConfigurationDescriptorProvider.class);
                    if (provider != null && provider.gotDescriptor() && (descriptor = provider.getConfigurationDescriptor()) != null && (activeConfiguration = descriptor.getActiveConfiguration()) != null) {
                        vars.add("__CND_TOOLS__=" + BuildTraceSupport.getTools(activeConfiguration));
                    }
                    if (this.executionEnvironment.isLocal()) {
                        vars.add("__CND_BUILD_LOG__=" + this.execLog.getAbsolutePath());
                    } else {
                        vars.add("__CND_BUILD_LOG__=" + this.remoteExecLog);
                    }
                }
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        if (TRACE) {
            logger.log(Level.INFO, "#make {0}", arguments);
        }
        if (this.canceled.get()) {
            listener.executionFinished(-1);
        } else {
            this.lastTask = MakeAction.execute((Node)node, (String)"", (ExecutionListener)listener, null, (Project)this.makeProject, (List)vars, (InputOutput)this.tab);
            if (this.lastTask == null) {
                listener.executionFinished(0);
            }
        }
    }

    public void cancel() {
        this.canceled.set(true);
        Future<Integer> task = this.lastTask;
        if (task != null) {
            task.cancel(true);
        }
    }

    private String getConfigureArguments(String configure, String otherOptions, String cCompilerFlags, String cppCompilerFlags, String ldFlags, boolean isSunCompiler) {
        StringBuilder buf = new StringBuilder();
        if (otherOptions != null && otherOptions.length() > 0) {
            buf.append(otherOptions);
            buf.append(' ');
        }
        if (configure.endsWith("CMakeLists.txt")) {
            buf.append(" -G \"Unix Makefiles\"");
            buf.append(" -DCMAKE_BUILD_TYPE=Debug");
            buf.append(" -DCMAKE_C_COMPILER=").append(this.getCCompilerName());
            buf.append(" -DCMAKE_CXX_COMPILER=").append(this.getCppCompilerName());
            buf.append(" -DCMAKE_C_FLAGS_DEBUG=").append(cCompilerFlags);
            buf.append(" -DCMAKE_CXX_FLAGS_DEBUG=").append(cppCompilerFlags);
            buf.append(" -DCMAKE_EXE_LINKER_FLAGS_DEBUG=").append(ldFlags);
        } else if (configure.endsWith(".pro")) {
            if (isSunCompiler && (this.platform == 1 || this.platform == 0)) {
                buf.append(" -spec solaris-cc");
            }
            if (this.platform == 4) {
                buf.append(" -spec macx-g++");
            }
            buf.append(" QMAKE_CC=").append(this.getCCompilerName());
            buf.append(" QMAKE_CXX=").append(this.getCppCompilerName());
            buf.append(" QMAKE_CFLAGS=").append(cCompilerFlags);
            buf.append(" QMAKE_CXXFLAGS=").append(cppCompilerFlags);
            buf.append(" QMAKE_LDFLAGS=").append(ldFlags);
        } else {
            buf.append(" CC=").append(this.getCCompilerName());
            buf.append(" CXX=").append(this.getCppCompilerName());
            buf.append(" CFLAGS=").append(cCompilerFlags);
            buf.append(" CXXFLAGS=").append(cppCompilerFlags);
            buf.append(" LDFLAGS=").append(ldFlags);
        }
        return buf.toString();
    }

    public CompilerOptions getLastCompilerOptions() {
        String lastFlags = this.getLastFlags();
        if (lastFlags == null) {
            return null;
        }
        DataObject dao = this.getImportant();
        if (dao == null) {
            return null;
        }
        String mime = dao.getPrimaryFile().getMIMEType();
        CompilerOptions options = new CompilerOptions();
        if ("text/sh".equals(mime)) {
            options.cFlags = this.getFlags(lastFlags, "CFLAGS=");
            options.cppFlags = this.getFlags(lastFlags, "CXXFLAGS=");
            options.cCompiler = this.getFlags(lastFlags, "CC=");
            options.cppCompiler = this.getFlags(lastFlags, "CXX=");
            options.linkerFlags = this.getFlags(lastFlags, "LDFLAGS=");
        } else if ("text/x-cmake".equals(mime)) {
            options.cFlags = this.getFlags(lastFlags, "-DCMAKE_C_FLAGS_DEBUG=");
            options.cppFlags = this.getFlags(lastFlags, "-DCMAKE_CXX_FLAGS_DEBUG=");
            options.cCompiler = this.getFlags(lastFlags, "-DCMAKE_C_COMPILER=");
            options.cppCompiler = this.getFlags(lastFlags, "-DCMAKE_CXX_COMPILER=");
            options.linkerFlags = this.getFlags(lastFlags, "-DCMAKE_EXE_LINKER_FLAGS_DEBUG=");
        } else if ("text/x-qtproject".equals(mime)) {
            options.cFlags = this.getFlags(lastFlags, "QMAKE_CFLAGS=");
            options.cppFlags = this.getFlags(lastFlags, "QMAKE_CXXFLAGS=");
            options.cCompiler = this.getFlags(lastFlags, "QMAKE_CC=");
            options.cppCompiler = this.getFlags(lastFlags, "QMAKE_CXX=");
            options.linkerFlags = this.getFlags(lastFlags, "QMAKE_LDFLAGS=");
        } else if ("text/x-make".equals(mime)) {
            options.cFlags = this.getFlags(lastFlags, "CFLAGS=");
            options.cppFlags = this.getFlags(lastFlags, "CXXFLAGS=");
            options.cCompiler = this.getFlags(lastFlags, "CC=");
            options.cppCompiler = this.getFlags(lastFlags, "CXX=");
            options.linkerFlags = this.getFlags(lastFlags, "LDFLAGS=");
        }
        return options;
    }

    public String getRestOptions() {
        String lastFlags = this.getLastFlags();
        if (lastFlags == null) {
            return "";
        }
        DataObject dao = this.getImportant();
        if (dao == null) {
            return "";
        }
        String mime = dao.getPrimaryFile().getMIMEType();
        if ("text/sh".equals(mime)) {
            lastFlags = this.removeFlag(lastFlags, "CFLAGS=", false);
            lastFlags = this.removeFlag(lastFlags, "CXXFLAGS=", false);
            lastFlags = this.removeFlag(lastFlags, "CC=", false);
            lastFlags = this.removeFlag(lastFlags, "CXX=", false);
            lastFlags = this.removeFlag(lastFlags, "LDFLAGS=", false);
        } else if ("text/x-cmake".equals(mime)) {
            lastFlags = this.removeFlag(lastFlags, "-DCMAKE_BUILD_TYPE=", false);
            lastFlags = this.removeFlag(lastFlags, "-DCMAKE_C_FLAGS_DEBUG=", false);
            lastFlags = this.removeFlag(lastFlags, "-DCMAKE_CXX_FLAGS_DEBUG=", false);
            lastFlags = this.removeFlag(lastFlags, "-DCMAKE_C_COMPILER=", false);
            lastFlags = this.removeFlag(lastFlags, "-DCMAKE_CXX_COMPILER=", false);
            lastFlags = this.removeFlag(lastFlags, "-DCMAKE_EXE_LINKER_FLAGS_DEBUG=", false);
            lastFlags = this.removeFlag(lastFlags, "-G", false);
        } else if ("text/x-qtproject".equals(mime)) {
            lastFlags = this.removeFlag(lastFlags, "QMAKE_CFLAGS=", false);
            lastFlags = this.removeFlag(lastFlags, "QMAKE_CXXFLAGS=", false);
            lastFlags = this.removeFlag(lastFlags, "QMAKE_CC=", false);
            lastFlags = this.removeFlag(lastFlags, "QMAKE_CXX=", false);
            lastFlags = this.removeFlag(lastFlags, "QMAKE_LDFLAGS=", false);
            lastFlags = this.removeFlag(lastFlags, "-spec solaris-cc", true);
            lastFlags = this.removeFlag(lastFlags, "-spec macx-g++", true);
        } else if ("text/x-make".equals(mime)) {
            return "";
        }
        return lastFlags.trim();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String removeFlag(String flags, String key, boolean noValue) {
        int i = flags.indexOf(key);
        if (i < 0) return flags.trim();
        if (key.charAt(key.length() - 1) == '=') {
            String rest = flags.substring(i + key.length());
            if (rest.startsWith("\"")) {
                int j = rest.indexOf(34, 1);
                if (j <= 0) return flags.trim();
                return flags.substring(0, i) + rest.substring(j + 1);
            }
            int j = rest.indexOf(32, 1);
            if (j <= 0) return flags.substring(0, i);
            return flags.substring(0, i) + rest.substring(j + 1);
        }
        String rest = flags.substring(i + key.length());
        if (rest.startsWith(" ")) {
            if (noValue) {
                return flags.substring(0, i) + rest;
            }
            if ((rest = rest.substring(1)).startsWith("\"")) {
                int j = rest.indexOf(34, 1);
                if (j <= 0) return flags.trim();
                return flags.substring(0, i) + rest.substring(j + 1);
            }
            int j = rest.indexOf(32, 1);
            if (j <= 0) return flags.substring(0, i);
            return flags.substring(0, i) + rest.substring(j + 1);
        }
        if (rest.length() != 0) return flags.trim();
        return flags.substring(0, i);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String getFlags(String flags, String key) {
        int i = flags.indexOf(key);
        if (i < 0) return null;
        if (key.charAt(key.length() - 1) == '=') {
            String rest = flags.substring(i + key.length());
            if (rest.startsWith("\"")) {
                int j = rest.indexOf(34, 1);
                if (j <= 0) return null;
                return rest.substring(1, j);
            }
            int j = rest.indexOf(32, 1);
            if (j <= 0) return rest;
            return rest.substring(0, j);
        }
        String rest = flags.substring(i + key.length());
        if (rest.startsWith(" ")) {
            if ((rest = rest.substring(1)).startsWith("\"")) {
                int j = rest.indexOf(34, 1);
                if (j <= 0) return null;
                return rest.substring(1, j);
            }
            int j = rest.indexOf(32, 1);
            if (j <= 0) return rest;
            return rest.substring(0, j);
        }
        if (rest.length() != 0) return null;
        return "";
    }

    public boolean isSunCompiler() {
        return this.isSunCompiler;
    }

    public CompilerSet getCompilerSet() {
        return this.compilerSet;
    }

    private String getCCompilerName() {
        String path = this.getToolPath(PredefinedToolKind.CCompiler);
        if (path == null) {
            if (this.isSunCompiler()) {
                return "cc";
            }
            return "gcc";
        }
        return path;
    }

    private String getCppCompilerName() {
        String path = this.getToolPath(PredefinedToolKind.CCCompiler);
        if (path == null) {
            if (this.isSunCompiler()) {
                return "CC";
            }
            return "g++";
        }
        return path;
    }

    private String getToolPath(PredefinedToolKind tool) {
        Tool compiler = this.compilerSet.findTool((ToolKind)tool);
        if (compiler == null) {
            return null;
        }
        return this.escapeFlags(compiler.getPath());
    }

    public DataObject getImportant() {
        if (this.cmake != null && this.make != null) {
            return this.cmake;
        }
        if (this.qmake != null && this.make != null) {
            return this.qmake;
        }
        if (this.configure != null && this.make != null) {
            return this.configure;
        }
        if (this.make != null) {
            return this.make;
        }
        return null;
    }

    public String getLastFlags() {
        String[] args;
        ExecutionSupport ses;
        if (this.cmake != null && this.make != null) {
            String[] args2;
            ExecutionSupport ses2 = (ExecutionSupport)this.cmake.getNodeDelegate().getLookup().lookup(ExecutionSupport.class);
            if (ses2 != null && (args2 = ses2.getArguments()) != null && args2.length > 0) {
                return args2[0];
            }
        } else if (this.qmake != null && this.make != null) {
            String[] args3;
            ExecutionSupport ses3 = (ExecutionSupport)this.qmake.getNodeDelegate().getLookup().lookup(ExecutionSupport.class);
            if (ses3 != null && (args3 = ses3.getArguments()) != null && args3.length > 0) {
                return args3[0];
            }
        } else if (this.configure != null && this.make != null) {
            String[] args4;
            ShellExecSupport ses4 = (ShellExecSupport)this.configure.getNodeDelegate().getLookup().lookup(ShellExecSupport.class);
            if (ses4 != null && (args4 = ses4.getArguments()) != null && args4.length > 0) {
                return args4[0];
            }
        } else if (this.make != null && (ses = (ExecutionSupport)this.make.getNodeDelegate().getLookup().lookup(ExecutionSupport.class)) != null && (args = ses.getEnvironmentVariables()) != null && args.length > 0) {
            List list = new ArrayList<String>();
            for (int i = 0; i < args.length; ++i) {
                list.add(args[i]);
            }
            list = ImportUtils.quoteList(list);
            StringBuilder b = new StringBuilder();
            for (String s : list) {
                b.append(s).append(' ');
            }
            return b.toString();
        }
        return null;
    }

    public static final class CompilerOptions {
        public String cFlags;
        public String cppFlags;
        public String cCompiler;
        public String cppCompiler;
        public String linkerFlags;
    }
}

