/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.discovery.projectimport;

import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.discovery.projectimport.ReconfigurePanel;
import org.netbeans.modules.cnd.discovery.projectimport.ReconfigureProject;
import org.netbeans.modules.cnd.makeproject.api.configurations.CompilerSet2Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptorProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.SharedClassObject;
import org.openide.util.actions.NodeAction;
import org.openide.util.actions.Presenter;

public class ReconfigureAction
extends NodeAction
implements Presenter.Popup {
    private static final RequestProcessor RP = new RequestProcessor(ReconfigureAction.class.getName(), 1);
    private boolean actionPerformedFlag = false;
    private JMenuItem presenter;
    private boolean inited = false;

    public ReconfigureAction() {
        this.putValue("SmallIcon", ImageUtilities.loadImageIcon((String)"org/netbeans/modules/cnd/discovery/wizard/resources/waitNode.gif", (boolean)false));
    }

    public static Action getReconfigureAction() {
        return (Action)SharedClassObject.findObject(ReconfigureAction.class, (boolean)true);
    }

    public String getName() {
        return NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"CTL_ReconfigureAction");
    }

    public JMenuItem getPopupPresenter() {
        return this.getPresenter();
    }

    private synchronized JMenuItem getPresenter() {
        if (!this.inited) {
            this.presenter = new JMenuItem((Action)((Object)this));
            this.inited = true;
        }
        return this.presenter;
    }

    private synchronized void setEnabledImpl(boolean enabled) {
        if (this.inited) {
            this.getPresenter().setEnabled(enabled);
            this.getPresenter().invalidate();
        }
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    private boolean enableImpl(Node[] activatedNodes) {
        Project p = this.getProject(activatedNodes);
        if (p == null) {
            return false;
        }
        ConfigurationDescriptorProvider pdp = (ConfigurationDescriptorProvider)p.getLookup().lookup(ConfigurationDescriptorProvider.class);
        if (pdp == null || !pdp.gotDescriptor()) {
            return false;
        }
        MakeConfigurationDescriptor mcd = pdp.getConfigurationDescriptor();
        if (mcd == null) {
            return false;
        }
        MakeConfiguration configuration = mcd.getActiveConfiguration();
        if (configuration == null || configuration.getConfigurationType().getValue() != 0) {
            return false;
        }
        CompilerSet2Configuration set = configuration.getCompilerSet();
        if (set == null) {
            return false;
        }
        CompilerSet cs = set.getCompilerSet();
        if (cs == null) {
            return false;
        }
        return new ReconfigureProject(p).isApplicable();
    }

    protected final boolean enable(final Node[] nodes) {
        if (this.actionPerformedFlag) {
            return true;
        }
        this.putValue("SmallIcon", ImageUtilities.loadImageIcon((String)"org/netbeans/modules/cnd/discovery/wizard/resources/waitNode.gif", (boolean)false));
        this.setEnabledImpl(false);
        RP.post(new Runnable(){
            private boolean enabled;

            @Override
            public void run() {
                if (SwingUtilities.isEventDispatchThread()) {
                    ReconfigureAction.this.setEnabled(this.enabled);
                    ReconfigureAction.this.putValue("SmallIcon", null);
                    ReconfigureAction.this.setEnabledImpl(this.enabled);
                } else {
                    this.enabled = ReconfigureAction.this.enableImpl(nodes);
                    SwingUtilities.invokeLater(this);
                }
            }
        });
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performAction(Node[] activatedNodes) {
        this.actionPerformedFlag = true;
        try {
            String cxxFlags;
            String cFlags;
            Project p = this.getProject(activatedNodes);
            final ReconfigureProject reconfigurator = new ReconfigureProject(p);
            String linkerFlags = "";
            if (reconfigurator.isSunCompiler()) {
                cFlags = "-g";
                cxxFlags = "-g";
            } else {
                cFlags = "-g3 -gdwarf-2";
                cxxFlags = "-g3 -gdwarf-2";
            }
            ReconfigurePanel panel = new ReconfigurePanel(cFlags, cxxFlags, linkerFlags, reconfigurator.getRestOptions(), this.getLegend(reconfigurator), reconfigurator.getCompilerSet().getDisplayName());
            JButton runButton = new JButton(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"ReconfigureButton"));
            runButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"ReconfigureButtonAD"));
            Object[] options = new Object[]{runButton, DialogDescriptor.CANCEL_OPTION};
            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)panel, NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"ReconfigureDialogTitle"), true, options, (Object)runButton, 0, null, null);
            Object ret = DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
            if (ret == runButton) {
                reconfigurator.setConfigureCodeAssistance(true);
                final String c = panel.getCFlags();
                final String cpp = panel.getCppFlags();
                final String link = panel.getLinkerFlags();
                final String other = panel.getOtherOptions();
                RP.post(new Runnable(){

                    @Override
                    public void run() {
                        reconfigurator.reconfigure(c, cpp, link, other, false, null);
                    }
                });
            }
        }
        finally {
            this.actionPerformedFlag = false;
        }
    }

    private String getLegend(ReconfigureProject reconfigurator) {
        ReconfigureProject.CompilerOptions options = reconfigurator.getLastCompilerOptions();
        if (options != null && options.cFlags != null && options.cppFlags != null && options.cCompiler != null && options.cppCompiler != null) {
            String linker = options.linkerFlags == null ? "" : options.linkerFlags;
            return NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"ReconfigureLegend", (Object)options.cCompiler, (Object)options.cppCompiler, (Object)options.cFlags, (Object)options.cppFlags, (Object[])new Object[]{linker});
        }
        return "";
    }

    protected boolean asynchronous() {
        return false;
    }

    protected Project getProject(Node[] nodes) {
        if (nodes.length != 1) {
            return null;
        }
        for (int i = 0; i < nodes.length; ++i) {
            Project p = (Project)nodes[i].getLookup().lookup(Project.class);
            if (p == null) continue;
            return p;
        }
        return null;
    }
}

