/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.discovery.projectimport;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.extexecution.print.ConvertedLine;
import org.netbeans.api.extexecution.print.LineConvertor;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.remote.PathMap;
import org.netbeans.modules.cnd.api.remote.RemoteFileUtil;
import org.netbeans.modules.cnd.api.remote.RemoteProject;
import org.netbeans.modules.cnd.api.remote.RemoteSyncSupport;
import org.netbeans.modules.cnd.api.remote.RemoteSyncWorker;
import org.netbeans.modules.cnd.api.remote.ServerList;
import org.netbeans.modules.cnd.api.remote.ServerRecord;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.api.toolchain.CompilerSetManager;
import org.netbeans.modules.cnd.api.toolchain.PredefinedToolKind;
import org.netbeans.modules.cnd.api.toolchain.Tool;
import org.netbeans.modules.cnd.api.toolchain.ToolKind;
import org.netbeans.modules.cnd.api.utils.PlatformInfo;
import org.netbeans.modules.cnd.discovery.projectimport.ImportProject;
import org.netbeans.modules.cnd.spi.toolchain.CompilerLineConvertor;
import org.netbeans.modules.cnd.spi.toolchain.ToolchainProject;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.nativeexecution.api.ExecutionListener;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.NativeProcess;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;
import org.netbeans.modules.nativeexecution.api.NativeProcessChangeEvent;
import org.netbeans.modules.nativeexecution.api.execution.NativeExecutionDescriptor;
import org.netbeans.modules.nativeexecution.api.execution.NativeExecutionService;
import org.netbeans.modules.nativeexecution.api.execution.PostMessageDisplayer;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.HelperLibraryUtility;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.nativeexecution.api.util.MacroMap;
import org.netbeans.modules.nativeexecution.api.util.WindowsSupport;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;

public class ExecuteCommand {
    private final String runDir;
    private String command;
    private final Project project;
    private final ExecutionEnvironment execEnv;

    public ExecuteCommand(Project project, String runDir, String command) {
        this.runDir = runDir;
        this.command = command;
        this.project = project;
        this.execEnv = this.getExecutionEnvironment();
    }

    public Future<Integer> performAction(ExecutionListener listener, Writer outputListener, List<String> additionalEnvironment) {
        NativeExecutionService es = this.prepare(listener, outputListener, additionalEnvironment);
        if (es != null) {
            return es.run();
        }
        return null;
    }

    private NativeExecutionService prepare(ExecutionListener listener, Writer outputListener, List<String> additionalEnvironment) {
        RemoteSyncWorker syncWorker;
        InputOutput inputOutput;
        HostInfo hostInfo;
        try {
            hostInfo = HostInfoUtils.getHostInfo((ExecutionEnvironment)this.execEnv);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
        catch (ConnectionManager.CancellationException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
        String executable = hostInfo.getShell();
        if (this.command.indexOf("${MAKE}") >= 0) {
            Tool findTool;
            String make = "make";
            CompilerSet compilerSet = this.getCompilerSet();
            if (compilerSet != null && (findTool = compilerSet.findTool((ToolKind)PredefinedToolKind.MakeTool)) != null && findTool.getPath() != null && findTool.getPath().length() > 0) {
                String aMake;
                make = findTool.getPath();
                if (hostInfo.getOSFamily() == HostInfo.OSFamily.WINDOWS && (aMake = WindowsSupport.getInstance().convertToShellPath(make)) != null && aMake.length() > 0) {
                    make = aMake;
                }
            }
            this.command = this.command.replace("${MAKE}", make);
        }
        String[] args = new String[]{"-c", this.command};
        String buildDir = this.convertToRemoteIfNeeded(this.runDir);
        if (buildDir == null) {
            ImportProject.logger.log(Level.INFO, "Run folder folder is null");
            return null;
        }
        Map<String, String> envMap = this.getEnv(additionalEnvironment);
        if (this.isSunStudio()) {
            envMap.put("SPRO_EXPAND_ERRORS", "");
        }
        if ((inputOutput = null) == null) {
            String tabName = this.execEnv.isLocal() ? NbBundle.getMessage(ExecuteCommand.class, (String)"MAKE_LABEL", (Object)this.command) : NbBundle.getMessage(ExecuteCommand.class, (String)"MAKE_REMOTE_LABEL", (Object)this.command, (Object)this.execEnv.getDisplayName());
            InputOutput _tab = IOProvider.getDefault().getIO(tabName, false);
            _tab.closeInputOutput();
            InputOutput tab = IOProvider.getDefault().getIO(tabName, true);
            try {
                tab.getOut().reset();
            }
            catch (IOException ioe) {
                // empty catch block
            }
            inputOutput = tab;
        }
        if ((syncWorker = RemoteSyncSupport.createSyncWorker((Project)this.project, (PrintWriter)inputOutput.getOut(), (PrintWriter)inputOutput.getErr())) != null && !syncWorker.startup(envMap)) {
            ImportProject.logger.log(Level.INFO, "RemoteSyncWorker is not started up");
            return null;
        }
        MacroMap mm = MacroMap.forExecEnv((ExecutionEnvironment)this.execEnv);
        mm.putAll(envMap);
        if (envMap.containsKey("__CND_TOOLS__")) {
            try {
                if (BuildTraceHelper.isMac((ExecutionEnvironment)this.execEnv)) {
                    String where;
                    String what = BuildTraceHelper.INSTANCE.getLibraryName(this.execEnv);
                    if (what.indexOf(58) > 0) {
                        what = what.substring(0, what.indexOf(58));
                    }
                    if ((where = BuildTraceHelper.INSTANCE.getLDPaths(this.execEnv)).indexOf(58) > 0) {
                        where = where.substring(0, where.indexOf(58));
                    }
                    String lib = where + '/' + what;
                    mm.prependPathVariable(BuildTraceHelper.getLDPreloadEnvName((ExecutionEnvironment)this.execEnv), lib);
                } else {
                    mm.prependPathVariable(BuildTraceHelper.getLDPreloadEnvName((ExecutionEnvironment)this.execEnv), BuildTraceHelper.INSTANCE.getLibraryName(this.execEnv));
                    mm.prependPathVariable(BuildTraceHelper.getLDPathEnvName((ExecutionEnvironment)this.execEnv), BuildTraceHelper.INSTANCE.getLDPaths(this.execEnv));
                }
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        this.traceExecutable(executable, buildDir, args, this.execEnv.toString(), (Map<String, String>)mm.toMap());
        ProcessChangeListener processChangeListener = new ProcessChangeListener(listener, outputListener, (LineConvertor)new CompilerLineConvertor(this.project, this.getCompilerSet(), this.execEnv, RemoteFileUtil.getFileObject((String)buildDir, (ExecutionEnvironment)this.execEnv)), syncWorker);
        NativeProcessBuilder npb = NativeProcessBuilder.newProcessBuilder((ExecutionEnvironment)this.execEnv).setExecutable(executable).setWorkingDirectory(buildDir).setArguments(args).unbufferOutput(false).addNativeProcessListener((ChangeListener)processChangeListener);
        npb.getEnvironment().putAll(mm);
        npb.redirectError();
        NativeExecutionDescriptor descr = new NativeExecutionDescriptor().controllable(true).frontWindow(true).inputVisible(true).showProgress(!CndUtils.isStandalone()).inputOutput(inputOutput).outLineBased(true).postExecution((Runnable)processChangeListener).postMessageDisplayer((PostMessageDisplayer)new PostMessageDisplayer.Default("Make")).errConvertorFactory((ExecutionDescriptor.LineConvertorFactory)processChangeListener).outConvertorFactory((ExecutionDescriptor.LineConvertorFactory)processChangeListener);
        return NativeExecutionService.newService((NativeProcessBuilder)npb, (NativeExecutionDescriptor)descr, (String)"make");
    }

    private CompilerSet getCompilerSet() {
        CompilerSet set = null;
        ToolchainProject toolchain = (ToolchainProject)this.project.getLookup().lookup(ToolchainProject.class);
        if (toolchain != null) {
            set = toolchain.getCompilerSet();
        }
        if (set == null) {
            set = CompilerSetManager.get((ExecutionEnvironment)ExecutionEnvironmentFactory.getLocal()).getDefaultCompilerSet();
        }
        return set;
    }

    private boolean isSunStudio() {
        CompilerSet set = this.getCompilerSet();
        if (set == null) {
            return false;
        }
        return set.getCompilerFlavor().isSunStudioCompiler();
    }

    private ExecutionEnvironment getExecutionEnvironment() {
        RemoteProject info = (RemoteProject)this.project.getLookup().lookup(RemoteProject.class);
        if (info != null) {
            return info.getDevelopmentHost();
        }
        return ExecutionEnvironmentFactory.getLocal();
    }

    private String convertToRemoteIfNeeded(String localDir) {
        if (!this.checkConnection()) {
            return null;
        }
        if (this.execEnv.isRemote()) {
            PathMap pathMap = RemoteSyncSupport.getPathMap((ExecutionEnvironment)this.execEnv, (Project)this.project);
            String remotePath = pathMap.getRemotePath(localDir, false);
            if (remotePath == null) {
                if (!pathMap.checkRemotePaths(new File[]{new File(localDir)}, true)) {
                    return null;
                }
                remotePath = pathMap.getRemotePath(localDir, false);
            }
            return remotePath;
        }
        return localDir;
    }

    private boolean checkConnection() {
        if (this.execEnv.isRemote()) {
            try {
                ConnectionManager.getInstance().connectTo(this.execEnv);
                ServerRecord record = ServerList.get((ExecutionEnvironment)this.execEnv);
                if (record.isOffline()) {
                    record.validate(true);
                }
                return record.isOnline();
            }
            catch (IOException ex) {
                return false;
            }
            catch (ConnectionManager.CancellationException ex) {
                return false;
            }
        }
        return true;
    }

    private void traceExecutable(String executable, String buildDir, String[] args, String host, Map<String, String> envMap) {
        StringBuilder argsFlat = new StringBuilder();
        for (int i = 0; i < args.length; ++i) {
            argsFlat.append(" ");
            argsFlat.append(args[i]);
        }
        this.traceExecutable(executable, buildDir, argsFlat, host, envMap);
    }

    private void traceExecutable(String executable, String buildDir, StringBuilder argsFlat, String host, Map<String, String> envMap) {
        StringBuilder buf = new StringBuilder("Run " + executable);
        buf.append("\n\tin folder   ").append(buildDir);
        buf.append("\n\targuments   ").append((CharSequence)argsFlat);
        buf.append("\n\thost        ").append(host);
        buf.append("\n\tenvironment ");
        for (Map.Entry<String, String> v : envMap.entrySet()) {
            buf.append("\n\t\t").append(v.getKey()).append("=").append(v.getValue());
        }
        buf.append("\n");
        ImportProject.logger.log(Level.INFO, buf.toString());
    }

    private Map<String, String> getEnv(List<String> additionalEnvironment) {
        HashMap<String, String> envMap = new HashMap<String, String>(this.getDefaultEnvironment());
        if (additionalEnvironment != null) {
            envMap.putAll(this.parseEnvironmentVariables(additionalEnvironment));
        }
        return envMap;
    }

    private Map<String, String> parseEnvironmentVariables(Collection<String> vars) {
        if (vars.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, String> envMap = new HashMap<String, String>();
        for (String s : vars) {
            int i = s.indexOf(61);
            if (i <= 0) continue;
            String key = s.substring(0, i);
            String value = s.substring(i + 1).trim();
            if (value.length() > 1 && (value.startsWith("\"") && value.endsWith("\"") || value.startsWith("'") && value.endsWith("'"))) {
                value = value.substring(1, value.length() - 1);
            }
            envMap.put(key, value);
        }
        return envMap;
    }

    private Map<String, String> getDefaultEnvironment() {
        PlatformInfo pi = PlatformInfo.getDefault((ExecutionEnvironment)this.execEnv);
        String defaultPath = pi.getPathAsString();
        CompilerSet cs = this.getCompilerSet();
        if (cs != null) {
            defaultPath = cs.getDirectory() + pi.pathSeparator() + defaultPath;
            String cmdDir = cs.getCompilerFlavor().getCommandFolder(pi.getPlatform());
            if (cmdDir != null && 0 < cmdDir.length()) {
                defaultPath = cmdDir + pi.pathSeparator() + defaultPath;
            }
        }
        return Collections.singletonMap(pi.getPathName(), defaultPath);
    }

    private static final class ProcessChangeListener
    implements ChangeListener,
    Runnable,
    ExecutionDescriptor.LineConvertorFactory {
        private final AtomicReference<NativeProcess> processRef = new AtomicReference();
        private final ExecutionListener listener;
        private Writer outputListener;
        private final LineConvertor lineConvertor;
        private final RemoteSyncWorker syncWorker;

        public ProcessChangeListener(ExecutionListener listener, Writer outputListener, LineConvertor lineConvertor, RemoteSyncWorker syncWorker) {
            this.listener = listener;
            this.outputListener = outputListener;
            this.lineConvertor = lineConvertor;
            this.syncWorker = syncWorker;
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (!(e instanceof NativeProcessChangeEvent)) {
                return;
            }
            NativeProcessChangeEvent event = (NativeProcessChangeEvent)e;
            this.processRef.compareAndSet(null, (NativeProcess)event.getSource());
            if (NativeProcess.State.RUNNING == event.state && this.listener != null) {
                this.listener.executionStarted(event.pid);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.closeOutputListener();
            NativeProcess process = this.processRef.get();
            try {
                if (process != null && this.listener != null) {
                    this.listener.executionFinished(process.exitValue());
                }
            }
            finally {
                if (this.syncWorker != null) {
                    this.syncWorker.shutdown();
                }
            }
        }

        public LineConvertor newLineConvertor() {
            return new LineConvertor(){

                public List<ConvertedLine> convert(String line) {
                    return ProcessChangeListener.this.convert(line);
                }
            };
        }

        private synchronized void closeOutputListener() {
            if (this.outputListener != null) {
                try {
                    this.outputListener.flush();
                    this.outputListener.close();
                }
                catch (IOException ex) {
                    ex.printStackTrace(System.err);
                }
                this.outputListener = null;
            }
            if (this.lineConvertor instanceof ChangeListener) {
                ((ChangeListener)this.lineConvertor).stateChanged(new ChangeEvent(this));
            }
        }

        private synchronized List<ConvertedLine> convert(String line) {
            if (this.outputListener != null) {
                try {
                    this.outputListener.write(line);
                    this.outputListener.write("\n");
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            if (this.lineConvertor != null) {
                return this.lineConvertor.convert(line);
            }
            return null;
        }
    }

    private static final class BuildTraceHelper
    extends HelperLibraryUtility {
        private static final BuildTraceHelper INSTANCE = new BuildTraceHelper();

        private BuildTraceHelper() {
            super("org.netbeans.modules.cnd.actions", "bin/${osname}-${platform}${_isa}/libBuildTrace.${soext}");
        }
    }
}

