/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.clientproject.libraries;

import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.netbeans.modules.web.clientproject.libraries.JavaScriptLibraryTypeProvider;
import org.netbeans.spi.project.libraries.LibraryImplementation;
import org.netbeans.spi.project.libraries.LibraryImplementation3;
import org.netbeans.spi.project.libraries.LibraryProvider;
import org.netbeans.spi.project.libraries.support.LibrariesSupport;
import org.openide.util.Exceptions;

public class GoogleLibrariesProvider
implements LibraryProvider<LibraryImplementation> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LibraryImplementation[] getLibraries() {
        ArrayList<LibraryImplementation> libs = new ArrayList<LibraryImplementation>();
        BufferedReader is = new BufferedReader(new InputStreamReader(GoogleLibrariesProvider.class.getResourceAsStream("resources/googlecdn.txt"), Charset.forName("UTF-8")));
        try {
            String line;
            String dispName = "";
            String name = "";
            String versions = "";
            String path = "";
            String pathu = "";
            String site = "";
            while ((line = is.readLine()) != null) {
                if (line.startsWith("name:")) {
                    name = line.substring("name: ".length());
                    continue;
                }
                if (line.startsWith("latest version:")) {
                    versions = line.substring("latest version: ".length());
                    continue;
                }
                if (line.startsWith("path:")) {
                    path = line.substring("path: ".length());
                    continue;
                }
                if (line.startsWith("path(u):")) {
                    pathu = line.substring("path(u): ".length());
                    continue;
                }
                if (line.startsWith("site:")) {
                    site = line.substring("site: ".length());
                    continue;
                }
                if (line.trim().length() == 0) {
                    this.addLibraries(libs, dispName, name, versions, path, pathu, site);
                    dispName = "";
                    name = "";
                    versions = "";
                    path = "";
                    pathu = "";
                    site = "";
                    continue;
                }
                dispName = line;
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        return libs.toArray(new LibraryImplementation[libs.size()]);
    }

    private void addLibraries(List<LibraryImplementation> libs, String dispName, String name, String versions, String path, String pathu, String site) {
        String latestVersion = null;
        for (String version : versions.split(", ")) {
            LibraryImplementation3 l1;
            if (latestVersion == null) {
                latestVersion = version;
            }
            LibraryImplementation3 named = l1 = (LibraryImplementation3)LibrariesSupport.createLibraryImplementation((String)"javascript", (String[])JavaScriptLibraryTypeProvider.VOLUMES);
            l1.setName("google-" + name + "-" + version);
            named.setDisplayName("[Google] " + dispName + " " + version);
            HashMap<String, String> p = new HashMap<String, String>();
            p.put("version", version);
            p.put("name", name);
            p.put("displayname", dispName);
            p.put("cdn", "Google");
            p.put("site", site);
            l1.setProperties(p);
            try {
                l1.setContent("minified", Collections.singletonList(new URL(path.replace(latestVersion, version))));
                if (pathu.length() != 0) {
                    l1.setContent("regular", Collections.singletonList(new URL(pathu.replace(latestVersion, version))));
                }
            }
            catch (MalformedURLException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            libs.add((LibraryImplementation)l1);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
    }
}

