/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.clientproject.libraries;

import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.json.simple.parser.ParseException;
import org.netbeans.modules.web.clientproject.libraries.JavaScriptLibraryTypeProvider;
import org.netbeans.spi.project.libraries.LibraryImplementation;
import org.netbeans.spi.project.libraries.LibraryImplementation3;
import org.netbeans.spi.project.libraries.LibraryProvider;
import org.netbeans.spi.project.libraries.support.LibrariesSupport;
import org.openide.util.Exceptions;

public class CDNJSLibrariesProvider
implements LibraryProvider<LibraryImplementation> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LibraryImplementation[] getLibraries() {
        ArrayList<LibraryImplementation> libs;
        block18: {
            libs = new ArrayList<LibraryImplementation>();
            HashMap<String, List<String>> versions = new HashMap<String, List<String>>();
            ZipInputStream str = new ZipInputStream(new BufferedInputStream(CDNJSLibrariesProvider.class.getResourceAsStream("resources/cdnjs.zip")));
            block13: while (true) {
                try {
                    ZipEntry entry;
                    while ((entry = str.getNextEntry()) != null) {
                        String entryName = entry.getName();
                        if (entry.isDirectory()) {
                            String lib;
                            int i = entryName.indexOf("/ajax/libs/");
                            if (i <= 0 || (lib = entryName.substring(i + "/ajax/libs/".length())).length() == 0 || (i = (lib = lib.substring(0, lib.length() - 1)).indexOf("/")) <= 0) continue;
                            String name = lib.substring(0, i);
                            String version = lib.substring(i + 1);
                            if (version.indexOf(47) != -1) continue;
                            ArrayList<String> v = (ArrayList<String>)versions.get(name);
                            if (v == null) {
                                v = new ArrayList<String>();
                                versions.put(name, v);
                            }
                            v.add(version);
                            continue;
                        }
                        if (!entry.getName().endsWith(".json")) continue;
                        try {
                            this.addLibrary(libs, str, versions);
                            continue block13;
                        }
                        catch (ParseException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                    break block18;
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                    break block18;
                }
            }
            finally {
                try {
                    if (str != null) {
                        str.close();
                    }
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
        return libs.toArray(new LibraryImplementation[libs.size()]);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
    }

    private void addLibrary(List<LibraryImplementation> libs, ZipInputStream str, Map<String, List<String>> versions) throws ParseException, IOException {
        List<String> vers;
        InputStreamReader r = new InputStreamReader((InputStream)str, Charset.forName("UTF-8"));
        JSONObject desc = (JSONObject)JSONValue.parseWithException((Reader)r);
        String name = (String)desc.get((Object)"name");
        String version = (String)desc.get((Object)"version");
        String file = (String)desc.get((Object)"filename");
        String homepage = (String)desc.get((Object)"homepage");
        String description = (String)desc.get((Object)"description");
        if (version != null) {
            libs.add(this.createLibrary(name, version, file, homepage, description));
        }
        if ((vers = versions.get(name)) == null) {
            return;
        }
        for (String v : vers) {
            if (v == null || v.equals(version)) continue;
            libs.add(this.createLibrary(name, v, file, homepage, description));
        }
    }

    private LibraryImplementation createLibrary(String name, String version, String file, String homepage, String description) {
        LibraryImplementation3 l1;
        LibraryImplementation3 named = l1 = (LibraryImplementation3)LibrariesSupport.createLibraryImplementation((String)"javascript", (String[])JavaScriptLibraryTypeProvider.VOLUMES);
        l1.setName("cdnjs-" + name + "-" + version);
        named.setDisplayName("[CDNJS] " + name + " " + version);
        HashMap<String, String> p = new HashMap<String, String>();
        p.put("version", version);
        p.put("name", name);
        p.put("displayname", name);
        p.put("cdn", "CDNJS");
        p.put("site", homepage);
        l1.setProperties(p);
        l1.setDescription(description);
        try {
            String path = "http://cdnjs.cloudflare.com/ajax/libs/" + name + "/" + version + "/" + file;
            l1.setContent("minified", Collections.singletonList(new URL(path)));
        }
        catch (MalformedURLException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return l1;
    }
}

