/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.clientproject.api.network;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collections;
import java.util.List;
import javax.swing.JButton;
import org.netbeans.api.options.OptionsDisplayer;
import org.netbeans.modules.web.clientproject.api.network.Bundle;
import org.netbeans.modules.web.clientproject.api.network.ui.NetworkErrorPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Parameters;

public final class NetworkSupport {
    private NetworkSupport() {
    }

    public static boolean showNetworkErrorDialog(String failedRequest) {
        Parameters.notNull((CharSequence)"failedRequest", (Object)failedRequest);
        return NetworkSupport.showNetworkErrorDialog(Collections.singletonList(failedRequest));
    }

    public static boolean showNetworkErrorDialog(List<String> failedRequests) {
        Parameters.notNull((CharSequence)"failedRequests", failedRequests);
        if (failedRequests.isEmpty()) {
            throw new IllegalArgumentException("Failed requests must be provided.");
        }
        DialogDescriptor descriptor = new DialogDescriptor((Object)new NetworkErrorPanel(failedRequests), Bundle.NetworkSupport_errorDialog_title(), true, 0, DialogDescriptor.YES_OPTION, null);
        JButton configureProxyButton = new JButton(Bundle.NetworkSupport_errorDialog_configureProxy());
        configureProxyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OptionsDisplayer.getDefault().open("General");
            }
        });
        descriptor.setAdditionalOptions(new Object[]{configureProxyButton});
        return DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor) == NotifyDescriptor.YES_OPTION;
    }
}

