/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.clientproject.api;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.project.libraries.Library;
import org.netbeans.modules.web.clientproject.api.MissingLibResourceException;
import org.netbeans.modules.web.clientproject.libraries.CDNJSLibrariesProvider;
import org.netbeans.modules.web.clientproject.libraries.GoogleLibrariesProvider;
import org.netbeans.spi.project.libraries.LibraryFactory;
import org.netbeans.spi.project.libraries.LibraryImplementation;
import org.netbeans.spi.project.libraries.LibraryProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.SpecificationVersion;

public final class WebClientLibraryManager {
    private static final Logger LOGGER = Logger.getLogger(WebClientLibraryManager.class.getName());
    public static final String TYPE = "javascript";
    public static final String VOL_REGULAR = "regular";
    public static final String VOL_MINIFIED = "minified";
    public static final String VOL_DOCUMENTED = "documented";
    public static final String PROPERTY_REAL_NAME = "name";
    public static final String PROPERTY_REAL_DISPLAY_NAME = "displayname";
    public static final String PROPERTY_CDN = "cdn";
    public static final String PROPERTY_SITE = "site";
    public static final String LIBS = "js/libs";
    public static final String PROPERTY_VERSION = "version";
    private static List<Library> libs;

    private WebClientLibraryManager() {
    }

    public static synchronized List<Library> getLibraries() {
        if (libs == null) {
            ArrayList<Library> libs2 = new ArrayList<Library>();
            WebClientLibraryManager.addLibraries(libs2, new CDNJSLibrariesProvider());
            WebClientLibraryManager.addLibraries(libs2, new GoogleLibrariesProvider());
            libs = libs2;
        }
        return libs;
    }

    private static void addLibraries(List<Library> libs, LibraryProvider<LibraryImplementation> provider) {
        for (LibraryImplementation li : provider.getLibraries()) {
            libs.add(LibraryFactory.createLibrary((LibraryImplementation)li));
        }
    }

    public static Library findLibrary(String name, String version) {
        SpecificationVersion lastVersion = null;
        Library lib = null;
        for (Library library : WebClientLibraryManager.getLibraries()) {
            if (!library.getType().equals(TYPE)) continue;
            String libName = (String)library.getProperties().get(PROPERTY_REAL_NAME);
            String libVersion = (String)library.getProperties().get(PROPERTY_VERSION);
            if (!name.equals(libName)) continue;
            if (version != null && version.equals(libVersion)) {
                return library;
            }
            int index = libVersion.indexOf(32);
            if (index != -1) {
                libVersion = libVersion.substring(0, index);
            }
            try {
                SpecificationVersion specVersion = new SpecificationVersion(libVersion);
                if (lastVersion != null && specVersion.compareTo((Object)lastVersion) <= 0) continue;
                lastVersion = specVersion;
                lib = library;
            }
            catch (NumberFormatException e) {}
        }
        return lib;
    }

    public static String[] getVersions(String libraryName) {
        LinkedList<String> result = new LinkedList<String>();
        for (Library library : WebClientLibraryManager.getLibraries()) {
            String libName;
            if (!library.getType().equals(TYPE) || !(libName = (String)library.getProperties().get(PROPERTY_REAL_NAME)).equals(libraryName)) continue;
            String libVersion = (String)library.getProperties().get(PROPERTY_VERSION);
            int index = libVersion.indexOf(32);
            if (index != -1) {
                libVersion = libVersion.substring(0, index);
            }
            result.add(libVersion);
        }
        return result.toArray(new String[result.size()]);
    }

    public static List<String> getLibraryFilePaths(@NonNull Library library, @NullAllowed String volume) {
        String libRootName = WebClientLibraryManager.getLibraryRootName(library);
        List<URL> urls = WebClientLibraryManager.getLibraryUrls(library, volume);
        ArrayList<String> filePaths = new ArrayList<String>(urls.size());
        for (URL url : urls) {
            StringBuilder sb = new StringBuilder(30);
            sb.append(libRootName);
            sb.append('/');
            sb.append(WebClientLibraryManager.getLibraryFilePath(url));
            filePaths.add(sb.toString());
        }
        return filePaths;
    }

    private static String getLibraryRootName(Library library) {
        return ((String)library.getProperties().get(PROPERTY_REAL_NAME)).replace(' ', '-') + '-' + (String)library.getProperties().get(PROPERTY_VERSION);
    }

    private static List<URL> getLibraryUrls(Library library, String volume) {
        List urls;
        if (volume != null) {
            urls = library.getContent(volume);
        } else {
            urls = library.getContent(VOL_MINIFIED);
            if (urls.isEmpty()) {
                urls = library.getContent(VOL_REGULAR);
            }
            if (urls.isEmpty()) {
                urls = library.getContent(VOL_DOCUMENTED);
            }
        }
        assert (!urls.isEmpty()) : "Library should not be empty: " + library + " " + volume;
        return urls;
    }

    private static String getLibraryFilePath(URL url) {
        String name = url.getPath();
        return name.substring(name.lastIndexOf(47) + 1);
    }

    public static List<FileObject> addLibraries(Library[] libraries, FileObject folder, String volume) throws IOException, MissingLibResourceException {
        boolean missingFiles = false;
        LinkedList<FileObject> result = new LinkedList<FileObject>();
        for (Library library : libraries) {
            String libRootName = WebClientLibraryManager.getLibraryRootName(library);
            FileObject libRoot = folder.getFileObject(libRootName);
            if (libRoot == null) {
                libRoot = folder.createFolder(libRootName);
            } else if (libRoot.isData()) {
                throw new IOException("File '" + libRootName + "' already exists and is not a folder");
            }
            List<URL> urls = WebClientLibraryManager.getLibraryUrls(library, volume);
            for (URL url : urls) {
                FileObject fileObject = WebClientLibraryManager.copySingleFile(url, WebClientLibraryManager.getLibraryFilePath(url), libRoot);
                if (fileObject == null) {
                    missingFiles = true;
                    continue;
                }
                result.add(fileObject);
            }
        }
        if (missingFiles) {
            throw new MissingLibResourceException(result);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static FileObject copySingleFile(URL url, String name, FileObject libRoot) throws IOException {
        InputStream is;
        FileObject fo = libRoot.createData(name);
        try {
            is = url.openStream();
        }
        catch (FileNotFoundException ex) {
            LOGGER.log(Level.INFO, "could not open stream for " + url, ex);
            return null;
        }
        catch (IOException ex) {
            LOGGER.log(Level.INFO, "could not open stream for " + url, ex);
            return null;
        }
        OutputStream os = null;
        try {
            os = fo.getOutputStream();
            FileUtil.copy((InputStream)is, (OutputStream)os);
        }
        finally {
            is.close();
            if (os != null) {
                os.close();
            }
        }
        return fo;
    }
}

