/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jboss4.nodes;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.MBeanServerConnection;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import javax.management.QueryExp;
import org.netbeans.modules.j2ee.jboss4.JBDeploymentManager;
import org.netbeans.modules.j2ee.jboss4.JBRemoteAction;
import org.netbeans.modules.j2ee.jboss4.JBoss5ProfileServiceProxy;
import org.netbeans.modules.j2ee.jboss4.nodes.JBAbilitiesSupport;
import org.netbeans.modules.j2ee.jboss4.nodes.JBEjbModuleNode;
import org.netbeans.modules.j2ee.jboss4.nodes.Util;
import org.netbeans.modules.j2ee.jboss4.nodes.actions.Refreshable;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;

public class JBEjbModulesChildren
extends Children.Keys
implements Refreshable {
    private static final Logger LOGGER = Logger.getLogger(JBEjbModulesChildren.class.getName());
    private final JBAbilitiesSupport abilitiesSupport;
    private final Lookup lookup;

    public JBEjbModulesChildren(Lookup lookup) {
        this.lookup = lookup;
        this.abilitiesSupport = new JBAbilitiesSupport(lookup);
    }

    @Override
    public void updateKeys() {
        this.setKeys(new Object[]{"wait_node"});
        RequestProcessor.getDefault().post(new Runnable(){

            @Override
            public void run() {
                LinkedList keys = new LinkedList();
                JBDeploymentManager dm = (JBDeploymentManager)JBEjbModulesChildren.this.lookup.lookup(JBDeploymentManager.class);
                JBEjbModulesChildren.this.addEjbModules(dm, keys);
                JBEjbModulesChildren.this.addEJB3Modules(dm, keys);
                JBEjbModulesChildren.this.setKeys(keys);
            }
        }, 0);
    }

    private void addEjbModules(JBDeploymentManager dm, final List keys) {
        try {
            dm.invokeRemoteAction(new JBRemoteAction<Void>(){

                @Override
                public Void action(MBeanServerConnection connection, JBoss5ProfileServiceProxy profileService) throws Exception {
                    ObjectName searchPattern;
                    String propertyName;
                    if (JBEjbModulesChildren.this.abilitiesSupport.isRemoteManagementSupported() && (JBEjbModulesChildren.this.abilitiesSupport.isJB4x() || JBEjbModulesChildren.this.abilitiesSupport.isJB6x())) {
                        propertyName = "name";
                        searchPattern = new ObjectName("jboss.management.local:j2eeType=EJBModule,J2EEApplication=null,*");
                    } else {
                        propertyName = "module";
                        searchPattern = new ObjectName("jboss.j2ee:service=EjbModule,*");
                    }
                    Method method = connection.getClass().getMethod("queryMBeans", ObjectName.class, QueryExp.class);
                    method = Util.fixJava4071957(method);
                    Set managedObj = (Set)method.invoke((Object)connection, searchPattern, null);
                    Iterator it = managedObj.iterator();
                    while (it.hasNext()) {
                        ObjectName elem = ((ObjectInstance)it.next()).getObjectName();
                        String name = elem.getKeyProperty(propertyName);
                        keys.add(new JBEjbModuleNode(name, JBEjbModulesChildren.this.lookup));
                    }
                    return null;
                }
            });
        }
        catch (ExecutionException ex) {
            LOGGER.log(Level.INFO, null, ex);
        }
    }

    private void addEJB3Modules(JBDeploymentManager dm, final List keys) {
        try {
            dm.invokeRemoteAction(new JBRemoteAction<Void>(){

                @Override
                public Void action(MBeanServerConnection connection, JBoss5ProfileServiceProxy profileService) throws Exception {
                    ObjectName searchPattern = new ObjectName("jboss.j2ee:service=EJB3,*");
                    Method method = connection.getClass().getMethod("queryMBeans", ObjectName.class, QueryExp.class);
                    method = Util.fixJava4071957(method);
                    Set managedObj = (Set)method.invoke((Object)connection, searchPattern, null);
                    Iterator it = managedObj.iterator();
                    while (it.hasNext()) {
                        try {
                            ObjectName elem = ((ObjectInstance)it.next()).getObjectName();
                            String name = elem.getKeyProperty("module");
                            if (name == null) continue;
                            keys.add(new JBEjbModuleNode(name, JBEjbModulesChildren.this.lookup, true));
                        }
                        catch (Exception ex) {
                            LOGGER.log(Level.INFO, null, ex);
                        }
                    }
                    return null;
                }
            });
        }
        catch (ExecutionException ex) {
            LOGGER.log(Level.INFO, null, ex);
        }
    }

    protected void addNotify() {
        this.updateKeys();
    }

    protected void removeNotify() {
        this.setKeys(Collections.EMPTY_SET);
    }

    protected Node[] createNodes(Object key) {
        if (key instanceof JBEjbModuleNode) {
            return new Node[]{(JBEjbModuleNode)((Object)key)};
        }
        if (key instanceof String && key.equals("wait_node")) {
            return new Node[]{Util.createWaitNode()};
        }
        return null;
    }
}

