/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jboss4;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.shared.factories.DeploymentFactoryManager;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.exceptions.DeploymentManagerCreationException;
import javax.enterprise.deploy.spi.factories.DeploymentFactory;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.j2ee.jboss4.JBDeploymentManager;
import org.netbeans.modules.j2ee.jboss4.ide.ui.JBPluginProperties;
import org.netbeans.modules.j2ee.jboss4.ide.ui.JBPluginUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class JBDeploymentFactory
implements DeploymentFactory {
    public static final String URI_PREFIX = "jboss-deployer:";
    private static final String DISCONNECTED_URI = "jboss-deployer:http://localhost:8080&";
    private static final Logger LOGGER = Logger.getLogger(JBDeploymentFactory.class.getName());
    private static final Map<InstanceProperties, JBClassLoader> JB_CLASSLOADER_CACHE = new WeakHashMap<InstanceProperties, JBClassLoader>();
    private static Map<InstanceProperties, DeploymentFactory> FACTORIES_CACHE = new WeakHashMap<InstanceProperties, DeploymentFactory>();
    private static JBDeploymentFactory instance;
    private static final String INSTALL_ROOT_PROP_NAME = "org.netbeans.modules.j2ee.jboss4.installRoot";

    public static synchronized DeploymentFactory create() {
        if (instance == null) {
            instance = new JBDeploymentFactory();
            DeploymentFactoryManager.getInstance().registerDeploymentFactory((DeploymentFactory)instance);
            JBDeploymentFactory.registerDefaultServerInstance();
        }
        return instance;
    }

    public static synchronized JBClassLoader getJBClassLoader(InstanceProperties ip) {
        JBClassLoader cl = JB_CLASSLOADER_CACHE.get(ip);
        if (cl == null) {
            DeploymentFactory factory = FACTORIES_CACHE.get(ip);
            if (factory != null) {
                cl = (JBClassLoader)factory.getClass().getClassLoader();
            }
            if (cl == null) {
                cl = JBDeploymentFactory.createJBClassLoader(ip.getProperty("root-dir"), ip.getProperty("server-dir"));
            }
            JB_CLASSLOADER_CACHE.put(ip, cl);
        }
        return cl;
    }

    public static JBClassLoader createJBClassLoader(String serverRoot, String domainRoot) {
        try {
            JBPluginUtils.Version JBVer = JBPluginUtils.getServerVersion(new File(serverRoot));
            boolean version5Above = JBVer != null && JBVer.compareToIgnoreUpdate(JBPluginUtils.JBOSS_5_0_0) >= 0;
            File domFile = new File(serverRoot, JBPluginUtils.LIB + "dom4j.jar");
            if (!domFile.exists()) {
                domFile = new File(domainRoot, JBPluginUtils.LIB + "dom4j.jar");
            }
            if (!domFile.exists()) {
                domFile = null;
                LOGGER.log(Level.INFO, "No dom4j.jar availabale on classpath");
            }
            ArrayList<URL> urlList = new ArrayList<URL>();
            if (domFile != null) {
                urlList.add(domFile.toURI().toURL());
            }
            if (version5Above) {
                File metaFile;
                File managedFile;
                File profileFile;
                File securityFile;
                List<URL> clientClassUrls = JBPluginUtils.getJB5ClientClasspath(serverRoot);
                urlList.addAll(clientClassUrls);
                File runFile = new File(serverRoot, "bin" + File.separator + "run.jar");
                if (runFile.exists()) {
                    urlList.add(runFile.toURI().toURL());
                }
                if ((securityFile = new File(serverRoot, "common" + File.separator + "lib" + File.separator + "jboss-security-aspects.jar")).exists()) {
                    urlList.add(securityFile.toURI().toURL());
                }
                if ((profileFile = new File(serverRoot, "common" + File.separator + "lib" + File.separator + "jboss-profileservice.jar")).exists()) {
                    urlList.add(profileFile.toURI().toURL());
                }
                if ((managedFile = new File(serverRoot, "lib" + File.separator + "jboss-managed.jar")).exists()) {
                    urlList.add(managedFile.toURI().toURL());
                }
                if ((metaFile = new File(serverRoot, "lib" + File.separator + "jboss-metatype.jar")).exists()) {
                    urlList.add(metaFile.toURI().toURL());
                }
            } else {
                urlList.add(new File(serverRoot, JBPluginUtils.CLIENT + "jbossall-client.jar").toURI().toURL());
                urlList.add(new File(serverRoot, JBPluginUtils.CLIENT + "jboss-deployment.jar").toURI().toURL());
                urlList.add(new File(serverRoot, JBPluginUtils.CLIENT + "jnp-client.jar").toURI().toURL());
                File client40 = new File(serverRoot, JBPluginUtils.CLIENT + "jboss-common-client.jar");
                if (client40.exists()) {
                    urlList.add(client40.toURI().toURL());
                }
            }
            JBClassLoader loader = new JBClassLoader(urlList.toArray(new URL[0]), JBDeploymentFactory.class.getClassLoader());
            return loader;
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, null, e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeploymentFactory getFactory(String instanceURL) {
        DeploymentFactory jbossFactory = null;
        try {
            String jbossRoot = InstanceProperties.getInstanceProperties((String)instanceURL).getProperty("root-dir");
            String domainRoot = InstanceProperties.getInstanceProperties((String)instanceURL).getProperty("server-dir");
            if (jbossRoot == null) {
                jbossRoot = JBPluginProperties.getInstance().getInstallLocation();
            }
            if (domainRoot == null) {
                domainRoot = JBPluginProperties.getInstance().getDomainLocation();
            }
            InstanceProperties ip = InstanceProperties.getInstanceProperties((String)instanceURL);
            Class<JBDeploymentFactory> clazz = JBDeploymentFactory.class;
            synchronized (JBDeploymentFactory.class) {
                if (ip != null) {
                    jbossFactory = FACTORIES_CACHE.get(ip);
                }
                if (jbossFactory == null) {
                    JBClassLoader loader = ip != null ? JBDeploymentFactory.getJBClassLoader(ip) : JBDeploymentFactory.createJBClassLoader(jbossRoot, domainRoot);
                    jbossFactory = (DeploymentFactory)loader.loadClass("org.jboss.deployment.spi.factories.DeploymentFactoryImpl").newInstance();
                    if (ip != null) {
                        FACTORIES_CACHE.put(ip, jbossFactory);
                    }
                }
                // ** MonitorExit[var6_7] (shouldn't be in output)
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, null, e);
        }
        {
            return jbossFactory;
        }
    }

    public boolean handlesURI(String uri) {
        return uri != null && uri.startsWith(URI_PREFIX);
    }

    public DeploymentManager getDeploymentManager(String uri, String uname, String passwd) throws DeploymentManagerCreationException {
        if (!this.handlesURI(uri)) {
            throw new DeploymentManagerCreationException(NbBundle.getMessage(JBDeploymentFactory.class, (String)"MSG_INVALID_URI", (Object)uri));
        }
        try {
            DeploymentFactory df = this.getFactory(uri);
            if (df == null) {
                throw new DeploymentManagerCreationException(NbBundle.getMessage(JBDeploymentFactory.class, (String)"MSG_ERROR_CREATING_DM", (Object)uri));
            }
            String jbURI = uri;
            try {
                jbURI = uri.substring(0, uri.indexOf("&"));
            }
            catch (Exception e) {
                LOGGER.log(Level.INFO, null, e);
            }
            return new JBDeploymentManager(df.getDeploymentManager(jbURI, uname, passwd), uri, uname, passwd);
        }
        catch (NoClassDefFoundError e) {
            DeploymentManagerCreationException dmce = new DeploymentManagerCreationException("Classpath is incomplete");
            dmce.initCause((Throwable)e);
            throw dmce;
        }
    }

    public DeploymentManager getDisconnectedDeploymentManager(String uri) throws DeploymentManagerCreationException {
        if (!this.handlesURI(uri)) {
            throw new DeploymentManagerCreationException(NbBundle.getMessage(JBDeploymentFactory.class, (String)"MSG_INVALID_URI", (Object)uri));
        }
        try {
            DeploymentFactory df = null;
            InstanceProperties ip = InstanceProperties.getInstanceProperties((String)uri);
            if (ip == null) {
                if (!DISCONNECTED_URI.equals(uri)) {
                    throw new DeploymentManagerCreationException("JBoss instance " + uri + " is not registered in the IDE.");
                }
            } else {
                df = this.getFactory(uri);
                if (df == null) {
                    throw new DeploymentManagerCreationException(NbBundle.getMessage(JBDeploymentFactory.class, (String)"MSG_ERROR_CREATING_DM", (Object)uri));
                }
            }
            String jbURI = uri;
            try {
                jbURI = uri.substring(0, uri.indexOf("&"));
            }
            catch (Exception e) {
                LOGGER.log(Level.INFO, null, e);
            }
            return new JBDeploymentManager(df != null ? df.getDisconnectedDeploymentManager(jbURI) : null, uri, null, null);
        }
        catch (NoClassDefFoundError e) {
            DeploymentManagerCreationException dmce = new DeploymentManagerCreationException("Classpath is incomplete");
            dmce.initCause((Throwable)e);
            throw dmce;
        }
    }

    public String getProductVersion() {
        return NbBundle.getMessage(JBDeploymentFactory.class, (String)"LBL_JBossFactoryVersion");
    }

    public String getDisplayName() {
        return NbBundle.getMessage(JBDeploymentFactory.class, (String)"SERVER_NAME");
    }

    private static void registerDefaultServerInstance() {
        try {
            FileObject serverInstanceDir = JBDeploymentFactory.getServerInstanceDir();
            String serverLocation = JBDeploymentFactory.getDefaultInstallLocation();
            String domainLocation = serverLocation + File.separator + "server" + File.separator + "default";
            JBDeploymentFactory.setRemovability(serverInstanceDir, domainLocation);
            File serverDirectory = new File(serverLocation);
            if (JBPluginUtils.isGoodJBLocation(serverDirectory, new File(domainLocation)) && !JBDeploymentFactory.isAlreadyRegistered(serverInstanceDir, domainLocation)) {
                String host = "localhost";
                String port = JBPluginUtils.getHTTPConnectorPort(domainLocation);
                JBDeploymentFactory.register(serverInstanceDir, serverLocation, domainLocation, host, port);
            }
        }
        catch (IOException ioe) {
            LOGGER.log(Level.SEVERE, ioe.getMessage());
        }
    }

    private static String getDefaultInstallLocation() {
        String installRoot = System.getProperty(INSTALL_ROOT_PROP_NAME);
        if (installRoot != null && new File(installRoot).exists()) {
            return installRoot;
        }
        return "";
    }

    private static boolean isAlreadyRegistered(FileObject serverInstanceDir, String domainLocation) throws IOException {
        String domainLocationCan = new File(domainLocation).getCanonicalPath();
        for (FileObject instanceFO : serverInstanceDir.getChildren()) {
            String installedLocationCan;
            String installedLocation = (String)instanceFO.getAttribute("server-dir");
            if (installedLocation == null || !domainLocationCan.equals(installedLocationCan = new File(installedLocation).getCanonicalPath())) continue;
            return true;
        }
        return false;
    }

    private static void setRemovability(FileObject serverInstanceDir, String domainLocation) throws IOException {
        String domainLocationCan = new File(domainLocation).getCanonicalPath();
        for (FileObject instanceFO : serverInstanceDir.getChildren()) {
            String url = (String)instanceFO.getAttribute("url");
            if (url == null) {
                LOGGER.log(Level.INFO, "No server URL in " + FileUtil.getFileDisplayName((FileObject)instanceFO));
                continue;
            }
            if (!url.startsWith(URI_PREFIX)) continue;
            String installedLocation = (String)instanceFO.getAttribute("server-dir");
            String installedLocationCan = new File(installedLocation).getCanonicalPath();
            if (domainLocationCan.equals(installedLocationCan)) {
                instanceFO.setAttribute("removeForbidden", (Object)Boolean.TRUE);
                continue;
            }
            if (instanceFO.getAttribute("removeForbidden") == null) continue;
            instanceFO.setAttribute("removeForbidden", (Object)Boolean.FALSE);
        }
    }

    private static void register(FileObject serverInstanceDir, String serverLocation, String domainLocation, String host, String port) throws IOException {
        String displayName = JBDeploymentFactory.generateDisplayName(serverInstanceDir);
        String url = URI_PREFIX + host + ":" + port + "#default&" + serverLocation;
        String name = FileUtil.findFreeFileName((FileObject)serverInstanceDir, (String)"instance", null);
        FileObject instanceFO = serverInstanceDir.createData(name);
        instanceFO.setAttribute("url", (Object)url);
        instanceFO.setAttribute("username", (Object)"");
        instanceFO.setAttribute("password", (Object)"");
        instanceFO.setAttribute("displayName", (Object)displayName);
        instanceFO.setAttribute("removeForbidden", (Object)"true");
        instanceFO.setAttribute("server", (Object)"default");
        String deployDir = JBPluginUtils.getDeployDir(domainLocation);
        instanceFO.setAttribute("deploy-dir", (Object)deployDir);
        instanceFO.setAttribute("server-dir", (Object)domainLocation);
        instanceFO.setAttribute("root-dir", (Object)serverLocation);
        instanceFO.setAttribute("host", (Object)host);
        instanceFO.setAttribute("port", (Object)port);
    }

    private static FileObject getServerInstanceDir() {
        FileObject dir = FileUtil.getConfigFile((String)"J2EE/InstalledServers");
        return dir;
    }

    private static String generateDisplayName(FileObject serverInstanceDir) {
        String serverName;
        String instanceName = serverName = NbBundle.getMessage(JBDeploymentFactory.class, (String)"SERVER_NAME");
        int counter = 1;
        Set<String> registeredInstances = JBDeploymentFactory.getServerInstancesNames(serverInstanceDir);
        while (registeredInstances.contains(instanceName.toUpperCase())) {
            instanceName = serverName + " (" + String.valueOf(counter++) + ")";
        }
        return instanceName;
    }

    private static Set<String> getServerInstancesNames(FileObject serverInstanceDir) {
        HashSet<String> names = new HashSet<String>();
        for (FileObject instanceFO : serverInstanceDir.getChildren()) {
            String instanceName = (String)instanceFO.getAttribute("displayName");
            names.add(instanceName.toUpperCase());
        }
        return names;
    }

    public static class JBClassLoader
    extends URLClassLoader {
        public JBClassLoader(URL[] urls, ClassLoader parent) throws MalformedURLException, RuntimeException {
            super(urls, parent);
        }

        @Override
        protected PermissionCollection getPermissions(CodeSource codeSource) {
            Permissions p = new Permissions();
            p.add(new AllPermission());
            return p;
        }

        @Override
        public Enumeration<URL> getResources(String name) throws IOException {
            if (name.indexOf("jndi.properties") != -1) {
                return Collections.enumeration(Collections.emptyList());
            }
            return super.getResources(name);
        }
    }
}

