/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.jboss4;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.MissingResourceException;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.enterprise.deploy.shared.ActionType;
import javax.enterprise.deploy.shared.CommandType;
import javax.enterprise.deploy.shared.StateType;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.OperationUnsupportedException;
import javax.enterprise.deploy.spi.status.ClientConfiguration;
import javax.enterprise.deploy.spi.status.DeploymentStatus;
import javax.enterprise.deploy.spi.status.ProgressEvent;
import javax.enterprise.deploy.spi.status.ProgressListener;
import javax.enterprise.deploy.spi.status.ProgressObject;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import org.netbeans.modules.j2ee.dd.api.application.Application;
import org.netbeans.modules.j2ee.dd.api.application.DDProvider;
import org.netbeans.modules.j2ee.dd.api.application.Module;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.j2ee.jboss4.JBDeploymentManager;
import org.netbeans.modules.j2ee.jboss4.JBRemoteAction;
import org.netbeans.modules.j2ee.jboss4.JBTargetModuleID;
import org.netbeans.modules.j2ee.jboss4.JBoss5ProfileServiceProxy;
import org.netbeans.modules.j2ee.jboss4.config.gen.JbossWeb;
import org.netbeans.modules.j2ee.jboss4.ide.JBDeploymentStatus;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.JarFileSystem;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class JBDeployer
implements ProgressObject,
Runnable {
    private static final int TIMEOUT = 60000;
    private static final int POLLING_INTERVAL = 1000;
    private static final Logger LOGGER = Logger.getLogger(JBDeployer.class.getName());
    private final JBDeploymentManager dm;
    private File file;
    private String uri;
    private JBTargetModuleID mainModuleID;
    private List<ProgressListener> listeners = new CopyOnWriteArrayList<ProgressListener>();
    private DeploymentStatus deploymentStatus;

    public JBDeployer(String serverUri, JBDeploymentManager dm) {
        this.uri = serverUri;
        this.dm = dm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProgressObject deploy(Target[] target, File file, File file2, String host, int port) {
        block15: {
            this.mainModuleID = new JBTargetModuleID(target[0], file.getName());
            try {
                String server_url = "http://" + host + ":" + port;
                if (file.getName().endsWith(".war")) {
                    this.mainModuleID.setContextURL(server_url + JbossWeb.createGraph(file2).getContextRoot());
                    break block15;
                }
                if (!file.getName().endsWith(".ear")) break block15;
                JarFileSystem jfs = new JarFileSystem();
                jfs.setJarFile(file);
                FileObject appXml = jfs.getRoot().getFileObject("META-INF/application.xml");
                if (appXml != null) {
                    Application ear = DDProvider.getDefault().getDDRoot(appXml);
                    Module[] modules = ear.getModule();
                    for (int i = 0; i < modules.length; ++i) {
                        JBTargetModuleID mod_id = new JBTargetModuleID(target[0]);
                        if (modules[i].getWeb() != null) {
                            mod_id.setJARName(modules[i].getWeb().getWebUri());
                            mod_id.setContextURL(server_url + modules[i].getWeb().getContextRoot());
                        }
                        this.mainModuleID.addChild(mod_id);
                    }
                    break block15;
                }
                for (FileObject child : jfs.getRoot().getChildren()) {
                    if (!child.hasExt("war") && !child.hasExt("jar")) continue;
                    JBTargetModuleID mod_id = new JBTargetModuleID(target[0], child.getNameExt());
                    if (child.hasExt("war")) {
                        String contextRoot = child.getName();
                        ZipInputStream zis = new ZipInputStream(child.getInputStream());
                        try {
                            ZipEntry entry = null;
                            while ((entry = zis.getNextEntry()) != null) {
                                if (!"WEB-INF/jboss-web.xml".equals(entry.getName())) continue;
                                String ddContextRoot = JbossWeb.createGraph(new ZipEntryInputStream(zis)).getContextRoot();
                                if (ddContextRoot != null) {
                                    contextRoot = ddContextRoot;
                                }
                                break;
                            }
                        }
                        catch (IOException ex) {
                            LOGGER.log(Level.INFO, "Error reading context-root", ex);
                        }
                        finally {
                            zis.close();
                        }
                        mod_id.setContextURL(server_url + contextRoot);
                    }
                    this.mainModuleID.addChild(mod_id);
                }
            }
            catch (Exception e) {
                LOGGER.log(Level.INFO, null, e);
            }
        }
        this.file = file;
        this.fireHandleProgressEvent(null, new JBDeploymentStatus(ActionType.EXECUTE, CommandType.DISTRIBUTE, StateType.RUNNING, NbBundle.getMessage(JBDeployer.class, (String)"MSG_DEPLOYING", (Object)file.getAbsolutePath())));
        RequestProcessor.getDefault().post((Runnable)this, 0, 5);
        return this;
    }

    public ProgressObject redeploy(TargetModuleID[] module_id, File file, File file2) {
        this.file = file;
        this.mainModuleID = (JBTargetModuleID)module_id[0];
        this.fireHandleProgressEvent(null, new JBDeploymentStatus(ActionType.EXECUTE, CommandType.DISTRIBUTE, StateType.RUNNING, NbBundle.getMessage(JBDeployer.class, (String)"MSG_DEPLOYING", (Object)file.getAbsolutePath())));
        RequestProcessor.getDefault().post((Runnable)this, 0, 5);
        return this;
    }

    @Override
    public void run() {
        String deployDir = InstanceProperties.getInstanceProperties((String)this.uri).getProperty("deploy-dir");
        FileObject foIn = FileUtil.toFileObject((File)this.file);
        FileObject foDestDir = FileUtil.toFileObject((File)new File(deployDir));
        String fileName = this.file.getName();
        File toDeploy = new File(deployDir + File.separator + fileName);
        if (toDeploy.exists()) {
            toDeploy.delete();
        }
        fileName = fileName.substring(0, fileName.lastIndexOf(46));
        String msg = NbBundle.getMessage(JBDeployer.class, (String)"MSG_DEPLOYING", (Object)this.file.getAbsolutePath());
        this.fireHandleProgressEvent(null, new JBDeploymentStatus(ActionType.EXECUTE, CommandType.DISTRIBUTE, StateType.RUNNING, msg));
        try {
            TargetModuleID[] ch;
            Long previousDeployTime = this.getDeploymentTime(toDeploy);
            FileUtil.copyFile((FileObject)foIn, (FileObject)foDestDir, (String)fileName);
            JBTargetModuleID moduleID = this.mainModuleID;
            String webUrl = this.mainModuleID.getWebURL();
            if (webUrl == null && (ch = this.mainModuleID.getChildTargetModuleID()) != null) {
                for (int i = 0; i < ch.length; ++i) {
                    webUrl = ch[i].getWebURL();
                    if (webUrl == null) continue;
                    moduleID = ch[i];
                    break;
                }
            }
            try {
                this.dm.invokeRemoteAction(new JBRemoteAction<Void>(){

                    @Override
                    public Void action(MBeanServerConnection connection, JBoss5ProfileServiceProxy profileService) throws Exception {
                        if (profileService != null) {
                            profileService.startAndWait(JBDeployer.this.mainModuleID.getModuleID(), 60000L);
                        }
                        return null;
                    }
                });
            }
            catch (ExecutionException ex) {
                LOGGER.log(Level.INFO, null, ex);
            }
            if (webUrl != null) {
                URL url = new URL(webUrl);
                String waitingMsg = NbBundle.getMessage(JBDeployer.class, (String)"MSG_Waiting_For_Url", (Object)url);
                this.fireHandleProgressEvent(null, new JBDeploymentStatus(ActionType.EXECUTE, CommandType.DISTRIBUTE, StateType.RUNNING, waitingMsg));
                boolean ready = this.waitForUrlReady(moduleID, toDeploy, previousDeployTime, 60000L);
                if (!ready) {
                    LOGGER.log(Level.INFO, "URL wait timeouted after {0}", 60000);
                }
            }
        }
        catch (MalformedURLException ex) {
            LOGGER.log(Level.INFO, null, ex);
            this.fireHandleProgressEvent(null, new JBDeploymentStatus(ActionType.EXECUTE, CommandType.DISTRIBUTE, StateType.FAILED, "Failed"));
        }
        catch (MissingResourceException ex) {
            LOGGER.log(Level.INFO, null, ex);
            this.fireHandleProgressEvent(null, new JBDeploymentStatus(ActionType.EXECUTE, CommandType.DISTRIBUTE, StateType.FAILED, "Failed"));
        }
        catch (IOException ex) {
            LOGGER.log(Level.INFO, null, ex);
            this.fireHandleProgressEvent(null, new JBDeploymentStatus(ActionType.EXECUTE, CommandType.DISTRIBUTE, StateType.FAILED, "Failed"));
        }
        catch (InterruptedException ex) {
            LOGGER.log(Level.INFO, null, ex);
        }
        this.fireHandleProgressEvent(null, new JBDeploymentStatus(ActionType.EXECUTE, CommandType.DISTRIBUTE, StateType.COMPLETED, "Applicaton Deployed"));
    }

    private boolean waitForUrlReady(TargetModuleID moduleID, File deployedFile, Long previousDeploymentTime, long timeout) throws InterruptedException {
        if (Thread.currentThread().isInterrupted()) {
            throw new InterruptedException("Interrupted on wait enter");
        }
        String mainName = moduleID.getModuleID();
        if (moduleID.getParentTargetModuleID() != null) {
            mainName = moduleID.getParentTargetModuleID().getModuleID();
        }
        int limit = (int)timeout / 1000;
        for (int i = 0; i < limit && !this.isApplicationReady(deployedFile, mainName, moduleID.getModuleID(), previousDeploymentTime, i == 0); ++i) {
            Thread.sleep(1000L);
        }
        return true;
    }

    private Long getDeploymentTime(final File fileToDeploy) {
        assert (fileToDeploy != null);
        try {
            this.dm.invokeRemoteAction(new JBRemoteAction<Long>(){

                @Override
                public Long action(MBeanServerConnection connection, JBoss5ProfileServiceProxy profileService) throws Exception {
                    Object info = connection.invoke(new ObjectName("jboss.system:service=MainDeployer"), "getDeployment", new Object[]{fileToDeploy.getCanonicalFile().toURL()}, new String[]{"java.net.URL"});
                    if (info == null) {
                        info = connection.invoke(new ObjectName("jboss.system:service=MainDeployer"), "getDeployment", new Object[]{fileToDeploy.toURL()}, new String[]{"java.net.URL"});
                    }
                    if (info == null) {
                        return Long.MIN_VALUE;
                    }
                    Class<?> infoClass = info.getClass();
                    return infoClass.getDeclaredField("lastDeployed").getLong(info);
                }
            });
        }
        catch (ExecutionException ex) {
            LOGGER.log(Level.FINE, null, ex);
        }
        return null;
    }

    private boolean isApplicationReady(final File deployedFile, final String mainName, final String warName, final Long previouslyDeployed, boolean initial) throws InterruptedException {
        assert (deployedFile != null);
        assert (warName != null);
        if (initial && previouslyDeployed == null) {
            Thread.sleep(2000L);
        }
        try {
            return this.dm.invokeRemoteAction(new JBRemoteAction<Boolean>(){

                @Override
                public Boolean action(MBeanServerConnection connection, JBoss5ProfileServiceProxy profileService) throws Exception {
                    try {
                        if (profileService != null) {
                            return profileService.isReady(mainName);
                        }
                    }
                    catch (Exception ex) {
                        LOGGER.log(Level.INFO, null, ex);
                    }
                    try {
                        Object info = connection.invoke(new ObjectName("jboss.system:service=MainDeployer"), "getDeployment", new Object[]{deployedFile.getCanonicalFile().toURL()}, new String[]{"java.net.URL"});
                        if (info == null) {
                            info = connection.invoke(new ObjectName("jboss.system:service=MainDeployer"), "getDeployment", new Object[]{deployedFile.toURL()}, new String[]{"java.net.URL"});
                        }
                        if (info != null) {
                            Class<?> infoClass = info.getClass();
                            long lastDeployed = infoClass.getDeclaredField("lastDeployed").getLong(info);
                            Object state = infoClass.getDeclaredField("state").get(info);
                            Object requiredState = state.getClass().getDeclaredField("STARTED").get(null);
                            return requiredState.equals(state) && (previouslyDeployed == null || previouslyDeployed != lastDeployed);
                        }
                    }
                    catch (Exception ex) {
                        LOGGER.log(Level.INFO, null, ex);
                    }
                    try {
                        ObjectName searchPattern = new ObjectName("jboss.web.deployment:war=" + warName + ",*");
                        return !connection.queryMBeans(searchPattern, null).isEmpty();
                    }
                    catch (Exception ex) {
                        LOGGER.log(Level.INFO, null, ex);
                        return false;
                    }
                }
            });
        }
        catch (ExecutionException ex) {
            LOGGER.log(Level.INFO, null, ex);
            return false;
        }
    }

    public void addProgressListener(ProgressListener pl) {
        this.listeners.add(pl);
    }

    public void removeProgressListener(ProgressListener pl) {
        this.listeners.remove(pl);
    }

    public void stop() throws OperationUnsupportedException {
        throw new OperationUnsupportedException("Stop is not supported");
    }

    public boolean isStopSupported() {
        return false;
    }

    public void cancel() throws OperationUnsupportedException {
        throw new OperationUnsupportedException("Cancel is not supported");
    }

    public boolean isCancelSupported() {
        return false;
    }

    public ClientConfiguration getClientConfiguration(TargetModuleID targetModuleID) {
        return null;
    }

    public TargetModuleID[] getResultTargetModuleIDs() {
        return new TargetModuleID[]{this.mainModuleID};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DeploymentStatus getDeploymentStatus() {
        JBDeployer jBDeployer = this;
        synchronized (jBDeployer) {
            return this.deploymentStatus;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireHandleProgressEvent(TargetModuleID targetModuleID, DeploymentStatus deploymentStatus) {
        ProgressEvent evt = new ProgressEvent((Object)this, targetModuleID, deploymentStatus);
        JBDeployer jBDeployer = this;
        synchronized (jBDeployer) {
            this.deploymentStatus = deploymentStatus;
        }
        for (ProgressListener listener : this.listeners) {
            listener.handleProgressEvent(evt);
        }
    }

    private static class ZipEntryInputStream
    extends InputStream {
        private final ZipInputStream zis;

        public ZipEntryInputStream(ZipInputStream zis) {
            this.zis = zis;
        }

        @Override
        public int available() throws IOException {
            return this.zis.available();
        }

        @Override
        public void close() throws IOException {
            this.zis.closeEntry();
        }

        @Override
        public int read() throws IOException {
            if (this.available() > 0) {
                return this.zis.read();
            }
            return -1;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return this.zis.read(b, off, len);
        }

        @Override
        public long skip(long n) throws IOException {
            return this.zis.skip(n);
        }
    }
}

