/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ddloaders.web;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.j2ee.dd.api.common.CommonDDBean;
import org.netbeans.modules.j2ee.dd.api.common.InitParam;
import org.netbeans.modules.j2ee.dd.api.common.RootInterface;
import org.netbeans.modules.j2ee.dd.api.web.DDProvider;
import org.netbeans.modules.j2ee.dd.api.web.ErrorPage;
import org.netbeans.modules.j2ee.dd.api.web.Filter;
import org.netbeans.modules.j2ee.dd.api.web.FilterMapping;
import org.netbeans.modules.j2ee.dd.api.web.Listener;
import org.netbeans.modules.j2ee.dd.api.web.Servlet;
import org.netbeans.modules.j2ee.dd.api.web.ServletMapping;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.j2ee.dd.impl.web.WebAppProxy;
import org.netbeans.modules.j2ee.dd.impl.web.WebParseUtils;
import org.netbeans.modules.j2ee.ddloaders.catalog.EnterpriseCatalog;
import org.netbeans.modules.j2ee.ddloaders.multiview.DDMultiViewDataObject;
import org.netbeans.modules.j2ee.ddloaders.web.DDChangesPanel;
import org.netbeans.modules.j2ee.ddloaders.web.DDDataLoader;
import org.netbeans.modules.j2ee.ddloaders.web.DDDataNode;
import org.netbeans.modules.j2ee.ddloaders.web.DDUtils;
import org.netbeans.modules.j2ee.ddloaders.web.event.DDChangeEvent;
import org.netbeans.modules.j2ee.ddloaders.web.event.DDChangeListener;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.xml.multiview.ToolBarMultiViewElement;
import org.netbeans.modules.xml.multiview.Utils;
import org.netbeans.modules.xml.multiview.XmlMultiViewDataObject;
import org.netbeans.modules.xml.multiview.XmlMultiViewElement;
import org.netbeans.spi.xml.cookies.CheckXMLSupport;
import org.netbeans.spi.xml.cookies.DataObjectAdapters;
import org.netbeans.spi.xml.cookies.ValidateXMLSupport;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataLoaderPool;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.MultiFileLoader;
import org.openide.loaders.OperationAdapter;
import org.openide.loaders.OperationEvent;
import org.openide.loaders.OperationListener;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class DDDataObject
extends DDMultiViewDataObject
implements DDChangeListener,
ChangeListener,
PropertyChangeListener {
    private transient WebApp webApp;
    private transient FileObject[] srcRoots;
    protected static final transient RequestProcessor RP = new RequestProcessor("XML Parsing");
    protected boolean changedFromUI;
    private static final long serialVersionUID = 8857563089355069362L;
    public static final String PROP_DOCUMENT_DTD = "documentDTD";
    public static final String HELP_ID_PREFIX_OVERVIEW = "dd_multiview_overview_";
    public static final String HELP_ID_PREFIX_ORDERING = "dd_multiview_ordering_";
    public static final String HELP_ID_PREFIX_SERVLETS = "dd_multiview_servlets_";
    public static final String HELP_ID_PREFIX_FILTERS = "dd_multiview_filters_";
    public static final String HELP_ID_PREFIX_PAGES = "dd_multiview_pages_";
    public static final String HELP_ID_PREFIX_REFERENCES = "dd_multiview_references_";
    public static final String HELP_ID_PREFIX_SECURITY = "dd_multiview_security_";
    private static final Logger LOG = Logger.getLogger(DDMultiViewDataObject.class.getName());
    private String documentDTD;
    private Vector updates;
    private static final RequestProcessor rp = new RequestProcessor();
    private transient RequestProcessor.Task updateTask;
    private transient RequestProcessor.Task refreshSourcesTask;
    private final String editorMimeType;
    private OperationListener operationListener = new OperationAdapter(){

        public void operationDelete(OperationEvent ev) {
            FileObject fo = ev.getObject().getPrimaryFile();
            String resourceName = DDDataObject.this.getPackageName(fo);
            if (resourceName != null && "java".equals(fo.getExt()) && DDDataObject.this.getWebApp() != null) {
                boolean foundElement = false;
                Servlet[] servlets = DDDataObject.this.getWebApp().getServlet();
                for (int i = 0; i < servlets.length; ++i) {
                    if (!resourceName.equals(servlets[i].getServletClass())) continue;
                    DDChangeEvent ddEvent = new DDChangeEvent(DDDataObject.this, DDDataObject.this, null, resourceName, 3);
                    DDDataObject.this.deploymentChange(ddEvent);
                    foundElement = true;
                    break;
                }
                if (foundElement) {
                    return;
                }
                Filter[] filters = DDDataObject.this.getWebApp().getFilter();
                for (int i = 0; i < filters.length; ++i) {
                    if (!resourceName.equals(filters[i].getFilterClass())) continue;
                    DDChangeEvent ddEvent = new DDChangeEvent(DDDataObject.this, DDDataObject.this, null, resourceName, 7);
                    DDDataObject.this.deploymentChange(ddEvent);
                    foundElement = true;
                    break;
                }
                if (foundElement) {
                    return;
                }
                Listener[] listeners = DDDataObject.this.getWebApp().getListener();
                for (int i = 0; i < listeners.length; ++i) {
                    if (!resourceName.equals(listeners[i].getListenerClass())) continue;
                    DDChangeEvent ddEvent = new DDChangeEvent(DDDataObject.this, DDDataObject.this, null, resourceName, 11);
                    DDDataObject.this.deploymentChange(ddEvent);
                    break;
                }
            }
        }
    };
    public static final String DD_MULTIVIEW_PREFIX = "dd_multiview";
    public static final String MULTIVIEW_OVERVIEW = "Overview";
    public static final String MULTIVIEW_SERVLETS = "Servlets";
    public static final String MULTIVIEW_FILTERS = "Filters";
    public static final String MULTIVIEW_PAGES = "Pages";
    public static final String MULTIVIEW_REFERENCES = "References";
    public static final String MULTIVIEW_SECURITY = "Security";

    public DDDataObject(FileObject pf, DDDataLoader loader, String editorMimeType) throws DataObjectExistsException {
        super(pf, (MultiFileLoader)loader);
        this.editorMimeType = editorMimeType;
        this.init(pf, loader);
    }

    protected String getEditorMimeType() {
        return this.editorMimeType;
    }

    protected int associateLookup() {
        return 1;
    }

    public static XmlMultiViewElement createXmlMultiViewElement(Lookup lookup) {
        return new XmlMultiViewElement((XmlMultiViewDataObject)lookup.lookup(XmlMultiViewDataObject.class));
    }

    private void init(FileObject fo, DDDataLoader loader) {
        Project project;
        InputSource in = DataObjectAdapters.inputSource((DataObject)this);
        CheckXMLSupport checkCookie = new CheckXMLSupport(in);
        this.getCookieSet().add((Node.Cookie)checkCookie);
        ValidateXMLSupport validateCookie = new ValidateXMLSupport(in);
        this.getCookieSet().add((Node.Cookie)validateCookie);
        if (!FileUtil.isArchiveFile((FileObject)this.getPrimaryFile()) && (project = FileOwnerQuery.getOwner((FileObject)this.getPrimaryFile())) != null) {
            Sources sources = ProjectUtils.getSources((Project)project);
            sources.addChangeListener((ChangeListener)this);
            this.refreshSourceFolders(sources);
        }
        this.addPropertyChangeListener(this);
    }

    private void refreshSourceFolders(Sources sources) {
        ArrayList<FileObject> srcRootList = new ArrayList<FileObject>();
        SourceGroup[] groups = sources.getSourceGroups("java");
        for (int i = 0; i < groups.length; ++i) {
            if (WebModule.getWebModule((FileObject)groups[i].getRootFolder()) == null) continue;
            srcRootList.add(groups[i].getRootFolder());
            DataLoaderPool.getDefault().removeOperationListener(this.operationListener);
            DataLoaderPool.getDefault().addOperationListener(this.operationListener);
        }
        this.srcRoots = srcRootList.toArray(new FileObject[srcRootList.size()]);
    }

    private String getPackageName(FileObject clazz) {
        for (int i = 0; i < this.srcRoots.length; ++i) {
            String rp = FileUtil.getRelativePath((FileObject)this.srcRoots[i], (FileObject)clazz);
            if (rp == null) continue;
            if (clazz.getExt().length() > 0) {
                rp = rp.substring(0, rp.length() - clazz.getExt().length() - 1);
            }
            return rp.replace('/', '.');
        }
        return null;
    }

    public WebApp getWebApp() {
        if (this.webApp == null) {
            try {
                this.webApp = this.createWebApp();
            }
            catch (IOException ex) {
                Logger.getLogger("global").log(Level.INFO, null, ex);
            }
        }
        return this.webApp;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("document_valid".equals(evt.getPropertyName()) && this.isValid()) {
            ((DDDataNode)this.getNodeDelegate()).iconChanged();
        }
    }

    private WebApp createWebApp() throws IOException {
        WebApp webApp = DDProvider.getDefault().getDDRoot(this.getPrimaryFile());
        if (webApp != null) {
            this.setSaxError(webApp.getError());
        }
        return webApp;
    }

    protected Node createNodeDelegate() {
        return new DDDataNode(this);
    }

    public void setReasonableMappings(ServletMapping[] mappings) {
        ArrayList<ServletMapping> newMappings = new ArrayList<ServletMapping>();
        Servlet[] servlets = this.webApp.getServlet();
        block0: for (int i = 0; i < mappings.length; ++i) {
            for (int j = 0; j < servlets.length; ++j) {
                if (!servlets[j].getServletName().equals(mappings[i].getServletName())) continue;
                newMappings.add(mappings[i]);
                continue block0;
            }
        }
        ServletMapping[] maps = new ServletMapping[newMappings.size()];
        newMappings.toArray(maps);
        this.webApp.setServletMapping(maps);
    }

    @Override
    protected void parseDocument() throws IOException {
        block3: {
            if (this.webApp == null || ((WebAppProxy)this.webApp).getOriginal() == null) {
                try {
                    this.webApp = DDProvider.getDefault().getDDRoot(this.getPrimaryFile());
                }
                catch (IOException e) {
                    if (this.webApp != null) break block3;
                    this.webApp = new WebAppProxy(null, null);
                }
            }
        }
        this.parseDocument(true);
    }

    @Override
    protected void validateDocument() throws IOException {
        this.parseDocument(false);
    }

    private void parseDocument(boolean updateWebApp) throws IOException {
        WebAppProxy webAppProxy = (WebAppProxy)this.webApp;
        try {
            SAXParseException error = WebParseUtils.parse((InputSource)new InputSource(this.createReader()), (EntityResolver)new EnterpriseCatalog());
            this.setSaxError(error);
            String version = WebParseUtils.getVersion((InputSource)new InputSource(this.createReader()));
            WebAppProxy app = new WebAppProxy(org.netbeans.modules.j2ee.dd.impl.common.DDUtils.createWebApp((InputStream)this.createInputStream(), (String)version), version);
            if (updateWebApp) {
                if (version.equals(webAppProxy.getVersion()) && webAppProxy.getOriginal() != null) {
                    this.webApp.merge((RootInterface)app, 3);
                } else if (app.getOriginal() != null) {
                    webAppProxy = app;
                    this.webApp = webAppProxy;
                }
            }
            webAppProxy.setStatus(error != null ? 1 : 0);
            webAppProxy.setError(error);
        }
        catch (SAXException ex) {
            webAppProxy.setStatus(2);
            if (ex instanceof SAXParseException) {
                webAppProxy.setError((SAXParseException)ex);
            } else if (ex.getException() instanceof SAXParseException) {
                webAppProxy.setError((SAXParseException)ex.getException());
            }
            this.setSaxError(ex);
        }
        catch (IllegalArgumentException iae) {
            webAppProxy.setStatus(2);
            LOG.log(Level.FINE, "IAE thrown during merge, see #104180.", iae);
        }
    }

    @Override
    protected RootInterface getDDModel() {
        return this.getWebApp();
    }

    @Override
    public boolean isDocumentParseable() {
        return 2 != this.getWebApp().getStatus();
    }

    protected String getPrefixMark() {
        return "<web-app";
    }

    private void createDefaultServletConfiguration(String clazz, String urlPattern) {
        WebApp wappTo = this.getWebApp();
        try {
            Servlet newSrvlt = (Servlet)this.webApp.createBean("Servlet");
            newSrvlt.setServletClass(clazz);
            String name = DDUtils.findFreeName((CommonDDBean[])wappTo.getServlet(), "ServletName", "Servlet_" + clazz);
            newSrvlt.setServletName(name);
            newSrvlt.setDescription(NbBundle.getMessage(DDDataObject.class, (String)"TXT_newServletElementDescription"));
            newSrvlt.setDisplayName("Servlet " + clazz);
            wappTo.addServlet(newSrvlt);
            ServletMapping newSM = (ServletMapping)this.webApp.createBean("ServletMapping");
            newSM.setServletName(name);
            newSM.setUrlPattern(urlPattern);
            wappTo.addServletMapping(newSM);
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger("DDDataObject").log(Level.FINE, "ignored exception", ex);
        }
    }

    protected DataObject handleCopy(DataFolder f) throws IOException {
        DataObject dObj = super.handleCopy(f);
        try {
            dObj.setValid(false);
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        return dObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void dispose() {
        DDDataObject dDDataObject = this;
        synchronized (dDDataObject) {
            this.updates = null;
            if (this.updateTask != null) {
                this.updateTask.cancel();
            }
        }
        super.dispose();
    }

    public String getDocumentDTD() {
        return this.documentDTD;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deploymentChange(DDChangeEvent evt) {
        if (evt.getType() == 1 && this.servletDefined(evt.getNewValue())) {
            return;
        }
        if (evt.getType() == 11 || evt.getType() == 7 || evt.getType() == 3) {
            return;
        }
        DDDataObject dDDataObject = this;
        synchronized (dDDataObject) {
            if (this.updates == null) {
                this.updates = new Vector();
            }
            this.updates.addElement(evt);
        }
        if (this.updateTask == null) {
            this.updateTask = rp.post(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Vector changes = null;
                    DDDataObject dDDataObject = DDDataObject.this;
                    synchronized (dDDataObject) {
                        if (!DDDataObject.this.isValid()) {
                            return;
                        }
                        if (DDDataObject.this.updates != null) {
                            changes = DDDataObject.this.updates;
                            DDDataObject.this.updates = null;
                        }
                    }
                    if (changes != null) {
                        DDDataObject.this.showDDChangesDialog(changes);
                    }
                }
            }, 2000, 1);
        } else {
            this.updateTask.schedule(2000);
        }
    }

    private boolean servletDefined(String classname) {
        WebApp webApp = this.getWebApp();
        if (webApp == null) {
            return true;
        }
        Servlet[] servlets = webApp.getServlet();
        for (int i = 0; i < servlets.length; ++i) {
            if (servlets[i].getServletClass() == null || !servlets[i].getServletClass().equals(classname)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showDDChangesDialog(List changes) {
        final Dialog[] confirmChangesDialog = new Dialog[]{null};
        final JButton processButton = new JButton(NbBundle.getMessage(DDDataObject.class, (String)"LAB_processButton"));
        processButton.setMnemonic(NbBundle.getMessage(DDDataObject.class, (String)"LAB_processButton_Mnemonic").charAt(0));
        processButton.setToolTipText(NbBundle.getMessage(DDDataObject.class, (String)"ACS_processButtonA11yDesc"));
        JButton processAllButton = new JButton(NbBundle.getMessage(DDDataObject.class, (String)"LAB_processAllButton"));
        processAllButton.setMnemonic(NbBundle.getMessage(DDDataObject.class, (String)"LAB_processAllButton_Mnemonic").charAt(0));
        processAllButton.setToolTipText(NbBundle.getMessage(DDDataObject.class, (String)"ACS_processAllButtonA11yDesc"));
        JButton closeButton = new JButton(NbBundle.getMessage(DDDataObject.class, (String)"LAB_closeButton"));
        closeButton.setMnemonic(NbBundle.getMessage(DDDataObject.class, (String)"LAB_closeButton_Mnemonic").charAt(0));
        closeButton.setToolTipText(NbBundle.getMessage(DDDataObject.class, (String)"ACS_closeButtonA11yDesc"));
        final Object[] options = new Object[]{processButton, processAllButton};
        final Object[] additionalOptions = new Object[]{closeButton};
        WebModule wm = WebModule.getWebModule((FileObject)this.getPrimaryFile());
        String fsname = "";
        if (wm != null) {
            fsname = wm.getContextPath();
        }
        String caption = NbBundle.getMessage(DDDataObject.class, (String)"MSG_SynchronizeCaption", (Object)fsname);
        final DDChangesPanel connectionPanel = new DDChangesPanel(caption, processButton);
        DialogDescriptor confirmChangesDescriptor = new DialogDescriptor((Object)connectionPanel, NbBundle.getMessage(DDDataObject.class, (String)"LAB_ConfirmDialog"), true, options, (Object)processButton, 1, HelpCtx.DEFAULT_HELP, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Component root;
                if (e.getSource() instanceof Component && !(root = SwingUtilities.getRoot((Component)e.getSource())).isDisplayable()) {
                    return;
                }
                if (options[0].equals(e.getSource())) {
                    int max;
                    int min = connectionPanel.changesList.getMinSelectionIndex();
                    for (int i = max = connectionPanel.changesList.getMaxSelectionIndex(); i >= min; --i) {
                        if (!connectionPanel.changesList.isSelectedIndex(i)) continue;
                        DDChangeEvent ev = (DDChangeEvent)connectionPanel.listModel.getElementAt(i);
                        DDDataObject.this.processDDChangeEvent(ev);
                        connectionPanel.listModel.removeElementAt(i);
                    }
                    if (connectionPanel.listModel.isEmpty()) {
                        confirmChangesDialog[0].setVisible(false);
                    } else {
                        processButton.setEnabled(false);
                    }
                } else if (options[1].equals(e.getSource())) {
                    Enumeration en = connectionPanel.listModel.elements();
                    while (en.hasMoreElements()) {
                        DDDataObject.this.processDDChangeEvent((DDChangeEvent)en.nextElement());
                    }
                    confirmChangesDialog[0].setVisible(false);
                    connectionPanel.setChanges(null);
                } else if (additionalOptions[0].equals(e.getSource())) {
                    confirmChangesDialog[0].setVisible(false);
                    connectionPanel.setChanges(null);
                }
            }
        });
        confirmChangesDescriptor.setAdditionalOptions(additionalOptions);
        processButton.setEnabled(false);
        processAllButton.requestFocus();
        connectionPanel.setChanges(changes);
        try {
            confirmChangesDialog[0] = DialogDisplayer.getDefault().createDialog(confirmChangesDescriptor);
            confirmChangesDialog[0].setVisible(true);
        }
        finally {
            confirmChangesDialog[0].dispose();
        }
    }

    private void processDDChangeEvent(DDChangeEvent evt) {
        String old;
        String clz;
        if (!this.isValid()) {
            return;
        }
        if (evt.getType() == 1) {
            clz = evt.getNewValue();
            String urimapping = "/servlet/" + clz;
            this.createDefaultServletConfiguration(clz, urimapping);
        } else if (evt.getType() == 2) {
            old = evt.getOldValue();
            if (old == null) {
                return;
            }
            Servlet[] servlets = this.getWebApp().getServlet();
            for (int i = 0; i < servlets.length; ++i) {
                if (!old.equals(servlets[i].getServletClass())) continue;
                servlets[i].setServletClass(evt.getNewValue());
            }
        } else if (evt.getType() == 3) {
            clz = evt.getNewValue();
            if (clz == null) {
                return;
            }
            WebApp wa = this.getWebApp();
            Servlet[] servlets = wa.getServlet();
            Vector<String> servletNames = new Vector<String>();
            for (int i = 0; i < servlets.length; ++i) {
                if (!clz.equals(servlets[i].getServletClass())) continue;
                servletNames.addElement(servlets[i].getServletName());
                wa.removeServlet(servlets[i]);
            }
            ServletMapping[] mappings = wa.getServletMapping();
            for (int i = 0; i < mappings.length; ++i) {
                if (!servletNames.contains(mappings[i].getServletName())) continue;
                wa.removeServletMapping(mappings[i]);
            }
        } else if (evt.getType() == 6) {
            old = evt.getOldValue();
            if (old == null) {
                return;
            }
            Filter[] filters = this.getWebApp().getFilter();
            for (int i = 0; i < filters.length; ++i) {
                if (!old.equals(filters[i].getFilterClass())) continue;
                filters[i].setFilterClass(evt.getNewValue());
            }
        } else if (evt.getType() == 7) {
            clz = evt.getNewValue();
            if (clz == null) {
                return;
            }
            WebApp wa = this.getWebApp();
            Filter[] filters = wa.getFilter();
            Vector<String> filterNames = new Vector<String>();
            for (int i = 0; i < filters.length; ++i) {
                if (!clz.equals(filters[i].getFilterClass())) continue;
                filterNames.addElement(filters[i].getFilterName());
                wa.removeFilter(filters[i]);
            }
            FilterMapping[] mappings = wa.getFilterMapping();
            for (int i = 0; i < mappings.length; ++i) {
                if (!filterNames.contains(mappings[i].getFilterName())) continue;
                wa.removeFilterMapping(mappings[i]);
            }
        } else if (evt.getType() == 10) {
            old = evt.getOldValue();
            if (old == null) {
                return;
            }
            Listener[] listeners = this.getWebApp().getListener();
            for (int i = 0; i < listeners.length; ++i) {
                if (!old.equals(listeners[i].getListenerClass())) continue;
                listeners[i].setListenerClass(evt.getNewValue());
            }
        } else if (evt.getType() == 11) {
            clz = evt.getNewValue();
            if (clz == null) {
                return;
            }
            WebApp wa = this.getWebApp();
            Listener[] listeners = wa.getListener();
            for (int i = 0; i < listeners.length; ++i) {
                if (!clz.equals(listeners[i].getListenerClass())) continue;
                wa.removeListener(listeners[i]);
                break;
            }
        }
        try {
            this.writeModel((RootInterface)this.getWebApp());
        }
        catch (IOException e) {
            Exceptions.printStackTrace((Throwable)e);
        }
    }

    @Override
    public void stateChanged(final ChangeEvent e) {
        if (this.refreshSourcesTask != null) {
            this.refreshSourcesTask.schedule(100);
            return;
        }
        this.refreshSourcesTask = rp.post(new Runnable(){

            @Override
            public void run() {
                DDDataObject.this.refreshSourceFolders((Sources)e.getSource());
            }
        }, 100);
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("dd_multiview_overview_overviewNode");
    }

    @Override
    protected boolean isModelCreated() {
        return this.webApp != null && ((WebAppProxy)this.webApp).getOriginal() != null;
    }

    public void showElement(Object element) {
        Object target = null;
        if (element instanceof Servlet) {
            this.openView(2);
            target = element;
        } else if (element instanceof Filter) {
            this.openView(3);
            target = element;
        } else if (element instanceof Listener) {
            this.openView(1);
            target = "listeners";
        } else if (element instanceof InitParam) {
            InitParam param = (InitParam)element;
            InitParam[] params = this.getWebApp().getContextParam();
            for (int i = 0; i < params.length; ++i) {
                if (params[i] != param) continue;
                this.openView(1);
                target = "context_params";
                break;
            }
        } else if (element instanceof ErrorPage) {
            this.openView(2);
            target = "error_pages";
        }
        if (target != null) {
            final Object key = target;
            Utils.runInAwtDispatchThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    ToolBarMultiViewElement mvEl = DDDataObject.this.getActiveMVElement();
                    if (mvEl != null) {
                        mvEl.getSectionView().openPanel(key);
                    }
                }
            });
        }
    }

    public boolean isDeleteAllowed() {
        String version = this.getWebApp().getVersion();
        if (version == null) {
            return true;
        }
        BigDecimal ver = new BigDecimal(version);
        return ver.compareTo(new BigDecimal("2.5")) >= 0;
    }

    public ToolBarMultiViewElement getActiveMVElement() {
        return (ToolBarMultiViewElement)super.getActiveMultiViewElement();
    }

    public boolean isChangedFromUI() {
        return this.changedFromUI;
    }

    public void setChangedFromUI(boolean changedFromUI) {
        this.changedFromUI = changedFromUI;
    }
}

