/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.editor.index;

import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.html.editor.api.gsf.HtmlParserResult;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.indexing.Context;
import org.netbeans.modules.parsing.spi.indexing.EmbeddingIndexer;
import org.netbeans.modules.parsing.spi.indexing.EmbeddingIndexerFactory;
import org.netbeans.modules.parsing.spi.indexing.Indexable;
import org.netbeans.modules.parsing.spi.indexing.support.IndexDocument;
import org.netbeans.modules.parsing.spi.indexing.support.IndexingSupport;
import org.netbeans.modules.web.jsf.editor.index.JsfPageModel;
import org.netbeans.modules.web.jsf.editor.index.JsfPageModelFactory;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class JsfIndexer
extends EmbeddingIndexer {
    public static final Logger LOG = Logger.getLogger(JsfIndexer.class.getName());

    protected void index(Indexable indexable, Parser.Result parserResult, Context context) {
        try {
            FileObject fo = parserResult.getSnapshot().getSource().getFileObject();
            LinkedList<IndexDocument> documents = new LinkedList<IndexDocument>();
            IndexingSupport support = IndexingSupport.getInstance((Context)context);
            Collection<JsfPageModel> models = JsfPageModelFactory.getModels((HtmlParserResult)parserResult);
            for (JsfPageModel model : models) {
                IndexDocument document = support.createDocument(indexable);
                model.storeToIndex(document);
                documents.add(document);
            }
            LOG.log(Level.FINE, "indexing {0}, found {1} document.", new Object[]{fo.getPath(), documents.size()});
            for (IndexDocument d : documents) {
                support.addDocument(d);
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public static class Factory
    extends EmbeddingIndexerFactory {
        static final String NAME = "jsf";
        static final int VERSION = 4;

        public EmbeddingIndexer createIndexer(Indexable indexable, Snapshot snapshot) {
            if (this.isIndexable(snapshot)) {
                return new JsfIndexer();
            }
            return null;
        }

        public boolean scanStarted(Context context) {
            try {
                LOG.log(Level.FINE, "scanning of {0} started", context.getRoot());
                return IndexingSupport.getInstance((Context)context).isValid();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return false;
            }
        }

        public void scanFinished(Context context) {
            super.scanFinished(context);
            LOG.log(Level.FINE, "scanning of {0} finished", context.getRoot());
        }

        public void filesDeleted(Iterable<? extends Indexable> deleted, Context context) {
        }

        public void filesDirty(Iterable<? extends Indexable> dirty, Context context) {
        }

        public String getIndexerName() {
            return NAME;
        }

        public int getIndexVersion() {
            return 4;
        }

        private boolean isIndexable(Snapshot snapshot) {
            FileObject fo = snapshot.getSource().getFileObject();
            String sourceFileMimeType = fo.getMIMEType();
            return "text/xhtml".equals(sourceFileMimeType);
        }
    }
}

