/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.editor.index;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.queries.SourceForBinaryQuery;
import org.netbeans.modules.parsing.spi.indexing.support.IndexResult;
import org.netbeans.modules.parsing.spi.indexing.support.QuerySupport;
import org.netbeans.modules.web.jsf.editor.index.CompositeComponentModel;
import org.netbeans.modules.web.jsf.editor.index.IndexedFile;
import org.netbeans.modules.web.jsf.editor.index.JsfPageModelFactory;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class JsfIndex {
    private final FileObject[] roots;
    private final FileObject[] binaryRoots;

    public static JsfIndex create(ClassPath sourceCp, ClassPath compileCp, ClassPath executeCp, ClassPath bootCp) {
        return new JsfIndex(sourceCp, compileCp, executeCp, bootCp);
    }

    private JsfIndex(ClassPath sourceCp, ClassPath compileCp, ClassPath executeCp, ClassPath bootCp) {
        HashSet<FileObject> cbRoots = new HashSet<FileObject>();
        cbRoots.addAll(Arrays.asList(compileCp.getRoots()));
        cbRoots.addAll(Arrays.asList(executeCp.getRoots()));
        this.binaryRoots = cbRoots.toArray(new FileObject[0]);
        HashSet<FileObject> croots = new HashSet<FileObject>();
        croots.addAll(Arrays.asList(sourceCp.getRoots()));
        for (ClassPath cp : new ClassPath[]{compileCp, bootCp}) {
            for (FileObject root : cp.getRoots()) {
                URL rootUrl = root.toURL();
                FileObject[] sourceRoots = SourceForBinaryQuery.findSourceRoots((URL)rootUrl).getRoots();
                if (sourceRoots.length == 0) {
                    croots.add(root);
                    continue;
                }
                croots.addAll(Arrays.asList(sourceRoots));
            }
        }
        this.roots = croots.toArray(new FileObject[0]);
    }

    private QuerySupport createEmbeddingIndex() throws IOException {
        return QuerySupport.forRoots((String)"jsf", (int)4, (FileObject[])this.roots);
    }

    private QuerySupport createBinaryIndex() throws IOException {
        return QuerySupport.forRoots((String)"jsfBinary", (int)9, (FileObject[])this.binaryRoots);
    }

    private QuerySupport createCustomIndex() throws IOException {
        return QuerySupport.forRoots((String)"jsfCustomIndexer", (int)4, (FileObject[])this.roots);
    }

    public Collection<String> getAllCompositeLibraryNames() {
        ArrayList<String> col = new ArrayList<String>();
        try {
            col.addAll(this.getAllCompositeLibraryNames(this.createBinaryIndex()));
            col.addAll(this.getAllCompositeLibraryNames(this.createCustomIndex()));
            col.addAll(this.getAllCompositeLibraryNames(this.createEmbeddingIndex()));
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return col;
    }

    private Collection<String> getAllCompositeLibraryNames(QuerySupport index) {
        ArrayList<String> libNames = new ArrayList<String>();
        try {
            Collection results = index.query("library", "", QuerySupport.Kind.PREFIX, new String[]{"library"});
            for (IndexResult result : results) {
                String libraryName = result.getValue("library");
                if (libraryName == null) continue;
                libNames.add(libraryName);
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return libNames;
    }

    public Collection<String> getCompositeLibraryComponents(String libraryName) {
        ArrayList<String> col = new ArrayList<String>();
        try {
            col.addAll(this.getCompositeLibraryComponents(this.createBinaryIndex(), libraryName));
            col.addAll(this.getCompositeLibraryComponents(this.createEmbeddingIndex(), libraryName));
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return col;
    }

    private Collection<String> getCompositeLibraryComponents(QuerySupport index, String libraryName) {
        ArrayList<String> components = new ArrayList<String>();
        try {
            Collection results = index.query("library", libraryName, QuerySupport.Kind.EXACT, new String[]{"library"});
            for (IndexResult result : results) {
                FileObject file = result.getFile();
                if (file == null) continue;
                components.add(file.getName());
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return components;
    }

    public CompositeComponentModel getCompositeComponentModel(String libraryName, String componentName) {
        try {
            CompositeComponentModel model = this.getCompositeComponentModel(this.createEmbeddingIndex(), libraryName, componentName);
            return model != null ? model : this.getCompositeComponentModel(this.createBinaryIndex(), libraryName, componentName);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    public Map<FileObject, CompositeComponentModel> getCompositeComponentModels(String libraryName) {
        HashMap<FileObject, CompositeComponentModel> models = new HashMap<FileObject, CompositeComponentModel>();
        try {
            models.putAll(this.getCompositeComponentModels(this.createEmbeddingIndex(), libraryName));
            models.putAll(this.getCompositeComponentModels(this.createBinaryIndex(), libraryName));
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return models;
    }

    private Map<FileObject, CompositeComponentModel> getCompositeComponentModels(QuerySupport index, String libraryName) {
        HashMap<FileObject, CompositeComponentModel> modelsMap = new HashMap<FileObject, CompositeComponentModel>();
        try {
            Collection results = index.query("library", libraryName, QuerySupport.Kind.EXACT, new String[]{"library", "interface_attributes", "has_implementation", "interface_facets", "interface_description"});
            for (IndexResult result : results) {
                FileObject file = result.getFile();
                if (file == null) continue;
                CompositeComponentModel model = (CompositeComponentModel)JsfPageModelFactory.getFactory(CompositeComponentModel.Factory.class).loadFromIndex(result);
                modelsMap.put(file, model);
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return modelsMap;
    }

    private CompositeComponentModel getCompositeComponentModel(QuerySupport index, String libraryName, String componentName) {
        try {
            Collection results = index.query("library", libraryName, QuerySupport.Kind.EXACT, new String[]{"library", "interface_attributes", "has_implementation", "interface_facets", "interface_description"});
            for (IndexResult result : results) {
                String fileName;
                FileObject file = result.getFile();
                if (file == null || !(fileName = file.getName()).equals(componentName)) continue;
                return (CompositeComponentModel)JsfPageModelFactory.getFactory(CompositeComponentModel.Factory.class).loadFromIndex(result);
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return null;
    }

    public Collection<IndexedFile> getAllFaceletsLibraryDescriptors() {
        ArrayList<IndexedFile> files = new ArrayList<IndexedFile>();
        try {
            this.queryFaceletsLibraryDescriptors(this.createBinaryIndex(), files);
            this.queryFaceletsLibraryDescriptors(this.createCustomIndex(), files);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return files;
    }

    private void queryFaceletsLibraryDescriptors(QuerySupport index, Collection<IndexedFile> files) throws IOException {
        Collection results = index.query("faceletsLibraryDescriptor", "true", QuerySupport.Kind.EXACT, new String[]{"faceletsLibraryDescriptor", "timestamp"});
        this.convertToFiles(results, files);
    }

    public IndexedFile getTagLibraryDescriptor(String namespace) {
        try {
            IndexedFile file = this.findTLD(this.createCustomIndex(), namespace);
            return file != null ? file : this.findTLD(this.createBinaryIndex(), namespace);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    private IndexedFile findTLD(QuerySupport index, String namespace) throws IOException {
        Collection results = index.query("namespace", namespace, QuerySupport.Kind.EXACT, new String[]{"tagLibraryDescriptor", "timestamp"});
        for (IndexResult result : results) {
            FileObject file;
            if (result.getValue("tagLibraryDescriptor") == null || (file = result.getFile()) == null) continue;
            long timestamp = Long.parseLong(result.getValue("timestamp"));
            return new IndexedFile(timestamp, file);
        }
        return null;
    }

    private void convertToFiles(Collection<? extends IndexResult> results, Collection<IndexedFile> files) {
        for (IndexResult indexResult : results) {
            FileObject file = indexResult.getFile();
            if (file == null) continue;
            long timestamp = Long.parseLong(indexResult.getValue("timestamp"));
            files.add(new IndexedFile(timestamp, file));
        }
    }
}

