/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.editor.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.html.editor.api.gsf.HtmlParserResult;
import org.netbeans.modules.parsing.api.Embedding;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.indexing.ConstrainedBinaryIndexer;
import org.netbeans.modules.parsing.spi.indexing.Context;
import org.netbeans.modules.parsing.spi.indexing.support.IndexDocument;
import org.netbeans.modules.parsing.spi.indexing.support.IndexingSupport;
import org.netbeans.modules.web.jsf.editor.facelets.FaceletsLibraryDescriptor;
import org.netbeans.modules.web.jsf.editor.index.CompositeComponentModel;
import org.netbeans.modules.web.jsf.editor.index.JsfIndexSupport;
import org.netbeans.modules.web.jsf.editor.index.JsfPageModelFactory;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class JsfBinaryIndexer
extends ConstrainedBinaryIndexer {
    private static final Logger LOGGER = Logger.getLogger(JsfBinaryIndexer.class.getSimpleName());
    private static final String CONTENT_UNKNOWN = "content/unknown";
    static final int INDEXER_VERSION = 9;
    static final String INDEXER_NAME = "jsfBinary";

    protected void index(Map<String, ? extends Iterable<? extends FileObject>> files, Context context) {
        LOGGER.log(Level.FINE, "indexing {0}", context.getRoot());
        if (context.getRoot() == null) {
            return;
        }
        this.processTlds(files.get(CONTENT_UNKNOWN), context);
        this.processFaceletsLibraryDescriptors(files.get(CONTENT_UNKNOWN), context);
        this.processFaceletsCompositeLibraries(files.get(CONTENT_UNKNOWN), context);
    }

    private void processTlds(Iterable<? extends FileObject> files, Context context) {
        if (files == null) {
            return;
        }
        for (FileObject file : JsfBinaryIndexer.findLibraryDescriptors(files, ".tld")) {
            try {
                String namespace = FaceletsLibraryDescriptor.parseNamespace(file.getInputStream(), "taglib", "uri");
                if (namespace == null) continue;
                JsfIndexSupport.indexTagLibraryDescriptor(context, file, namespace);
                LOGGER.log(Level.FINE, "The file {0} indexed as a TLD (namespace={1})", new Object[]{file, namespace});
            }
            catch (IOException ex) {
                LOGGER.info(String.format("Error parsing %s file: %s", file.getPath(), ex.getMessage()));
            }
        }
    }

    private void processFaceletsLibraryDescriptors(Iterable<? extends FileObject> files, Context context) {
        if (files == null) {
            return;
        }
        for (FileObject file : JsfBinaryIndexer.findLibraryDescriptors(files, ".taglib.xml")) {
            if (!file.getNameExt().endsWith(".taglib.xml")) continue;
            try {
                String namespace = FaceletsLibraryDescriptor.parseNamespace(file.getInputStream());
                if (namespace == null) continue;
                JsfIndexSupport.indexFaceletsLibraryDescriptor(context, file, namespace);
                LOGGER.log(Level.FINE, "The file {0} indexed as a Facelets Library Descriptor", file);
            }
            catch (IOException ex) {
                LOGGER.info(String.format("Error parsing %s file: %s", file.getPath(), ex.getMessage()));
            }
        }
    }

    private void processFaceletsCompositeLibraries(Iterable<? extends FileObject> files, Context context) {
        if (files == null) {
            return;
        }
        try {
            final JsfPageModelFactory compositeComponentModelFactory = JsfPageModelFactory.getFactory(CompositeComponentModel.Factory.class);
            final IndexingSupport sup = IndexingSupport.getInstance((Context)context);
            for (final FileObject fileObject : files) {
                if (!CompositeComponentModel.isCompositeLibraryMember(fileObject)) continue;
                Source source = Source.create((FileObject)fileObject);
                try {
                    ParserManager.parse(Collections.singleton(source), (UserTask)new UserTask(){

                        public void run(ResultIterator resultIterator) throws Exception {
                            for (Embedding e : resultIterator.getEmbeddings()) {
                                HtmlParserResult result;
                                CompositeComponentModel ccmodel;
                                if (!e.getMimeType().equals("text/html") || (ccmodel = (CompositeComponentModel)compositeComponentModelFactory.getModel(result = (HtmlParserResult)resultIterator.getResultIterator(e).getParserResult())) == null) continue;
                                IndexDocument doc = sup.createDocument(fileObject);
                                ccmodel.storeToIndex(doc);
                                sup.addDocument(doc);
                                LOGGER.log(Level.FINE, "Composite Libraries Scan: Model created for file {0}", fileObject);
                            }
                        }
                    });
                }
                catch (ParseException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public static Collection<FileObject> findLibraryDescriptors(Iterable<? extends FileObject> fos, String suffix) {
        ArrayList<FileObject> files = new ArrayList<FileObject>();
        for (FileObject fileObject : fos) {
            if (!fileObject.getNameExt().toLowerCase(Locale.US).endsWith(suffix)) continue;
            files.add(fileObject);
        }
        return files;
    }
}

