/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.editor.hints;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.lib.editor.util.CharSequenceUtilities;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintFix;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.Rule;
import org.netbeans.modules.csl.api.RuleContext;
import org.netbeans.modules.el.lexer.api.ELTokenId;
import org.netbeans.modules.html.editor.api.gsf.HtmlParserResult;
import org.netbeans.modules.html.editor.lib.api.elements.Attribute;
import org.netbeans.modules.html.editor.lib.api.elements.AttributeFilter;
import org.netbeans.modules.html.editor.lib.api.elements.CloseTag;
import org.netbeans.modules.html.editor.lib.api.elements.Element;
import org.netbeans.modules.html.editor.lib.api.elements.ElementType;
import org.netbeans.modules.html.editor.lib.api.elements.ElementUtils;
import org.netbeans.modules.html.editor.lib.api.elements.ElementVisitor;
import org.netbeans.modules.html.editor.lib.api.elements.Node;
import org.netbeans.modules.html.editor.lib.api.elements.OpenTag;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.web.common.api.LexerUtils;
import org.netbeans.modules.web.jsf.editor.JsfSupportImpl;
import org.netbeans.modules.web.jsf.editor.JsfUtils;
import org.netbeans.modules.web.jsf.editor.facelets.AbstractFaceletsLibrary;
import org.netbeans.modules.web.jsf.editor.hints.FixLibDeclaration;
import org.netbeans.modules.web.jsf.editor.hints.HintsProvider;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class LibraryDeclarationChecker
extends HintsProvider {
    @Override
    public List<Hint> compute(RuleContext context) {
        ArrayList<Hint> hints = new ArrayList<Hint>();
        this.checkLibraryDeclarations(hints, context);
        return hints;
    }

    private void checkLibraryDeclarations(final List<Hint> hints, final RuleContext context) {
        Hint hint;
        HtmlParserResult result = (HtmlParserResult)context.parserResult;
        final Snapshot snapshot = result.getSnapshot();
        Set declaredNamespaces = result.getNamespaces().keySet();
        ArrayList<AbstractFaceletsLibrary> declaredLibraries = new ArrayList<AbstractFaceletsLibrary>();
        JsfSupportImpl jsfSupport = JsfSupportImpl.findFor(context.parserResult.getSnapshot().getSource());
        Map<Object, Object> libs = Collections.emptyMap();
        if (jsfSupport != null) {
            libs = jsfSupport.getLibraries();
        }
        final HashMap namespace2Attribute = new HashMap();
        Node root = result.root();
        final CharSequence docText = this.getSourceText(snapshot.getSource());
        ElementVisitor namespacesCollector = new ElementVisitor(){

            public void visit(Element node) {
                OpenTag openTag = (OpenTag)node;
                Collection nsAttrs = openTag.attributes(new AttributeFilter(){

                    public boolean accepts(Attribute attribute) {
                        if (attribute.unquotedValue() == null) {
                            return false;
                        }
                        CharSequence nsPrefix = attribute.namespacePrefix();
                        if (nsPrefix == null) {
                            return false;
                        }
                        return LexerUtils.equals((CharSequence)"xmlns", (CharSequence)nsPrefix, (boolean)true, (boolean)true);
                    }
                });
                for (Attribute attr : nsAttrs) {
                    namespace2Attribute.put(((Object)attr.unquotedValue()).toString(), attr);
                }
            }
        };
        ElementUtils.visitChildren((Element)root, (ElementVisitor)namespacesCollector, (ElementType)ElementType.OPEN_TAG);
        Node undeclaredComponentsTreeRoot = result.rootOfUndeclaredTagsParseTree();
        if (undeclaredComponentsTreeRoot != null) {
            ElementUtils.visitChildren((Element)undeclaredComponentsTreeRoot, (ElementVisitor)namespacesCollector, (ElementType)ElementType.OPEN_TAG);
            ElementUtils.visitChildren((Element)undeclaredComponentsTreeRoot, (ElementVisitor)new ElementVisitor(){

                public void visit(Element node) {
                    OpenTag openTag = (OpenTag)node;
                    String namespacePrefix = ((Object)openTag.namespacePrefix()).toString();
                    if (namespacePrefix != null) {
                        ArrayList<FixLibDeclaration> fixes = new ArrayList<FixLibDeclaration>();
                        List libs = LibraryDeclarationChecker.getLibsByPrefix(context, namespacePrefix);
                        for (AbstractFaceletsLibrary lib : libs) {
                            FixLibDeclaration fix = new FixLibDeclaration((Document)context.doc, namespacePrefix, lib);
                            fixes.add(fix);
                        }
                        hints.add(new Hint((Rule)HintsProvider.ERROR_RULE_BADGING, NbBundle.getMessage(HintsProvider.class, (String)"MSG_UNDECLARED_COMPONENT", (Object)((Object)openTag.name()).toString()), context.parserResult.getSnapshot().getSource().getFileObject(), JsfUtils.createOffsetRange(snapshot, docText, node.from(), node.from() + openTag.name().length() + 1), fixes, 50));
                        CloseTag matchingCloseTag = openTag.matchingCloseTag();
                        if (matchingCloseTag != null) {
                            hints.add(new Hint((Rule)HintsProvider.ERROR_RULE_BADGING, NbBundle.getMessage(HintsProvider.class, (String)"MSG_UNDECLARED_COMPONENT", (Object)((Object)openTag.name()).toString()), context.parserResult.getSnapshot().getSource().getFileObject(), JsfUtils.createOffsetRange(snapshot, docText, matchingCloseTag.from(), matchingCloseTag.to()), fixes, 50));
                        }
                    }
                }
            }, (ElementType)ElementType.OPEN_TAG);
        }
        for (String namespace : declaredNamespaces) {
            AbstractFaceletsLibrary lib = (AbstractFaceletsLibrary)libs.get(namespace);
            if (lib != null) {
                declaredLibraries.add(lib);
                continue;
            }
            Attribute attr = (Attribute)namespace2Attribute.get(namespace);
            if (attr == null) continue;
            hint = new Hint((Rule)ERROR_RULE_BADGING, NbBundle.getMessage(HintsProvider.class, (String)"MSG_MISSING_LIBRARY", (Object)namespace), context.parserResult.getSnapshot().getSource().getFileObject(), JsfUtils.createOffsetRange(snapshot, docText, attr.nameOffset(), attr.valueOffset() + attr.value().length()), Collections.emptyList(), 50);
            hints.add(hint);
        }
        ArrayList<OffsetRange> ranges = new ArrayList<OffsetRange>();
        for (AbstractFaceletsLibrary lib : declaredLibraries) {
            Attribute declAttr;
            Node rootNode = result.root(lib.getNamespace());
            if (rootNode == null) continue;
            final int[] usages = new int[1];
            ElementUtils.visitChildren((Element)rootNode, (ElementVisitor)new ElementVisitor(){

                public void visit(Element node) {
                    usages[0] = usages[0] + 1;
                }
            }, (ElementType)ElementType.OPEN_TAG);
            usages[0] = usages[0] + (this.isFunctionLibraryPrefixUsedInEL(context, lib, docText) ? 1 : 0);
            if (usages[0] != 0 || (declAttr = (Attribute)namespace2Attribute.get(lib.getNamespace())) == null) continue;
            int from = declAttr.nameOffset();
            int to = declAttr.valueOffset() + declAttr.value().length();
            OffsetRange documentRange = JsfUtils.createOffsetRange(snapshot, docText, from, to);
            ranges.add(documentRange);
        }
        for (OffsetRange range : ranges) {
            List fixes;
            try {
                fixes = context.doc != null ? Arrays.asList(new RemoveUnusedLibraryDeclarationHintFix(context.doc, LibraryDeclarationChecker.createPositionRange(context, range)), new RemoveUnusedLibrariesDeclarationHintFix(context.doc, LibraryDeclarationChecker.createPositionRanges(context, ranges))) : Collections.emptyList();
            }
            catch (BadLocationException ex) {
                fixes = Collections.emptyList();
            }
            hint = new Hint((Rule)DEFAULT_WARNING_RULE, NbBundle.getMessage(HintsProvider.class, (String)"MSG_UNUSED_LIBRARY_DECLARATION", (Object)docText.subSequence(range.getStart(), range.getEnd())), context.parserResult.getSnapshot().getSource().getFileObject(), range, fixes, 50);
            hints.add(hint);
        }
    }

    private static PositionRange createPositionRange(RuleContext context, OffsetRange offsetRange) throws BadLocationException {
        return new PositionRange(context, offsetRange.getStart(), offsetRange.getEnd());
    }

    private static Collection<PositionRange> createPositionRanges(RuleContext context, Collection<OffsetRange> offsetRanges) throws BadLocationException {
        ArrayList<PositionRange> ranges = new ArrayList<PositionRange>();
        for (OffsetRange offsetRange : offsetRanges) {
            ranges.add(LibraryDeclarationChecker.createPositionRange(context, offsetRange));
        }
        return ranges;
    }

    private static List<AbstractFaceletsLibrary> getLibsByPrefix(RuleContext context, String prefix) {
        ArrayList<AbstractFaceletsLibrary> libs = new ArrayList<AbstractFaceletsLibrary>();
        JsfSupportImpl sup = JsfSupportImpl.findFor(context.parserResult.getSnapshot().getSource());
        if (sup != null) {
            for (AbstractFaceletsLibrary lib : new HashSet<AbstractFaceletsLibrary>(sup.getLibraries().values())) {
                if (!prefix.equals(lib.getDefaultPrefix())) continue;
                libs.add(lib);
            }
        }
        return libs;
    }

    private boolean isFunctionLibraryPrefixUsedInEL(RuleContext context, AbstractFaceletsLibrary lib, CharSequence sourceText) {
        String libraryPrefix = (String)((HtmlParserResult)context.parserResult).getNamespaces().get(lib.getNamespace());
        TokenHierarchy th = TokenHierarchy.create((CharSequence)sourceText, (Language)Language.find((String)"text/xhtml"));
        TokenSequence ts = th.tokenSequence();
        ts.moveStart();
        while (ts.moveNext()) {
            TokenSequence elts = ts.embeddedJoined(ELTokenId.language());
            if (elts == null) continue;
            elts.moveStart();
            while (elts.moveNext()) {
                if (elts.token().id() != ELTokenId.TAG_LIB_PREFIX || !CharSequenceUtilities.equals((CharSequence)libraryPrefix, (Object)elts.token().text())) continue;
                return true;
            }
        }
        return false;
    }

    private static final class PositionRange {
        private Position from;
        private Position to;

        public PositionRange(RuleContext context, int from, int to) throws BadLocationException {
            this.from = context.doc.createPosition(from);
            this.to = context.doc.createPosition(to);
        }

        public int getFrom() {
            return this.from.getOffset();
        }

        public int getTo() {
            return this.to.getOffset();
        }
    }

    private static class RemoveUnusedLibrariesDeclarationHintFix
    implements HintFix {
        protected Collection<PositionRange> ranges = new ArrayList<PositionRange>();
        protected BaseDocument document;

        public RemoveUnusedLibrariesDeclarationHintFix(BaseDocument document, Collection<PositionRange> ranges) {
            this.document = document;
            this.ranges = ranges;
        }

        public String getDescription() {
            return NbBundle.getMessage(HintsProvider.class, (String)"MSG_HINTFIX_REMOVE_ALL_UNUSED_LIBRARIES_DECLARATION");
        }

        public void implement() throws Exception {
            this.document.runAtomic(new Runnable(){

                @Override
                public void run() {
                    try {
                        for (PositionRange range : RemoveUnusedLibrariesDeclarationHintFix.this.ranges) {
                            int firstNonWhite;
                            int from = range.getFrom();
                            int to = range.getTo();
                            int lineBeginning = Utilities.getRowStart((BaseDocument)RemoveUnusedLibrariesDeclarationHintFix.this.document, (int)from);
                            if (lineBeginning > (firstNonWhite = Utilities.getFirstNonWhiteBwd((BaseDocument)RemoveUnusedLibrariesDeclarationHintFix.this.document, (int)from))) {
                                from = lineBeginning - 1;
                            }
                            RemoveUnusedLibrariesDeclarationHintFix.this.document.remove(from, to - from);
                        }
                    }
                    catch (BadLocationException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            });
        }

        public boolean isSafe() {
            return true;
        }

        public boolean isInteractive() {
            return false;
        }
    }

    private static class RemoveUnusedLibraryDeclarationHintFix
    extends RemoveUnusedLibrariesDeclarationHintFix {
        public RemoveUnusedLibraryDeclarationHintFix(BaseDocument document, PositionRange range) {
            super(document, Collections.singletonList(range));
        }

        @Override
        public String getDescription() {
            return NbBundle.getMessage(HintsProvider.class, (String)"MSG_HINTFIX_REMOVE_UNUSED_LIBRARY_DECLARATION");
        }
    }
}

