/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.editor.facelets.mojarra;

import com.sun.faces.config.DocumentInfo;
import com.sun.faces.config.processor.AbstractConfigProcessor;
import com.sun.faces.facelets.util.ReflectionUtil;
import com.sun.faces.util.FacesLogger;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.servlet.ServletContext;
import org.netbeans.modules.web.jsf.editor.facelets.CompositeComponentLibrary;
import org.netbeans.modules.web.jsf.editor.facelets.FaceletsLibrary;
import org.netbeans.modules.web.jsf.editor.facelets.FaceletsLibrarySupport;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FaceletsTaglibConfigProcessor
extends AbstractConfigProcessor {
    private static final Logger LOGGER = FacesLogger.CONFIG.getLogger();
    private static final String LIBRARY_CLASS = "library-class";
    private static final String TAGLIB_NAMESPACE = "namespace";
    private static final String TAG = "tag";
    private static final String FUNCTION = "function";
    private static final String TAG_NAME = "tag-name";
    private static final String COMPONENT = "component";
    private static final String VALIDATOR = "validator";
    private static final String CONVERTER = "converter";
    private static final String BEHAVIOR = "behavior";
    private static final String SOURCE = "source";
    private static final String HANDLER_CLASS = "handler-class";
    private static final String VALIDATOR_ID = "validator-id";
    private static final String CONVERTER_ID = "converter-id";
    private static final String BEHAVIOR_ID = "behavior-id";
    private static final String COMPONENT_TYPE = "component-type";
    private static final String RENDERER_TYPE = "renderer-type";
    private static final String FUNCTION_NAME = "function-name";
    private static final String FUNCTION_CLASS = "function-class";
    private static final String FUNCTION_SIGNATURE = "function-signature";
    private static final String COMPOSITE_LIBRARY_NAME = "composite-library-name";
    private static final String ATTRIBUTE_NAME = "attribute";
    public FaceletsLibrarySupport.Compiler compiler = new FaceletsLibrarySupport.Compiler();
    private FaceletsLibrarySupport support;

    public FaceletsTaglibConfigProcessor(FaceletsLibrarySupport support) {
        this.support = support;
    }

    protected Class<?> loadClass(String className, Object fallback, Class<?> expectedType) {
        try {
            return super.loadClass(className, fallback, expectedType);
        }
        catch (ClassNotFoundException ignore) {
        }
        catch (NoClassDefFoundError ignore) {
            // empty catch block
        }
        return null;
    }

    public void process(ServletContext context, DocumentInfo[] documents) {
        int length = documents.length;
        for (int i = 0; i < length; ++i) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, MessageFormat.format("Processing facelet-taglibrary document: ''{0}''", documents[i].getDocument().getDocumentURI()));
            }
            String namespace = documents[i].getDocument().getDocumentElement().getNamespaceURI();
            Element documentElement = documents[i].getDocument().getDocumentElement();
            NodeList libraryClass = documentElement.getElementsByTagNameNS(namespace, LIBRARY_CLASS);
            if (libraryClass != null && libraryClass.getLength() > 0) {
                this.processTaglibraryClass(libraryClass, this.compiler);
                continue;
            }
            this.processTagLibrary(documents[i], documentElement, namespace, this.compiler);
        }
    }

    private void processTaglibraryClass(NodeList libraryClass, FaceletsLibrarySupport.Compiler compiler) {
    }

    private void processTagLibrary(DocumentInfo info, Element documentElement, String namespace, FaceletsLibrarySupport.Compiler compiler) {
        NodeList children = documentElement.getChildNodes();
        if (children != null && children.getLength() > 0) {
            URL sourceUrl;
            String taglibNamespace = null;
            String compositeLibraryName = null;
            int ilen = children.getLength();
            for (int i = 0; i < ilen; ++i) {
                Node n = children.item(i);
                if (TAGLIB_NAMESPACE.equals(n.getLocalName())) {
                    taglibNamespace = this.getNodeText(n);
                    continue;
                }
                if (!COMPOSITE_LIBRARY_NAME.equals(n.getLocalName())) continue;
                compositeLibraryName = this.getNodeText(n);
            }
            try {
                sourceUrl = info.getSourceURI().toURL();
            }
            catch (MalformedURLException ex) {
                LOGGER.log(Level.INFO, null, ex);
                return;
            }
            NodeList tags = documentElement.getElementsByTagNameNS(namespace, TAG);
            FaceletsLibrary taglibrary = compositeLibraryName != null ? new CompositeComponentLibrary(this.support, compositeLibraryName, taglibNamespace, sourceUrl) : new FaceletsLibrary(this.support, taglibNamespace, sourceUrl);
            this.processTags(documentElement, tags, taglibrary);
            compiler.addTagLibrary(taglibrary);
        }
    }

    private void processTags(Element documentElement, NodeList tags, FaceletsLibrary taglibrary) {
        if (tags != null && tags.getLength() > 0) {
            int ilen = tags.getLength();
            for (int i = 0; i < ilen; ++i) {
                Node tagNode = tags.item(i);
                NodeList children = tagNode.getChildNodes();
                String tagName = null;
                NodeList component = null;
                NodeList converter = null;
                NodeList validator = null;
                NodeList behavior = null;
                Node source = null;
                Node handlerClass = null;
                int jlen = children.getLength();
                for (int j = 0; j < jlen; ++j) {
                    Node n = children.item(j);
                    if (TAG_NAME.equals(n.getLocalName())) {
                        tagName = this.getNodeText(n);
                        continue;
                    }
                    if (COMPONENT.equals(n.getLocalName())) {
                        component = n.getChildNodes();
                        continue;
                    }
                    if (CONVERTER.equals(n.getLocalName())) {
                        converter = n.getChildNodes();
                        continue;
                    }
                    if (VALIDATOR.equals(n.getLocalName())) {
                        validator = n.getChildNodes();
                        continue;
                    }
                    if (BEHAVIOR.equals(n.getLocalName())) {
                        behavior = n.getChildNodes();
                        continue;
                    }
                    if (SOURCE.equals(n.getLocalName())) {
                        source = n;
                        continue;
                    }
                    if (!HANDLER_CLASS.equals(n.getLocalName())) continue;
                    handlerClass = n;
                }
                if (component != null) {
                    this.processComponent(component, taglibrary, tagName);
                    continue;
                }
                if (converter != null) {
                    this.processConverter(converter, taglibrary, tagName);
                    continue;
                }
                if (validator != null) {
                    this.processValidator(validator, taglibrary, tagName);
                    continue;
                }
                if (behavior != null) {
                    this.processBehavior(behavior, taglibrary, tagName);
                    continue;
                }
                if (source != null) {
                    this.processSource(documentElement, source, taglibrary, tagName);
                    continue;
                }
                if (handlerClass == null) continue;
                this.processHandlerClass(handlerClass, taglibrary, tagName);
            }
        }
    }

    private void processBehavior(NodeList behavior, FaceletsLibrary taglibrary, String tagName) {
        if (behavior != null && behavior.getLength() > 0) {
            String behaviorId = null;
            String handlerClass = null;
            int ilen = behavior.getLength();
            for (int i = 0; i < ilen; ++i) {
                Node n = behavior.item(i);
                if (BEHAVIOR_ID.equals(n.getLocalName())) {
                    behaviorId = this.getNodeText(n);
                    continue;
                }
                if (!HANDLER_CLASS.equals(n.getLocalName())) continue;
                handlerClass = this.getNodeText(n);
            }
            if (handlerClass != null) {
                Class<?> clazz = this.loadClass(handlerClass, (Object)this, null);
                taglibrary.putBehavior(tagName, behaviorId, clazz);
            } else {
                taglibrary.putBehavior(tagName, behaviorId);
            }
        }
    }

    private void processHandlerClass(Node handlerClass, FaceletsLibrary taglibrary, String name) {
        String className = this.getNodeText(handlerClass);
        if (className == null) {
            return;
        }
        Class<?> clazz = this.loadClass(className, (Object)this, null);
        taglibrary.putTagHandler(name, clazz);
    }

    private void processSource(Element documentElement, Node source, FaceletsLibrary taglibrary, String name) {
        String docURI = documentElement.getOwnerDocument().getDocumentURI();
        String s = this.getNodeText(source);
        if (s == null) {
            return;
        }
        try {
            URL url = new URL(new URL(docURI), s);
            taglibrary.putUserTag(name, url);
        }
        catch (MalformedURLException e) {
            throw new FacesException((Throwable)e);
        }
    }

    private void processValidator(NodeList validator, FaceletsLibrary taglibrary, String name) {
        if (validator != null && validator.getLength() > 0) {
            String validatorId = null;
            String handlerClass = null;
            int ilen = validator.getLength();
            for (int i = 0; i < ilen; ++i) {
                Node n = validator.item(i);
                if (VALIDATOR_ID.equals(n.getLocalName())) {
                    validatorId = this.getNodeText(n);
                    continue;
                }
                if (!HANDLER_CLASS.equals(n.getLocalName())) continue;
                handlerClass = this.getNodeText(n);
            }
            if (handlerClass != null) {
                Class<?> clazz = this.loadClass(handlerClass, (Object)this, null);
                taglibrary.putValidator(name, validatorId, clazz);
            } else {
                taglibrary.putValidator(name, validatorId);
            }
        }
    }

    private void processConverter(NodeList converter, FaceletsLibrary taglibrary, String name) {
        if (converter != null && converter.getLength() > 0) {
            String converterId = null;
            String handlerClass = null;
            int ilen = converter.getLength();
            for (int i = 0; i < ilen; ++i) {
                Node n = converter.item(i);
                if (CONVERTER_ID.equals(n.getLocalName())) {
                    converterId = this.getNodeText(n);
                    continue;
                }
                if (!HANDLER_CLASS.equals(n.getLocalName())) continue;
                handlerClass = this.getNodeText(n);
            }
            if (handlerClass != null) {
                Class<?> clazz = this.loadClass(handlerClass, (Object)this, null);
                taglibrary.putConverter(name, converterId, clazz);
            } else {
                taglibrary.putConverter(name, converterId);
            }
        }
    }

    private void processComponent(NodeList component, FaceletsLibrary taglibrary, String name) {
        if (component != null && component.getLength() > 0) {
            String componentType = null;
            String rendererType = null;
            String handlerClass = null;
            int ilen = component.getLength();
            for (int i = 0; i < ilen; ++i) {
                Node n = component.item(i);
                if (COMPONENT_TYPE.equals(n.getLocalName())) {
                    componentType = this.getNodeText(n);
                    continue;
                }
                if (RENDERER_TYPE.equals(n.getLocalName())) {
                    rendererType = this.getNodeText(n);
                    continue;
                }
                if (!HANDLER_CLASS.equals(n.getLocalName())) continue;
                handlerClass = this.getNodeText(n);
            }
            if (handlerClass != null) {
                Class<?> clazz = this.loadClass(handlerClass, (Object)this, null);
                taglibrary.putComponent(name, componentType, rendererType, clazz);
            } else {
                taglibrary.putComponent(name, componentType, rendererType);
            }
        }
    }

    private void processFunctions(NodeList functions, FaceletsLibrary taglibrary) {
        if (functions != null && functions.getLength() > 0) {
            int ilen = functions.getLength();
            for (int i = 0; i < ilen; ++i) {
                NodeList children = functions.item(i).getChildNodes();
                String functionName = null;
                String functionClass = null;
                String functionSignature = null;
                int jlen = children.getLength();
                for (int j = 0; j < jlen; ++j) {
                    Node n = children.item(j);
                    if (FUNCTION_NAME.equals(n.getLocalName())) {
                        functionName = this.getNodeText(n);
                        continue;
                    }
                    if (FUNCTION_CLASS.equals(n.getLocalName())) {
                        functionClass = this.getNodeText(n);
                        continue;
                    }
                    if (!FUNCTION_SIGNATURE.equals(n.getLocalName())) continue;
                    functionSignature = this.getNodeText(n);
                }
                Method m = null;
                try {
                    Class<?> clazz = this.loadClass(functionClass, (Object)this, null);
                    m = FaceletsTaglibConfigProcessor.createMethod(clazz, functionSignature);
                }
                catch (Exception e) {
                    // empty catch block
                }
                taglibrary.putFunction(functionName, m);
            }
        }
    }

    private static Method createMethod(Class type, String signature) throws Exception {
        Class[] pc;
        int pos = signature.indexOf(32);
        if (pos == -1) {
            throw new Exception("Must Provide Return Type: " + signature);
        }
        int pos2 = signature.indexOf(40, pos + 1);
        if (pos2 == -1) {
            throw new Exception("Must provide a method name, followed by '(': " + signature);
        }
        String mn = signature.substring(pos + 1, pos2).trim();
        pos = signature.indexOf(41, pos2 + 1);
        if (pos == -1) {
            throw new Exception("Must close parentheses, ')' missing: " + signature);
        }
        String[] ps = signature.substring(pos2 + 1, pos).trim().split(",");
        if (ps.length == 1 && "".equals(ps[0])) {
            pc = new Class[]{};
        } else {
            pc = new Class[ps.length];
            for (int i = 0; i < pc.length; ++i) {
                pc[i] = ReflectionUtil.forName((String)ps[i].trim());
            }
        }
        try {
            return type.getMethod(mn, pc);
        }
        catch (NoSuchMethodException e) {
            throw new Exception("No Function Found on type: " + type.getName() + " with signature: " + signature);
        }
    }
}

