/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.editor.facelets;

import com.sun.faces.config.DocumentInfo;
import com.sun.faces.spi.ConfigurationResourceProvider;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.jsf.editor.JsfSupportImpl;
import org.netbeans.modules.web.jsf.editor.facelets.AbstractFaceletsLibrary;
import org.netbeans.modules.web.jsf.editor.facelets.CompositeComponentLibrary;
import org.netbeans.modules.web.jsf.editor.facelets.DefaultFaceletLibraries;
import org.netbeans.modules.web.jsf.editor.facelets.PureCompositeComponentLibrary;
import org.netbeans.modules.web.jsf.editor.facelets.WebFaceletTaglibResourceProvider;
import org.netbeans.modules.web.jsf.editor.facelets.mojarra.ConfigManager;
import org.netbeans.modules.web.jsf.editor.facelets.mojarra.FaceletsTaglibConfigProcessor;
import org.netbeans.modules.web.jsf.editor.index.IndexedFile;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.URLMapper;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;

public class FaceletsLibrarySupport {
    private JsfSupportImpl jsfSupport;
    private Map<String, AbstractFaceletsLibrary> faceletsLibraries;
    private long libraries_hash;
    private static final Logger LOGGER = Logger.getLogger(FaceletsLibrarySupport.class.getSimpleName());
    private FileChangeListener DDLISTENER = new FileChangeAdapter(){

        public void fileChanged(FileEvent fe) {
            FaceletsLibrarySupport.this.invalidateLibrariesCache();
        }
    };
    private static final String DD_FILE_NAME = "web.xml";

    public FaceletsLibrarySupport(JsfSupportImpl jspSupport) {
        this.jsfSupport = jspSupport;
        WebModule webModule = this.jsfSupport.getWebModule();
        if (webModule != null) {
            FileObject webInf;
            FileObject dd = webModule.getDeploymentDescriptor();
            if (dd != null) {
                dd.addFileChangeListener(this.DDLISTENER);
            }
            if ((webInf = webModule.getWebInf()) != null) {
                webInf.addFileChangeListener((FileChangeListener)new FileChangeAdapter(){

                    public void fileDataCreated(FileEvent fe) {
                        FileObject file = fe.getFile();
                        if (file.getNameExt().equalsIgnoreCase(FaceletsLibrarySupport.DD_FILE_NAME)) {
                            file.addFileChangeListener(FaceletsLibrarySupport.this.DDLISTENER);
                        }
                    }

                    public void fileDeleted(FileEvent fe) {
                        FileObject file = fe.getFile();
                        if (file.getNameExt().equalsIgnoreCase(FaceletsLibrarySupport.DD_FILE_NAME)) {
                            file.removeFileChangeListener(FaceletsLibrarySupport.this.DDLISTENER);
                        }
                    }
                });
            }
        }
    }

    public JsfSupportImpl getJsfSupport() {
        return this.jsfSupport;
    }

    private synchronized void invalidateLibrariesCache() {
        this.faceletsLibraries = null;
    }

    public synchronized Map<String, AbstractFaceletsLibrary> getLibraries() {
        this.checkLibraryDescriptorsUpToDate();
        if (this.faceletsLibraries == null) {
            this.faceletsLibraries = this.findLibraries();
            if (this.faceletsLibraries == null) {
                return Collections.emptyMap();
            }
            this.updateCompositeLibraries(this.faceletsLibraries);
        }
        return this.faceletsLibraries;
    }

    private void checkLibraryDescriptorsUpToDate() {
        long hash = 7L;
        for (IndexedFile indexedFile : this.getJsfSupport().getIndex().getAllFaceletsLibraryDescriptors()) {
            long timestamp = indexedFile.getTimestamp();
            hash = 79L * hash + timestamp;
        }
        for (String ccLibName : this.getJsfSupport().getIndex().getAllCompositeLibraryNames()) {
            hash = 79L * hash + (long)ccLibName.hashCode();
        }
        if (hash != this.libraries_hash) {
            LOGGER.info("Invalidating facelets libraries due to a library descriptor change.");
            this.invalidateLibrariesCache();
            this.libraries_hash = hash;
        }
    }

    private void updateCompositeLibraries(Map<String, AbstractFaceletsLibrary> faceletsLibraries) {
        ArrayList<String> libraryNames = new ArrayList<String>(this.jsfSupport.getIndex().getAllCompositeLibraryNames());
        HashMap<String, CompositeComponentLibrary> cclibsMap = new HashMap<String, CompositeComponentLibrary>();
        for (AbstractFaceletsLibrary lib : faceletsLibraries.values()) {
            if (!(lib instanceof CompositeComponentLibrary)) continue;
            CompositeComponentLibrary cclib = (CompositeComponentLibrary)lib;
            cclibsMap.put(cclib.getDefaultNamespace(), cclib);
            String libraryName = cclib.getLibraryName();
            libraryNames.remove(libraryName);
        }
        faceletsLibraries.putAll(cclibsMap);
        for (String libraryName : libraryNames) {
            PureCompositeComponentLibrary ccl = new PureCompositeComponentLibrary(this, libraryName);
            faceletsLibraries.put(ccl.getDefaultNamespace(), ccl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, AbstractFaceletsLibrary> findLibraries() {
        ProgressHandle progress = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(FaceletsLibrarySupport.class, (String)"MSG_ParsingFaceletsLibraries"));
        progress.start();
        progress.switchToIndeterminate();
        try {
            Map<String, AbstractFaceletsLibrary> map = this._findLibraries();
            return map;
        }
        finally {
            progress.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, AbstractFaceletsLibrary> _findLibraries() {
        ClassLoader originalLoader = this.getClass().getClassLoader();
        LOGGER.log(Level.FINE, "Scanning facelets libraries, current classloader class={0}, the used URLClassLoader will also contain following roots:", originalLoader.getClass().getName());
        ArrayList<URL> urlsToLoad = new ArrayList<URL>();
        for (FileObject cpRoot : this.getJsfSupport().getClassPath().getRoots()) {
            try {
                String fsName = cpRoot.getFileSystem().getDisplayName();
                if (!fsName.endsWith("javax.faces.jar")) {
                    urlsToLoad.add(URLMapper.findURL((FileObject)cpRoot, (int)0));
                    LOGGER.log(Level.FINE, "+++{0}", cpRoot);
                    continue;
                }
                LOGGER.log(Level.FINE, "---{0}", cpRoot);
            }
            catch (FileStateInvalidException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        URLClassLoader proxyLoader = new URLClassLoader(urlsToLoad.toArray(new URL[0]), originalLoader){

            @Override
            public URL findResource(String name) {
                return name.startsWith("META-INF/services") ? null : super.findResource(name);
            }

            @Override
            public Enumeration<URL> findResources(String name) throws IOException {
                if (name.startsWith("META-INF/services")) {
                    return Collections.enumeration(Collections.emptyList());
                }
                return super.findResources(name);
            }
        };
        ClassLoader originalContextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(proxyLoader);
            Map<String, AbstractFaceletsLibrary> map = this.parseLibraries();
            return map;
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalContextClassLoader);
        }
    }

    private Map<String, AbstractFaceletsLibrary> parseLibraries() {
        ArrayList<ConfigurationResourceProvider> faceletTaglibProviders = new ArrayList<ConfigurationResourceProvider>();
        WebModule webModule = this.getJsfSupport().getWebModule();
        if (webModule != null) {
            faceletTaglibProviders.add(new WebFaceletTaglibResourceProvider(webModule));
        }
        final ArrayList<URI> uris = new ArrayList<URI>();
        for (IndexedFile file : this.getJsfSupport().getIndex().getAllFaceletsLibraryDescriptors()) {
            try {
                uris.add(URLMapper.findURL((FileObject)file.getFile(), (int)1).toURI());
            }
            catch (URISyntaxException ex) {
                LOGGER.log(Level.INFO, null, ex);
            }
        }
        faceletTaglibProviders.add(new ConfigurationResourceProvider(){

            public Collection<URI> getResources(ServletContext sc) {
                return uris;
            }
        });
        Collection<FileObject> libraryDescriptorFiles = DefaultFaceletLibraries.getInstance().getLibrariesDescriptorsFiles();
        final ArrayList<URI> libraryURIs = new ArrayList<URI>();
        for (FileObject fo : libraryDescriptorFiles) {
            try {
                libraryURIs.add(fo.getURL().toURI());
            }
            catch (FileStateInvalidException ex) {
                LOGGER.log(Level.INFO, null, ex);
            }
            catch (URISyntaxException ex) {
                LOGGER.log(Level.INFO, null, ex);
            }
        }
        faceletTaglibProviders.add(new ConfigurationResourceProvider(){

            public Collection<URI> getResources(ServletContext sc) {
                return libraryURIs;
            }
        });
        DocumentInfo[] documents = ConfigManager.getConfigDocuments(null, faceletTaglibProviders, null, true);
        if (documents == null) {
            return null;
        }
        FaceletsTaglibConfigProcessor processor = new FaceletsTaglibConfigProcessor(this);
        processor.process(null, documents);
        HashMap<String, AbstractFaceletsLibrary> libsMap = new HashMap<String, AbstractFaceletsLibrary>();
        for (AbstractFaceletsLibrary lib : processor.compiler.libraries) {
            libsMap.put(lib.getNamespace(), lib);
        }
        return libsMap;
    }

    public static class Compiler {
        private Collection<AbstractFaceletsLibrary> libraries = new HashSet<AbstractFaceletsLibrary>();

        public void addTagLibrary(AbstractFaceletsLibrary lib) {
            this.libraries.add(lib);
        }
    }
}

