/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.editor.facelets;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.web.jsf.editor.facelets.FaceletsLibraryDescriptor;
import org.netbeans.modules.web.jsf.editor.facelets.LibraryDescriptorException;
import org.netbeans.modules.web.jsfapi.api.DefaultLibraryInfo;
import org.netbeans.modules.web.jsfapi.api.LibraryInfo;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;

public class DefaultFaceletLibraries {
    public static DefaultFaceletLibraries INSTANCE;
    private Collection<FileObject> libraryDescriptorsFiles;
    private Map<String, FaceletsLibraryDescriptor> librariesDescriptors;

    public static synchronized DefaultFaceletLibraries getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new DefaultFaceletLibraries();
        }
        return INSTANCE;
    }

    public DefaultFaceletLibraries() {
        this.init();
    }

    private void init() {
        File jsfImplJar = InstalledFileLocator.getDefault().locate("modules/ext/jsf-2_1/javax.faces.jar", "org.netbeans.modules.web.jsf20", false);
        assert (jsfImplJar != null);
        FileObject jsfImplJarFo = FileUtil.getArchiveRoot((FileObject)FileUtil.toFileObject((File)jsfImplJar));
        this.libraryDescriptorsFiles = DefaultFaceletLibraries.findLibraryDescriptors(jsfImplJarFo, ".taglib.xml");
    }

    public Collection<FileObject> getLibrariesDescriptorsFiles() {
        return this.libraryDescriptorsFiles;
    }

    public synchronized Map<String, FaceletsLibraryDescriptor> getLibrariesDescriptors() {
        if (this.librariesDescriptors == null) {
            this.librariesDescriptors = new HashMap<String, FaceletsLibraryDescriptor>();
            this.parseLibraries();
        }
        return this.librariesDescriptors;
    }

    private void parseLibraries() {
        for (FileObject lfo : this.getLibrariesDescriptorsFiles()) {
            try {
                FaceletsLibraryDescriptor descritor = FaceletsLibraryDescriptor.create(lfo);
                this.librariesDescriptors.put(descritor.getNamespace(), descritor);
            }
            catch (LibraryDescriptorException ex) {
                Logger.global.log(Level.WARNING, "Error parsing facelets library " + FileUtil.getFileDisplayName((FileObject)lfo) + " in javax.faces.jar from bundled web.jsf20 library", ex);
            }
        }
    }

    public static String getLibraryDisplayName(String uri) {
        LibraryInfo li = DefaultLibraryInfo.forNamespace((String)uri);
        return li != null ? li.getDisplayName() : null;
    }

    public static String getLibraryDefaultPrefix(String uri) {
        LibraryInfo li = DefaultLibraryInfo.forNamespace((String)uri);
        return li != null ? li.getDefaultPrefix() : null;
    }

    private static Collection<FileObject> findLibraryDescriptors(FileObject classpathRoot, String suffix) {
        ArrayList<FileObject> files = new ArrayList<FileObject>();
        Enumeration fos = classpathRoot.getChildren(true);
        while (fos.hasMoreElements()) {
            FileObject file = (FileObject)fos.nextElement();
            if (!file.isValid() || !file.isData() || !file.getNameExt().toLowerCase(Locale.US).endsWith(suffix)) continue;
            files.add(file);
        }
        return files;
    }
}

