/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.editor.el;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.html.editor.api.gsf.HtmlParserResult;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.web.el.spi.ELVariableResolver;
import org.netbeans.modules.web.el.spi.ResolverContext;
import org.netbeans.modules.web.jsf.api.editor.JSFBeanCache;
import org.netbeans.modules.web.jsf.api.metamodel.FacesManagedBean;
import org.netbeans.modules.web.jsf.editor.JsfUtils;
import org.netbeans.modules.web.jsf.editor.el.JsfVariableContext;
import org.netbeans.modules.web.jsf.editor.el.JsfVariablesModel;
import org.netbeans.modules.web.jsf.editor.index.CompositeComponentModel;
import org.netbeans.modules.web.jsf.editor.index.JsfPageModelFactory;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public final class JsfELVariableResolver
implements ELVariableResolver {
    private static final String CONTENT_NAME = "JsfBeans";
    private static final String OBJECT_NAME__CC = "cc";
    private static final String ATTR_NAME__ATTRS = "attrs";
    private static final String ATTR_NAME__ID = "id";
    private static final String ATTR_NAME__RENDERED = "rendered";
    private static final ELVariableResolver.VariableInfo VARIABLE_INFO__ATTRS = ELVariableResolver.VariableInfo.createResolvedVariable((String)"attrs", (String)Object.class.getName());
    private static final ELVariableResolver.VariableInfo VARIABLE_INFO__ID = ELVariableResolver.VariableInfo.createResolvedVariable((String)"id", (String)Object.class.getName());
    private static final ELVariableResolver.VariableInfo VARIABLE_INFO__RENDERED = ELVariableResolver.VariableInfo.createResolvedVariable((String)"rendered", (String)Object.class.getName());

    public String getBeanClass(String beanName, FileObject target, ResolverContext context) {
        for (FacesManagedBean bean : this.getJsfManagedBeans(target, context)) {
            if (!beanName.equals(bean.getManagedBeanName())) continue;
            return bean.getManagedBeanClass();
        }
        return null;
    }

    public String getBeanName(String clazz, FileObject target, ResolverContext context) {
        for (FacesManagedBean bean : this.getJsfManagedBeans(target, context)) {
            if (!clazz.equals(bean.getManagedBeanClass())) continue;
            return bean.getManagedBeanName();
        }
        return null;
    }

    public List<ELVariableResolver.VariableInfo> getManagedBeans(FileObject target, ResolverContext context) {
        List<FacesManagedBean> beans = this.getJsfManagedBeans(target, context);
        ArrayList<ELVariableResolver.VariableInfo> result = new ArrayList<ELVariableResolver.VariableInfo>(beans.size());
        for (FacesManagedBean bean : beans) {
            if (bean.getManagedBeanClass() == null || bean.getManagedBeanName() == null) continue;
            result.add(ELVariableResolver.VariableInfo.createResolvedVariable((String)bean.getManagedBeanName(), (String)bean.getManagedBeanClass()));
        }
        return result;
    }

    public List<ELVariableResolver.VariableInfo> getVariables(Snapshot snapshot, int offset, ResolverContext context) {
        List<JsfVariableContext> allJsfVariables = this.getAllJsfVariables(snapshot, offset);
        ArrayList<ELVariableResolver.VariableInfo> result = new ArrayList<ELVariableResolver.VariableInfo>(allJsfVariables.size());
        for (JsfVariableContext jsfVariable : allJsfVariables) {
            String expression = jsfVariable.getResolvedExpression();
            if (expression == null) continue;
            result.add(ELVariableResolver.VariableInfo.createUnresolvedVariable((String)jsfVariable.getVariableName(), (String)expression));
        }
        return result;
    }

    public List<ELVariableResolver.VariableInfo> getRawObjectProperties(String objectName, Snapshot snapshot, ResolverContext context) {
        ArrayList<ELVariableResolver.VariableInfo> variables = new ArrayList<ELVariableResolver.VariableInfo>(3);
        if (OBJECT_NAME__CC.equals(objectName)) {
            variables.add(VARIABLE_INFO__ID);
            variables.add(VARIABLE_INFO__RENDERED);
            variables.add(VARIABLE_INFO__ATTRS);
        } else if (ATTR_NAME__ATTRS.equals(objectName)) {
            variables.add(VARIABLE_INFO__ID);
            variables.add(VARIABLE_INFO__RENDERED);
            final JsfPageModelFactory modelFactory = JsfPageModelFactory.getFactory(CompositeComponentModel.Factory.class);
            assert (modelFactory != null);
            final AtomicReference ccModelRef = new AtomicReference();
            try {
                ParserManager.parse(Collections.singleton(snapshot.getSource()), (UserTask)new UserTask(){

                    public void run(ResultIterator resultIterator) throws Exception {
                        Parser.Result parseResult = JsfUtils.getEmbeddedParserResult(resultIterator, "text/html");
                        if (parseResult instanceof HtmlParserResult) {
                            ccModelRef.set((CompositeComponentModel)modelFactory.getModel((HtmlParserResult)parseResult));
                        }
                    }
                });
                CompositeComponentModel ccmodel = (CompositeComponentModel)ccModelRef.get();
                if (ccmodel != null) {
                    Collection<Map<String, String>> allCCInterfaceAttrs = ccmodel.getExistingInterfaceAttributes();
                    for (Map<String, String> attrsMap : allCCInterfaceAttrs) {
                        String name = attrsMap.get("name");
                        if (name == null) continue;
                        variables.add(ELVariableResolver.VariableInfo.createResolvedVariable((String)name, (String)Object.class.getName()));
                    }
                }
            }
            catch (ParseException e) {
                Exceptions.printStackTrace((Throwable)e);
            }
        }
        return variables;
    }

    public List<ELVariableResolver.VariableInfo> getBeansInScope(String scope, Snapshot snapshot, ResolverContext context) {
        ArrayList<ELVariableResolver.VariableInfo> result = new ArrayList<ELVariableResolver.VariableInfo>();
        for (FacesManagedBean bean : this.getJsfManagedBeans(snapshot.getSource().getFileObject(), context)) {
            if (bean.getManagedBeanClass() == null || bean.getManagedBeanName() != null || !scope.equals(bean.getManagedBeanScopeString())) continue;
            result.add(ELVariableResolver.VariableInfo.createResolvedVariable((String)bean.getManagedBeanName(), (String)bean.getManagedBeanClass()));
        }
        return result;
    }

    private List<FacesManagedBean> getJsfManagedBeans(FileObject target, ResolverContext context) {
        Project project = FileOwnerQuery.getOwner((FileObject)target);
        if (project == null) {
            return Collections.emptyList();
        }
        if (context.getContent(CONTENT_NAME) == null) {
            context.setContent(CONTENT_NAME, (Object)JSFBeanCache.getBeans((Project)project));
        }
        return (List)context.getContent(CONTENT_NAME);
    }

    private List<JsfVariableContext> getAllJsfVariables(Snapshot snapshot, final int offset) {
        final ArrayList<JsfVariableContext> result = new ArrayList<JsfVariableContext>();
        try {
            ParserManager.parse(Collections.singleton(snapshot.getSource()), (UserTask)new UserTask(){

                public void run(ResultIterator resultIterator) throws Exception {
                    Parser.Result parseResult = JsfUtils.getEmbeddedParserResult(resultIterator, "text/html");
                    if (parseResult instanceof HtmlParserResult) {
                        JsfVariablesModel model = JsfVariablesModel.getModel((HtmlParserResult)parseResult, resultIterator.getSnapshot());
                        List<JsfVariableContext> contexts = model.getAllAvailableVariables(offset, false);
                        result.addAll(contexts);
                    }
                }
            });
        }
        catch (ParseException e) {
            Exceptions.printStackTrace((Throwable)e);
        }
        return result;
    }
}

