/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.editor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.html.lexer.HTMLTokenId;
import org.netbeans.api.lexer.InputAttributes;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.lexer.LanguagePath;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.lib.editor.util.CharSequenceUtilities;
import org.netbeans.modules.csl.api.ColoringAttributes;
import org.netbeans.modules.csl.api.DeclarationFinder;
import org.netbeans.modules.csl.api.Error;
import org.netbeans.modules.csl.api.Hint;
import org.netbeans.modules.csl.api.HintsProvider;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.csl.api.RuleContext;
import org.netbeans.modules.csl.spi.ParserResult;
import org.netbeans.modules.editor.NbEditorDocument;
import org.netbeans.modules.html.editor.api.completion.HtmlCompletionItem;
import org.netbeans.modules.html.editor.api.gsf.HtmlExtension;
import org.netbeans.modules.html.editor.api.gsf.HtmlParserResult;
import org.netbeans.modules.html.editor.lib.api.elements.Attribute;
import org.netbeans.modules.html.editor.lib.api.elements.Element;
import org.netbeans.modules.html.editor.lib.api.elements.ElementType;
import org.netbeans.modules.html.editor.lib.api.elements.ElementUtils;
import org.netbeans.modules.html.editor.lib.api.elements.ElementVisitor;
import org.netbeans.modules.html.editor.lib.api.elements.Named;
import org.netbeans.modules.html.editor.lib.api.elements.Node;
import org.netbeans.modules.html.editor.lib.api.elements.OpenTag;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.SchedulerEvent;
import org.netbeans.modules.web.common.api.LexerUtils;
import org.netbeans.modules.web.common.taginfo.AttrValueType;
import org.netbeans.modules.web.common.taginfo.LibraryMetadata;
import org.netbeans.modules.web.common.taginfo.TagAttrMetadata;
import org.netbeans.modules.web.common.taginfo.TagMetadata;
import org.netbeans.modules.web.jsf.editor.InjectCompositeComponent;
import org.netbeans.modules.web.jsf.editor.JsfSupportImpl;
import org.netbeans.modules.web.jsf.editor.completion.JsfCompletionItem;
import org.netbeans.modules.web.jsf.editor.facelets.AbstractFaceletsLibrary;
import org.netbeans.modules.web.jsf.editor.facelets.CompositeComponentLibrary;
import org.netbeans.modules.web.jsf.editor.facelets.FaceletsLibraryMetadata;
import org.netbeans.modules.web.jsf.editor.hints.HintsRegistry;
import org.netbeans.modules.web.jsf.editor.index.CompositeComponentModel;
import org.netbeans.modules.web.jsf.editor.index.JsfPageModelFactory;
import org.netbeans.modules.web.jsfapi.api.Library;
import org.netbeans.modules.web.jsfapi.api.LibraryComponent;
import org.netbeans.modules.web.jsfapi.api.Tag;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.netbeans.spi.lexer.MutableTextInput;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class JsfHtmlExtension
extends HtmlExtension {
    private static final String EL_ENABLED_KEY = "el_enabled";

    public Map<OffsetRange, Set<ColoringAttributes>> getHighlights(HtmlParserResult result, SchedulerEvent event) {
        HashMap<OffsetRange, Set<ColoringAttributes>> highlights = new HashMap<OffsetRange, Set<ColoringAttributes>>();
        this.highlightJsfTags(result, highlights);
        this.checkELEnabled(result);
        return highlights;
    }

    public void checkELEnabled(HtmlParserResult result) {
        Language xhtmlLang;
        Document doc = result.getSnapshot().getSource().getDocument(true);
        InputAttributes inputAttributes = (InputAttributes)doc.getProperty(InputAttributes.class);
        if (inputAttributes == null) {
            inputAttributes = new InputAttributes();
            doc.putProperty(InputAttributes.class, inputAttributes);
        }
        if (inputAttributes.getValue(LanguagePath.get((Language)(xhtmlLang = Language.find((String)"text/xhtml"))), (Object)EL_ENABLED_KEY) == null) {
            inputAttributes.setValue(LanguagePath.get((Language)xhtmlLang), (Object)EL_ENABLED_KEY, new Object(), false);
            this.recolor(doc);
        }
    }

    private void recolor(final Document doc) {
        SwingUtilities.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                NbEditorDocument nbdoc = (NbEditorDocument)doc;
                nbdoc.extWriteLock();
                try {
                    MutableTextInput mti = (MutableTextInput)doc.getProperty(MutableTextInput.class);
                    if (mti != null) {
                        mti.tokenHierarchyControl().rebuild();
                    }
                }
                finally {
                    nbdoc.extWriteUnlock();
                }
            }
        });
    }

    private void highlightJsfTags(HtmlParserResult result, final Map<OffsetRange, Set<ColoringAttributes>> highlights) {
        final Snapshot snapshot = result.getSnapshot();
        Source source = snapshot.getSource();
        JsfSupportImpl jsfs = JsfSupportImpl.findFor(source);
        if (jsfs == null) {
            return;
        }
        Map<String, AbstractFaceletsLibrary> libs = jsfs.getLibraries();
        Map nss = result.getNamespaces();
        for (String namespace : nss.keySet()) {
            Node root = result.root(namespace);
            if (root == null) continue;
            final AbstractFaceletsLibrary tldl = libs.get(namespace);
            ElementUtils.visitChildren((Node)root, (ElementVisitor)new ElementVisitor(){

                public void visit(Element element) {
                    Named named;
                    if ((element.type() == ElementType.OPEN_TAG || element.type() == ElementType.CLOSE_TAG) && (named = (Named)element).namespacePrefix() != null) {
                        EnumSet coloring = tldl == null ? ColoringAttributes.CLASS_SET : ColoringAttributes.METHOD_SET;
                        try {
                            JsfHtmlExtension.this.highlight(snapshot, named, highlights, coloring);
                        }
                        catch (BadLocationException ex) {
                            // empty catch block
                        }
                    }
                }
            });
        }
    }

    private void highlight(Snapshot s, Named node, Map<OffsetRange, Set<ColoringAttributes>> hls, Set<ColoringAttributes> cas) throws BadLocationException {
        int prefixLen = node.type() == ElementType.OPEN_TAG ? 1 : 2;
        hls.put(this.getDocumentOffsetRange(s, node.from(), node.from() + node.name().length() + prefixLen), cas);
        hls.put(this.getDocumentOffsetRange(s, node.to() - 1, node.to()), cas);
    }

    private OffsetRange getDocumentOffsetRange(Snapshot s, int astFrom, int astTo) throws BadLocationException {
        int from = s.getOriginalOffset(astFrom);
        int to = s.getOriginalOffset(astTo);
        if (from == -1 || to == -1) {
            throw new BadLocationException("Cannot convert snapshot offset to document offset", -1);
        }
        return new OffsetRange(from, to);
    }

    public List<CompletionItem> completeOpenTags(HtmlExtension.CompletionContext context) {
        HtmlParserResult result = context.getResult();
        Source source = result.getSnapshot().getSource();
        JsfSupportImpl jsfs = JsfSupportImpl.findFor(source);
        if (jsfs == null) {
            return Collections.emptyList();
        }
        Map<String, AbstractFaceletsLibrary> libs = jsfs.getLibraries();
        HashSet<AbstractFaceletsLibrary> librariesSet = new HashSet<AbstractFaceletsLibrary>(libs.values());
        Map declaredNS = result.getNamespaces();
        ArrayList<CompletionItem> items = new ArrayList<CompletionItem>();
        int colonIndex = context.getPrefix().indexOf(58);
        if (colonIndex == -1) {
            for (AbstractFaceletsLibrary lib : librariesSet) {
                String declaredPrefix = (String)declaredNS.get(lib.getNamespace());
                if (declaredPrefix == null) {
                    if (lib.getDefaultPrefix() == null || !lib.getDefaultPrefix().startsWith(context.getPrefix())) continue;
                    items.addAll(this.queryLibrary(context, lib, lib.getDefaultPrefix(), true));
                    continue;
                }
                items.addAll(this.queryLibrary(context, lib, declaredPrefix, false));
            }
        } else {
            String tagNamePrefix = context.getPrefix().substring(0, colonIndex);
            String namespace = this.getUriForPrefix(tagNamePrefix, declaredNS);
            if (namespace == null) {
                for (AbstractFaceletsLibrary lib : librariesSet) {
                    if (lib.getDefaultPrefix() == null || !lib.getDefaultPrefix().equals(tagNamePrefix)) continue;
                    items.addAll(this.queryLibrary(context, lib, tagNamePrefix, true));
                }
            } else {
                AbstractFaceletsLibrary lib = libs.get(namespace);
                if (lib == null) {
                    return Collections.emptyList();
                }
                items.addAll(this.queryLibrary(context, lib, tagNamePrefix, false));
            }
        }
        Iterator itr = items.iterator();
        while (itr.hasNext()) {
            if (CharSequenceUtilities.startsWith((CharSequence)((CompletionItem)itr.next()).getInsertPrefix(), (CharSequence)context.getPrefix())) continue;
            itr.remove();
        }
        return items;
    }

    private String getUriForPrefix(String prefix, Map<String, String> namespaces) {
        for (Map.Entry<String, String> entry : namespaces.entrySet()) {
            if (!prefix.equals(entry.getValue())) continue;
            return entry.getKey();
        }
        return null;
    }

    private Collection<CompletionItem> queryLibrary(HtmlExtension.CompletionContext context, AbstractFaceletsLibrary lib, String nsPrefix, boolean undeclared) {
        ArrayList<CompletionItem> items = new ArrayList<CompletionItem>();
        for (AbstractFaceletsLibrary.NamedComponent namedComponent : lib.getComponents()) {
            items.add((CompletionItem)JsfCompletionItem.createTag(context.getCCItemStartOffset(), namedComponent, nsPrefix, undeclared));
        }
        return items;
    }

    public List<CompletionItem> completeAttributes(HtmlExtension.CompletionContext context) {
        Tag tag;
        HtmlParserResult result = context.getResult();
        Source source = result.getSnapshot().getSource();
        JsfSupportImpl jsfs = JsfSupportImpl.findFor(source);
        if (jsfs == null) {
            return Collections.emptyList();
        }
        Map<String, AbstractFaceletsLibrary> libs = jsfs.getLibraries();
        Map declaredNS = result.getNamespaces();
        ArrayList<CompletionItem> items = new ArrayList<CompletionItem>();
        Element queriedNode = context.getCurrentNode();
        if (queriedNode.type() != ElementType.OPEN_TAG) {
            return Collections.emptyList();
        }
        OpenTag ot = (OpenTag)queriedNode;
        CharSequence nsPrefix = ot.namespacePrefix();
        if (nsPrefix == null) {
            return Collections.emptyList();
        }
        String tagName = ((Object)ot.unqualifiedName()).toString();
        String namespace = this.getUriForPrefix(((Object)nsPrefix).toString(), declaredNS);
        AbstractFaceletsLibrary flib = libs.get(namespace);
        if (flib == null) {
            return Collections.emptyList();
        }
        AbstractFaceletsLibrary.NamedComponent comp = flib.getComponent(tagName);
        if (comp != null && (tag = comp.getTag()) != null) {
            Collection attrs = tag.getAttributes();
            ArrayList<String> existingAttrNames = new ArrayList<String>();
            for (Attribute a : ot.attributes()) {
                existingAttrNames.add(((Object)a.name()).toString());
            }
            for (Attribute a : attrs) {
                String attrName = a.getName();
                if (existingAttrNames.contains(attrName) && !existingAttrNames.contains(context.getItemText())) continue;
                items.add((CompletionItem)JsfCompletionItem.createAttribute(attrName, context.getCCItemStartOffset(), flib, tag, (org.netbeans.modules.web.jsfapi.api.Attribute)a));
            }
        }
        if (context.getPrefix().length() > 0) {
            Iterator itr = items.iterator();
            while (itr.hasNext()) {
                CharSequence insertPrefix = ((CompletionItem)itr.next()).getInsertPrefix();
                if (insertPrefix == null || CharSequenceUtilities.startsWith((CharSequence)insertPrefix, (CharSequence)context.getPrefix())) continue;
                itr.remove();
            }
        }
        return items;
    }

    public List<CompletionItem> completeAttributeValue(HtmlExtension.CompletionContext context) {
        OpenTag openTag;
        ArrayList<CompletionItem> items = new ArrayList<CompletionItem>();
        JsfSupportImpl jsfs = JsfSupportImpl.findFor(context.getResult().getSnapshot().getSource());
        String ns = ElementUtils.getNamespace((Element)context.getCurrentNode());
        OpenTag openTag2 = openTag = context.getCurrentNode().type() == ElementType.OPEN_TAG ? (OpenTag)context.getCurrentNode() : null;
        if (jsfs != null) {
            this.completeXMLNSAttribute(context, items, jsfs);
        }
        if (ns == null || openTag == null) {
            return items;
        }
        this.completeTagLibraryMetadata(context, items, ns, openTag);
        if (jsfs == null) {
            return items;
        }
        this.completeValueAccordingToType(context, items, ns, openTag, jsfs);
        this.completeFacetsInCCImpl(context, items, ns, openTag, jsfs);
        this.completeFacets(context, items, ns, openTag, jsfs);
        return items;
    }

    private void completeFacetsInCCImpl(HtmlExtension.CompletionContext context, List<CompletionItem> items, String ns, OpenTag openTag, JsfSupportImpl jsfs) {
        CompositeComponentModel ccModel;
        String tagName;
        if ("http://java.sun.com/jsf/composite".equalsIgnoreCase(ns) && ("renderFacet".equalsIgnoreCase(tagName = ((Object)openTag.unqualifiedName()).toString()) || "insertFacet".equalsIgnoreCase(tagName)) && "name".equalsIgnoreCase(context.getAttributeName()) && (ccModel = (CompositeComponentModel)JsfPageModelFactory.getFactory(CompositeComponentModel.Factory.class).getModel(context.getResult())) != null) {
            Collection<String> facets = ccModel.getDeclaredFacets();
            for (String facet : facets) {
                items.add((CompletionItem)HtmlCompletionItem.createAttributeValue((String)facet, (int)context.getCCItemStartOffset(), (!context.isValueQuoted() ? 1 : 0) != 0));
            }
        }
    }

    private void completeFacets(HtmlExtension.CompletionContext context, List<CompletionItem> items, String ns, OpenTag openTag, JsfSupportImpl jsfs) {
        String tagName;
        if ("http://java.sun.com/jsf/core".equalsIgnoreCase(ns) && "facet".equalsIgnoreCase(tagName = ((Object)openTag.unqualifiedName()).toString()) && "name".equalsIgnoreCase(context.getAttributeName())) {
            for (String libraryNs : context.getResult().getNamespaces().keySet()) {
                Library library = jsfs.getLibrary(libraryNs);
                if (library == null || !(library instanceof CompositeComponentLibrary)) continue;
                Collection lcs = library.getComponents();
                for (LibraryComponent lc : lcs) {
                    CompositeComponentLibrary.CompositeComponent ccomp = (CompositeComponentLibrary.CompositeComponent)lc;
                    CompositeComponentModel model = ccomp.getComponentModel();
                    for (String facetName : model.getDeclaredFacets()) {
                        items.add((CompletionItem)HtmlCompletionItem.createAttributeValue((String)facetName, (int)context.getCCItemStartOffset(), (!context.isValueQuoted() ? 1 : 0) != 0));
                    }
                }
            }
        }
    }

    private void completeValueAccordingToType(HtmlExtension.CompletionContext context, List<CompletionItem> items, String ns, OpenTag openTag, JsfSupportImpl jsfs) {
        Library lib = jsfs.getLibrary(ns);
        if (lib == null) {
            return;
        }
        String tagName = ((Object)openTag.unqualifiedName()).toString();
        LibraryComponent comp = lib.getComponent(tagName);
        if (comp == null) {
            return;
        }
        String attrName = context.getAttributeName();
        org.netbeans.modules.web.jsfapi.api.Attribute attr = comp.getTag().getAttribute(attrName);
        if (attr == null) {
            return;
        }
        String aType = attr.getType();
        if ("boolean".equals(aType) || "java.lang.Boolean".equals(aType)) {
            items.add((CompletionItem)HtmlCompletionItem.createAttributeValue((String)"true", (int)context.getCCItemStartOffset(), (!context.isValueQuoted() ? 1 : 0) != 0));
            items.add((CompletionItem)HtmlCompletionItem.createAttributeValue((String)"false", (int)context.getCCItemStartOffset(), (!context.isValueQuoted() ? 1 : 0) != 0));
        }
    }

    private void completeXMLNSAttribute(HtmlExtension.CompletionContext context, List<CompletionItem> items, JsfSupportImpl jsfs) {
        if (context.getAttributeName().toLowerCase(Locale.ENGLISH).startsWith("xmlns")) {
            ArrayList<String> nss = new ArrayList<String>(jsfs.getLibraries().keySet());
            nss.add("http://www.w3.org/1999/xhtml");
            for (String namespace : nss) {
                if (!namespace.startsWith(context.getPrefix())) continue;
                items.add((CompletionItem)HtmlCompletionItem.createAttributeValue((String)namespace, (int)context.getCCItemStartOffset(), (!context.isValueQuoted() ? 1 : 0) != 0));
            }
        }
    }

    private void completeTagLibraryMetadata(HtmlExtension.CompletionContext context, List<CompletionItem> items, String ns, OpenTag openTag) {
        Collection valueTypes;
        TagAttrMetadata attr;
        TagMetadata tag;
        String attrName = context.getAttributeName();
        String tagName = ((Object)openTag.unqualifiedName()).toString();
        LibraryMetadata lib = FaceletsLibraryMetadata.get(ns);
        if (lib != null && (tag = lib.getTag(tagName)) != null && (attr = tag.getAttribute(attrName)) != null && (valueTypes = attr.getValueTypes()) != null) {
            for (AttrValueType valueType : valueTypes) {
                String[] possibleVals = valueType.getPossibleValues();
                if (possibleVals == null) continue;
                for (String val : possibleVals) {
                    if (!val.startsWith(context.getPrefix())) continue;
                    HtmlCompletionItem itm = HtmlCompletionItem.createAttributeValue((String)val, (int)context.getCCItemStartOffset(), (!context.isValueQuoted() ? 1 : 0) != 0);
                    items.add((CompletionItem)itm);
                }
            }
        }
    }

    public DeclarationFinder.DeclarationLocation findDeclaration(ParserResult result, final int caretOffset) {
        assert (result instanceof HtmlParserResult);
        HtmlParserResult htmlresult = (HtmlParserResult)result;
        Snapshot snapshot = result.getSnapshot();
        Element leaf = htmlresult.findByPhysicalRange(caretOffset, true);
        if (leaf == null || leaf.type() != ElementType.OPEN_TAG) {
            return DeclarationFinder.DeclarationLocation.NONE;
        }
        JsfSupportImpl jsfs = JsfSupportImpl.findFor(result.getSnapshot().getSource());
        if (jsfs == null) {
            return DeclarationFinder.DeclarationLocation.NONE;
        }
        String ns = ElementUtils.getNamespace((Element)leaf);
        if (ns == null) {
            return DeclarationFinder.DeclarationLocation.NONE;
        }
        AbstractFaceletsLibrary lib = jsfs.getLibraries().get(ns);
        if (lib == null) {
            return DeclarationFinder.DeclarationLocation.NONE;
        }
        if (lib instanceof CompositeComponentLibrary) {
            OpenTag openTag = (OpenTag)leaf;
            String tagName = ((Object)openTag.unqualifiedName()).toString();
            AbstractFaceletsLibrary.NamedComponent component = lib.getComponent(tagName);
            if (component == null) {
                return DeclarationFinder.DeclarationLocation.NONE;
            }
            if (!(component instanceof CompositeComponentLibrary.CompositeComponent)) {
                return DeclarationFinder.DeclarationLocation.NONE;
            }
            CompositeComponentModel model = ((CompositeComponentLibrary.CompositeComponent)component).getComponentModel();
            FileObject file = model.getSourceFile();
            int astOffset = snapshot.getEmbeddedOffset(caretOffset);
            int jumpOffset = 0;
            TokenSequence htmlTs = snapshot.getTokenHierarchy().tokenSequence();
            htmlTs.move(astOffset);
            if ((htmlTs.moveNext() || htmlTs.movePrevious()) && htmlTs.token().id() != HTMLTokenId.TAG_OPEN && htmlTs.token().id() == HTMLTokenId.ARGUMENT) {
                final String attributeName = ((Object)htmlTs.token().text()).toString();
                Source source = Source.create((FileObject)file);
                final int[] attrOffset = new int[1];
                try {
                    ParserManager.parse(Collections.singleton(source), (UserTask)new UserTask(){

                        public void run(ResultIterator resultIterator) throws Exception {
                            Parser.Result result = resultIterator.getParserResult(caretOffset);
                            if (result instanceof HtmlParserResult) {
                                HtmlParserResult hresult = (HtmlParserResult)result;
                                Node root = hresult.root("http://java.sun.com/jsf/composite");
                                ElementUtils.visitChildren((Element)root, (ElementVisitor)new ElementVisitor(){

                                    public void visit(Element node) {
                                        OpenTag ot = (OpenTag)node;
                                        if (LexerUtils.equals((CharSequence)"interface", (CharSequence)ot.unqualifiedName(), (boolean)true, (boolean)true)) {
                                            for (Element child : ot.children(ElementType.OPEN_TAG)) {
                                                CharSequence value;
                                                Attribute nameAttr;
                                                OpenTag otch = (OpenTag)child;
                                                if (!LexerUtils.equals((CharSequence)"attribute", (CharSequence)otch.unqualifiedName(), (boolean)true, (boolean)true) || (nameAttr = otch.getAttribute("name")) == null || (value = nameAttr.unquotedValue()) == null || !LexerUtils.equals((CharSequence)attributeName, (CharSequence)value, (boolean)true, (boolean)false)) continue;
                                                attrOffset[0] = child.from();
                                                break;
                                            }
                                        }
                                    }
                                }, (ElementType)ElementType.OPEN_TAG);
                            }
                        }
                    });
                }
                catch (ParseException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                jumpOffset = attrOffset[0];
            }
            if (file != null) {
                return new DeclarationFinder.DeclarationLocation(file, jumpOffset);
            }
        }
        return DeclarationFinder.DeclarationLocation.NONE;
    }

    public OffsetRange getReferenceSpan(Document doc, int caretOffset) {
        TokenHierarchy th = TokenHierarchy.get((Document)doc);
        List seqs = th.embeddedTokenSequences(caretOffset, false);
        TokenSequence ts = null;
        for (TokenSequence _ts : seqs) {
            if (_ts.language() != HTMLTokenId.language()) continue;
            ts = _ts;
            break;
        }
        if (ts == null) {
            return OffsetRange.NONE;
        }
        ts.move(caretOffset);
        if (ts.moveNext() || ts.movePrevious()) {
            Token t = ts.token();
            if (t.id() == HTMLTokenId.TAG_OPEN) {
                if (CharSequenceUtilities.indexOf((CharSequence)t.text(), (int)58) != -1) {
                    return new OffsetRange(ts.offset(), ts.offset() + t.length());
                }
            } else if (t.id() == HTMLTokenId.ARGUMENT) {
                int from = ts.offset();
                int to = from + t.text().length();
                while (ts.movePrevious()) {
                    if (ts.token().id() != HTMLTokenId.TAG_OPEN) continue;
                    if (CharSequenceUtilities.indexOf((CharSequence)ts.token().text(), (int)58) == -1) break;
                    return new OffsetRange(from, to);
                }
            }
        }
        return OffsetRange.NONE;
    }

    public void computeErrors(HintsProvider.HintsManager manager, RuleContext context, List<Hint> hints, List<Error> unhandled) {
        hints.addAll(HintsRegistry.getDefault().gatherHints(context));
    }

    public void computeSelectionHints(HintsProvider.HintsManager manager, RuleContext context, List<Hint> hints, int start, int end) {
        Hint injectCC = InjectCompositeComponent.getHint(context, start, end);
        if (injectCC != null) {
            hints.add(injectCC);
        }
    }
}

