/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javafx2.editor.sax;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.xml.lexer.XMLTokenId;
import org.netbeans.modules.javafx2.editor.ErrorMark;
import org.netbeans.modules.javafx2.editor.sax.Bundle;
import org.netbeans.modules.javafx2.editor.sax.ContentLocator;
import org.netbeans.modules.javafx2.editor.sax.SequenceContentHandler;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class XmlLexerParser
implements ContentLocator {
    public static final String XMLNS_PREFIX = "xmlns";
    public static final String NO_NAMESPACE_PREFIX = "";
    public static final char PREFIX_DELIMITER_CHAR = ':';
    public static final String TAG_CLOSE = ">";
    public static final String OPEN_TAG = "<";
    public static final String OPEN_CLOSING_TAG = "</";
    public static final String SELF_CLOSING_TAG_CLOSE = "/>";
    public static final char TAG_START_CHAR = '<';
    public static final char TAG_END_CHAR = '>';
    public static final char CLOSE_TAG_CHAR = '/';
    private LexicalHandler lexicalHandler;
    private ContentHandler contentHandler;
    private SequenceContentHandler seqHandler;
    private TokenHierarchy hierarchy;
    private TokenSequence<XMLTokenId> seq;
    private LinkedList<Level> levelStack = new LinkedList();
    private int errorCount;
    private static final String ERR_UnexpectedToken = "unexpected-token";
    private static final String ERR_DuplicateAttribute = "duplicate-attribute";
    private static final String ERR_UnclosedValue = "unclosed-value";
    private static final String ERR_InvalidTagContent = "invalid-tag-content";
    private static final String ERR_TagNotFinished = "tag-not-finished";
    private static final String ERR_MissingEndTag = "missing-end-tag";
    private static final String ERR_UnexpectedTag = "unexpected-tag";
    private List<ErrorMark> errors = Collections.emptyList();
    private List<ErrorMark> leftErrors = Collections.emptyList();
    private Level currentLevel;
    private int errorsFetched = 0;
    private int[] targetOffset;
    private int[] dataOffset;
    private XMLTokenId forcedId;
    private int endDocOffset = -1;
    private Map<String, String> prefix2Uri = new HashMap<String, String>();
    private int endOffset;
    private int elementOffset;
    private String tagName;
    private String tagUri;
    private String qName;
    private Map<String, String> attrs;
    private List<String> attrNames;
    private Map<String, int[]> attrOffsets;
    private int levelBound;
    private Token<XMLTokenId> currentToken;
    private int[] currentAttrOffsets;
    private boolean selfClosed;
    private List<Integer> tokenOffsets = Collections.emptyList();
    private List<Token<XMLTokenId>> matchedTokens = Collections.emptyList();

    private void markError() {
        this.addError(ERR_UnexpectedToken, Bundle.ERR_unexpectedToken(((Object)this.currentToken.text()).toString()), new Object[0]);
    }

    private void markUnclosedElement(String qName) {
        this.addError(ERR_MissingEndTag, Bundle.ERR_elementNotClosed(qName), qName);
    }

    @Override
    public int getEndOffset() {
        return this.endOffset;
    }

    @Override
    public TokenSequence<XMLTokenId> getTokenSequence() {
        return this.hierarchy.tokenSequence();
    }

    private void addError(String type, String msg, Object ... params) {
        Token t = this.seq.token();
        ErrorMark mark = new ErrorMark(this.seq.offset(), t == null ? 1 : t.length(), type, msg, params);
        this.addError(mark);
    }

    private void addError(ErrorMark mark) {
        if (this.errors.isEmpty()) {
            this.errors = new ArrayList<ErrorMark>();
        }
        this.errors.add(mark);
        ++this.errorCount;
    }

    private void resetOffsets() {
        this.elementOffset = -1;
        this.endOffset = -1;
        if (this.attrOffsets != null && this.attrOffsets.isEmpty()) {
            this.attrOffsets = null;
        }
        this.flush();
    }

    private void flush() {
        if (this.errorsFetched < this.errors.size()) {
            if (this.leftErrors.isEmpty()) {
                this.leftErrors = new ArrayList<ErrorMark>();
            }
            this.leftErrors.addAll(this.errors.subList(this.errorsFetched, this.errors.size()));
        }
        this.errorsFetched = 0;
        this.errors = Collections.emptyList();
        this.matchedTokens = Collections.emptyList();
        this.tokenOffsets = Collections.emptyList();
    }

    public XmlLexerParser(TokenHierarchy<?> hierarchy) {
        this.hierarchy = hierarchy;
    }

    public void setLexicalHandler(LexicalHandler lexicalHandler) {
        this.lexicalHandler = lexicalHandler;
    }

    public void setContentHandler(ContentHandler contentHandler) {
        this.contentHandler = contentHandler;
        if (contentHandler instanceof ContentLocator.Receiver) {
            ((ContentLocator.Receiver)((Object)contentHandler)).setContentLocator(this);
        }
        if (contentHandler instanceof SequenceContentHandler) {
            this.seqHandler = (SequenceContentHandler)contentHandler;
        }
    }

    private void parseProcessingInstruction() throws SAXException {
        StringBuilder content = new StringBuilder();
        String target = null;
        this.targetOffset = new int[]{-1, -1, -1, -1};
        this.dataOffset = new int[]{-1, -1, -1, -1};
        this.skipWhitespace();
        Token<XMLTokenId> t = this.nextToken();
        if (t == null || t.id() != XMLTokenId.PI_TARGET) {
            this.markUnexpectedToken();
            return;
        }
        this.targetOffset[2] = this.targetOffset[0] = this.seq.offset();
        this.targetOffset[3] = this.targetOffset[1] = this.seq.offset() + t.length();
        target = ((Object)t.text()).toString();
        this.consume();
        boolean dataPresent = false;
        this.skipWhitespace();
        block5: while ((t = this.nextToken()) != null) {
            switch ((XMLTokenId)t.id()) {
                case WS: {
                    if (dataPresent) {
                        content.append(((Object)t.text()).toString());
                    }
                    this.skipWhitespace();
                    continue block5;
                }
                case PI_CONTENT: {
                    if (!dataPresent) {
                        dataPresent = true;
                        this.dataOffset[0] = this.dataOffset[2] = this.seq.offset();
                    }
                    content.append(((Object)t.text()).toString());
                    this.dataOffset[1] = this.dataOffset[3] = this.seq.offset() + t.length();
                    this.consume();
                    continue block5;
                }
                case PI_END: {
                    this.contentHandler.processingInstruction(target, content.toString().trim());
                    this.flush();
                    this.consume();
                    this.resetOffsets();
                    return;
                }
            }
            this.contentHandler.processingInstruction(target, content.toString().trim());
            this.endOffset = this.makeErrorOffset();
            this.flush();
            return;
        }
    }

    private int makeErrorOffset() {
        return -this.seq.offset() - 1;
    }

    private void handleErrorAs(XMLTokenId id) {
        this.markError();
        this.forcedId = id;
    }

    private XMLTokenId getTokenId() {
        if (this.forcedId != null) {
            XMLTokenId id = this.forcedId;
            this.forcedId = null;
            return id;
        }
        return (XMLTokenId)this.nextToken().id();
    }

    public void parse() throws SAXException {
        this.seq = this.hierarchy.tokenSequence();
        this.seq.move(0);
        this.parse2();
    }

    private void callCharacters(CharSequence t) throws SAXException {
        if (this.seqHandler != null) {
            this.seqHandler.characterSequence(t);
        } else {
            this.contentHandler.characters(((Object)t).toString().toCharArray(), 0, t.length());
        }
    }

    private void callCharacters(Token<XMLTokenId> t) throws SAXException {
        this.callCharacters(t.text());
    }

    private void callIgnorableWhitespace(Token<XMLTokenId> t) throws SAXException {
        if (this.seqHandler != null) {
            this.seqHandler.ignorableWhitespaceSequence(t.text());
        } else {
            this.contentHandler.ignorableWhitespace(((Object)t.text()).toString().toCharArray(), 0, t.length());
        }
    }

    void parse2() throws SAXException {
        Token<XMLTokenId> t;
        boolean whitespacePossible = true;
        this.elementOffset = 0;
        this.contentHandler.startDocument();
        block6: while ((t = this.nextToken()) != null) {
            this.resetOffsets();
            this.elementOffset = this.seq.offset();
            this.endOffset = this.elementOffset + t.length();
            switch ((XMLTokenId)t.id()) {
                case PI_START: {
                    this.consume();
                    this.parseProcessingInstruction();
                    whitespacePossible = true;
                    continue block6;
                }
                case BLOCK_COMMENT: {
                    this.consume();
                    if (this.lexicalHandler == null) continue block6;
                    this.lexicalHandler.comment(((Object)t.text()).toString().toCharArray(), 0, t.length());
                    continue block6;
                }
                case CDATA_SECTION: {
                    this.consume();
                    whitespacePossible = false;
                    if (this.lexicalHandler != null) {
                        this.lexicalHandler.startCDATA();
                    }
                    this.callCharacters(t);
                    if (this.lexicalHandler == null) continue block6;
                    this.lexicalHandler.endCDATA();
                    continue block6;
                }
                case TAG: {
                    CharSequence cs = t.text();
                    if (cs.charAt(0) == '<' && cs.length() > 1) {
                        if (cs.charAt(1) == '/') {
                            this.consume();
                            this.parseClosingTag(((Object)cs.subSequence(2, cs.length())).toString());
                        } else {
                            this.parseTag(t);
                        }
                    } else {
                        this.markError();
                        this.consume();
                        continue block6;
                    }
                    whitespacePossible = true;
                    continue block6;
                }
            }
            this.consume();
            String s = ((Object)t.text()).toString();
            if (whitespacePossible) {
                String trimmed = s.trim();
                if (trimmed.isEmpty()) {
                    this.callIgnorableWhitespace(t);
                    continue;
                }
                if (trimmed.startsWith(OPEN_TAG)) {
                    int idx = s.indexOf(trimmed);
                    ErrorMark mark = new ErrorMark(this.seq.offset() + idx, 1, ERR_UnexpectedToken, "Unexpected character: <", new Object[0]);
                    this.addError(mark);
                    if (trimmed.length() == 1) continue;
                    this.elementOffset = this.seq.offset() + idx + 1;
                    s = s.substring(idx);
                }
            }
            this.callCharacters(s);
            whitespacePossible = false;
        }
        this.endDocOffset = this.endOffset;
        while (!this.levelStack.isEmpty() && this.currentLevel != null) {
            this.markUnclosedElement(this.currentLevel.tagQName);
            String[] nsName = this.parseQName(this.currentLevel.tagQName);
            this.resetAndSetErrorOffsets();
            this.contentHandler.endElement(this.prefix2Uri.get(nsName[0]), nsName[1], this.currentLevel.tagQName);
            this.terminateLevel();
        }
        this.elementOffset = this.endDocOffset;
        this.contentHandler.endDocument();
        this.errors = this.leftErrors;
    }

    private void processPrefixMappings() throws SAXException {
        Map<String, String> savedPrefixMap = this.prefix2Uri;
        HashMap<String, String> prefixMap = null;
        for (String s : this.attrNames) {
            if (!s.startsWith(XMLNS_PREFIX)) continue;
            String prefix = NO_NAMESPACE_PREFIX;
            if (s.length() > 5 && s.charAt(5) == ':') {
                prefix = s.substring(6);
            }
            if (prefixMap == null) {
                prefixMap = new HashMap<String, String>(savedPrefixMap);
            }
            this.currentLevel.newPrefixes.add(s);
            prefixMap.put(prefix, this.attrs.get(s));
            this.contentHandler.startPrefixMapping(prefix, this.attrs.get(s));
        }
        if (prefixMap != null) {
            this.prefix2Uri = prefixMap;
        }
        this.currentLevel.savedPrefixes = savedPrefixMap;
    }

    private void startLevel() {
        this.attrNames = new ArrayList<String>();
        this.attrOffsets = new HashMap<String, int[]>();
        this.attrs = new HashMap<String, String>();
        this.currentLevel = new Level();
        this.currentLevel.tagQName = this.qName;
        this.currentLevel.savedPrefixes = this.prefix2Uri;
        this.levelStack.push(this.currentLevel);
    }

    private void terminateLevel() throws SAXException {
        if (this.currentLevel == null) {
            return;
        }
        for (String s : this.currentLevel.newPrefixes) {
            this.contentHandler.endPrefixMapping(s);
        }
        this.prefix2Uri = this.currentLevel.savedPrefixes;
        this.levelStack.pop();
        if (this.levelStack.size() <= this.levelBound) {
            this.currentLevel = null;
            return;
        }
        this.currentLevel = this.levelStack.peek();
        if (this.currentLevel != null) {
            this.qName = this.currentLevel.tagQName;
            String[] qn = this.parseQName(this.qName);
            this.tagUri = this.prefix2Uri.get(qn[0]);
            this.tagName = qn[1];
        } else {
            this.qName = null;
            this.tagName = null;
            this.tagUri = null;
        }
    }

    private String[] parseQName(String qn) {
        int pos = qn.indexOf(58);
        if (pos == -1) {
            return new String[]{NO_NAMESPACE_PREFIX, qn};
        }
        return new String[]{qn.substring(0, pos), qn.substring(pos + 1)};
    }

    private Object[] save() {
        return new Object[]{this.elementOffset, this.endOffset, this.tokenOffsets, this.matchedTokens};
    }

    private void restore(Object[] o) {
        this.elementOffset = (Integer)o[0];
        this.endOffset = (Integer)o[1];
        this.tokenOffsets = (List)o[2];
        this.matchedTokens = (List)o[3];
    }

    private void parseClosingTag(String tagName) throws SAXException {
        Token<XMLTokenId> token;
        this.elementOffset = this.seq.offset();
        this.skipWhitespace();
        this.qName = tagName;
        block5: while ((token = this.nextToken()) != null) {
            XMLTokenId id = (XMLTokenId)token.id();
            switch (id) {
                case WS: {
                    this.skipWhitespace();
                    continue block5;
                }
                case TAG: {
                    String s = ((Object)token.text()).toString();
                    if (s.equals(TAG_CLOSE)) {
                        this.consume();
                        break;
                    }
                    this.addError(ERR_TagNotFinished, null, new Object[0]);
                    this.markApproxEnd();
                    break;
                }
                case ARGUMENT: 
                case OPERATOR: 
                case VALUE: {
                    this.consume();
                    this.addError(ERR_InvalidTagContent, null, new Object[0]);
                    continue block5;
                }
                default: {
                    this.markUnexpectedToken();
                    break;
                }
            }
            break;
        }
        this.processTagName(tagName);
        if (this.levelStack.isEmpty()) {
            this.addError(new ErrorMark(this.elementOffset, this.seq.offset() + token.length() - this.elementOffset, ERR_MissingEndTag, Bundle.ERR_unexpectedTag(tagName), tagName));
            this.terminateLevel();
            return;
        }
        if (this.levelStack.size() <= this.levelBound || this.qName.equals(this.currentLevel.tagQName)) {
            this.contentHandler.endElement(this.tagUri, this.tagName, this.qName);
            this.terminateLevel();
            return;
        }
        Object[] o = this.save();
        if (this.findUpperOpening(tagName)) {
            this.restore(o);
            this.contentHandler.endElement(this.tagUri, this.tagName, this.qName);
            this.terminateLevel();
            return;
        }
        this.addError(ERR_UnexpectedTag, Bundle.ERR_unexpectedTag(tagName), new Object[0]);
    }

    private void markApproxEnd() {
        this.endOffset = -2;
    }

    private void resetAndSetErrorOffsets() {
        this.resetAndSetErrorOffsets(-1);
    }

    private void resetAndSetErrorOffsets(int startError) {
        this.resetOffsets();
        if (this.endDocOffset != -1) {
            this.elementOffset = -this.endDocOffset - 1;
        } else {
            int o = startError > -1 ? startError : this.seq.offset();
            this.elementOffset = -o - 1;
        }
        this.endOffset = this.elementOffset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean findUpperOpening(String tagName) throws SAXException {
        int depth = 0;
        Level found = null;
        for (Level l : this.levelStack) {
            if (l.tagQName.equals(tagName)) {
                found = l;
                break;
            }
            ++depth;
        }
        if (found == null) {
            return false;
        }
        int markSequence = this.seq.offset();
        XmlLexerParser parser = this.duplicate();
        parser.consume();
        ParentCollector pm = new ParentCollector((depth - 1) * 2 + 1);
        parser.setContentHandler(pm);
        boolean success = false;
        try {
            parser.parse2();
        }
        catch (StopParseException ex) {
        }
        finally {
            this.seq.move(markSequence);
            this.seq.moveNext();
        }
        Deque<String> followingClosingTags = pm.closingTags;
        followingClosingTags.addLast(tagName);
        int count = 0;
        for (int stackPtr = 0; stackPtr < this.levelStack.size() - followingClosingTags.size(); ++stackPtr) {
            Iterator<String> it = followingClosingTags.descendingIterator();
            boolean ok = true;
            for (int i = stackPtr; i >= 0 && it.hasNext(); ++i) {
                String s = it.next();
                Level l = this.levelStack.get(i);
                if (l.tagQName.equals(s)) continue;
                ok = false;
                break;
            }
            if (!ok) continue;
            success = true;
            count = stackPtr;
            break;
        }
        if (!success) {
            return false;
        }
        for (int i = 0; i <= count && this.currentLevel != null; ++i) {
            this.qName = this.currentLevel.tagQName;
            this.processTagName(this.qName);
            this.markUnclosedElement(this.qName);
            this.resetAndSetErrorOffsets();
            this.contentHandler.endElement(this.tagUri, this.tagName, this.qName);
            this.terminateLevel();
        }
        this.resetOffsets();
        return true;
    }

    private XmlLexerParser duplicate() {
        XmlLexerParser parser = new XmlLexerParser(this.hierarchy);
        parser.seq = this.seq;
        parser.levelStack = new LinkedList<Level>(this.levelStack);
        parser.levelBound = this.levelStack.size();
        parser.currentLevel = this.currentLevel;
        parser.currentToken = this.currentToken;
        return parser;
    }

    private Token<XMLTokenId> nextToken() {
        if (this.currentToken == null) {
            if (this.seq.moveNext()) {
                this.currentToken = this.seq.token();
                return this.currentToken;
            }
            return null;
        }
        return this.currentToken;
    }

    private void consume() {
        if (this.currentToken != null) {
            if (this.matchedTokens.isEmpty()) {
                this.matchedTokens = new ArrayList<Token<XMLTokenId>>();
                this.tokenOffsets = new ArrayList<Integer>();
            }
            this.tokenOffsets.add(this.seq.offset());
            this.matchedTokens.add(this.currentToken);
            if (this.endOffset != -2) {
                this.endOffset = this.seq.offset() + this.currentToken.length();
            }
        }
        this.currentToken = null;
    }

    private void skipWhitespace() {
        Token<XMLTokenId> t;
        while ((t = this.nextToken()) != null && t.id() == XMLTokenId.WS) {
            this.consume();
        }
    }

    private int fuzzyOffset(int pos) {
        return -pos - 1;
    }

    private void markUnexpectedAttrToken() {
        if (this.nextToken() != null && this.nextToken().id() == XMLTokenId.ERROR) {
            return;
        }
        int offset = this.seq.offset();
        if (this.currentAttrOffsets[2] == -1) {
            this.currentAttrOffsets[2] = this.fuzzyOffset(offset);
        }
        this.currentAttrOffsets[1] = this.currentAttrOffsets[3] = this.fuzzyOffset(offset);
        this.markUnexpectedToken();
    }

    private boolean parseAttribute(Token<XMLTokenId> t) {
        boolean ignore;
        String argName = ((Object)t.text()).toString();
        if (this.attrs.containsKey(argName)) {
            this.addError(ERR_DuplicateAttribute, null, new Object[0]);
            ignore = true;
        } else {
            this.currentAttrOffsets = new int[]{this.seq.offset(), -1, -1, -1};
            this.attrOffsets.put(argName, this.currentAttrOffsets);
            this.attrNames.add(argName);
            this.attrs.put(argName, null);
            ignore = false;
        }
        this.consume();
        this.skipWhitespace();
        t = this.nextToken();
        if (t == null || t.id() != XMLTokenId.OPERATOR) {
            this.markUnexpectedAttrToken();
            return false;
        }
        this.consume();
        this.skipWhitespace();
        t = this.nextToken();
        if (t == null || t.id() != XMLTokenId.VALUE) {
            this.markUnexpectedAttrToken();
            return false;
        }
        this.consume();
        CharSequence s = t.text();
        StringBuilder sb = null;
        int valStart = this.seq.offset();
        int valEnd = this.seq.offset() + t.length();
        char quote = s.charAt(0);
        t = this.nextToken();
        while (t != null && (t.id() == XMLTokenId.VALUE || t.id() == XMLTokenId.CHARACTER)) {
            valEnd = this.seq.offset() + t.length();
            if (sb == null) {
                sb = new StringBuilder();
                sb.append(((Object)s).toString());
            }
            sb.append(t.text());
            this.consume();
            t = this.nextToken();
        }
        int end = valEnd;
        if (sb != null) {
            s = sb;
        }
        if (quote == '\'' || quote == '\"') {
            if (s.charAt(s.length() - 1) == quote) {
                s = s.subSequence(1, s.length() - 1);
                ++valStart;
                --valEnd;
            } else if (t == null || t.id() == XMLTokenId.ERROR) {
                s = s.subSequence(1, s.length());
                ++valStart;
            }
        }
        if (!ignore) {
            this.attrs.put(argName, ((Object)s).toString());
            int[] offsets = this.attrOffsets.get(argName);
            offsets[1] = end;
            offsets[2] = valStart;
            offsets[3] = valEnd;
        }
        return true;
    }

    private void processTagName(String tagName) {
        String[] qn = this.parseQName(tagName);
        this.tagUri = this.prefix2Uri.get(qn[0]);
        this.tagName = qn[1];
    }

    private void errorStartTagInTagName() throws SAXException {
        ErrorMark em;
        if (!this.errors.isEmpty() && (em = this.errors.get(this.errors.size() - 1)).getErrorType().equals(ERR_UnexpectedToken)) {
            this.errors.remove(this.errors.size() - 1);
        }
        this.addError(ERR_TagNotFinished, Bundle.ERR_tagNotTerminated(this.qName), this.qName);
    }

    private void markUnexpectedToken() {
        if (this.currentToken != null) {
            String s = ((Object)this.currentToken.text()).toString();
            s = s.replaceAll("\\\n", Bundle.TOKEN_newline()).replaceAll("\\\t", Bundle.TOKEN_tab());
            this.addError(ERR_UnexpectedToken, Bundle.ERR_unexpectedToken(s), new Object[0]);
        } else {
            this.addError(ERR_UnexpectedToken, Bundle.ERR_UnexpectedEndOfFile(), new Object[0]);
        }
    }

    private void parseTag(Token<XMLTokenId> t) throws SAXException {
        String tagMark = ((Object)t.text()).toString();
        this.selfClosed = false;
        if ((tagMark = tagMark.substring(1)).endsWith(SELF_CLOSING_TAG_CLOSE)) {
            this.selfClosed = true;
            tagMark = tagMark.substring(0, tagMark.length() - 2);
        }
        this.consume();
        this.qName = tagMark;
        this.startLevel();
        boolean inError = false;
        block6: while ((t = this.nextToken()) != null) {
            XMLTokenId id = (XMLTokenId)t.id();
            switch (id) {
                case WS: {
                    this.consume();
                    continue block6;
                }
                case ARGUMENT: {
                    inError = !this.parseAttribute(t);
                    continue block6;
                }
                case TAG: {
                    CharSequence cs = t.text();
                    if (cs.charAt(0) == '<') {
                        inError = true;
                        this.errorStartTagInTagName();
                        break;
                    }
                    if (cs.charAt(cs.length() - 1) != '>') {
                        throw new IllegalStateException("Invalid tag text: " + cs);
                    }
                    if (cs.charAt(0) == '/') {
                        this.selfClosed = true;
                    }
                    this.consume();
                    break;
                }
                case ERROR: {
                    this.markUnexpectedToken();
                    this.consume();
                    inError = true;
                    continue block6;
                }
            }
            break;
        }
        boolean close = this.selfClosed;
        if (inError) {
            close |= this.determineClosedTag();
        }
        this.handleStartElement(close);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean determineClosedTag() throws SAXException {
        int markSequence = this.seq.offset();
        XmlLexerParser parser = this.duplicate();
        ParentCollector pm = new ParentCollector(this.levelStack.size());
        parser.setContentHandler(pm);
        try {
            parser.parse2();
        }
        catch (StopParseException ex) {
        }
        finally {
            this.seq.move(markSequence);
            this.seq.moveNext();
        }
        if (this.levelStack.isEmpty() || pm.closingTags.isEmpty()) {
            return false;
        }
        Level l = this.levelStack.peek();
        return !pm.closingTags.peekLast().equals(l.tagQName);
    }

    private void handleStartElement(boolean selfClosed) throws SAXException {
        this.processPrefixMappings();
        this.processTagName(this.qName);
        this.contentHandler.startElement(this.tagUri, this.tagName, this.qName, new Attrs(this.attrNames, this.attrs, this.prefix2Uri));
        this.flush();
        if (selfClosed) {
            this.contentHandler.endElement(this.tagUri, this.tagName, this.qName);
            this.terminateLevel();
        }
    }

    @Override
    public int getElementOffset() {
        return this.elementOffset;
    }

    @Override
    public int[] getAttributeOffsets(String attribute) {
        if (attribute == "*target") {
            return this.targetOffset;
        }
        if (attribute == "*data") {
            return this.dataOffset;
        }
        if (this.attrOffsets == null) {
            return null;
        }
        return this.attrOffsets.get(attribute);
    }

    @Override
    public Collection<ErrorMark> getErrors() {
        this.errorsFetched = this.errors.size();
        return this.errors.isEmpty() ? this.errors : Collections.unmodifiableList(this.errors);
    }

    @Override
    public List<Token<XMLTokenId>> getMatchingTokens() {
        return this.matchedTokens.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(this.matchedTokens);
    }

    private static final class Attrs
    implements Attributes {
        private List<String> order;
        private Map<String, String> attributes;
        private Map<String, String> prefi2URI;

        public Attrs(List<String> order, Map<String, String> attributes, Map<String, String> prefi2URI) {
            assert (order.size() == attributes.size());
            this.order = order;
            this.attributes = attributes;
            this.prefi2URI = prefi2URI;
        }

        @Override
        public int getLength() {
            return this.order.size();
        }

        private String n(int index) {
            return this.order.get(index);
        }

        @Override
        public String getURI(int index) {
            String n = this.n(index);
            int i = n.indexOf(58);
            if (i == -1) {
                return null;
            }
            return this.prefi2URI.get(n.substring(0, i));
        }

        @Override
        public String getLocalName(int index) {
            String n = this.n(index);
            int i = n.indexOf(58);
            if (i == -1) {
                return n;
            }
            return n.substring(i + 1);
        }

        @Override
        public String getQName(int index) {
            return this.n(index);
        }

        @Override
        public String getType(int index) {
            return "CDATA";
        }

        @Override
        public String getValue(int index) {
            return this.attributes.get(this.n(index));
        }

        @Override
        public int getIndex(String uri, String localName) {
            return this.order.indexOf(this.qn(uri, localName));
        }

        @Override
        public int getIndex(String qName) {
            return this.order.indexOf(qName);
        }

        @Override
        public String getType(String uri, String localName) {
            return "CDATA";
        }

        @Override
        public String getType(String qName) {
            return "CDATA";
        }

        @Override
        public String getValue(String uri, String localName) {
            return this.attributes.get(this.qn(uri, localName));
        }

        @Override
        public String getValue(String qName) {
            return this.attributes.get(qName);
        }

        private String qn(String uri, String localName) {
            String qn = localName;
            String prefix = this.uri2prefix(uri);
            if (prefix != null) {
                qn = prefix + ':' + localName;
            }
            return qn;
        }

        private String uri2prefix(String uri) {
            for (Map.Entry<String, String> en : this.prefi2URI.entrySet()) {
                if (!uri.equals(en.getValue())) continue;
                return en.getKey();
            }
            return null;
        }
    }

    private static class ParentCollector
    implements ContentHandler {
        int matchLevels;
        Deque<String> closingTags = new LinkedList<String>();
        int levelsBelow;

        ParentCollector(int matchLevels) {
            this.matchLevels = matchLevels;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            ++this.levelsBelow;
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (this.levelsBelow > 0) {
                --this.levelsBelow;
                return;
            }
            this.closingTags.push(qName);
            if (this.closingTags.size() == this.matchLevels) {
                throw new StopParseException(true);
            }
        }

        @Override
        public void setDocumentLocator(Locator locator) {
        }

        @Override
        public void startDocument() throws SAXException {
        }

        @Override
        public void endDocument() throws SAXException {
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) throws SAXException {
        }

        @Override
        public void endPrefixMapping(String prefix) throws SAXException {
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
        }

        @Override
        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        }

        @Override
        public void processingInstruction(String target, String data) throws SAXException {
        }

        @Override
        public void skippedEntity(String name) throws SAXException {
        }
    }

    static class StopParseException
    extends SAXException {
        private boolean success;

        public StopParseException(boolean success) {
            this.success = success;
        }
    }

    private static class Level {
        private String tagQName;
        private Map<String, String> savedPrefixes;
        private Collection<String> newPrefixes = new LinkedList<String>();

        private Level() {
        }
    }
}

