/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javafx2.editor.parser.processors;

import java.util.Iterator;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.TypeMirrorHandle;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.xml.lexer.XMLTokenId;
import org.netbeans.modules.javafx2.editor.ErrorMark;
import org.netbeans.modules.javafx2.editor.completion.beans.FxBean;
import org.netbeans.modules.javafx2.editor.completion.beans.FxDefinitionKind;
import org.netbeans.modules.javafx2.editor.completion.beans.FxProperty;
import org.netbeans.modules.javafx2.editor.completion.model.FxInstance;
import org.netbeans.modules.javafx2.editor.completion.model.FxNodeVisitor;
import org.netbeans.modules.javafx2.editor.completion.model.MapProperty;
import org.netbeans.modules.javafx2.editor.completion.model.PropertySetter;
import org.netbeans.modules.javafx2.editor.completion.model.PropertyValue;
import org.netbeans.modules.javafx2.editor.completion.model.StaticProperty;
import org.netbeans.modules.javafx2.editor.parser.BuildEnvironment;
import org.netbeans.modules.javafx2.editor.parser.ModelBuilderStep;
import org.netbeans.modules.javafx2.editor.parser.processors.Bundle;
import org.netbeans.modules.javafx2.editor.parser.processors.ImportProcessor;

public class PropertyResolver
extends FxNodeVisitor.ModelTreeTraversal
implements ModelBuilderStep {
    private BuildEnvironment env;
    private FxInstance currentInstance;
    private FxBean beanInfo;
    private ImportProcessor importer;

    public PropertyResolver() {
    }

    public PropertyResolver(BuildEnvironment env) {
        this.env = env;
    }

    private ImportProcessor getImporter() {
        if (this.importer != null) {
            return this.importer;
        }
        ImportProcessor proc = new ImportProcessor(this.env.getHierarchy(), null, this.env.getTreeUtilities());
        proc.load(this.env.getCompilationInfo(), this.env.getModel());
        this.importer = proc;
        return this.importer;
    }

    @Override
    public void visitBaseInstance(FxInstance decl) {
        FxInstance save = this.currentInstance;
        FxBean saveInfo = this.beanInfo;
        this.currentInstance = decl;
        this.beanInfo = this.env.getBeanInfo(decl.getResolvedName());
        super.visitBaseInstance(decl);
        this.beanInfo = saveInfo;
        this.currentInstance = save;
    }

    @Override
    public void visitStaticProperty(StaticProperty p) {
        if (this.doVisitStaticProperty(p)) {
            super.visitStaticProperty(p);
        }
    }

    private boolean doVisitStaticProperty(StaticProperty p) {
        if (this.beanInfo == null) {
            return true;
        }
        String sourceClassName = p.getSourceClassName();
        Set<String> names = this.getImporter().resolveName(sourceClassName);
        int offs = this.env.getTreeUtilities().positions(p).getStart();
        if (names == null) {
            this.env.addError(new ErrorMark(offs, p.getPropertyName().length(), "undefined-attached-source-class", Bundle.ERR_undefinedSourceAttachClass(sourceClassName), sourceClassName));
            return true;
        }
        if (names.size() > 1) {
            Iterator<String> it = names.iterator();
            this.env.addError(new ErrorMark(offs, p.getPropertyName().length(), "attached-source-class-ambiguous", Bundle.ERR_sourceAttachClassAmbiguous(sourceClassName, it.next(), it.next()), sourceClassName));
            return true;
        }
        String resolvedName = names.iterator().next();
        TypeElement resolvedEl = this.env.getCompilationInfo().getElements().getTypeElement(resolvedName);
        ElementHandle sourceTypeHandle = resolvedEl != null ? ElementHandle.create((Element)resolvedEl) : null;
        TypeMirrorHandle typeHandle = null;
        ElementHandle<ExecutableElement> accessorHandle = null;
        FxProperty pi = null;
        FxBean sourceInfo = this.env.getBeanInfo(resolvedName);
        if (sourceInfo == null) {
            this.env.addError(new ErrorMark(offs, p.getPropertyName().length(), "unable-analyse-class", Bundle.ERR_unableAnalyseClass(resolvedName), resolvedName));
            this.env.getAccessor().makeBroken(p);
        } else {
            String propName = p.getPropertyName();
            pi = sourceInfo.getAttachedProperty(propName);
            if (pi == null) {
                this.env.addError(new ErrorMark(offs, p.getPropertyName().length(), "attached-property-not-exist", Bundle.ERR_attachedPropertyNotExist(resolvedName, propName), resolvedName, propName));
                this.env.getAccessor().makeBroken(p);
            } else {
                accessorHandle = pi.getAccessor();
                typeHandle = pi.getType();
            }
        }
        this.env.getAccessor().resolve(p, accessorHandle, typeHandle, (ElementHandle<TypeElement>)sourceTypeHandle, pi);
        return true;
    }

    @Override
    public void visitPropertySetter(PropertySetter p) {
        if (this.beanInfo != null) {
            if (p.isImplicit()) {
                this.processDefaultProperty(p);
            } else {
                this.processInstanceProperty(p);
            }
        }
        super.visitPropertySetter(p);
    }

    private int[] findContentPositions(PropertySetter p) {
        int start = this.env.getTreeUtilities().positions(p).getStart();
        int len = 1;
        TokenSequence seq = this.env.getHierarchy().tokenSequence();
        seq.move(start);
        if (seq.moveNext()) {
            Token t = seq.token();
            if (t.id() == XMLTokenId.TEXT) {
                String tokenText = ((Object)t.text()).toString();
                String trimmed = tokenText.trim();
                int indexOfTrimmed = tokenText.indexOf(trimmed);
                int indexOfNl = trimmed.indexOf(10);
                start = seq.offset() + indexOfTrimmed;
                len = indexOfNl > -1 ? indexOfNl : trimmed.length();
            } else {
                start = seq.offset();
                len = t.length();
            }
        }
        return new int[]{start, len};
    }

    private void processDefaultProperty(PropertySetter p) {
        FxProperty pi = this.beanInfo.getDefaultProperty();
        if (pi == null) {
            if (this.beanInfo.isCollection() || this.beanInfo.isMap()) {
                return;
            }
            int[] posInfo = this.findContentPositions(p);
            this.env.addError(new ErrorMark(posInfo[0], posInfo[1], "no-default-property", Bundle.ERR_noDefaultProperty(this.beanInfo.getClassName()), this.beanInfo.getClassName()));
        } else if (p.getSourceName() == null && this.currentInstance.getProperty(pi.getName()) != null) {
            int[] posInfo = this.findContentPositions(p);
            this.env.addError(new ErrorMark(posInfo[0], posInfo[1], "default-property-clash", Bundle.ERR_defaultPropertyClash(pi.getName()), p));
            this.env.getAccessor().makeBroken(p);
        } else {
            this.env.getAccessor().resolve(p, pi.getAccessor(), pi.getType(), null, pi);
            this.env.getAccessor().rename(this.currentInstance, p, pi.getName());
        }
    }

    private boolean processInstanceProperty(PropertyValue p) {
        String propName = p.getPropertyName();
        FxProperty pi = this.beanInfo.getProperty(propName);
        if (pi == null && this.beanInfo.getBuilder() != null && (pi = this.beanInfo.getBuilder().getProperty(propName)) == null && this.beanInfo.getBuilder().isMap()) {
            return true;
        }
        int offs = this.env.getTreeUtilities().positions(p).getStart();
        if (pi == null) {
            this.env.addError(new ErrorMark(offs, propName.length(), "property-not-exist", Bundle.ERR_propertyNotExist(this.beanInfo.getClassName(), propName), this.beanInfo.getClassName(), propName));
            this.env.getAccessor().makeBroken(p);
            return false;
        }
        this.env.getAccessor().resolve(p, pi.getAccessor(), pi.getType(), null, pi);
        return true;
    }

    @Override
    public void visitMapProperty(MapProperty p) {
        if (this.beanInfo != null && this.processInstanceProperty(p) && p.getPropertyInfo().getKind() != FxDefinitionKind.MAP) {
            String propName = p.getPropertyName();
            int offs = this.env.getTreeUtilities().positions(p).getStart() + 1;
            this.env.addError(new ErrorMark(offs, propName.length(), "property-with-attributes", Bundle.ERR_propertyHasAttributes(propName), propName));
        }
        super.visitMapProperty(p);
    }

    @Override
    public FxNodeVisitor createVisitor(BuildEnvironment env) {
        return new PropertyResolver(env);
    }
}

