/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javafx2.editor.parser;

import java.net.URL;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.xml.lexer.XMLTokenId;
import org.netbeans.modules.javafx2.editor.ErrorMark;
import org.netbeans.modules.javafx2.editor.completion.model.EventHandler;
import org.netbeans.modules.javafx2.editor.completion.model.FxInclude;
import org.netbeans.modules.javafx2.editor.completion.model.FxInstance;
import org.netbeans.modules.javafx2.editor.completion.model.FxInstanceCopy;
import org.netbeans.modules.javafx2.editor.completion.model.FxModel;
import org.netbeans.modules.javafx2.editor.completion.model.FxNewInstance;
import org.netbeans.modules.javafx2.editor.completion.model.FxNode;
import org.netbeans.modules.javafx2.editor.completion.model.FxObjectBase;
import org.netbeans.modules.javafx2.editor.completion.model.FxScriptFragment;
import org.netbeans.modules.javafx2.editor.completion.model.FxXmlSymbols;
import org.netbeans.modules.javafx2.editor.completion.model.ImportDecl;
import org.netbeans.modules.javafx2.editor.completion.model.LanguageDecl;
import org.netbeans.modules.javafx2.editor.completion.model.MapProperty;
import org.netbeans.modules.javafx2.editor.completion.model.PropertySetter;
import org.netbeans.modules.javafx2.editor.completion.model.PropertyValue;
import org.netbeans.modules.javafx2.editor.completion.model.StaticProperty;
import org.netbeans.modules.javafx2.editor.completion.model.TextPositions;
import org.netbeans.modules.javafx2.editor.parser.Bundle;
import org.netbeans.modules.javafx2.editor.parser.ModelAccessor;
import org.netbeans.modules.javafx2.editor.parser.NodeInfo;
import org.netbeans.modules.javafx2.editor.sax.ContentLocator;
import org.netbeans.modules.javafx2.editor.sax.SequenceContentHandler;
import org.openide.util.Utilities;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class FxModelBuilder
implements SequenceContentHandler,
ContentLocator.Receiver {
    private URL sourceURL;
    private Deque<FxNode> nodeStack = new LinkedList<FxNode>();
    private ContentLocator contentLocator;
    private FxModel fxModel;
    private FxInstance current;
    private List<ImportDecl> imports = new ArrayList<ImportDecl>();
    private List<ErrorMark> errors = new ArrayList<ErrorMark>();
    private ModelAccessor accessor = ModelAccessor.INSTANCE;
    private String controllerName;
    private FxInstance rootComponent;
    private LanguageDecl language;
    private String tagName;
    private static final String EVENT_HANDLER_PREFIX = "on";
    private static final int EVENT_HANDLER_PREFIX_LEN = 2;
    private static final String EVENT_HANDLER_METHOD_PREFIX = "#";
    private NodeInfo definitionsNode;
    private List<FxNewInstance> instanceDefinitions = new ArrayList<FxNewInstance>();
    private int definitions;
    private boolean definitionsFound;
    private int start;
    private int end;

    public void setBaseURL(URL sourceURL) {
        this.sourceURL = sourceURL;
    }

    @Override
    public void setDocumentLocator(Locator locator) {
    }

    NodeInfo i(FxNode n) {
        return this.accessor.i(n);
    }

    private void initElement(FxNode node) {
        NodeInfo ni = this.i(node);
        ni.startAt(this.contentLocator.getElementOffset()).startContent(this.contentLocator.getEndOffset());
        ni.setTagName(this.tagName);
    }

    private void initAttribute(FxNode node, String atQName) {
        NodeInfo ni = this.i(node);
        ni.makeAttribute();
        int[] offsets = this.contentLocator.getAttributeOffsets(atQName);
        ni.startAt(offsets[0]).endsAt(offsets[1]).startContent(offsets[2]).endContent(offsets[3]);
    }

    @Override
    public void startDocument() throws SAXException {
        this.fxModel = this.accessor.newModel(this.sourceURL, this.imports, this.instanceDefinitions);
        this.initElement(this.fxModel);
        this.nodeStack.push(this.fxModel);
    }

    @Override
    public void endDocument() throws SAXException {
        this.addElementErrors();
        this.accessor.initModel(this.fxModel, this.controllerName, this.rootComponent, this.language);
        this.accessor.addDefinitions(this.fxModel, this.instanceDefinitions);
        int end = this.contentLocator.getElementOffset();
        this.i(this.fxModel).endContent(end).endsAt(end, true);
    }

    private void fixNodes(NodeInfo ni, int pos) {
        Enumeration<FxNode> en = ni.getEnclosedNodes();
        while (en.hasMoreElements()) {
            this.fixNode(this.i(en.nextElement()), pos);
        }
    }

    private void fixNode(NodeInfo ni, int pos) {
        if (ni.isDefined(TextPositions.Position.End)) {
            return;
        }
        if (ni.getEnd() == pos) {
            ni.markIncludeEnd();
            this.fixNodes(ni, pos);
        }
    }

    @Override
    public void startPrefixMapping(String prefix, String uri) throws SAXException {
    }

    @Override
    public void endPrefixMapping(String prefix) throws SAXException {
    }

    private void addAttributeError(String qName, String code, String message, Object ... params) {
        FxNode n;
        int[] offsets = this.contentLocator.getAttributeOffsets(qName);
        int s = offsets == null ? ((n = this.nodeStack.peek()) != null ? this.i(n).getStart() : -1) : offsets[0];
        this.addError(new ErrorMark(s, qName.length(), code, message, params));
    }

    private FxNewInstance handleClassTag(String localName, Attributes atts) {
        String fxValueContent = null;
        String fxFactoryContent = null;
        String fxId = null;
        boolean constant = false;
        int off = this.contentLocator.getElementOffset() + 1;
        for (int i = 0; i < atts.getLength(); ++i) {
            String uri = atts.getURI(i);
            if (!"http://javafx.com/fxml".equals(uri)) continue;
            String name = atts.getLocalName(i);
            if ("value".equals(name)) {
                fxValueContent = atts.getValue(i);
                continue;
            }
            if ("constant".equals(name)) {
                fxValueContent = atts.getValue(i);
                constant = true;
                continue;
            }
            if ("factory".equals(name)) {
                fxFactoryContent = atts.getValue(i);
                continue;
            }
            if ("id".equals(name)) {
                fxId = atts.getValue(i);
                continue;
            }
            if ("controller".equals(name)) {
                if (this.nodeStack.peek().getKind() != FxNode.Kind.Source) {
                    this.addAttributeError(atts.getQName(i), "fx-controller-permitted-on-root", Bundle.ERR_fxControllerPermittedOnRoot(localName), localName);
                    continue;
                }
                this.controllerName = atts.getValue(i);
                continue;
            }
            this.addAttributeError(atts.getQName(i), "invalid-property-reserved-name", Bundle.ERR_invalidReservedPropertyName(name), name);
        }
        FxNewInstance instance = this.accessor.createInstance(localName, fxValueContent, constant, fxFactoryContent, fxId);
        if (!FxXmlSymbols.isQualifiedIdentifier(localName)) {
            this.addError(new ErrorMark(off, localName.length(), "invalid-class-name", Bundle.ERR_tagNotJavaIdentifier(localName), localName));
            this.accessor.makeBroken(instance);
            return instance;
        }
        return instance;
    }

    private FxNode processEventHandlerAttribute(String event, String content) {
        EventHandler eh;
        if (content != null && content.startsWith(EVENT_HANDLER_METHOD_PREFIX)) {
            eh = this.accessor.asMethodRef(this.accessor.createEventHandler(event));
            this.accessor.addContent(eh, content.substring(1));
        } else {
            eh = this.accessor.createEventHandler(event);
            if (content != null && content.length() > 0) {
                this.accessor.addContent(eh, content);
            }
        }
        return eh;
    }

    private void processInstanceAttributes(Attributes atts) {
        for (int i = 0; i < atts.getLength(); ++i) {
            FxNode node;
            String uri = atts.getURI(i);
            String name = atts.getLocalName(i);
            String qname = atts.getQName(i);
            PropertySetter ps = null;
            if (qname.startsWith("xmlns")) continue;
            if ("http://javafx.com/fxml".equals(uri)) {
                if (FxXmlSymbols.isFxReservedAttribute(name)) continue;
                this.addAttributeError(qname, "error-unsupported-attribute", Bundle.ERR_unsupportedAttribute(qname, this.tagName), qname, this.tagName);
                continue;
            }
            if (!(this.current instanceof FxInstanceCopy) && !(this.current instanceof FxInclude) ? this.current instanceof FxNewInstance && ((FxNewInstance)this.current).isCustomRoot() && "type".equals(name) && uri == null : "source".equals(name) && uri == null) continue;
            if (name.startsWith(EVENT_HANDLER_PREFIX) && name.length() > 2) {
                String en = Character.toLowerCase(name.charAt(2)) + name.substring(3);
                node = this.processEventHandlerAttribute(en, atts.getValue(i));
            } else {
                int stProp = FxXmlSymbols.findStaticProperty(name);
                if (stProp == -2) {
                    this.addAttributeError(qname, "invalid-property-name", Bundle.ERR_lowercasePropertyName(name), name);
                    node = this.accessor.makeBroken(this.accessor.createProperty(name, false));
                } else {
                    node = stProp == -1 ? (ps = this.accessor.createProperty(name, false)) : (ps = this.accessor.createStaticProperty(name.substring(stProp + 1), name.substring(0, stProp)));
                }
                if (ps != null) {
                    this.accessor.addContent(ps, atts.getValue(i));
                    node = ps;
                }
            }
            this.initAttribute(node, qname);
            this.attachProperty(ps);
            this.attachChildNode(node);
        }
    }

    private FxNode handleFxmlElement(String localName, Attributes atts) {
        if ("define".equals(localName)) {
            ++this.definitions;
            if (this.definitionsFound) {
                this.addError("duplicate-definitions", Bundle.ERR_duplicateDefinitions(), new Object[0]);
            }
            FxNode n = this.accessor.createElement(localName);
            this.definitionsNode = this.accessor.i(n);
            return n;
        }
        if ("copy".equals(localName)) {
            return this.handleFxReference(atts, true);
        }
        if ("reference".equals(localName)) {
            return this.handleFxReference(atts, false);
        }
        if ("include".equals(localName)) {
            return this.handleFxInclude(atts, localName);
        }
        if ("script".equals(localName)) {
            return this.handleFxScript(atts);
        }
        if ("root".equals(localName)) {
            return this.handleFxRoot(atts);
        }
        FxNode n = this.accessor.createErrorElement(localName);
        this.initElement(n);
        this.addError("invalid-fx-element", Bundle.ERR_invalidFxElement(localName), localName);
        return n;
    }

    private FxNode handleFxRoot(Attributes atts) {
        String typeName = null;
        String fxId = null;
        for (int i = 0; i < atts.getLength(); ++i) {
            String name = atts.getLocalName(i);
            if ("type".equals(name)) {
                typeName = atts.getValue(i);
                continue;
            }
            if ("controller".equals(name)) {
                if (this.nodeStack.peek().getKind() != FxNode.Kind.Source) {
                    this.addAttributeError(atts.getQName(i), "fx-controller-permitted-on-root", Bundle.ERR_fxControllerPermittedOnRoot("root"), "root");
                    continue;
                }
                this.controllerName = atts.getValue(i);
                continue;
            }
            if (!"id".equals(name)) continue;
            fxId = atts.getValue(i);
        }
        int off = this.contentLocator.getElementOffset() + 1;
        boolean broken = false;
        if (typeName == null) {
            this.addError(new ErrorMark(off, this.contentLocator.getEndOffset() - off, "root-missing-type", Bundle.ERR_rootMissingType(), null));
            typeName = "";
            broken = true;
        } else if (!FxXmlSymbols.isQualifiedIdentifier(typeName)) {
            int len;
            int start;
            int[] offsets = this.contentLocator.getAttributeOffsets("type");
            if (offsets == null) {
                start = off;
                len = this.contentLocator.getEndOffset() - off;
            } else {
                start = offsets[0];
                len = offsets[1] - start;
            }
            this.addError(new ErrorMark(start, len, "invalid-class-name", Bundle.ERR_tagNotJavaIdentifier(typeName), typeName));
            broken = true;
        }
        FxNewInstance instance = this.accessor.createCustomRoot(typeName, fxId);
        if (broken) {
            this.accessor.makeBroken(instance);
        }
        return instance;
    }

    private FxNode handleFxScript(Attributes atts) {
        String ref = null;
        for (int i = 0; i < atts.getLength(); ++i) {
            String name = atts.getLocalName(i);
            if (!"source".equals(name)) {
                this.addAttributeError(atts.getQName(i), "invalid-script-attribute", Bundle.ERR_unexpectedScriptAttribute(name), name);
                continue;
            }
            ref = atts.getValue(i);
        }
        return this.accessor.createScript(ref);
    }

    private FxNode handleFxReference(Attributes atts, boolean copy) {
        String refId = null;
        String id = null;
        for (int i = 0; i < atts.getLength(); ++i) {
            String ns = atts.getURI(i);
            String name = atts.getLocalName(i);
            if (!"http://javafx.com/fxml".equals(ns)) {
                if ("source".equals(name) && refId == null) {
                    refId = atts.getValue(i);
                    continue;
                }
                if (copy) continue;
                this.addAttributeError(atts.getQName(i), "invalid-reference-attribute", Bundle.ERR_unexpectedReferenceAttribute(name), name);
                continue;
            }
            if ("id".equals(name) && id == null) {
                id = atts.getValue(i);
                continue;
            }
            this.addAttributeError(atts.getQName(i), "invalid-reference-attribute", Bundle.ERR_unexpectedReferenceAttribute(name), name);
        }
        FxObjectBase ref = this.accessor.createCopyReference(copy, refId);
        if (refId == null || "".equals(refId)) {
            this.addError("missing-reference-source", Bundle.ERR_missingReferenceSource(), new Object[0]);
            this.accessor.makeBroken(ref);
        }
        return ref;
    }

    private void pushInstance(FxNode instance) {
        this.nodeStack.push(instance);
        this.current = instance.getKind() == FxNode.Kind.Instance || instance.getKind() == FxNode.Kind.Include ? (FxInstance)instance : null;
    }

    private FxNode attachInstance(FxObjectBase instance) {
        String localName = instance.getSourceName();
        int off = this.contentLocator.getElementOffset() + 1;
        FxNode parent = this.nodeStack.peek();
        if (parent.getKind() == FxNode.Kind.Instance) {
            PropertySetter s = this.accessor.createProperty(null, true);
            this.i(s).startAt(this.contentLocator.getElementOffset());
            this.attachChildNode(s);
            parent = s;
        }
        if (parent.getKind() == FxNode.Kind.Source) {
            FxInstance old = this.rootComponent;
            if (old != null) {
                this.addError(new ErrorMark(off, this.contentLocator.getEndOffset() - off, "duplicate-root", Bundle.ERR_moreRootElements(localName), localName));
                this.accessor.makeBroken(instance);
            } else {
                if (!(instance instanceof FxInstance)) {
                    throw new UnsupportedOperationException();
                }
                this.rootComponent = (FxInstance)instance;
            }
        } else if (parent.getKind() == FxNode.Kind.Property) {
            if (parent instanceof MapProperty) {
                this.addError(new ErrorMark(off, this.contentLocator.getEndOffset() - off, "instance-in-map-property", Bundle.ERR_instanceInMapProperty(), localName));
                this.accessor.makeBroken(instance);
            }
        } else if (parent.getKind() == FxNode.Kind.Element && parent.getSourceName().equals("define") && instance instanceof FxNewInstance) {
            this.instanceDefinitions.add((FxNewInstance)instance);
        } else if (parent.getKind() != FxNode.Kind.Error) {
            this.addError(new ErrorMark(off, this.contentLocator.getEndOffset() - off, "parent-not-support-instance", Bundle.ERR_parentNotSupportInstance(parent.getSourceName()), new Object[0]));
            this.accessor.makeBroken(instance);
        }
        return instance;
    }

    private FxNode handleEventHandlerTag(String eventName) {
        EventHandler node = this.accessor.createEventHandler(eventName);
        FxNode parent = this.nodeStack.peek();
        if (!(parent instanceof FxInstance)) {
            this.accessor.makeBroken(node);
        }
        return node;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        FxNode newElement;
        this.tagName = localName;
        this.start = this.contentLocator.getElementOffset();
        this.end = this.contentLocator.getEndOffset();
        this.addElementErrors();
        if (uri == null && !qName.equals(localName)) {
            int prefColon = qName.indexOf(58);
            String prefix = qName.substring(0, prefColon);
            this.addError("undeclared-prefix", Bundle.ERR_undeclaredElementPrefix(prefix), new Object[0]);
            newElement = this.accessor.createErrorElement(localName);
        } else if ("".equals(localName)) {
            newElement = this.accessor.createErrorElement(localName);
        } else if ("http://javafx.com/fxml".equals(uri)) {
            newElement = this.handleFxmlElement(localName, atts);
        } else {
            String eventName = FxXmlSymbols.getEventHandlerName(localName);
            newElement = this.rootComponent == null || FxXmlSymbols.isClassTagName(localName) ? this.handleClassTag(localName, atts) : (eventName != null ? this.handleEventHandlerTag(eventName) : this.handlePropertyTag(localName, atts));
        }
        if (newElement == null) {
            throw new IllegalStateException();
        }
        this.initElement(newElement);
        FxNode newNode = newElement;
        if (!newElement.isBroken()) {
            if (newElement instanceof FxObjectBase) {
                newNode = this.attachInstance((FxObjectBase)newElement);
            } else if (newElement instanceof PropertyValue) {
                newNode = this.attachProperty((PropertyValue)newElement);
            }
        }
        this.attachChildNode(newNode);
        if (newNode.getKind() == FxNode.Kind.Instance || newNode.getKind() == FxNode.Kind.Include) {
            this.processInstanceAttributes(atts);
        }
    }

    private PropertyValue handleStaticProperty(String className, String propName, Attributes atts) {
        StaticProperty s = this.accessor.createStaticProperty(propName, className);
        return s;
    }

    private PropertyValue handleSimpleProperty(String propName, Attributes atts) {
        PropertySetter p = this.accessor.createProperty(propName, false);
        return p;
    }

    private FxNode attachProperty(PropertyValue p) {
        if (this.current == null) {
            FxNode node = this.nodeStack.peek();
            this.addError(new ErrorMark(this.start, this.end - this.start, "parent-not-accept-property", Bundle.ERR_doesNotAcceptProperty(node.getSourceName()), node));
            this.accessor.makeBroken(p);
        }
        return p;
    }

    private PropertyValue handleMapProperty(String propName, Attributes atts) {
        HashMap<String, CharSequence> contents = new HashMap<String, CharSequence>();
        for (int i = 0; i < atts.getLength(); ++i) {
            String uri = atts.getURI(i);
            if (uri != null) continue;
            contents.put(atts.getLocalName(i), atts.getValue(i));
        }
        return this.accessor.createMapProperty(propName, contents);
    }

    private FxNode handlePropertyTag(String propName, Attributes atts) {
        PropertyValue pv;
        int errorAttrs = 0;
        for (int i = 0; i < atts.getLength(); ++i) {
            String uri = atts.getURI(i);
            if (uri == null) continue;
            String qn = atts.getQName(i);
            ++errorAttrs;
            this.addAttributeError(qn, "property-namespaced-attribute", Bundle.ERR_propertyElementNamespacedAttribute(qn), qn);
        }
        int stProp = FxXmlSymbols.findStaticProperty(propName);
        switch (stProp) {
            case -1: {
                if (!Utilities.isJavaIdentifier((String)propName)) {
                    this.addError(new ErrorMark(this.start, this.end, "invalid-property-name", Bundle.ERR_invalidPropertyName(propName), propName));
                }
                if (errorAttrs == atts.getLength()) {
                    pv = this.handleSimpleProperty(propName, atts);
                    break;
                }
                pv = this.handleMapProperty(propName, atts);
                break;
            }
            case -2: {
                pv = this.accessor.makeBroken(this.accessor.createProperty(propName, false));
                this.addError(new ErrorMark(this.start, this.end, "invalid-property-name", Bundle.ERR_invalidPropertyName(propName), propName));
                break;
            }
            default: {
                pv = this.handleStaticProperty(propName.substring(0, stProp), propName.substring(stProp + 1), atts);
            }
        }
        return pv;
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        PropertySetter ps;
        String tn;
        PropertySetter s;
        this.addElementErrors();
        FxNode node = this.nodeStack.pop();
        this.i(node).endsAt(this.contentLocator.getEndOffset()).endContent(this.contentLocator.getElementOffset());
        if (node instanceof PropertySetter && (s = (PropertySetter)node).isImplicit()) {
            node = this.nodeStack.pop();
            this.i(node).endsAt(this.contentLocator.getEndOffset()).endContent(this.contentLocator.getElementOffset());
        }
        if (!(tn = node.getSourceName()).equals(localName)) {
            throw new IllegalStateException();
        }
        FxNode parentNode = this.nodeStack.peek();
        if (parentNode instanceof PropertySetter && (ps = (PropertySetter)parentNode).isImplicit() && ps.getContent() == null) {
            this.i(ps).endsAt(this.contentLocator.getEndOffset()).endContent(this.contentLocator.getEndOffset());
        }
        this.current = !this.nodeStack.isEmpty() && this.nodeStack.peek().getKind() == FxNode.Kind.Instance ? (FxInstance)this.nodeStack.peek() : null;
    }

    @Override
    public void characterSequence(CharSequence seq) {
        this.addElementErrors();
        int length = seq.length();
        FxNode node = this.nodeStack.peek();
        FxNode addedNode = null;
        switch (node.getKind()) {
            case Event: {
                addedNode = this.handleEventContent(seq);
                break;
            }
            case Instance: {
                addedNode = this.handleInstanceContent(seq);
                break;
            }
            case Property: {
                addedNode = this.handlePropertyContent(seq);
                break;
            }
            case Script: {
                addedNode = this.handleScriptContent(seq);
                break;
            }
            default: {
                this.addError(new ErrorMark(this.contentLocator.getElementOffset(), length, "unexpected-characters", Bundle.ERR_unexpectedCharacters(), new Object[0]));
            }
        }
        if (addedNode != null) {
            this.i(addedNode).endsAt(this.contentLocator.getEndOffset());
        }
    }

    private FxNode handleScriptContent(CharSequence content) {
        FxScriptFragment script = (FxScriptFragment)this.nodeStack.peek();
        if (content.length() > 0 && this.language == null) {
            this.addError("script-np-language", Bundle.ERR_scriptWithoutLanguage(), new Object[0]);
            this.accessor.makeBroken(script);
        }
        if (script.getSourcePath() != null && !script.hasContent()) {
            this.addError("script-source-and-content", Bundle.ERR_scriptHasContentAndSource(), new Object[0]);
            this.accessor.makeBroken(script);
        }
        this.accessor.addContent(script, content);
        return script;
    }

    private FxNode handleEventContent(CharSequence content) {
        EventHandler eh = (EventHandler)this.nodeStack.peek();
        if (eh.isScript() && !eh.hasContent()) {
            if (content.length() == 0) {
                throw new UnsupportedOperationException();
            }
            if (content.charAt(0) == '#') {
                content = content.subSequence(1, content.length());
                eh = this.accessor.asMethodRef(eh);
            }
        }
        this.accessor.addContent(eh, content);
        return eh;
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        System.err.println("");
    }

    private FxNode handleInstanceContent(CharSequence seq) {
        PropertySetter defaultSetter = null;
        for (PropertyValue p : this.current.getProperties()) {
            PropertySetter ps;
            if (!(p instanceof PropertySetter) || !(ps = (PropertySetter)p).isImplicit()) continue;
            defaultSetter = ps;
        }
        if (defaultSetter == null) {
            defaultSetter = this.accessor.createProperty(null, true);
            this.i(defaultSetter).startAt(this.contentLocator.getElementOffset());
            this.attachProperty(defaultSetter);
            this.attachChildNode(defaultSetter);
        }
        this.accessor.addContent(defaultSetter, seq);
        return defaultSetter;
    }

    private ErrorMark addError(String errCode, String message, Object ... params) {
        int offs = this.contentLocator.getElementOffset();
        ErrorMark m = new ErrorMark(offs, this.contentLocator.getEndOffset() - offs, errCode, message, params);
        this.addError(m);
        return m;
    }

    private FxNode handlePropertyContent(CharSequence seq) {
        FxNode node = this.nodeStack.peek();
        if (!(node instanceof PropertySetter)) {
            this.addError("unexpected-characters", Bundle.ERR_unexpectedCharacters(), new Object[0]);
            return null;
        }
        PropertySetter ps = (PropertySetter)node;
        if (!ps.getValues().isEmpty()) {
            this.addError("mixed-content-not-allowed", Bundle.ERR_mixedContentNotAllowed(), new Object[0]);
        }
        this.accessor.addContent((PropertySetter)node, seq);
        return node;
    }

    @Override
    public void ignorableWhitespaceSequence(CharSequence seq) {
        this.addElementErrors();
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
        this.start = this.contentLocator.getElementOffset();
        this.end = this.contentLocator.getEndOffset();
        this.addElementErrors();
        FxNode node = null;
        boolean broken = false;
        if (!this.isTopLevel() || this.rootComponent != null) {
            this.addError("instruction-bad-placement", Bundle.ERR_instructionBadPlacement(), new Object[0]);
            broken = true;
        }
        if ("import".equals(target)) {
            node = this.handleFxImport(data);
        } else if ("language".equals(target)) {
            node = this.handleFxLanguage(data);
        } else {
            if (target != null && target.startsWith("scenebuilder-")) {
                return;
            }
            if (!"xml".equals(target)) {
                this.handleErrorInstruction(target, data);
            }
        }
        if (node == null) {
            return;
        }
        this.i(node).makePI().startAt(this.start).endsAt(this.end);
        if (broken) {
            this.accessor.makeBroken(node);
        }
        this.attachChildNode(node);
    }

    private FxNode handleFxImport(String data) {
        if (data.endsWith("?")) {
            data = data.substring(0, data.length() - 1);
        }
        if ("".equals(data)) {
            this.addError("missing-import-identifier", Bundle.ERR_missingImportIdentifier(), new Object[0]);
            return null;
        }
        int lastDot = data.lastIndexOf(46);
        boolean starImport = false;
        if (lastDot != -1 && lastDot < data.length() - 1 && "*".equals(data.substring(lastDot + 1))) {
            starImport = true;
            data = data.substring(0, lastDot);
        }
        ImportDecl decl = this.accessor.createImport(data, starImport);
        if (!FxXmlSymbols.isQualifiedIdentifier(data)) {
            this.addAttributeError("*data", "import-not-java-identifier", Bundle.ERR_importNotJavaIdentifier(), data);
            this.accessor.makeBroken(decl);
        }
        this.imports.add(decl);
        return decl;
    }

    private FxNode handleFxInclude(Attributes atts, String localName) {
        String include = null;
        String id = null;
        for (int i = 0; i < atts.getLength(); ++i) {
            String uri = atts.getURI(i);
            String attName = atts.getLocalName(i);
            if ("source".equals(attName)) {
                include = atts.getValue(i);
                continue;
            }
            if (!"http://javafx.com/fxml".equals(uri)) continue;
            if ("id".equals(attName)) {
                id = atts.getValue(i);
                continue;
            }
            String qName = atts.getQName(i);
            this.addAttributeError(qName, "unexpected-include-attribute", Bundle.ERR_unexpectedIncludeAttribute(qName), qName);
        }
        if (include == null) {
            this.addAttributeError("*target", "missing-included-name", Bundle.ERR_missingIncludeName(), new Object[0]);
            FxNode n = this.accessor.createErrorElement(localName);
            this.initElement(n);
            this.addError("invalid-fx-element", Bundle.ERR_invalidFxElement(localName), localName);
            return n;
        }
        FxInclude fxInclude = this.accessor.createInclude(include, id);
        return fxInclude;
    }

    private FxNode handleFxLanguage(String language) {
        LanguageDecl decl = this.accessor.createLanguage(language);
        if (language == null) {
            this.addAttributeError("*target", "missing-language-name", Bundle.ERR_missingLanguageName(), new Object[0]);
            this.accessor.makeBroken(decl);
        } else if (this.language != null) {
            this.addError(new ErrorMark(this.start, this.end - this.start, "duplicate-language", Bundle.ERR_duplicateLanguageDeclaration(), this.fxModel.getLanguage()));
            this.accessor.makeBroken(decl);
        } else if (this.isTopLevel()) {
            this.language = decl;
        }
        return decl;
    }

    private boolean isTopLevel() {
        return this.nodeStack.peek() == this.fxModel;
    }

    void addElementErrors() {
        this.errors.addAll(this.contentLocator.getErrors());
    }

    void addError(ErrorMark mark) {
        this.errors.add(mark);
    }

    private void attachChildNode(FxNode node) {
        FxNode top = this.nodeStack.peek();
        this.i(top).addChild(node);
        this.accessor.attach(node, this.fxModel);
        if (!node.isBroken() && this.i(node) != this.definitionsNode) {
            this.accessor.addChild(top, node);
        }
        if (this.i(node).isElement()) {
            this.pushInstance(node);
        }
    }

    private void handleErrorInstruction(String target, String data) {
        int start = this.contentLocator.getElementOffset();
        int offset = -1;
        int piOffset = -1;
        TokenSequence<XMLTokenId> seq = this.contentLocator.getTokenSequence();
        seq.move(start);
        boolean found = false;
        block4: while (!found && seq.moveNext()) {
            Token t = seq.token();
            switch ((XMLTokenId)t.id()) {
                case PI_START: {
                    piOffset = offset;
                    if (target == null) {
                        found = true;
                    }
                }
                case WS: {
                    continue block4;
                }
            }
            offset = seq.offset();
            found = true;
        }
        ErrorMark mark = target != null ? new ErrorMark(offset, seq.token().length(), "invalid-processing-instruction", Bundle.ERR_invalidProcessingInstruction(target), target) : new ErrorMark(piOffset, seq.token().length(), "missing-processing-instruction", Bundle.ERR_missingProcessingInstruction(), new Object[0]);
        this.addError(mark);
    }

    @Override
    public void skippedEntity(String name) throws SAXException {
    }

    @Override
    public void setContentLocator(ContentLocator l) {
        this.contentLocator = l;
    }

    FxModel getModel() {
        return this.fxModel;
    }

    List<ErrorMark> getErrors() {
        return this.errors;
    }
}

