/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javafx2.editor.completion.model;

import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.openide.util.Utilities;

public final class FxXmlSymbols {
    public static final String FX_IMPORT = "import";
    public static final String FX_IMPORT_STAR = "*";
    public static final String FX_INCLUDE = "include";
    public static final String FX_DEFINITIONS = "define";
    public static final String FX_COPY = "copy";
    public static final String FX_REFERENCE = "reference";
    public static final String FX_ATTR_ID = "id";
    public static final String FX_LANGUAGE = "language";
    public static final String FX_ATTR_REFERENCE_SOURCE = "source";
    public static final String FX_ATTR_TYPE = "type";
    public static final String FX_ATTR_CONSTANT = "constant";
    public static final String FX_SCRIPT = "script";
    public static final String FX_ROOT = "root";
    public static final String FX_VALUE = "value";
    public static final String FX_ID = "id";
    public static final String FX_CONTROLLER = "controller";
    public static final String FX_FACTORY = "factory";
    public static final String NAME_VALUE_OF = "valueOf";
    public static final String SETTER_PREFIX = "set";
    public static final String SCENEBUILDER_PI_PREFIX = "scenebuilder-";
    private static final Set<String> fxReservedAttributes;

    public static boolean isClassTagName(CharSequence s) {
        if (s.length() == 0) {
            return false;
        }
        for (int i = s.length() - 1; i >= 0; --i) {
            if (s.charAt(i) != '.' || i >= s.length() - 1) continue;
            char c = s.charAt(i + 1);
            return Character.isUpperCase(c);
        }
        return Character.isUpperCase(s.charAt(0));
    }

    public static String getEventHandlerName(CharSequence s) {
        if (s.length() < 3) {
            return null;
        }
        if (s.charAt(0) != 'o' || s.charAt(1) != 'n' || !Character.isUpperCase(s.charAt(2))) {
            return null;
        }
        return Character.toLowerCase(s.charAt(2)) + ((Object)s.subSequence(3, s.length())).toString();
    }

    public static int findStaticProperty(CharSequence s) {
        boolean allIdentifiers = true;
        for (int i = s.length() - 1; allIdentifiers && i >= 0; --i) {
            char c = s.charAt(i);
            if (c == '.') {
                if (!FxXmlSymbols.isClassTagName(s.subSequence(0, i))) {
                    return -2;
                }
                if (i >= s.length() - 1) {
                    return -2;
                }
                return Character.isLowerCase(s.charAt(i + 1)) ? i : -2;
            }
            if (Character.isJavaIdentifierPart(c)) continue;
            allIdentifiers = false;
        }
        return allIdentifiers ? -1 : -2;
    }

    public CharSequence[] splitPackageAndName(CharSequence qn) {
        for (int i = qn.length() - 1; i > 0; --i) {
            if (qn.charAt(i) != '.') continue;
            return new CharSequence[]{qn.subSequence(0, i), qn.subSequence(i + 1, qn.length())};
        }
        return null;
    }

    public static boolean isQualifiedIdentifier(String qn) {
        StringTokenizer tukac = new StringTokenizer(qn, ".");
        if (!tukac.hasMoreTokens()) {
            return false;
        }
        while (tukac.hasMoreTokens()) {
            if (Utilities.isJavaIdentifier((String)tukac.nextToken())) continue;
            return false;
        }
        return true;
    }

    public static boolean isFxReservedAttribute(String fxLocalName) {
        return fxReservedAttributes.contains(fxLocalName);
    }

    static {
        HashSet<String> h = new HashSet<String>();
        h.add(FX_ATTR_CONSTANT);
        h.add("id");
        h.add(FX_VALUE);
        h.add(FX_FACTORY);
        h.add(FX_CONTROLLER);
        fxReservedAttributes = h;
    }
}

