/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javafx2.editor.completion.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.api.xml.lexer.XMLTokenId;
import org.netbeans.modules.javafx2.editor.completion.model.FxModel;
import org.netbeans.modules.javafx2.editor.completion.model.FxNode;
import org.netbeans.modules.javafx2.editor.completion.model.FxNodeVisitor;
import org.netbeans.modules.javafx2.editor.completion.model.TextPositions;
import org.netbeans.modules.javafx2.editor.parser.ModelAccessor;
import org.netbeans.modules.javafx2.editor.parser.NodeInfo;

public final class FxTreeUtilities {
    private FxModel model;
    private ModelAccessor accessor;
    private TokenHierarchy hierarchy;

    public FxTreeUtilities(ModelAccessor accessor, FxModel model, TokenHierarchy hierarchy) {
        if (accessor == null) {
            throw new IllegalArgumentException();
        }
        this.accessor = accessor;
        this.model = model;
        this.hierarchy = hierarchy;
    }

    public boolean containsPos(FxNode n, int position, boolean caret) {
        return this.accessor.i(n).contains(position, caret);
    }

    public boolean contentContainsPos(FxNode n, int position, boolean caret) {
        return this.accessor.i(n).contentContains(position, caret);
    }

    public boolean isDefined(int pos) {
        return pos != -1;
    }

    public boolean isAccurate(int pos) {
        return pos >= 0;
    }

    public int getOffset(int pos) {
        return pos >= 0 ? pos : -pos - 1;
    }

    public int getStart(FxNode n) {
        return this.accessor.i(n).getStart();
    }

    public List<? extends FxNode> findEnclosingElements(final int position, boolean ignoreTag, final boolean caret) {
        FxNode n;
        class T
        extends FxNodeVisitor.ModelTreeTraversal {
            Deque<FxNode> nodeStack = new LinkedList<FxNode>();

            T() {
            }

            @Override
            protected void scan(FxNode node) {
                super.scan(node);
            }

            @Override
            public void visitNode(FxNode node) {
                NodeInfo ni = FxTreeUtilities.this.accessor.i(node);
                if (ni.contains(position, caret)) {
                    this.nodeStack.push(node);
                    super.visitNode(node);
                }
                if (ni.getStart() > position) {
                    throw new Error();
                }
            }
        }
        T visitor = new T();
        try {
            this.model.accept(visitor);
        }
        catch (Error e) {
            // empty catch block
        }
        if (visitor.nodeStack.size() > 1 && ignoreTag && !this.accessor.i(n = visitor.nodeStack.peekFirst()).contentContains(position, caret)) {
            visitor.nodeStack.removeFirst();
        }
        if (visitor.nodeStack.isEmpty()) {
            visitor.nodeStack.add(this.model);
        }
        return Collections.unmodifiableList(new ArrayList<FxNode>(visitor.nodeStack));
    }

    public int[] findAttributePos(FxNode node, String uri, String name, boolean value) {
        NodeInfo ni = this.accessor.i(node);
        if (!ni.isElement()) {
            throw new IllegalArgumentException();
        }
        TokenSequence seq = this.hierarchy.tokenSequence();
        seq.move(ni.getStart());
        boolean state = false;
        while (seq.moveNext()) {
            Token t = seq.token();
            if (ni.isDefined(TextPositions.Position.ContentStart) && seq.offset() >= ni.getContentStart()) {
                return null;
            }
            XMLTokenId id = (XMLTokenId)t.id();
            switch (id) {
                case TAG: {
                    if (t.text().charAt(0) != '>' && seq.offset() == ni.getStart()) break;
                    return new int[]{ni.getStart(), ni.getContentStart()};
                }
                case ARGUMENT: {
                    String n = ((Object)t.text()).toString();
                    int pos = n.indexOf(58);
                    if (uri != null && pos == -1) break;
                    if (pos != -1) {
                        n = n.substring(pos + 1);
                    }
                    if (!name.equals(n)) break;
                    if (!value) {
                        return new int[]{seq.offset(), seq.offset() + t.length()};
                    }
                    state = true;
                    break;
                }
                case VALUE: {
                    if (!state) break;
                    return new int[]{seq.offset() + 1, seq.offset() + t.length() + 1};
                }
            }
        }
        return null;
    }

    public TextPositions positions(FxNode node) {
        return this.accessor.i(node);
    }

    public boolean isElement(FxNode node) {
        return this.accessor.i(node).isElement();
    }

    public boolean isAttribute(FxNode node) {
        return this.accessor.i(node).isAttribute();
    }
}

