/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javafx2.editor.completion.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.modules.javafx2.editor.completion.impl.Completer;
import org.netbeans.modules.javafx2.editor.completion.impl.CompletionContext;
import org.netbeans.modules.javafx2.editor.completion.impl.ResourcePathItem;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;

public class ResourcePathCompleter
implements Completer,
Completer.Factory {
    private boolean resourceRef;
    private CompletionContext context;
    private String valPrefix;
    private List<CompletionItem> results;
    private String extMatch;

    public ResourcePathCompleter() {
    }

    public ResourcePathCompleter(CompletionContext context, boolean resourceRef, String extMatch) {
        this.context = context;
        this.resourceRef = resourceRef;
        this.results = new ArrayList<CompletionItem>();
        this.extMatch = extMatch;
    }

    private void completeFromRoots() {
        String fileMatch;
        String folderName;
        int lastSlash = this.valPrefix.lastIndexOf(47);
        if (lastSlash == 0) {
            folderName = "";
            fileMatch = this.valPrefix.substring(1);
        } else {
            folderName = this.valPrefix.substring(1, lastSlash);
            fileMatch = this.valPrefix.substring(lastSlash + 1);
        }
        HashSet<String> names = new HashSet<String>();
        ArrayList<FileObject> files = new ArrayList<FileObject>();
        this.collectFromClasspath(this.context.getClasspathInfo().getClassPath(ClasspathInfo.PathKind.SOURCE), folderName, files, names, fileMatch, this.extMatch);
        this.collectFromClasspath(this.context.getClasspathInfo().getClassPath(ClasspathInfo.PathKind.COMPILE), folderName, files, names, fileMatch, this.extMatch);
        this.toCompletionItems(folderName, files);
    }

    private void toCompletionItems(String folderName, Collection<FileObject> files) {
        for (FileObject f : files) {
            String value;
            DataObject d;
            try {
                d = DataObject.find((FileObject)f);
            }
            catch (DataObjectNotFoundException ex) {
                continue;
            }
            String string = value = folderName == null ? f.getNameExt() : folderName + "/" + f.getNameExt();
            if (f.isFolder()) {
                value = value + "/";
            }
            if (this.resourceRef) {
                value = "@" + value;
            }
            if (this.context.isAttribute()) {
                value = "\"" + value + "\"";
            }
            ResourcePathItem item = new ResourcePathItem(d, this.context, value, null);
            this.results.add(item);
        }
    }

    private void completeMatchingFiles() {
    }

    private void completeFromCurrent() {
        String folderName;
        String fileMatch = this.valPrefix;
        FileObject fo = this.context.getSource().getFileObject();
        if (fo == null) {
            return;
        }
        String classpathDir = null;
        FileObject dir = fo.getParent();
        ClassPath srcPath = this.context.getClasspathInfo().getClassPath(ClasspathInfo.PathKind.SOURCE);
        ClassPath compilePath = this.context.getClasspathInfo().getClassPath(ClasspathInfo.PathKind.COMPILE);
        if (dir == null) {
            classpathDir = "";
        } else {
            if (srcPath != null) {
                classpathDir = srcPath.getResourceName(dir);
            }
            if (srcPath == null && compilePath != null) {
                classpathDir = srcPath.getResourceName(dir);
            }
            if (classpathDir == null) {
                return;
            }
        }
        int slash = this.valPrefix.indexOf(47);
        if (slash != -1) {
            folderName = this.valPrefix.substring(0, slash);
            fileMatch = this.valPrefix.substring(slash + 1);
            classpathDir = "".equals(classpathDir) ? folderName : classpathDir + "/" + folderName;
        } else {
            folderName = null;
        }
        HashSet<String> names = new HashSet<String>();
        ArrayList<FileObject> files = new ArrayList<FileObject>();
        this.collectFromClasspath(this.context.getClasspathInfo().getClassPath(ClasspathInfo.PathKind.SOURCE), classpathDir, files, names, fileMatch, this.extMatch);
        this.collectFromClasspath(this.context.getClasspathInfo().getClassPath(ClasspathInfo.PathKind.COMPILE), classpathDir, files, names, fileMatch, this.extMatch);
        files.remove(fo);
        this.toCompletionItems(folderName, files);
    }

    @Override
    public List<? extends CompletionItem> complete() {
        this.valPrefix = this.context.getPrefix();
        if (this.resourceRef && this.valPrefix.startsWith("@")) {
            this.valPrefix = this.valPrefix.substring(1);
        }
        HashSet names = new HashSet();
        ArrayList files = new ArrayList();
        if (this.valPrefix.startsWith("/")) {
            this.completeFromRoots();
        } else {
            this.completeFromCurrent();
        }
        return this.results;
    }

    private Collection<FileObject> collectFromClasspath(ClassPath cp, String parentDir, Collection<FileObject> result, Set<String> names, String filesMatch, String extMatch) {
        if (cp == null) {
            return result;
        }
        if (extMatch != null) {
            extMatch = extMatch.toLowerCase();
        }
        if (filesMatch != null) {
            filesMatch = filesMatch.toLowerCase();
        }
        for (ClassPath.Entry en : cp.entries()) {
            FileObject root = en.getRoot();
            FileObject dir = root.getFileObject(parentDir);
            if (dir == null) continue;
            for (FileObject f : dir.getChildren()) {
                String k;
                if (filesMatch != null && !filesMatch.isEmpty() && !f.getNameExt().toLowerCase().startsWith(filesMatch) || !f.isFolder() && extMatch != null && !extMatch.equals(f.getExt().toLowerCase()) || !names.add(k = f.getNameExt())) continue;
                result.add(f);
            }
        }
        return result;
    }

    @Override
    public boolean hasMoreItems() {
        return false;
    }

    @Override
    public Completer createCompleter(CompletionContext ctx) {
        if (ctx.getType() == CompletionContext.Type.RESOURCE_REF) {
            return new ResourcePathCompleter(ctx, true, null);
        }
        if (ctx.getType() != CompletionContext.Type.PROPERTY_VALUE) {
            return null;
        }
        if (!"source".equals(ctx.getPropertyName())) {
            return null;
        }
        String fxPrefix = ctx.findNsPrefix("http://javafx.com/fxml");
        if (fxPrefix == null) {
            return null;
        }
        String qn = ctx.getTagName();
        int prefixPos = qn.indexOf(58);
        if (prefixPos == -1) {
            return null;
        }
        String prefix = qn.substring(0, prefixPos);
        if (!fxPrefix.equals(prefix)) {
            return null;
        }
        String ln = qn.substring(prefixPos + 1);
        if (!"include".equals(ln)) {
            return null;
        }
        return new ResourcePathCompleter(ctx, false, "fxml");
    }
}

