/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javafx2.editor.completion.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.TypeMirrorHandle;
import org.netbeans.api.java.source.TypeUtilities;
import org.netbeans.modules.javafx2.editor.completion.beans.FxBean;
import org.netbeans.modules.javafx2.editor.completion.beans.FxDefinitionKind;
import org.netbeans.modules.javafx2.editor.completion.beans.FxProperty;
import org.netbeans.modules.javafx2.editor.completion.impl.CompletionContext;
import org.netbeans.modules.javafx2.editor.completion.impl.CompletionUtils;
import org.netbeans.modules.javafx2.editor.completion.impl.InstanceCompleter;
import org.netbeans.modules.javafx2.editor.completion.impl.PropertyElementItem;
import org.netbeans.modules.javafx2.editor.completion.model.FxClassUtils;
import org.netbeans.modules.javafx2.editor.completion.model.FxInstance;
import org.netbeans.modules.javafx2.editor.completion.model.FxNewInstance;
import org.netbeans.modules.javafx2.editor.completion.model.PropertyValue;
import org.netbeans.spi.editor.completion.CompletionItem;

public class PropertyCompleter
extends InstanceCompleter {
    private Set<String> existingPropNames = new HashSet<String>();
    private List<CompletionItem> resultItems = new ArrayList<CompletionItem>();
    private boolean itemsFiltered;
    private String namePrefix;
    private static final int IMPORTANT_PROPERTIES_TRESHOLD = 10;

    public PropertyCompleter() {
    }

    public PropertyCompleter(FxInstance instance, boolean attribute, CompletionContext context) {
        super(instance, attribute, context);
    }

    @Override
    public boolean hasMoreItems() {
        return this.itemsFiltered;
    }

    private void addPropertiesFrom(FxBean beanInfo, Set<String> alreadyAdded, boolean dontMark) {
        if (beanInfo == null) {
            return;
        }
        Collection<String> propNames = this.filterNames(new ArrayList<String>(this.attribute ? beanInfo.getSimplePropertyNames() : beanInfo.getPropertyNames()));
        FxBean parentInfo = beanInfo.getSuperclassInfo();
        for (String s : propNames) {
            TypeMirror tm;
            boolean propInherited;
            if (alreadyAdded.contains(s)) continue;
            FxProperty pi = beanInfo.getProperty(s);
            boolean bl = propInherited = parentInfo != null && parentInfo.getProperty(s) != null;
            if (this.existingPropNames.contains(s) && (!s.startsWith(this.namePrefix) || !this.ctx.isReplaceExisting()) || this.attribute && !pi.isSimple()) continue;
            PropertyElementItem item = new PropertyElementItem(this.ctx, s, this.attribute);
            TypeMirrorHandle typeH = pi.getType();
            if (typeH != null && (tm = typeH.resolve(this.ctx.getCompilationInfo())) != null) {
                String typeString = ((Object)this.ctx.getCompilationInfo().getTypeUtilities().getTypeName(tm, new TypeUtilities.TypeNameOptions[0])).toString();
                item.setPropertyType(typeString);
                item.setPrimitive(FxClassUtils.isSimpleType(tm, this.ctx.getCompilationInfo()));
                item.setInherited(dontMark || propInherited);
                alreadyAdded.add(s);
            }
            item.setMap(pi.getKind() == FxDefinitionKind.MAP);
            this.resultItems.add(item);
        }
    }

    private void addImportantProperties() {
        FxBean beanInfo = this.getBeanInfo();
        if (beanInfo == null) {
            return;
        }
        HashSet<String> names = new HashSet<String>();
        boolean next = false;
        do {
            this.addPropertiesFrom(beanInfo.getDeclareadInfo(), names, next);
            if (beanInfo.getBuilder() != null) {
                this.addPropertiesFrom(beanInfo.getBuilder().getDeclareadInfo(), names, next);
            }
            beanInfo = beanInfo.getSuperclassInfo();
            next = true;
        } while (beanInfo != null && this.resultItems.size() < 10);
    }

    private void init() {
        this.namePrefix = this.ctx.getPrefix();
        if (this.namePrefix.startsWith("<")) {
            this.namePrefix = this.namePrefix.substring(1);
        }
        for (PropertyValue pv : this.instance.getProperties()) {
            this.existingPropNames.add(pv.getPropertyName());
        }
    }

    public List<CompletionItem> complete() {
        this.init();
        if (this.getBeanInfo() == null) {
            return null;
        }
        HashSet<String> names = new HashSet<String>();
        if (this.ctx.getCompletionType() == 1) {
            this.addImportantProperties();
            if (this.resultItems.isEmpty()) {
                this.addPropertiesFrom(this.getBeanInfo(), names, false);
                this.addPropertiesFrom(this.getBeanInfo().getBuilder(), names, false);
            }
        } else if (this.ctx.getCompletionType() == 9) {
            this.addPropertiesFrom(this.getBeanInfo(), names, false);
            this.addPropertiesFrom(this.getBeanInfo().getBuilder(), names, false);
        }
        if (this.ctx.getType() == CompletionContext.Type.PROPERTY) {
            FxNewInstance newInst;
            PropertyElementItem pi;
            String ns = this.ctx.findNsPrefix("http://javafx.com/fxml");
            if (this.instance.getId() == null && ("id".startsWith(this.namePrefix) || ns != null && (ns + ":id").startsWith(this.namePrefix))) {
                pi = new PropertyElementItem(this.ctx, "fx:id", true);
                pi.setPrimitive(true);
                pi.setInherited(false);
                pi.setSystem(true);
                pi.setNamespaceCreator(CompletionUtils.makeFxNamespaceCreator(this.ctx));
                pi.setPropertyType("String");
                this.resultItems.add(pi);
            }
            if (this.ctx.isRootElement() && this.ctx.getModel().getController() == null && ("controller".startsWith(this.namePrefix) || ns != null && (ns + ":controller").startsWith(this.namePrefix))) {
                pi = new PropertyElementItem(this.ctx, "fx:controller", true);
                pi.setPrimitive(true);
                pi.setInherited(false);
                pi.setSystem(true);
                pi.setNamespaceCreator(CompletionUtils.makeFxNamespaceCreator(this.ctx));
                pi.setPropertyType("Class");
                this.resultItems.add(pi);
            }
            if (this.instance instanceof FxNewInstance && (newInst = (FxNewInstance)this.instance).getFactoryMethod() == null && newInst.getInitValue() == null && !newInst.getDefinition().getConstants().isEmpty()) {
                PropertyElementItem pi2 = new PropertyElementItem(this.ctx, "fx:constant", true);
                pi2.setPrimitive(true);
                pi2.setInherited(false);
                pi2.setSystem(true);
                pi2.setNamespaceCreator(CompletionUtils.makeFxNamespaceCreator(this.ctx));
                pi2.setPropertyType(newInst.getDefinition().getClassName());
                this.resultItems.add(pi2);
            }
        }
        return this.resultItems;
    }

    @Override
    protected InstanceCompleter createCompleter(FxInstance instance, boolean attribute, CompletionContext ctx) {
        return new PropertyCompleter(instance, attribute, ctx);
    }
}

