/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javafx2.editor.completion.impl;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.text.JTextComponent;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.modules.editor.java.JavaCompletionItem;
import org.netbeans.modules.javafx2.editor.completion.impl.AbstractCompletionItem;
import org.netbeans.modules.javafx2.editor.completion.impl.Completer;
import org.netbeans.modules.javafx2.editor.completion.impl.CompletionContext;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.openide.util.ImageUtilities;

public class ImportCompleter
implements Completer,
Completer.Factory {
    private static final String PI_IMPORT = "<?import ";
    private static final String PI_IMPORT2 = "import";
    private final CompletionContext ctx;
    private List<CompletionItem> results;
    private static final String IMG_INSTRUCTION = "org/netbeans/modules/javafx2/editor/resources/instruction.png";
    private static final String FMT_INSTRUCTION = "<font color=#000099>{0}</font>";

    public ImportCompleter() {
        this.ctx = null;
    }

    ImportCompleter(CompletionContext ctx) {
        this.ctx = ctx;
    }

    public boolean accepts(CompletionContext ctx) {
        if (ctx.getType() == CompletionContext.Type.INSTRUCTION_TARGET) {
            return true;
        }
        if (ctx.getType() == CompletionContext.Type.INSTRUCTION_DATA) {
            return PI_IMPORT2.equals(ctx.getPiTarget());
        }
        return ctx.getType() == CompletionContext.Type.BEAN;
    }

    @Override
    public boolean hasMoreItems() {
        return false;
    }

    private CompletionItem completeTarget() {
        String prefix = this.ctx.getPrefix();
        if (!"<?".startsWith(prefix) && !PI_IMPORT2.startsWith(prefix)) {
            return null;
        }
        return new ImportInstruction(this.ctx);
    }

    public List<CompletionItem> complete() {
        if (this.ctx.getType() == CompletionContext.Type.INSTRUCTION_TARGET || this.ctx.getType() == CompletionContext.Type.ROOT) {
            CompletionItem item = this.completeTarget();
            return item != null ? Collections.singletonList(this.completeTarget()) : null;
        }
        this.results = new ArrayList<CompletionItem>();
        Set packages = this.ctx.getClasspathInfo().getClassIndex().getPackageNames(this.ctx.getPrefix(), true, EnumSet.of(ClassIndex.SearchScope.SOURCE, ClassIndex.SearchScope.DEPENDENCIES));
        for (String s : packages) {
            this.results.add((CompletionItem)JavaCompletionItem.createPackageItem((String)s, (int)this.ctx.getCaretOffset(), (boolean)false));
        }
        return this.results;
    }

    @Override
    public Completer createCompleter(CompletionContext ctx) {
        switch (ctx.getType()) {
            case INSTRUCTION_DATA: 
            case ROOT: {
                return new ImportCompleter(ctx);
            }
            case INSTRUCTION_TARGET: {
                if (ctx.getPiTarget() != null && !PI_IMPORT2.startsWith(ctx.getPiTarget())) break;
                return new ImportCompleter(ctx);
            }
        }
        return null;
    }

    private static class ImportInstruction
    extends AbstractCompletionItem {
        private static ImageIcon ICON;

        public ImportInstruction(CompletionContext ctx) {
            super(ctx, ctx.getPrefix().isEmpty() || ctx.getPrefix().startsWith("<") ? ImportCompleter.PI_IMPORT : "import ");
        }

        @Override
        public boolean instantSubstitution(JTextComponent component) {
            this.defaultAction(component);
            return true;
        }

        @Override
        protected String getLeftHtmlText() {
            return MessageFormat.format(ImportCompleter.FMT_INSTRUCTION, ImportCompleter.PI_IMPORT2);
        }

        @Override
        protected ImageIcon getIcon() {
            if (ICON == null) {
                ICON = ImageUtilities.loadImageIcon((String)ImportCompleter.IMG_INSTRUCTION, (boolean)false);
            }
            return ICON;
        }

        public String toString() {
            return this.getSubstituteText();
        }
    }
}

