/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javafx2.editor.completion.impl;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.KeyEvent;
import javax.swing.ImageIcon;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.javafx2.editor.completion.impl.CompletionContext;
import org.netbeans.spi.editor.completion.CompletionItem;
import org.netbeans.spi.editor.completion.CompletionTask;
import org.netbeans.spi.editor.completion.support.CompletionUtilities;
import org.openide.util.Exceptions;

abstract class AbstractCompletionItem
implements CompletionItem {
    private final int substOffset;
    private final int length;
    private final String text;
    protected final CompletionContext ctx;
    private Position substPos;

    protected AbstractCompletionItem(CompletionContext ctx, String text) {
        this.substOffset = ctx.getStartOffset();
        this.length = ctx.getReplaceLength();
        this.text = text;
        this.ctx = ctx;
    }

    protected AbstractCompletionItem(int offset, int len, String text) {
        this.substOffset = offset;
        this.length = len;
        this.text = text;
        this.ctx = null;
    }

    protected int getStartOffset() {
        return this.substOffset;
    }

    protected int getLength() {
        return this.length;
    }

    public void defaultAction(JTextComponent component) {
        this.substituteText(component, this.getSubstituteText());
    }

    protected String getSubstituteText() {
        return this.text;
    }

    protected int getCaretShift(Document d) {
        return this.getSubstituteText().length();
    }

    public int getSubstOffset() {
        if (this.substPos != null) {
            return this.substPos.getOffset();
        }
        return this.substOffset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void substituteText(JTextComponent c, String text) {
        Document d = c.getDocument();
        BaseDocument bd = (BaseDocument)d;
        bd.extWriteLock();
        try {
            this.substPos = bd.createPosition(this.substOffset);
            this.doSubstituteText(c, bd, text);
        }
        catch (BadLocationException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        finally {
            bd.extWriteUnlock();
        }
    }

    protected void doSubstituteText(JTextComponent c, BaseDocument d, String text) throws BadLocationException {
        int offset = this.getSubstOffset();
        String old = d.getText(offset, this.length);
        int nextOffset = this.ctx.getNextCaretPos();
        Position p = null;
        if (nextOffset >= 0) {
            p = d.createPosition(nextOffset);
        }
        if (text.equals(old)) {
            if (p != null) {
                c.setCaretPosition(p.getOffset());
            } else {
                c.setCaretPosition(offset + this.getCaretShift((Document)d));
            }
        } else {
            d.remove(offset, this.length);
            d.insertString(offset, text, null);
            if (p != null) {
                c.setCaretPosition(p.getOffset());
            } else {
                c.setCaretPosition(offset + this.getCaretShift((Document)d));
            }
        }
    }

    public void processKeyEvent(KeyEvent evt) {
    }

    public int getPreferredWidth(Graphics g, Font defaultFont) {
        return CompletionUtilities.getPreferredWidth((String)this.getLeftHtmlText(), (String)this.getRightHtmlText(), (Graphics)g, (Font)defaultFont);
    }

    protected String getLeftHtmlText() {
        return this.text;
    }

    protected String getRightHtmlText() {
        return null;
    }

    protected ImageIcon getIcon() {
        return null;
    }

    public void render(Graphics g, Font defaultFont, Color defaultColor, Color backgroundColor, int width, int height, boolean selected) {
        CompletionUtilities.renderHtml((ImageIcon)this.getIcon(), (String)this.getLeftHtmlText(), (String)this.getRightHtmlText(), (Graphics)g, (Font)defaultFont, (Color)defaultColor, (int)width, (int)height, (boolean)selected);
    }

    public CompletionTask createDocumentationTask() {
        return null;
    }

    public CompletionTask createToolTipTask() {
        return null;
    }

    public boolean instantSubstitution(JTextComponent component) {
        return false;
    }

    public int getSortPriority() {
        return -1;
    }

    public CharSequence getSortText() {
        return this.text;
    }

    public CharSequence getInsertPrefix() {
        return this.text;
    }
}

