/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javafx2.editor.completion.beans;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.WildcardType;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Types;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.TypeMirrorHandle;
import org.netbeans.modules.javafx2.editor.completion.beans.BuilderResolver;
import org.netbeans.modules.javafx2.editor.completion.beans.FxBean;
import org.netbeans.modules.javafx2.editor.completion.beans.FxBeanCache;
import org.netbeans.modules.javafx2.editor.completion.beans.FxBeanProvider;
import org.netbeans.modules.javafx2.editor.completion.beans.FxDefinitionKind;
import org.netbeans.modules.javafx2.editor.completion.beans.FxEvent;
import org.netbeans.modules.javafx2.editor.completion.beans.FxProperty;
import org.netbeans.modules.javafx2.editor.completion.model.FxClassUtils;

public final class BeanModelBuilder {
    private final CompilationInfo compilationInfo;
    private final String className;
    private Set<String> dependencies = Collections.emptySet();
    private Map<String, FxProperty> allProperties = Collections.emptyMap();
    private Map<String, FxProperty> staticProperties = Collections.emptyMap();
    private Map<String, FxProperty> simpleProperties = Collections.emptyMap();
    private Map<String, TypeMirrorHandle> factoryMethods = Collections.emptyMap();
    private FxBean resultInfo;
    private Set<String> constants = Collections.emptySet();
    @NullAllowed
    private TypeElement classElement;
    private FxBeanProvider provider;
    private boolean builder;
    private static final String SET_NAME_PREFIX = "set";
    private static final int SET_NAME_PREFIX_LEN = 3;
    private static final String GET_NAME_PREFIX = "get";
    private static final int GET_NAME_PREFIX_LEN = 3;
    private boolean consumed;
    private Collection<ExecutableElement> getters = new ArrayList<ExecutableElement>();
    private static final String LIST_CLASS = "java.util.List";
    private static final String MAP_CLASS = "java.util.Map";
    private static final String EVENT_TYPE_NAME = "javafx.event.Event";
    private ElementHandle<TypeElement> eventHandle;
    private ExecutableElement mapGetMethod = null;
    private ExecutableElement listGetMethod = null;
    private static final String EVENT_PREFIX = "setOn";
    private static final int EVENT_PREFIX_LEN = 5;
    private static final String ANNOTATION_TYPE_FXML = "javax.fxml.beans.FXML";
    private static final String JAVAFX_EVENT_BASE = "javafx.event.EventHandler";
    private TypeMirror eventHandlerBase;
    private Map<String, FxEvent> events = Collections.emptyMap();
    private FxBeanCache beanCache;
    private Map<String, ElementHandle<ExecutableElement>> observableAccessors = new HashMap<String, ElementHandle<ExecutableElement>>();
    private static final String JAVA_LANG_OBJECT = "java.lang.Object";
    private FxBean superBi;

    public BeanModelBuilder(FxBeanProvider provider, CompilationInfo compilationInfo, String className) {
        this.compilationInfo = compilationInfo;
        this.className = className;
        this.provider = provider;
    }

    private void addDependency(TypeMirror tm) {
        if (tm.getKind() == TypeKind.ARRAY) {
            this.addDependency(((ArrayType)tm).getComponentType());
        } else if (tm.getKind() == TypeKind.WILDCARD) {
            WildcardType wt = (WildcardType)tm;
            TypeMirror bound = wt.getSuperBound();
            if (bound == null) {
                bound = wt.getExtendsBound();
            }
            this.addDependency(bound);
        } else if (tm.getKind() == TypeKind.DECLARED) {
            this.addDependency(((TypeElement)this.compilationInfo.getTypes().asElement(tm)).getQualifiedName().toString());
        }
    }

    private void addDependency(String name) {
        if (this.dependencies.isEmpty()) {
            this.dependencies = new HashSet<String>();
        }
        this.dependencies.add(name);
    }

    FxBean process() {
        Types t;
        boolean valueOf;
        this.classElement = this.compilationInfo.getElements().getTypeElement(this.className);
        TypeElement builderEl = this.compilationInfo.getElements().getTypeElement("javafx.util.Builder");
        TypeElement mapEl = this.compilationInfo.getElements().getTypeElement(MAP_CLASS);
        TypeElement collectionEl = this.compilationInfo.getElements().getTypeElement("java.util.Collection");
        if (this.classElement == null) {
            this.resultInfo = null;
            return null;
        }
        if (builderEl != null) {
            Types t2 = this.compilationInfo.getTypes();
            this.builder = t2.isAssignable(t2.erasure(this.classElement.asType()), t2.erasure(builderEl.asType()));
        }
        boolean fxInstance = true;
        boolean bl = valueOf = FxClassUtils.findValueOf(this.classElement, this.compilationInfo) != null;
        if (!this.classElement.getModifiers().contains((Object)Modifier.PUBLIC)) {
            fxInstance = false;
        } else {
            boolean found = false;
            for (ExecutableElement c : ElementFilter.constructorsIn(this.classElement.getEnclosedElements())) {
                if (!c.getParameters().isEmpty() || !FxClassUtils.isFxmlAccessible(c)) continue;
                found = true;
                break;
            }
            fxInstance = found ? true : valueOf;
        }
        FxBean declared = this.resultInfo = new FxBean(this.className);
        this.resultInfo.setJavaType((ElementHandle<TypeElement>)ElementHandle.create((Element)this.classElement));
        this.resultInfo.setFxInstance(fxInstance);
        this.resultInfo.setValueOf(valueOf);
        if (mapEl != null && (t = this.compilationInfo.getTypes()).isAssignable(t.erasure(this.classElement.asType()), t.erasure(mapEl.asType()))) {
            this.resultInfo.makeMap();
        }
        if (collectionEl != null && (t = this.compilationInfo.getTypes()).isAssignable(t.erasure(this.classElement.asType()), t.erasure(collectionEl.asType()))) {
            this.resultInfo.makeCollection();
        }
        this.inspectMembers();
        this.resultInfo.setProperties(this.allProperties);
        this.resultInfo.setSimpleProperties(this.simpleProperties);
        this.resultInfo.setAttachedProperties(this.staticProperties);
        this.resultInfo.setEvents(this.events);
        this.resultInfo.setFactories(this.factoryMethods);
        this.resultInfo.setConstants(this.constants);
        String defaultProperty = FxClassUtils.getDefaultProperty(this.classElement);
        this.resultInfo.setDefaultPropertyName(defaultProperty);
        FxBean merge = new FxBean(this.className);
        merge.setJavaType(this.resultInfo.getJavaType());
        merge.setValueOf(this.resultInfo.hasValueOf());
        merge.setFxInstance(this.resultInfo.isFxInstance());
        merge.setDeclaredInfo(this.resultInfo);
        merge.setFactories(this.factoryMethods);
        this.resultInfo = merge;
        this.findBuilder();
        if (this.classElement.getKind() == ElementKind.CLASS) {
            this.collectSuperClass(this.classElement.getSuperclass());
        }
        this.resultInfo.setParentBeanInfo(this.superBi);
        this.resultInfo.merge(declared);
        this.resultInfo.setConstants(this.constants);
        if (this.beanCache != null) {
            this.beanCache.addBeanInfo(this.compilationInfo.getClasspathInfo(), this.resultInfo, this.dependencies);
        }
        return this.resultInfo;
    }

    private void findBuilder() {
        if (this.classElement.getNestingKind() != NestingKind.TOP_LEVEL || this.builder) {
            return;
        }
        Collection resolvers = MimeLookup.getLookup((String)"text/x-fxml+xml").lookupAll(BuilderResolver.class);
        for (BuilderResolver r : resolvers) {
            FxBean builderBean;
            String builderName = r.findBuilderClass(this.compilationInfo, null, this.className);
            if (builderName == null || (builderBean = this.provider.getBeanInfo(builderName)) == null) continue;
            this.resultInfo.setBuilder(builderBean);
            builderBean.makeBuilder(this.resultInfo);
            return;
        }
    }

    public FxBean getBeanInfo() {
        if (this.resultInfo == null) {
            this.process();
        }
        return this.resultInfo;
    }

    TypeElement getClassElement() {
        return this.classElement;
    }

    private String getPropertyName(String setterName) {
        return Character.toLowerCase(setterName.charAt(3)) + setterName.substring(4);
    }

    private void addCandidateROProperty(ExecutableElement m) {
        if (this.consumed) {
            return;
        }
        String name = m.getSimpleName().toString();
        if (name.length() > 3 && name.startsWith(GET_NAME_PREFIX)) {
            String n = this.getPropertyName(name);
            if (m.getParameters().isEmpty()) {
                this.getters.add(m);
            }
        }
    }

    private void processGetters() {
        TypeMirror listType = this.compilationInfo.getElements().getTypeElement(LIST_CLASS).asType();
        TypeMirror mapType = this.compilationInfo.getElements().getTypeElement(MAP_CLASS).asType();
        for (ExecutableElement m : this.getters) {
            String n = this.getPropertyName(m.getSimpleName().toString());
            if (this.allProperties.containsKey(n)) continue;
            TypeMirror retType = m.getReturnType();
            TypeMirror erasure = this.compilationInfo.getTypes().erasure(retType);
            if (this.compilationInfo.getTypes().isAssignable(erasure, listType)) {
                this.addListProperty(m, n);
                continue;
            }
            if (!this.compilationInfo.getTypes().isAssignable(erasure, mapType)) continue;
            this.addMapProperty(m, n);
        }
    }

    private ElementHandle<TypeElement> getPropertyChangeHandle() {
        if (this.eventHandle == null) {
            this.eventHandle = ElementHandle.create((Element)this.compilationInfo.getElements().getTypeElement(EVENT_TYPE_NAME));
        }
        return this.eventHandle;
    }

    private void generatePropertyChanges() {
        for (FxProperty p : this.allProperties.values()) {
            if (p.getObservableAccessor() == null) continue;
            String evName = p.getName() + "Change";
            FxEvent ev = new FxEvent(evName);
            ev.setPropertyChange(true);
            ev.setEventClassName(EVENT_TYPE_NAME);
            ev.setEventType(this.getPropertyChangeHandle());
            this.addEvent(ev);
        }
    }

    private void addAttachedProperty(ExecutableElement m) {
        if (this.consumed) {
            return;
        }
        String name = m.getSimpleName().toString();
        if (!name.startsWith(SET_NAME_PREFIX) || name.length() == 3 || !Character.isUpperCase(name.charAt(3))) {
            return;
        }
        if (!this.isStatic(m)) {
            return;
        }
        if (m.getParameters().size() != 2) {
            return;
        }
        TypeMirror objectType = m.getParameters().get(0).asType();
        TypeMirror paramType = m.getParameters().get(1).asType();
        boolean simple = FxClassUtils.isSimpleType(paramType, this.compilationInfo);
        this.addDependency(paramType);
        FxProperty pi = new FxProperty(this.getPropertyName(name), FxDefinitionKind.ATTACHED);
        pi.setSimple(simple);
        pi.setType(TypeMirrorHandle.create((TypeMirror)paramType));
        pi.setAccessor((ElementHandle<ExecutableElement>)ElementHandle.create((Element)m));
        pi.setObjectType(TypeMirrorHandle.create((TypeMirror)objectType));
        if (this.staticProperties.isEmpty()) {
            this.staticProperties = new HashMap<String, FxProperty>();
        }
        this.staticProperties.put(pi.getName(), pi);
        this.consumed = true;
    }

    private ExecutableType findMapGetMethod(DeclaredType inType) {
        TypeElement mapClass = this.compilationInfo.getElements().getTypeElement(MAP_CLASS);
        if (this.mapGetMethod == null) {
            for (ExecutableElement mm : ElementFilter.methodsIn(mapClass.getEnclosedElements())) {
                if (!mm.getSimpleName().toString().equals(GET_NAME_PREFIX)) continue;
                this.mapGetMethod = mm;
            }
        }
        return (ExecutableType)this.compilationInfo.getTypes().asMemberOf(inType, this.mapGetMethod);
    }

    private ExecutableType findListGetMethod(DeclaredType inType) {
        TypeElement mapClass = this.compilationInfo.getElements().getTypeElement(LIST_CLASS);
        if (this.listGetMethod == null) {
            for (ExecutableElement mm : ElementFilter.methodsIn(mapClass.getEnclosedElements())) {
                if (!mm.getSimpleName().toString().equals(GET_NAME_PREFIX)) continue;
                this.listGetMethod = mm;
            }
        }
        return (ExecutableType)this.compilationInfo.getTypes().asMemberOf(inType, this.listGetMethod);
    }

    private void addMapProperty(ExecutableElement m, String propName) {
        FxProperty pi = new FxProperty(propName, FxDefinitionKind.MAP);
        pi.setSimple(false);
        pi.setAccessor((ElementHandle<ExecutableElement>)ElementHandle.create((Element)m));
        DeclaredType t = (DeclaredType)m.getReturnType();
        ExecutableType getterType = this.findMapGetMethod(t);
        pi.setType(TypeMirrorHandle.create((TypeMirror)getterType.getReturnType()));
        pi.setObservableAccessors(pi.getAccessor());
        this.registerProperty(pi);
    }

    private void addListProperty(ExecutableElement m, String propName) {
        FxProperty pi = new FxProperty(propName, FxDefinitionKind.LIST);
        pi.setSimple(false);
        pi.setAccessor((ElementHandle<ExecutableElement>)ElementHandle.create((Element)m));
        DeclaredType t = (DeclaredType)m.getReturnType();
        ExecutableType getterType = this.findListGetMethod(t);
        pi.setType(TypeMirrorHandle.create((TypeMirror)getterType.getReturnType()));
        pi.setObservableAccessors(pi.getAccessor());
        this.registerProperty(pi);
    }

    private void addObservableAccessor(ExecutableElement m) {
        if (this.consumed) {
            return;
        }
        String mName = m.getSimpleName().toString();
        if (!mName.endsWith("Property")) {
            return;
        }
        mName = mName.substring(0, mName.length() - 8);
        this.observableAccessors.put(mName, (ElementHandle<ExecutableElement>)ElementHandle.create((Element)m));
    }

    private void markObservableProperties() {
        for (FxProperty prop : this.allProperties.values()) {
            String n = prop.getName();
            ElementHandle<ExecutableElement> m = this.observableAccessors.get(n);
            prop.setObservableAccessors(m);
        }
    }

    protected String findPropertyName(ExecutableElement m) {
        String name = m.getSimpleName().toString();
        if (!(this.builder || name.startsWith(SET_NAME_PREFIX) && name.length() != 3 && Character.isUpperCase(name.charAt(3)))) {
            return null;
        }
        if (m.getParameters().size() != 1) {
            return null;
        }
        if (this.builder) {
            StringBuilder sb = new StringBuilder();
            sb.append(Character.toLowerCase(name.charAt(0)));
            if (name.length() > 1) {
                sb.append(name.substring(1));
            }
            return this.compilationInfo.getTypes().isAssignable(m.getReturnType(), m.getEnclosingElement().asType()) ? sb.toString() : null;
        }
        return m.getReturnType().getKind() == TypeKind.VOID ? this.getPropertyName(name.toString()) : null;
    }

    private void addProperty(ExecutableElement m) {
        if (this.consumed) {
            return;
        }
        String name = this.findPropertyName(m);
        if (name == null) {
            return;
        }
        this.registerProperty(m, name);
    }

    private void registerProperty(ExecutableElement m, String name) {
        TypeMirror paramType = m.getParameters().get(0).asType();
        boolean simple = FxClassUtils.isSimpleType(paramType, this.compilationInfo);
        this.addDependency(paramType);
        FxProperty pi = new FxProperty(name, FxDefinitionKind.SETTER);
        pi.setSimple(simple);
        pi.setType(TypeMirrorHandle.create((TypeMirror)paramType));
        pi.setAccessor((ElementHandle<ExecutableElement>)ElementHandle.create((Element)m));
        this.registerProperty(pi);
        if (simple) {
            if (this.simpleProperties.isEmpty()) {
                this.simpleProperties = new HashMap<String, FxProperty>();
            }
            this.simpleProperties.put(pi.getName(), pi);
        }
        this.consumed = true;
    }

    private void registerProperty(FxProperty pi) {
        if (this.allProperties.isEmpty()) {
            this.allProperties = new HashMap<String, FxProperty>();
        }
        this.allProperties.put(pi.getName(), pi);
    }

    private void addFactoryMethod(ExecutableElement m) {
        if (this.consumed) {
            return;
        }
        if (!this.isStatic(m)) {
            return;
        }
        if (!m.getParameters().isEmpty()) {
            return;
        }
        TypeMirrorHandle returnType = TypeMirrorHandle.create((TypeMirror)m.getReturnType());
        if (this.factoryMethods.isEmpty()) {
            this.factoryMethods = new HashMap<String, TypeMirrorHandle>();
        }
        this.factoryMethods.put(m.getSimpleName().toString(), returnType);
        this.consumed = true;
    }

    private boolean isStatic(ExecutableElement m) {
        return m.getModifiers().contains((Object)Modifier.STATIC);
    }

    private boolean isAccessible(Element m) {
        if (!m.getModifiers().contains((Object)Modifier.PUBLIC)) {
            for (AnnotationMirror annotationMirror : m.getAnnotationMirrors()) {
                String atype = ((TypeElement)annotationMirror.getAnnotationType().asElement()).getQualifiedName().toString();
                if (!ANNOTATION_TYPE_FXML.equals(atype)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private boolean isAccessible(ExecutableElement m, boolean classMethod) {
        return this.isAccessible(m) && m.getModifiers().contains((Object)Modifier.STATIC) == classMethod;
    }

    private TypeMirror getHandlerBaseType() {
        if (this.eventHandlerBase == null) {
            TypeElement el = this.compilationInfo.getElements().getTypeElement(JAVAFX_EVENT_BASE);
            if (el == null) {
                throw new IllegalStateException();
            }
            this.eventHandlerBase = el.asType();
        }
        return this.eventHandlerBase;
    }

    private void addEventSource(ExecutableElement m) {
        if (this.consumed) {
            return;
        }
        String sn = m.getSimpleName().toString();
        if (!this.isAccessible(m, false)) {
            return;
        }
        if (!sn.startsWith(EVENT_PREFIX) || sn.length() == 5) {
            return;
        }
        if (m.getParameters().size() != 1) {
            return;
        }
        VariableElement param = m.getParameters().get(0);
        TypeMirror varType = param.asType();
        if (this.compilationInfo.getTypes().isAssignable(varType, this.getHandlerBaseType())) {
            return;
        }
        ElementHandle eventHandle = null;
        String eventClassName = null;
        if (varType.getKind() == TypeKind.DECLARED) {
            DeclaredType dt = (DeclaredType)varType;
            List<? extends TypeMirror> tParams = dt.getTypeArguments();
            if (tParams.size() != 1) {
                return;
            }
            TypeMirror eventType = tParams.get(0);
            if (eventType.getKind() == TypeKind.WILDCARD) {
                TypeMirror t = ((WildcardType)eventType).getSuperBound();
                if (t == null) {
                    t = ((WildcardType)eventType).getExtendsBound();
                }
                eventType = t;
            }
            if (eventType.getKind() != TypeKind.DECLARED) {
                throw new IllegalStateException();
            }
            TypeElement te = (TypeElement)this.compilationInfo.getTypes().asElement(eventType);
            eventClassName = te.getQualifiedName().toString();
            eventHandle = ElementHandle.create((Element)te);
            this.addDependency(eventType);
        }
        String eventName = Character.toLowerCase(sn.charAt(5)) + sn.substring(6);
        FxEvent ei = new FxEvent(eventName);
        ei.setEventClassName(eventClassName);
        ei.setEventType(eventHandle);
        this.addEvent(ei);
        this.consumed = true;
    }

    private void addEvent(FxEvent ei) {
        if (this.events.isEmpty()) {
            this.events = new HashMap<String, FxEvent>();
        }
        this.events.put(ei.getName(), ei);
    }

    private void inspectMembers() {
        List<ExecutableElement> methods = ElementFilter.methodsIn(this.classElement.getEnclosedElements());
        for (ExecutableElement m : methods) {
            if (!this.isAccessible(m)) continue;
            this.consumed = false;
            this.addEventSource(m);
            this.addProperty(m);
            this.addFactoryMethod(m);
            this.addAttachedProperty(m);
            this.addCandidateROProperty(m);
            this.addObservableAccessor(m);
        }
        this.processGetters();
        this.markObservableProperties();
        this.generatePropertyChanges();
        List<VariableElement> vars = ElementFilter.fieldsIn(this.classElement.getEnclosedElements());
        for (VariableElement v : vars) {
            if (!this.isAccessible(v)) continue;
            this.consumed = false;
            this.addConstant(v);
        }
    }

    void setBeanCache(FxBeanCache beanCache) {
        this.beanCache = beanCache;
    }

    private void collectSuperClass(TypeMirror superT) {
        if (superT == null) {
            return;
        }
        TypeElement elem = (TypeElement)this.compilationInfo.getTypes().asElement(superT);
        String fqn = elem.getQualifiedName().toString();
        if (JAVA_LANG_OBJECT.equals(fqn)) {
            return;
        }
        this.addDependency(fqn);
        this.superBi = null;
        if (this.beanCache != null) {
            this.superBi = this.beanCache.getBeanInfo(this.compilationInfo.getClasspathInfo(), fqn);
        }
        if (this.superBi == null) {
            this.superBi = this.provider.getBeanInfo(fqn);
        }
        this.resultInfo.merge(this.superBi);
    }

    private void addConstant(VariableElement v) {
        Set<Modifier> mods = v.getModifiers();
        if (!mods.contains((Object)Modifier.FINAL) || !mods.contains((Object)Modifier.STATIC)) {
            return;
        }
        boolean ok = false;
        if (!this.compilationInfo.getTypes().isSameType(v.asType(), this.classElement.asType())) {
            TypeMirror t = v.asType();
            if (t instanceof PrimitiveType) {
                PrimitiveType p = (PrimitiveType)t;
                if (this.compilationInfo.getTypes().isSameType(this.compilationInfo.getTypes().boxedClass(p).asType(), this.classElement.asType())) {
                    ok = true;
                }
            }
            if (!ok) {
                return;
            }
        }
        this.addConstant(v.getSimpleName().toString());
    }

    private void addConstant(String s) {
        if (this.constants.isEmpty()) {
            this.constants = new HashSet<String>();
        }
        this.constants.add(s);
    }
}

