/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javafx2.editor.actions;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import java.util.StringTokenizer;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.modules.java.source.parsing.ClasspathInfoProvider;
import org.netbeans.modules.javafx2.editor.actions.Bundle;
import org.netbeans.modules.javafx2.editor.completion.model.FxModel;
import org.netbeans.modules.javafx2.editor.completion.model.FxXmlSymbols;
import org.netbeans.modules.javafx2.editor.completion.model.FxmlParserResult;
import org.netbeans.modules.parsing.api.ParserManager;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Source;
import org.netbeans.modules.parsing.api.UserTask;
import org.netbeans.modules.parsing.spi.ParseException;
import org.netbeans.modules.parsing.spi.Parser;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.util.Utilities;

class ControllerFileMaker {
    private DataObject context;
    private DataObject controllerFile;
    private String controllerClassName;
    private boolean hasControllerName;
    private static final String TEMPLATE_PATH = "Templates/javafx/FXMLController.java";

    public ControllerFileMaker(DataObject context) {
        this.context = context;
    }

    public String getControllerClassName() {
        return this.controllerClassName;
    }

    public boolean hasControllerName() {
        return this.hasControllerName;
    }

    DataObject getControllerFile() throws IOException {
        DataFolder targetFolder;
        String packageName;
        String fname;
        Source s = Source.create((FileObject)this.context.getPrimaryFile());
        final DataObject[] result = new DataObject[1];
        final ClasspathInfo cpInfo = ClasspathInfo.create((FileObject)this.context.getPrimaryFile());
        try {
            ParserManager.parse(Collections.singleton(s), (UserTask)new UserTask(){

                public void run(ResultIterator resultIterator) throws Exception {
                    final FxmlParserResult fxResult = FxmlParserResult.get(resultIterator.getParserResult());
                    if (fxResult == null) {
                        throw new IllegalStateException();
                    }
                    FxModel m = fxResult.getSourceModel();
                    if (m == null || m.getRootComponent() == null) {
                        return;
                    }
                    ControllerFileMaker.this.controllerClassName = m.getController();
                    if (ControllerFileMaker.this.controllerClassName == null) {
                        return;
                    }
                    ControllerFileMaker.this.hasControllerName = true;
                    ElementHandle<TypeElement> type = m.getControllerType();
                    if (type != null) {
                        ControllerFileMaker.this.controllerClassName = type.getQualifiedName();
                        FileObject target = SourceUtils.getFile(type, (ClasspathInfo)cpInfo);
                        if (target == null) {
                            throw new ParseException(Bundle.ERR_controllerSourceNotFound());
                        }
                        if (FileUtil.getArchiveFile((FileObject)target) != null) {
                            throw new ParseException(Bundle.ERR_controllerInLibrary());
                        }
                        try {
                            result[0] = DataObject.find((FileObject)target);
                        }
                        catch (IOException ex) {
                            throw new ParseException(Bundle.ERR_controllerSourceFailure(), (Throwable)ex);
                        }
                    } else {
                        if (!FxXmlSymbols.isQualifiedIdentifier(ControllerFileMaker.this.controllerClassName)) {
                            throw new ParseException(Bundle.ERR_controllerClassNotValid());
                        }
                        class UT
                        extends UserTask
                        implements ClasspathInfoProvider {
                            UT() {
                            }

                            public void run(ResultIterator resultIterator) throws Exception {
                                CompilationInfo info = CompilationInfo.get((Parser.Result)resultIterator.getParserResult());
                                Set<String> names = fxResult.resolveClassName(info, ControllerFileMaker.this.controllerClassName);
                                if (names != null) {
                                    throw new ParseException(Bundle.ERR_controllerClassAmbiguous());
                                }
                            }

                            public ClasspathInfo getClasspathInfo() {
                                return cpInfo;
                            }
                        }
                        ParserManager.parse((String)"text/x-java", (UserTask)new UT());
                    }
                }
            });
        }
        catch (ParseException ex) {
            Throwable cause = ex.getCause() == ex ? ex : ex.getCause();
            NotifyDescriptor nd = new NotifyDescriptor((Object)cause.getLocalizedMessage(), Bundle.TITLE_makeController(), -1, 2, new Object[]{NotifyDescriptor.OK_OPTION}, null);
            DialogDisplayer.getDefault().notifyLater(nd);
            return null;
        }
        if (result[0] != null) {
            return result[0];
        }
        ClassPath cp = cpInfo.getClassPath(ClasspathInfo.PathKind.SOURCE);
        FileObject root = cp.findOwnerRoot(this.context.getPrimaryFile());
        if (root == null) {
            throw new UnsupportedOperationException();
        }
        String cn = this.controllerClassName;
        if (cn == null) {
            fname = Bundle.FMT_controllerClassName(ControllerFileMaker.capitalize(this.context.getName()));
            String resName = cp.getResourceName(this.context.getPrimaryFile().getParent());
            packageName = resName.replaceAll("/", ".");
            targetFolder = this.context.getFolder();
        } else {
            int dot = cn.lastIndexOf(46);
            if (dot == -1) {
                fname = cn;
                String resName = cp.getResourceName(this.context.getPrimaryFile().getParent());
                packageName = resName.replaceAll("/", ".");
                targetFolder = this.context.getFolder();
            } else {
                packageName = cn.substring(0, dot);
                fname = cn.substring(dot + 1);
                String folderName = packageName.replaceAll("\\.", "/");
                FileObject folder = root.getFileObject(folderName);
                if (folder == null || folder.isData()) {
                    folder = FileUtil.createFolder((FileObject)root, (String)folderName);
                }
                targetFolder = DataFolder.findFolder((FileObject)folder);
            }
        }
        if (!ControllerFileMaker.isValidPackageName(packageName)) {
            throw new UnsupportedOperationException("handle invalid package");
        }
        this.controllerClassName = packageName != null && !"".equals(packageName) ? packageName + "." + fname : fname;
        FileObject templateF = FileUtil.getConfigFile((String)TEMPLATE_PATH);
        DataObject template = DataObject.find((FileObject)templateF);
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("package", packageName);
        FileObject existing = targetFolder.getPrimaryFile().getFileObject(fname, "java");
        if (existing != null) {
            return DataObject.find((FileObject)existing);
        }
        return template.createFromTemplate(targetFolder, fname, parameters);
    }

    private static String capitalize(String str) {
        return Character.toUpperCase(str.charAt(0)) + str.substring(1);
    }

    static boolean isValidPackageName(String str) {
        if (str.length() > 0 && str.charAt(0) == '.') {
            return false;
        }
        StringTokenizer tukac = new StringTokenizer(str, ".");
        while (tukac.hasMoreTokens()) {
            String token = tukac.nextToken();
            if ("".equals(token)) {
                return false;
            }
            if (Utilities.isJavaIdentifier((String)token)) continue;
            return false;
        }
        return true;
    }
}

