/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.core;

import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.netbeans.api.fileinfo.NonRecursiveFolder;
import org.netbeans.modules.versioning.core.NoVCSMenuItem;
import org.netbeans.modules.versioning.core.Utils;
import org.netbeans.modules.versioning.core.VersioningManager;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.core.filesystems.VCSFilesystemInterceptor;
import org.netbeans.modules.versioning.core.spi.VCSAnnotator;
import org.netbeans.modules.versioning.core.spi.VCSContext;
import org.netbeans.modules.versioning.core.util.VCSSystemProvider;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.util.ContextAwareAction;
import org.openide.util.HelpCtx;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.Presenter;
import org.openide.util.actions.SystemAction;

public class VersioningAnnotationProvider {
    private static final VersioningAnnotationProvider instance = new VersioningAnnotationProvider();
    private static final Logger LOG = Logger.getLogger(VersioningAnnotationProvider.class.getName());
    private static final int CACHE_INITIAL_SIZE = 500;
    private static final long CACHE_ITEM_MAX_AGE = VersioningAnnotationProvider.getMaxAge();
    private static final boolean ANNOTATOR_ASYNC = !"false".equals(System.getProperty("versioning.asyncAnnotator", "true"));
    private static final Image EMPTY_ICON = new BufferedImage(1, 1, 2);
    private Map<FileSystem, Set<FileObject>> filesToRefresh = new HashMap<FileSystem, Set<FileObject>>();
    private Map<FileSystem, Set<FileObject>> parentsToRefresh = new HashMap<FileSystem, Set<FileObject>>();
    private RequestProcessor rp = new RequestProcessor("Versioning fire FileStatusChanged", 1, true);
    private RequestProcessor.Task refreshAllAnnotationsTask = this.rp.create(new Runnable(){

        @Override
        public void run() {
            VersioningAnnotationProvider.this.clearMap(VersioningAnnotationProvider.this.filesToRefresh);
            VersioningAnnotationProvider.this.clearMap(VersioningAnnotationProvider.this.parentsToRefresh);
            ((Cache)VersioningAnnotationProvider.this.labelCache).removeAll();
            ((Cache)VersioningAnnotationProvider.this.iconCache).removeAll();
            VersioningManager.deliverStatusEvent(new VCSFilesystemInterceptor.VCSAnnotationEvent(true, true));
        }
    });
    private RequestProcessor.Task fireFileStatusChangedTask = this.rp.create(new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ArrayList<VCSFilesystemInterceptor.VCSAnnotationEvent> fileEvents = new ArrayList<VCSFilesystemInterceptor.VCSAnnotationEvent>();
            ArrayList<VCSFilesystemInterceptor.VCSAnnotationEvent> folderEvents = new ArrayList<VCSFilesystemInterceptor.VCSAnnotationEvent>();
            Map map = VersioningAnnotationProvider.this.filesToRefresh;
            synchronized (map) {
                Set fileSystems = VersioningAnnotationProvider.this.filesToRefresh.keySet();
                if (fileSystems == null || fileSystems.isEmpty()) {
                    return;
                }
                for (FileSystem fs : fileSystems) {
                    HashSet<FileObject> files = new HashSet<FileObject>();
                    HashSet<FileObject> folders = new HashSet<FileObject>();
                    Set set = (Set)VersioningAnnotationProvider.this.filesToRefresh.get(fs);
                    for (FileObject fo : set) {
                        if (fo.isFolder()) {
                            folders.add(fo);
                            continue;
                        }
                        files.add(fo);
                    }
                    set.clear();
                    if (files.size() > 0) {
                        fileEvents.add(new VCSFilesystemInterceptor.VCSAnnotationEvent(files, true, true));
                    }
                    if (folders.size() <= 0) continue;
                    folderEvents.add(new VCSFilesystemInterceptor.VCSAnnotationEvent(folders, true, true));
                }
            }
            this.fireFileStatusEvents(fileEvents);
            this.fireFileStatusEvents(folderEvents);
            ArrayList<VCSFilesystemInterceptor.VCSAnnotationEvent> parentEvents = new ArrayList<VCSFilesystemInterceptor.VCSAnnotationEvent>();
            Map map2 = VersioningAnnotationProvider.this.parentsToRefresh;
            synchronized (map2) {
                Set fileSystems = VersioningAnnotationProvider.this.parentsToRefresh.keySet();
                for (FileSystem fs : fileSystems) {
                    Set set = (Set)VersioningAnnotationProvider.this.parentsToRefresh.get(fs);
                    HashSet files = new HashSet(set);
                    parentEvents.add(new VCSFilesystemInterceptor.VCSAnnotationEvent(files, true, false));
                    set.clear();
                }
            }
            this.fireFileStatusEvents(parentEvents);
        }

        private void fireFileStatusEvents(Collection<VCSFilesystemInterceptor.VCSAnnotationEvent> events) {
            for (VCSFilesystemInterceptor.VCSAnnotationEvent event : events) {
                VersioningManager.deliverStatusEvent(event);
            }
        }
    });
    private final Cache<Image, String> iconCache = new Cache("IconCache");
    private final Cache<String, String> labelCache = new Cache("LabelCache");
    private static final Pattern lessThan = Pattern.compile("<");

    private VersioningAnnotationProvider() {
    }

    public static VersioningAnnotationProvider getDefault() {
        return instance;
    }

    private VCSSystemProvider.VersioningSystem getOwner(VCSFileProxy file, Boolean isFile) {
        return file == null ? null : VersioningManager.getInstance().getOwner(file, isFile);
    }

    public Image annotateIcon(Image icon, int iconType, Set<? extends FileObject> files) {
        Image annotatedIcon;
        if (ANNOTATOR_ASYNC) {
            Cache<Image, String> cache = this.iconCache;
            cache.getClass();
            annotatedIcon = this.iconCache.getValue(cache.new Cache.ItemKey<Image, String>(files, "", files instanceof NonRecursiveFolder, EMPTY_ICON));
            annotatedIcon = annotatedIcon == null ? icon : ImageUtilities.mergeImages((Image)icon, (Image)annotatedIcon, (int)0, (int)0);
        } else {
            Cache<Image, String> cache = this.iconCache;
            cache.getClass();
            annotatedIcon = this.iconCache.getValue(cache.new Cache.ItemKey<Image, String>(files, "", files instanceof NonRecursiveFolder, icon));
        }
        return annotatedIcon;
    }

    public String annotateNameHtml(String name, Set<? extends FileObject> files) {
        Cache<String, String> cache = this.labelCache;
        cache.getClass();
        String annotatedName = this.labelCache.getValue(cache.new Cache.ItemKey<String, String>(files, name, files instanceof NonRecursiveFolder, name));
        return annotatedName == null ? this.htmlEncode(name) : annotatedName;
    }

    public Action[] actions(Set files) {
        if (files.isEmpty()) {
            return new Action[0];
        }
        if (!VersioningManager.isInitialized()) {
            return new Action[]{SystemAction.get(InitVersioningSystemAction.class), SystemAction.get(InitLHSystemAction.class)};
        }
        ArrayList<AbstractVersioningSystemActions> actions = new ArrayList<AbstractVersioningSystemActions>();
        LocalHistoryActions localHistoryAction = null;
        HashMap<VCSSystemProvider.VersioningSystem, ArrayList<VCSFileProxy>> owners = new HashMap<VCSSystemProvider.VersioningSystem, ArrayList<VCSFileProxy>>(3);
        for (FileObject fo : files) {
            VCSSystemProvider.VersioningSystem owner;
            VCSFileProxy file = VCSFileProxy.createFileProxy(fo);
            if (file == null) continue;
            VCSSystemProvider.VersioningSystem localHistory = VersioningManager.getInstance().getLocalHistory(file, !fo.isFolder());
            if (localHistoryAction == null && localHistory != null && localHistory.getVCSAnnotator() != null) {
                localHistoryAction = (LocalHistoryActions)SystemAction.get(LocalHistoryActions.class);
                localHistoryAction.setVersioningSystem(localHistory);
                actions.add(localHistoryAction);
            }
            if ((owner = this.getOwner(file, !fo.isFolder())) == null) continue;
            ArrayList<VCSFileProxy> fileList = (ArrayList<VCSFileProxy>)owners.get(owner);
            if (fileList == null) {
                fileList = new ArrayList<VCSFileProxy>();
            }
            fileList.add(file);
            owners.put(owner, fileList);
        }
        VCSSystemProvider.VersioningSystem vs = null;
        if (owners.keySet().size() != 1) {
            return actions.toArray(new Action[actions.size()]);
        }
        vs = (VCSSystemProvider.VersioningSystem)owners.keySet().iterator().next();
        VCSAnnotator an = null;
        if (vs != null) {
            an = vs.getVCSAnnotator();
        }
        if (an != null) {
            VersioningSystemActions action = (VersioningSystemActions)SystemAction.get(VersioningSystemActions.class);
            action.setVersioningSystem(vs);
            actions.add(action);
        }
        return actions.toArray(new Action[actions.size()]);
    }

    static void refreshAllAnnotations() {
        if (instance != null) {
            instance.refreshAnnotations(null);
        }
    }

    void refreshAnnotations(Set<VCSFileProxy> files) {
        this.refreshAnnotations(files, true);
    }

    void refreshAnnotations(Set<VCSFileProxy> files, boolean removeFromCache) {
        if (files == null) {
            LOG.log(Level.FINE, "refreshing all annotations");
            this.refreshAllAnnotationsTask.schedule(2000);
            return;
        }
        if (removeFromCache) {
            LOG.log(Level.FINE, "refreshing annotations for {0}", files);
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.log(Level.FINEST, "refreshing annotations called from:", new Exception());
            }
        }
        for (VCSFileProxy file : files) {
            FileObject fo = file.toFileObject();
            if (fo == null) {
                fo = this.getExistingParent(file);
            } else {
                this.addToMap(this.filesToRefresh, fo, removeFromCache);
                fo = fo.getParent();
            }
            if (!removeFromCache) continue;
            for (FileObject parent = fo; parent != null; parent = parent.getParent()) {
                this.addToMap(this.parentsToRefresh, parent, removeFromCache);
            }
        }
        this.fireFileStatusChangedTask.schedule(2000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearMap(Map<FileSystem, Set<FileObject>> map) {
        Map<FileSystem, Set<FileObject>> map2 = map;
        synchronized (map2) {
            if (map.size() > 0) {
                map.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToMap(Map<FileSystem, Set<FileObject>> map, FileObject fo, boolean removeFromCache) {
        FileSystem fs;
        if (fo == null) {
            return;
        }
        try {
            fs = fo.getFileSystem();
        }
        catch (FileStateInvalidException e) {
            return;
        }
        Map<FileSystem, Set<FileObject>> map2 = map;
        synchronized (map2) {
            Set<FileObject> set = map.get(fs);
            if (set == null) {
                set = new HashSet<FileObject>();
                map.put(fs, set);
            }
            set.add(fo);
            if (removeFromCache) {
                if (LOG.isLoggable(Level.FINER)) {
                    LOG.log(Level.FINER, "addToMap(): removing from cache {0}", new Object[]{fo});
                }
                ((Cache)this.labelCache).removeAllFor(fo);
                ((Cache)this.iconCache).removeAllFor(fo);
            }
        }
    }

    private FileObject getExistingParent(VCSFileProxy file) {
        FileObject fo = null;
        for (VCSFileProxy parent = file; parent != null && fo == null; parent = parent.getParentFile()) {
            fo = parent.toFileObject();
        }
        return fo;
    }

    private static long getMaxAge() {
        String cacheItemAgeProp = System.getProperty("versioning.annotator.cacheItem.maxAge", "600000");
        long cacheItemAge = 0L;
        try {
            if (cacheItemAgeProp != null) {
                cacheItemAge = Long.parseLong(cacheItemAgeProp);
            }
        }
        catch (NumberFormatException ex) {
            LOG.log(Level.INFO, "Max cache item age: " + cacheItemAgeProp, ex);
            cacheItemAge = 0L;
        }
        if (cacheItemAge != -1L && cacheItemAge < 60000L) {
            cacheItemAge = 600000L;
        }
        LOG.log(Level.FINE, "getMaxAge(): {0}", cacheItemAge);
        return cacheItemAge;
    }

    private String htmlEncode(String name) {
        if (name.indexOf(60) == -1) {
            return name;
        }
        return lessThan.matcher(name).replaceAll("&lt;");
    }

    private class Cache<T, KEY> {
        private static final String ANNOTATION_TYPE_ICON = "IconCache";
        private static final String ANNOTATION_TYPE_LABEL = "LabelCache";
        private final Object writeLock = new Object();
        private final Object LOCK_VALUES = new Object();
        private int peekCount;
        private LinkedHashMap<ItemKey<T, KEY>, Item<T>> cachedValues = new LinkedHashMap(500);
        private WeakHashMap<FileObject, Set<ItemKey<T, KEY>>> index = new WeakHashMap(500);
        private final LinkedHashSet<ItemKey<T, KEY>> filesToAnnotate;
        private final RequestProcessor.Task annotationRefreshTask;
        private final String type;
        private final HashSet<FileObject> refreshedFiles = new HashSet();
        private boolean allCleared;

        Cache(String type) {
            this.annotationRefreshTask = new RequestProcessor("VersioningAnnotator.annotationRefresh", 1, false, false).create((Runnable)new AnnotationRefreshTask());
            this.filesToAnnotate = new LinkedHashSet();
            assert (ANNOTATION_TYPE_ICON.equals(type) || ANNOTATION_TYPE_LABEL.equals(type));
            this.type = type;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        T getValue(ItemKey<T, KEY> key) {
            T cachedValue;
            if (!ANNOTATOR_ASYNC) {
                return this.annotate(key.getInitialValue(), key.getFiles());
            }
            boolean itemCached = false;
            Object object = this.LOCK_VALUES;
            synchronized (object) {
                Item<T> cachedItem = this.cachedValues.get(key);
                T t = cachedValue = cachedItem == null ? null : (T)cachedItem.getValue();
                if (cachedValue != null || this.cachedValues.containsKey(key)) {
                    itemCached = true;
                }
            }
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.log(Level.FINEST, "{0}.getValue() cached: {1} for {2}", new Object[]{this.type, cachedValue, key.getFiles()});
            }
            if (!itemCached) {
                this.addFilesToAnnotate(key);
            }
            return cachedValue;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean setValue(ItemKey<T, KEY> key, T value) {
            Object object = this.writeLock;
            synchronized (object) {
                if (this.allCleared) {
                    return false;
                }
                Set<FileObject> files = key.getFiles();
                for (FileObject fo : files) {
                    if (!this.refreshedFiles.contains(fo)) continue;
                    return false;
                }
                if (LOG.isLoggable(Level.FINEST)) {
                    LOG.log(Level.FINEST, "{0}.setValue(): inserting for {1}:{2}", new Object[]{this.type, key.getFiles(), value});
                }
                Iterator<FileObject> i$ = this.LOCK_VALUES;
                synchronized (i$) {
                    this.cachedValues.put(key, new Item<T>(value));
                    this.peekCount = Math.max(this.peekCount, this.cachedValues.size() + 1);
                }
                for (FileObject fo : files) {
                    Set<ItemKey<T, KEY>> sets = this.index.get(fo);
                    if (sets == null) {
                        sets = new HashSet<ItemKey<T, KEY>>();
                        this.index.put(fo, sets);
                    }
                    sets.add(key);
                }
                this.removeOldValues();
            }
            if (LOG.isLoggable(Level.FINEST)) {
                LOG.log(Level.FINEST, "{0}.setValue(): {1} for {2}", new Object[]{this.type, value, key});
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void removeOldValues() {
            Map.Entry<ItemKey<T, KEY>, Item<T>> e;
            assert (Thread.holdsLock(this.writeLock));
            Iterator<Map.Entry<ItemKey<T, KEY>, Item<T>>> it = this.cachedValues.entrySet().iterator();
            while (it.hasNext() && !(e = it.next()).getValue().isValid()) {
                if (LOG.isLoggable(Level.FINER)) {
                    LOG.log(Level.FINER, "{0}.removeOldValues(): {1}", new Object[]{this.type, e.getKey().getFiles()});
                }
                this.removeFromIndex(e.getKey());
                Object object = this.LOCK_VALUES;
                synchronized (object) {
                    it.remove();
                }
            }
            this.shrinkMaps();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addFilesToAnnotate(ItemKey<T, KEY> key) {
            boolean start;
            LinkedHashSet<ItemKey<T, KEY>> linkedHashSet = this.filesToAnnotate;
            synchronized (linkedHashSet) {
                start = this.filesToAnnotate.add(key);
            }
            if (start) {
                this.annotationRefreshTask.schedule(0);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ItemKey<T, KEY> getNextFilesToAnnotate() {
            ItemKey retval = null;
            LinkedHashSet<ItemKey<T, KEY>> linkedHashSet = this.filesToAnnotate;
            synchronized (linkedHashSet) {
                Iterator it = this.filesToAnnotate.iterator();
                if (it.hasNext()) {
                    retval = (ItemKey)it.next();
                    it.remove();
                }
            }
            return retval;
        }

        private T annotate(VCSAnnotator annotator, T initialValue, VCSContext context) {
            if (ANNOTATION_TYPE_LABEL.equals(this.type)) {
                return (T)annotator.annotateName((String)initialValue, context);
            }
            if (ANNOTATION_TYPE_ICON.equals(this.type)) {
                return (T)annotator.annotateIcon((Image)initialValue, context);
            }
            LOG.log(Level.WARNING, "{0}.annotate unsupported", this.type);
            assert (false);
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private T annotate(T initialValue, Set<? extends FileObject> files) {
            T t;
            block23: {
                VCSAnnotator an;
                long ft;
                block21: {
                    T t2;
                    block22: {
                        VCSSystemProvider.VersioningSystem vs;
                        block19: {
                            T t3;
                            block20: {
                                block17: {
                                    T t4;
                                    block18: {
                                        ft = System.currentTimeMillis();
                                        if (LOG.isLoggable(Level.FINEST)) {
                                            LOG.log(Level.FINEST, "{0}.annotate for {1}", new Object[]{this.type, files});
                                        }
                                        an = null;
                                        try {
                                            if (!files.isEmpty()) break block17;
                                            t4 = initialValue;
                                            if (!LOG.isLoggable(Level.FINEST)) break block18;
                                        }
                                        catch (Throwable throwable) {
                                            if (LOG.isLoggable(Level.FINEST)) {
                                                long t5 = System.currentTimeMillis();
                                                if (an != null) {
                                                    LOG.log(Level.FINEST, "{0}.annotate in {1} returns in " + (t5 - ft) + " millis", new Object[]{this.type, an.getClass().getName()});
                                                } else {
                                                    LOG.log(Level.FINEST, "{0}.annotate returns in " + (t5 - ft) + " millis", new Object[]{this.type});
                                                }
                                            }
                                            throw throwable;
                                        }
                                        long t6 = System.currentTimeMillis();
                                        if (an != null) {
                                            LOG.log(Level.FINEST, "{0}.annotate in {1} returns in " + (t6 - ft) + " millis", new Object[]{this.type, an.getClass().getName()});
                                        } else {
                                            LOG.log(Level.FINEST, "{0}.annotate returns in " + (t6 - ft) + " millis", new Object[]{this.type});
                                        }
                                    }
                                    return t4;
                                }
                                FileObject fo = files.iterator().next();
                                vs = VersioningAnnotationProvider.this.getOwner(VCSFileProxy.createFileProxy(fo), !fo.isFolder());
                                if (vs != null) break block19;
                                t3 = null;
                                if (!LOG.isLoggable(Level.FINEST)) break block20;
                                long t7 = System.currentTimeMillis();
                                if (an != null) {
                                    LOG.log(Level.FINEST, "{0}.annotate in {1} returns in " + (t7 - ft) + " millis", new Object[]{this.type, an.getClass().getName()});
                                } else {
                                    LOG.log(Level.FINEST, "{0}.annotate returns in " + (t7 - ft) + " millis", new Object[]{this.type});
                                }
                            }
                            return t3;
                        }
                        an = vs.getVCSAnnotator();
                        if (an != null) break block21;
                        t2 = null;
                        if (!LOG.isLoggable(Level.FINEST)) break block22;
                        long t8 = System.currentTimeMillis();
                        if (an != null) {
                            LOG.log(Level.FINEST, "{0}.annotate in {1} returns in " + (t8 - ft) + " millis", new Object[]{this.type, an.getClass().getName()});
                        } else {
                            LOG.log(Level.FINEST, "{0}.annotate returns in " + (t8 - ft) + " millis", new Object[]{this.type});
                        }
                    }
                    return t2;
                }
                VCSContext context = Utils.contextForFileObjects(files);
                t = this.annotate(an, initialValue, context);
                if (!LOG.isLoggable(Level.FINEST)) break block23;
                long t9 = System.currentTimeMillis();
                if (an != null) {
                    LOG.log(Level.FINEST, "{0}.annotate in {1} returns in " + (t9 - ft) + " millis", new Object[]{this.type, an.getClass().getName()});
                } else {
                    LOG.log(Level.FINEST, "{0}.annotate returns in " + (t9 - ft) + " millis", new Object[]{this.type});
                }
            }
            return t;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void removeAllFor(FileObject fo) {
            Object object = this.writeLock;
            synchronized (object) {
                this.refreshedFiles.add(fo);
                LOG.log(Level.FINER, "{0}.removeAllFor(): {1}", new Object[]{this.type, fo.getPath()});
                Set<ItemKey<ItemKey, KEY>> keys = this.index.get(fo);
                if (keys != null) {
                    ItemKey[] keysArray;
                    for (ItemKey<T, KEY> itemKey : keys) {
                        if (LOG.isLoggable(Level.FINER)) {
                            LOG.log(Level.FINER, "{0}.removeAllFor(): remove from cache: {1}", new Object[]{this.type, itemKey.getFiles()});
                        }
                        Object object2 = this.LOCK_VALUES;
                        synchronized (object2) {
                            this.cachedValues.remove(itemKey);
                        }
                    }
                    for (ItemKey key : keysArray = keys.toArray(new ItemKey[keys.size()])) {
                        if (LOG.isLoggable(Level.FINEST)) {
                            LOG.log(Level.FINEST, "{0}.removeAllFor(): remove from index: {1}", new Object[]{this.type, key.getFiles()});
                        }
                        this.removeFromIndex(key);
                    }
                }
                this.shrinkMaps();
            }
        }

        private void removeFromIndex(ItemKey<T, KEY> key) {
            assert (Thread.holdsLock(this.writeLock));
            Set<FileObject> files = key.getFiles();
            for (FileObject fo : files) {
                Set<ItemKey<T, KEY>> sets = this.index.get(fo);
                if (sets == null) continue;
                sets.remove(key);
                if (!sets.isEmpty()) continue;
                this.index.remove(fo);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void removeAll() {
            Object object = this.writeLock;
            synchronized (object) {
                this.allCleared = true;
                Object object2 = this.LOCK_VALUES;
                synchronized (object2) {
                    this.cachedValues.clear();
                }
                this.index.clear();
                this.shrinkMaps();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void shrinkMaps() {
            assert (Thread.holdsLock(this.writeLock));
            if (this.peekCount > 500 && this.peekCount > this.cachedValues.size() * 4) {
                LOG.log(Level.FINER, "{0}.shrinkMaps(): last peek was {1}", new Object[]{this.type, this.peekCount});
                Object object = this.LOCK_VALUES;
                synchronized (object) {
                    this.cachedValues = new LinkedHashMap<ItemKey<T, KEY>, Item<T>>(this.cachedValues);
                    this.index = new WeakHashMap<FileObject, Set<ItemKey<T, KEY>>>(this.index);
                    this.peekCount = this.cachedValues.size();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void clearEvents() {
            Object object = this.writeLock;
            synchronized (object) {
                this.refreshedFiles.clear();
                this.allCleared = false;
            }
        }

        private class ItemKey<T, KEY> {
            private final T initialValue;
            private final KEY keyPart;
            private final Set<? extends FileObject> files;
            private Integer hashCode;
            private final boolean nonRecursiveFolders;

            public ItemKey(Set<? extends FileObject> files, KEY keyPart, boolean nonRecursiveFolders, T initialValue) {
                assert (keyPart != null);
                this.initialValue = initialValue;
                this.keyPart = keyPart;
                this.files = files;
                this.nonRecursiveFolders = nonRecursiveFolders;
            }

            public T getInitialValue() {
                return this.initialValue;
            }

            public Set<? extends FileObject> getFiles() {
                return this.files;
            }

            public boolean equals(Object obj) {
                if (obj instanceof ItemKey) {
                    ItemKey other = (ItemKey)obj;
                    return this.nonRecursiveFolders == other.nonRecursiveFolders && ((Object)this.files).equals(other.files) && this.keyPart.equals(other.keyPart);
                }
                return super.equals(obj);
            }

            public int hashCode() {
                if (this.hashCode == null) {
                    int hash = 5;
                    hash = 29 * hash + (this.keyPart != null ? this.keyPart.hashCode() : 0);
                    hash = 29 * hash + (this.files != null ? ((Object)this.files).hashCode() : 0);
                    if (this.hashCode == null) {
                        this.hashCode = hash;
                    }
                    this.hashCode = hash;
                }
                return this.hashCode;
            }

            public String toString() {
                return this.files.toString() + ": " + this.keyPart.toString() + "(" + (this.initialValue == null ? "null" : this.initialValue.toString()) + ")";
            }
        }

        private class Item<T> {
            private final T value;
            private final long timeStamp;

            public Item(T value) {
                this.value = value;
                this.timeStamp = System.currentTimeMillis();
            }

            public T getValue() {
                return this.value;
            }

            public boolean isValid() {
                return CACHE_ITEM_MAX_AGE == -1L || System.currentTimeMillis() - this.timeStamp < CACHE_ITEM_MAX_AGE;
            }
        }

        private class AnnotationRefreshTask
        implements Runnable {
            private AnnotationRefreshTask() {
            }

            @Override
            public void run() {
                ItemKey refreshCandidate;
                while ((refreshCandidate = Cache.this.getNextFilesToAnnotate()) != null) {
                    Object initialValue = refreshCandidate.getInitialValue();
                    Set<FileObject> files = refreshCandidate.getFiles();
                    assert (files != null);
                    Cache.this.clearEvents();
                    Object newValue = Cache.this.annotate(initialValue, files);
                    boolean isNonRecursive = files instanceof NonRecursiveFolder;
                    boolean fireEvent = Cache.this.setValue(new ItemKey(files = new HashSet<FileObject>(files), refreshCandidate.keyPart, isNonRecursive, initialValue), newValue);
                    if (!fireEvent) continue;
                    HashSet<VCSFileProxy> filesToRefresh = new HashSet<VCSFileProxy>(files.size());
                    for (FileObject fo : files) {
                        VCSFileProxy proxy = VCSFileProxy.createFileProxy(fo);
                        if (proxy == null) continue;
                        filesToRefresh.add(proxy);
                    }
                    if (LOG.isLoggable(Level.FINEST)) {
                        LOG.log(Level.FINEST, "{0}.AnnotationRefreshTask.run(): firing refresh event for {1}", new Object[]{Cache.this.type, filesToRefresh});
                    }
                    VersioningAnnotationProvider.this.refreshAnnotations(filesToRefresh, false);
                }
            }
        }
    }

    private static class RealVersioningSystemActions
    extends AbstractAction
    implements Presenter.Popup {
        private final VCSSystemProvider.VersioningSystem system;
        private final VCSContext context;

        public RealVersioningSystemActions(VCSSystemProvider.VersioningSystem system, VCSContext context) {
            super(system.getDisplayName());
            this.system = system;
            this.context = context;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }

        public JMenuItem getPopupPresenter() {
            return new VersioningSystemMenuItem();
        }

        private class VersioningSystemMenuItem
        extends JMenu {
            private boolean popupContructed;

            public VersioningSystemMenuItem() {
                Mnemonics.setLocalizedText((AbstractButton)this, (String)Utils.getSystemMenuName(RealVersioningSystemActions.this.system));
            }

            @Override
            public void setSelected(boolean selected) {
                if (selected && !this.popupContructed) {
                    Action[] actions = RealVersioningSystemActions.this.system.getVCSAnnotator().getActions(RealVersioningSystemActions.this.context, VCSAnnotator.ActionDestination.PopupMenu);
                    for (int i = 0; i < actions.length; ++i) {
                        Action action = actions[i];
                        if (action == null) {
                            this.addSeparator();
                            continue;
                        }
                        JMenuItem item = Utils.toMenuItem(action);
                        this.add(item);
                    }
                    this.popupContructed = true;
                }
                super.setSelected(selected);
            }
        }
    }

    public static abstract class AbstractVersioningSystemActions
    extends SystemAction
    implements ContextAwareAction {
        private VCSSystemProvider.VersioningSystem system;

        public String getName() {
            return this.system.getDisplayName();
        }

        public HelpCtx getHelpCtx() {
            return new HelpCtx(this.system.getClass());
        }

        public void actionPerformed(ActionEvent ev) {
        }

        public Action createContextAwareInstance(Lookup actionContext) {
            return new RealVersioningSystemActions(this.system, Utils.contextForLookup(actionContext));
        }

        public void setVersioningSystem(VCSSystemProvider.VersioningSystem system) {
            this.system = system;
        }
    }

    public static class InitVersioningSystemAction
    extends SystemAction
    implements Presenter.Popup {
        public void actionPerformed(ActionEvent ae) {
        }

        public JMenuItem getPopupPresenter() {
            return NoVCSMenuItem.createInitializingMenu(this.getName());
        }

        public String getName() {
            return NbBundle.getMessage(VersioningAnnotationProvider.class, (String)"CTL_MenuItem_VersioningMenu");
        }

        public HelpCtx getHelpCtx() {
            return null;
        }
    }

    public static class InitLHSystemAction
    extends InitVersioningSystemAction {
        @Override
        public String getName() {
            return NbBundle.getMessage(VersioningAnnotationProvider.class, (String)"CTL_MenuItem_LocalHistory");
        }
    }

    public static class LocalHistoryActions
    extends AbstractVersioningSystemActions {
    }

    public static class VersioningSystemActions
    extends AbstractVersioningSystemActions {
    }
}

