/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.core;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.diff.PatchAction;
import org.netbeans.modules.versioning.core.DelegatingVCS;
import org.netbeans.modules.versioning.core.NoVCSMenuItem;
import org.netbeans.modules.versioning.core.Utils;
import org.netbeans.modules.versioning.core.VersioningConfig;
import org.netbeans.modules.versioning.core.VersioningMainMenu;
import org.netbeans.modules.versioning.core.VersioningManager;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.core.spi.VCSAnnotator;
import org.netbeans.modules.versioning.core.spi.VCSContext;
import org.netbeans.modules.versioning.core.util.VCSSystemProvider;
import org.openide.awt.Actions;
import org.openide.awt.DynamicMenuContent;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.actions.Presenter;
import org.openide.util.actions.SystemAction;
import org.openide.windows.TopComponent;

public class ProjectMenuItem
extends AbstractAction
implements Presenter.Popup {
    public JMenuItem getPopupPresenter() {
        return new DynamicDummyItem();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
    }

    private JComponent[] createItems() {
        ArrayList<JMenu> popups = new ArrayList<JMenu>();
        if (!VersioningManager.isInitialized()) {
            popups.add(NoVCSMenuItem.createInitializingMenu(NbBundle.getMessage(VersioningMainMenu.class, (String)"CTL_MenuItem_VersioningMenu")));
            popups.add(NoVCSMenuItem.createInitializingMenu(NbBundle.getMessage(VersioningMainMenu.class, (String)"CTL_MenuItem_LocalHistory")));
        } else {
            Node[] nodes = this.getActivatedNodes();
            if (nodes.length > 0) {
                LazyMenu menu;
                Set<VCSSystemProvider.VersioningSystem> owners = this.getOwnersForProjectNodes(nodes);
                if (owners.size() != 1) {
                    return new JComponent[0];
                }
                VCSSystemProvider.VersioningSystem owner = owners.iterator().next();
                VCSSystemProvider.VersioningSystem localHistory = this.getLocalHistory(nodes);
                if (owner == null || owner.getVCSAnnotator() != null) {
                    menu = new LazyMenu(nodes, owner);
                    popups.add(menu);
                }
                if (localHistory != null && localHistory.getVCSAnnotator() != null) {
                    menu = new LazyMenu(nodes, localHistory);
                    popups.add(menu);
                }
            }
        }
        return popups.toArray(new JComponent[popups.size()]);
    }

    private VCSSystemProvider.VersioningSystem getLocalHistory(Node[] nodes) {
        Set<VCSFileProxy> rootFiles = this.getRootFilesForProjectNodes(nodes);
        VCSSystemProvider.VersioningSystem owner = null;
        for (VCSFileProxy file : rootFiles) {
            VCSSystemProvider.VersioningSystem fileOwner = VersioningManager.getInstance().getLocalHistory(file);
            if (owner != null) {
                if (fileOwner == null || fileOwner == owner) continue;
                return null;
            }
            owner = fileOwner;
        }
        return owner;
    }

    private Set<VCSSystemProvider.VersioningSystem> getOwnersForProjectNodes(Node[] nodes) {
        Set<VCSFileProxy> rootFiles = this.getRootFilesForProjectNodes(nodes);
        HashSet<VCSSystemProvider.VersioningSystem> owners = new HashSet<VCSSystemProvider.VersioningSystem>(2);
        boolean someUnversioned = false;
        for (VCSFileProxy file : rootFiles) {
            VCSSystemProvider.VersioningSystem fileOwner = VersioningManager.getInstance().getOwner(file);
            if (fileOwner == null) {
                someUnversioned = true;
                continue;
            }
            owners.add(fileOwner);
        }
        if (owners.isEmpty() && someUnversioned) {
            owners.add(null);
        }
        return owners;
    }

    private JComponent[] createVersioningSystemItems(VCSSystemProvider.VersioningSystem vs, Node[] nodes, boolean displayConnectAction) {
        VCSFileProxy root;
        VCSContext ctx = VCSContext.forNodes(nodes);
        Action[] actions = null;
        if (displayConnectAction && ctx.getRootFiles().size() == 1 && (root = vs.getTopmostManagedAncestor(ctx.getRootFiles().iterator().next())) != null && VersioningConfig.getDefault().isDisconnected(vs, root)) {
            String displayName = vs.getMenuLabel();
            actions = new Action[]{new VersioningMainMenu.ConnectAction(vs, root, NbBundle.getMessage(ProjectMenuItem.class, (String)"CTL_ConnectAction.name.vcs", (Object)displayName))};
        }
        if (actions == null) {
            if (vs instanceof DelegatingVCS) {
                actions = ((DelegatingVCS)vs).getInitActions(ctx);
            } else {
                VCSAnnotator an = vs.getVCSAnnotator();
                if (an == null) {
                    return null;
                }
                actions = an.getActions(ctx, VCSAnnotator.ActionDestination.PopupMenu);
            }
        }
        JComponent[] items = new JComponent[actions.length];
        int i = 0;
        for (Action action : actions) {
            if (action == null) {
                items[i++] = Utils.createJSeparator();
                continue;
            }
            JMenuItem item = this.createmenuItem(action);
            items[i++] = item;
        }
        return items;
    }

    private JMenuItem createmenuItem(Action action) {
        JMenuItem item;
        if (action instanceof Presenter.Menu) {
            item = ((Presenter.Menu)action).getMenuPresenter();
        } else {
            item = new JMenuItem();
            Actions.connect((JMenuItem)item, (Action)action, (boolean)true);
        }
        return item;
    }

    private Node[] getActivatedNodes() {
        return TopComponent.getRegistry().getActivatedNodes();
    }

    private Set<VCSFileProxy> getRootFilesForProjectNodes(Node[] nodes) {
        HashSet<VCSFileProxy> rootFiles = new HashSet<VCSFileProxy>(nodes.length);
        for (int i = 0; i < nodes.length; ++i) {
            Node node = nodes[i];
            Project project = (Project)node.getLookup().lookup(Project.class);
            if (project == null) continue;
            Sources sources = ProjectUtils.getSources((Project)project);
            SourceGroup[] sourceGroups = sources.getSourceGroups("generic");
            for (int j = 0; j < sourceGroups.length; ++j) {
                SourceGroup sourceGroup = sourceGroups[j];
                FileObject srcRootFo = sourceGroup.getRootFolder();
                VCSFileProxy rootFile = VCSFileProxy.createFileProxy(srcRootFo);
                if (rootFile == null) continue;
                rootFiles.add(rootFile);
            }
        }
        return rootFiles;
    }

    private class LazyMenu
    extends JMenu {
        private final Node[] nodes;
        private final VCSSystemProvider.VersioningSystem owner;
        boolean initialized;

        private LazyMenu(Node[] nodes, VCSSystemProvider.VersioningSystem owner) {
            super(owner == null ? NbBundle.getMessage(ProjectMenuItem.class, (String)"CTL_MenuItem_VersioningMenu") : Utils.getSystemMenuName(owner));
            this.nodes = nodes;
            this.owner = owner;
        }

        @Override
        public JPopupMenu getPopupMenu() {
            if (!this.initialized) {
                super.removeAll();
                if (this.owner == null) {
                    ArrayList<VCSSystemProvider.VersioningSystem> vcs = new ArrayList<VCSSystemProvider.VersioningSystem>(Arrays.asList(VersioningManager.getInstance().getVersioningSystems()));
                    Collections.sort(vcs, new VersioningMainMenu.ByDisplayNameComparator());
                    boolean added = false;
                    for (VCSSystemProvider.VersioningSystem vs : vcs) {
                        if (vs.isLocalHistory() || !this.addVersioningSystemItems(vs, this.nodes, true)) continue;
                        added = true;
                    }
                    if (added) {
                        this.addSeparator();
                        this.add(ProjectMenuItem.this.createmenuItem((Action)SystemAction.get(PatchAction.class)));
                    } else {
                        JMenuItem item = new JMenuItem();
                        Mnemonics.setLocalizedText((AbstractButton)item, (String)NbBundle.getMessage(VersioningMainMenu.class, (String)"LBL_NoneAvailable"));
                        item.setEnabled(false);
                        this.add(item);
                    }
                } else {
                    this.addVersioningSystemItems(this.owner, this.nodes, false);
                }
                this.initialized = true;
            }
            return super.getPopupMenu();
        }

        private boolean addVersioningSystemItems(VCSSystemProvider.VersioningSystem vs, Node[] nodes, boolean displayConnectAction) {
            JComponent[] items = ProjectMenuItem.this.createVersioningSystemItems(vs, nodes, displayConnectAction);
            if (items != null && items.length > 0) {
                for (JComponent item : items) {
                    this.add(item);
                }
                return true;
            }
            return false;
        }
    }

    private class DynamicDummyItem
    extends JMenuItem
    implements DynamicMenuContent {
        private DynamicDummyItem() {
        }

        public JComponent[] getMenuPresenters() {
            return ProjectMenuItem.this.createItems();
        }

        public JComponent[] synchMenuPresenters(JComponent[] items) {
            return ProjectMenuItem.this.createItems();
        }
    }
}

